/*
 *	Andrew's workroom.c
 */
#include <stats.h>
#include <config.h>
#include "door.h"
inherit "/complex/room";


object	key1, key2;
object	d1, d2, data1, lock;

void create() {
    set_short("Andrew's workroom.");
    set_long("This is Andrew's workroom.\n" +
	     "Not that Andrew ever, EVER, works though you understand.\n");
    set_exits(({ "/room/start"}),
	      ({ "out"}) );
    set_light(1);
    
    /* Never regenerated in this example */
    MAKE_KEY(key1, "yale");
    key1->set_id(({"silver key", "key"}));
    key1->set_short("A silver key");
    key1->set_long("It's just an ordinary silver key.\n");
    key1->move("/example/workroom");
    
    MAKE_KEY(key2, "mortice");
    key2->set_id(({"bronze key", "key"}));
    key2->set_short("A bronze key");
    key2->set_long("It's just an ordinary bronze key.\n");
    key2->move("/example/workroom");
    
    MAKE_LOCK(lock, "yale");
    MAKE_LOCKABLE_DOOR(d1, "/room/start2", ({"start2"}), d2, "/example/workroom", ({"workroom"}), data1, lock);
    d1->move("/example/workroom");
    d1->set_short("A door to /room/start2");
    d1->set_id(({"oak door", "door"}));
    d1->set_short("An oak door");
    
    d2->move("/room/start2");
    d2->set_short("A door to /example/workroom");
    d2->set_id(({"oak door", "door"}));
    d2->set_short("An oak door");
}
