# File: Makefile.wat

# Purpose: Makefile support for "main-ibm.c" for Watcom C/C++

# From: akemi@netcom.com (David Boeren)

CC = wcc386

CFLAGS  = /mf /3r /3 /wx /s /oneatx /DUSE_IBM /DUSE_WAT
# CFLAGS  = /mf /3r /3 /wx /oaeilmnrt /DUSE_IBM /DUSE_WAT

OBJS = &
    main.obj main-ibm.obj signals.obj util.obj io.obj init.obj save.obj &
    save-old.obj files.obj generate.obj birth.obj melee.obj &
    dungeon.obj effects.obj store.obj cmd1.obj cmd2.obj cmd3.obj cmd4.obj &
    cmd5.obj cmd6.obj misc.obj monster.obj mon-desc.obj object.obj &
    obj-desc.obj spells1.obj spells2.obj cave.obj tables.obj variable.obj &
    term.obj z-util.obj z-virt.obj z-form.obj wizard.obj wiz-spo.obj

all: angband makepref gredit

# Use whichever of these two you wish...
angband: $(OBJS) angband.lnk
   wlink system dos4g @angband.lnk
   move angband.exe ..\ang_wat.exe
#  copy angband.exe ..
   %create angband

makepref: makepref.obj makepref.lnk
   wlink system dos4g @makepref.lnk
   move makepref.exe ..\mp_wat.exe
#  copy makepref.exe ..
   %create makepref

gredit: gredit.obj gredit.lnk
   wlink system dos4g @gredit.lnk
   move gredit.exe ..\gr_wat.exe
#  copy gredit.exe ..
   %create gredit

angband.lnk:
    %create  angband.lnk
    @%append angband.lnk OPTION CASEEXACT
    @%append angband.lnk OPTION STACK=16k
    @%append angband.lnk name angband
    @for %i in ($(OBJS)) do @%append angband.lnk file %i

makepref.lnk:
    %create  makepref.lnk
    @%append makepref.lnk OPTION CASEEXACT
    @%append makepref.lnk OPTION STACK=16k
    @%append makepref.lnk name makepref
    @%append makepref.lnk file makepref.obj

gredit.lnk:
    %create  gredit.lnk
    @%append gredit.lnk OPTION CASEEXACT
    @%append gredit.lnk OPTION STACK=16k
    @%append gredit.lnk name gredit
    @%append gredit.lnk file gredit.obj

.c.obj:
    $(CC) $(CFLAGS) $[*.c

