#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <sys/param.h>

#include "contest.h"

#define USAGE "Usage: %s team problem result [version]\n"

static void insert_result();
static int mail_team();

static char *progname;

        int
main(argc, argv)
        int argc;
        char *argv[];
{
	char *team = argv[1];
	char path[MAXPATHLEN];
	char *program;
	char problem;
	int result;
	struct result_list *rs;
	int version;
	int fd;

	progname = argv[0];
	if (argc < 4 || argc > 5) {
		(void) fprintf(stderr, USAGE, progname);
		exit(1);
	}

	if (strlen(argv[3]) != 1 || argv[3][0] < '0' || argv[3][0] > '9') {
		(void) fprintf(stderr, "%s: invalid result code %s\n",
			       progname, argv[3]);
		exit(1);
	}
	result = atoi(argv[3]);
	problem = argv[2][0];

	if (argc == 4) {
		int done = 0;

		for (version = 1 ; !done ;) {
			sprintf(path, "%s/%s%c%d", get_teamdir(team),
				PREFIX, problem, version);
			switch(fd = prob_search(path)) {
			      case -2:
				(void) fprintf(stderr,
					     "%s: error determining version\n",
					       progname);
				exit(1);

			      case -1:
				version--;
				done = 1;
				break;

			      default:
				version++;
				close(fd);
				break;
			}
		}
	} else {
		version = atoi(argv[4]);
	}
	(void) sprintf(path, "%s/%s%c%d", get_teamdir(team), PREFIX,
		       problem, version);
	if ((fd = prob_search(path)) < 0) {
		(void) fprintf(stderr,
			       "%s: version %s of problem %c not found\n",
			       progname, argv[4], problem);
		exit(1);
	}
	close(fd);
			       
	program = strrchr(path, '/') + 1;
	if (!read_results(team, &rs)) {
		(void) fprintf(stderr, "%s: failed to read result file\n",
			       progname);
		exit(1);
	}
	
	insert_result(&rs, program, result);

	if (!write_results(team, rs)) {
		(void) fprintf(stderr, "%s: failed to write result file\n",
			       progname);
		exit(1);
	}

	if (!mail_team(team, program, result)) {
		(void) fprintf(stderr, "%s: failed to mail to %s\n",
			       progname, team);
		exit(1);
	}

	(void) printf(
"Result %d (%s), team %s, problem %c, version %d, problem set %s\n",
	              result, error_message(result), team,
		      extract_problem(program), extract_version(program),
		      get_contest_name());
	return 0;
}


        static void
insert_result(rs, program, result)
        struct result_list **rs;
        char *program;
        int result;
{
	char problem, list_prob;
	int version, list_vers;
	struct result_list *new_elem;
	  
	problem = extract_problem(program);
	version = extract_version(program);
	while (*rs) {
		list_prob = extract_problem((*rs)->program);
		list_vers = extract_version((*rs)->program);
		if (problem < list_prob || (problem == list_prob &&
					     version <= list_vers)) {
			break;
		}
		if (problem == list_prob && (*rs)->result == CORRECT) {
			(void) fprintf(stderr,
				     "%s: warning %s already marked correct\n",
				       progname, (*rs)->program);
		}
		rs = &(*rs)->next;
	}
	
	if (problem == list_prob && version == list_vers) {
		(void) printf("Replacing result %d with %d\n", (*rs)->result,
			      result);
		(*rs)->result = result;
	} else {
		new_elem = (struct result_list *)emalloc(sizeof(*new_elem));
	  	new_elem->program = program;
		new_elem->result = result;
		new_elem->next = *rs;
		*rs = new_elem;
	}
}


        static int
mail_team(team, program, result)
        char *team;
        char *program;
        int result;
{
	FILE *mail;
	char *format_str = "/bin/mail %s >/dev/null";
	char *mail_str = emalloc(strlen(format_str) + strlen(team) + 1);

	(void) sprintf(mail_str, format_str, team);

	if ((mail = popen(mail_str, "w")) == 0) {
		return 0;
	}

	(void) fprintf(mail,
		       "Result for submission %d for problem %c, set %s: %s\n",
		       extract_version(program), extract_problem(program),
		       get_contest_name(), error_message(result));
	(void) pclose(mail);
	return 1;
}
