program trial (input, output);

#include "str.h"

type
  char_set = set of char;


procedure replace (var line: string;
                a, b: string);

(* replace all occurances of 'a' with 'b' *)

  var
    p, start, finish: integer;

  begin
  p := pos(a, line);
  while (p <> 0) do
    begin
    delete(line, p, length(a));
    insert(b, line, p);
    p := pos(a, line);
    end;
  end;


procedure set_replace (var line: string;
                target: char_set;
                new: string);

  var
    ch: char;

  begin
  for ch := chr(1) to chr(255) do
    if ch in target then
      replace(line, ch, new);
  end;


function valid (var line: string): boolean;

  var
    loop, ptr, start, finish: integer;
    ok: boolean;
    tidy_line: string;

  begin
  ok := TRUE;
  for loop := 1 to length(line) do
    if (line[loop] in ['a'..'z']) then
      ok := FALSE;

(* single spaced *)
  while (pos('  ', line) <> 0) do
    delete(line, pos('  ', line), 1);
  tidy_line := line;

(* signs *)
  ok := ok and (pos('""', line) = 0) and (pos('" "', line) = 0);
  start := 1;
  while ok and (start < length(line)) do
    begin
    if (line[start] = '"') then
      begin
      finish := start + 1;
      while (finish <= length(line)) AND (line[finish] in ['A'..'Z', '(', ')', '.', ' ']) do
        finish := finish + 1;
      if (finish <= length(line)) AND (line[finish] = '"') then
        delete(line, start + 1, finish - start - 1)
      else
        ok := FALSE;
      start := start + 2;
      end
    else
      start := start + 1;
    end;

  if ok then
    begin
    set_replace(line, ['0'..'9'], 'dgt');
    replace(line, 'dgtdgt', '0');
    replace(line, 'dgt', '0');
    replace(line, 'CHANGE AVERAGE SPEED', 'cas');
    replace(line, 'CAS', 'cas');
    replace(line, 'RECORD TIME', 'time');
    replace(line, 'cas TO 0 KMH', 'time');
    replace(line, 'AT ""', 'where');
    replace(line, 'FIRST', 'when');
    replace(line, 'SECOND', 'when');
    replace(line, 'THIRD', 'when');
    replace(line, '0 TH', 'when');
    replace(line, 'RIGHT', 'direction');
    replace(line, 'LEFT', 'direction');
    replace(line, 'GO when', 'how');
    replace(line, 'GO', 'how');
    replace(line, 'KEEP', 'how');
    replace(line, 'how direction where', 'd');
    replace(line, 'how direction', 'd');
    replace(line, 'd AND THEN d', 'd');
    replace(line, 'd AND time', 'i');

{**writeln('Processed "', line, '"');{**}

    ok := (line = 'd') or (line = 'time') or (line = 'i');
    end;

  line := tidy_line;
  valid := ok;
  end;


procedure doit;

  var
    line_number: integer;
    line: string;

  begin
  line_number := 0;
  readln(line);
  while (line <> '#') do
    begin
    line_number := line_number + 1;
{**writeln('Processing "', line, '"');{**}
    if valid(line) then
      writeln(line_number : 3, '.', ' ', line)
    else
      writeln(line_number : 3, '.', ' Trap!');
    readln(line);
    end;
  end;


begin
doit;
end.
