program worm (input, output);

#include "../NZ.91/str.h"

var
  connect: array['A'..'Z', 'A'..'Z'] of boolean;
  used, dead: set of char;
  line: string;
  k, err: integer;
  start_node: char;


procedure init;

  var
    row, column: char;

  begin
  dead := [];
  used := [];
  for row := 'A' to 'Z' do
    for column := 'A' to 'Z' do
      connect[row, column] := FALSE;
  end;


procedure process_line;

  var
    node: char;
    ptr: integer;

  begin
  while (line[1] in ['A'..'Z']) do
    begin
    node := line[1];
    used := used + [node];
    delete(line, 1, 2);
    while not (line[1] in [';', '.']) do
      begin
      connect[node, line[1]] := TRUE;
      connect[line[1], node] := TRUE;
      used := used + [line[1]];
      delete(line, 1, 1);
      end;
    delete(line, 1, 1);
    end;

  start_node := line[length(line)];
  delete(line, length(line) - 1, 2);
  {readstring(line, k);}
  Valint(line, k, err);
  end;


procedure solve;

  var
    ptr, current_node, start_ptr: char;
    last_left_via: array['A'..'Z'] of char;
    first, finished: boolean;
    count_down: integer;

  begin
  for ptr := 'A' to 'Z' do
    begin
    last_left_via[ptr] := ptr;
    connect[ptr, ptr] := FALSE;
    end;
  count_down := k;
  finished := FALSE;
  current_node := start_node;

  while not finished do
    begin
    count_down := count_down - 1;
    if (count_down = 0) then
      begin
      dead := dead + [current_node];
      write(current_node, ' ');
      count_down := k;
      end;

    start_ptr := last_left_via[current_node];
    ptr := start_ptr;
    repeat
      ptr := succ(ptr);
      if (ptr > 'Z') then
        ptr := 'A';
    until (ptr = start_ptr) or ((not (ptr in dead)) and connect[ptr, current_node]);

    finished := (ptr in dead) or not connect[ptr, current_node];
    if not finished then
      begin
      last_left_via[current_node] := ptr;
      current_node := ptr;
      end;
    end;

  write('/', current_node, ' ');
  dead := dead + [current_node];
  first := TRUE;
  for ptr := 'A' to 'Z' do
    if (ptr in used) and not (ptr in dead) then
      begin
      if first then
        begin
        write('/', ptr);
        first := FALSE;
        end
      else
        write(' ', ptr);
      end;
  writeln;
  end;


begin
readln(line);
while (line <> '#') do
  begin
  init;
  process_line;
  solve;
  readln(line);
  end;
end.
