PROGRAM SomeProg;

#include "str.h"
	
CONST probname = 'PROBLEM';
      probnumber = 'S';
VAR debugcounter: integer;
CONST max = 100;

TYPE  index = 0..max;
      heading = (north, east, south, west);

VAR   w,b : integer;
      maze : array[index, index] of integer;
      hist : array[0..4] of integer;
      i,j : index;
      h : heading;
      Finished : Boolean;

FUNCTION ReadData : Boolean;        forward;
PROCEDURE Solveproblem;             forward;
FUNCTION NextRightClosed: Boolean;  forward;
FUNCTION ForwardOpen : Boolean;     forward;
PROCEDURE Move;                     forward;
PROCEDURE TurnRight;                forward;
PROCEDURE TurnLeft;                 forward;

PROCEDURE MainProg;
begin  {Main}

while ReadData do
  SolveProblem;

end; {of main procedure}

PROCEDURE Error(s: string);
begin writeln; writeln('Error - ', s); HALT end;

FUNCTION ReadData : Boolean;
VAR i,j : index;
    s : string;

begin
for i := 0 to max do for j := 0 to max do maze[i, j] := -1;
for i := 0 to 4 do hist[i] := 0;
readln(b, w);
if not( (b in [0..max]) and (w in [0..max]))
  then Error('w or b out of range');
if (w > 0) and (b > 0)
  then begin
    ReadData := true;
    for i := 1 to b do begin
      readln(s);
      if length(s) <> w then Error('Maze string wrong length' + s);
      for j := 1 to w do
        if s[j] = '0' then maze[i,j] := 0;
      end;
    end
  else ReadData := false;
end;  {Read Data}

PROCEDURE SolveProblem;
begin {Solve Problem}
i := b; j := 1; h := east; Finished := false;
repeat
  while NextRightClosed and ForwardOpen do Move;
  TurnRight; while not ForwardOpen do TurnLeft; Move;
  until Finished;

for i := 1 to b do
  for j := 1 to w do
    if maze[i,j] >= 0
      then hist[maze[i,j]] := hist[maze[i,j]] + 1;
for i := 0 to 4 do write(hist[i]:3); writeln;
end;  {Solve Problem}

FUNCTION NextRightClosed: Boolean;
VAR NRC: Boolean;
begin
case h of
  north: NRC := maze[i, j+1] < 0;
  east:  NRC := maze[i+1, j] < 0;
  south: NRC := maze[i, j-1] < 0;
  west:  NRC := maze[i-1, j] < 0;
  end;
NextRightClosed := NRC;
end;

FUNCTION ForwardOpen : Boolean;
VAR FO: Boolean;
begin
case h of
  north: FO := maze[i-1, j] >= 0;
  east:  FO := maze[i, j+1] >= 0;
  south: FO := maze[i+1, j] >= 0;
  west:  FO := maze[i, j-1] >= 0;
  end;
ForwardOpen := FO;
end;

PROCEDURE Move;
begin
if not Finished
  then begin
    maze[i,j] := maze[i,j] + 1;
    case h of
      north: dec(i);
      east:  inc(j);
      south: inc(i);
      west:  dec(j);
      end;  {case}
     end;
Finished := (i = b) and (j = 1);
end;

PROCEDURE TurnRight;
begin
if h = west
  then h := north
  else h := succ(h);
end;

PROCEDURE TurnLeft;
begin
if h = north
  then h := west
  else h := pred(h);
end;

begin mainprog end.