PROGRAM SomeName;

#include "str.h"

TYPE  chargesteps = 'A'..'E';
      ratesteps = (DayRate, EveningRate, NightRate);

CONST day = 1440;

VAR
      steptable:array[0..6] of record timebreak:integer; ratestep:ratesteps end;

      ratetable: array[chargesteps, ratesteps] of real;

      chargestep: chargesteps;
      ratestep: ratesteps;
      r: 0..6;
      periods: array[ratesteps] of integer;
      telnumber: string;
      cost: real;
      e_time, s_time, f_time,
      s_hour, s_minute,
      f_hour, f_minute : integer;
      ch, blank : char;
      i : integer;

procedure initial;
begin
    steptable[0].timebreak := 480; steptable[0].ratestep := NightRate; {08am}
    steptable[1].timebreak := 1080; steptable[1].ratestep := DayRate;  {06pm}
    steptable[2].timebreak := 1320; steptable[2].ratestep := EveningRate; {10pm}
    steptable[3].timebreak := 1920; steptable[3].ratestep := NightRate;
    							     {08am - next day}
    steptable[4].timebreak := 2520; steptable[4].ratestep := DayRate;  {06pm}
    steptable[5].timebreak := 2760; steptable[5].ratestep := EveningRate; {10pm}
    steptable[6].timebreak := 2880; steptable[6].ratestep := NightRate;
    							      {midnight}

    ratetable['A', DayRate] := 0.10;
    ratetable['A', EveningRate] := 0.06;
    ratetable['A', NightRate] := 0.02;
    ratetable['B', DayRate] := 0.25;
    ratetable['B', EveningRate] := 0.15;
    ratetable['B', NightRate] := 0.05;
    ratetable['C', DayRate] := 0.53;
    ratetable['C', EveningRate] := 0.33;
    ratetable['C', NightRate] := 0.13;
    ratetable['D', DayRate] := 0.87;
    ratetable['D', EveningRate] := 0.47;
    ratetable['D', NightRate] := 0.17;
    ratetable['E', DayRate] := 1.44;
    ratetable['E', EveningRate] := 0.80;
    ratetable['E', NightRate] := 0.30;
end;


begin  {Main}
initial;

read(ch);
while ch <> '#' do begin
  repeat read(blank) until blank <> ' ';
  telnumber := blank;
  for i := 1 to 7 do
      begin
      read(blank);
      telnumber := telnumber + blank;
  end;
  readln(s_hour, s_minute, f_hour, f_minute);
  s_time := s_hour * 60 + s_minute;
  f_time := f_hour * 60 + f_minute;
  if f_time <= s_time
    then f_time := f_time + day;
  e_time := s_time; cost := 0;
  for ratestep := DayRate to NightRate do periods[ratestep] := 0;
  while e_time < f_time do begin
    r := 0; while s_time >= steptable[r].timebreak do r := r+1;
    if steptable[r].timebreak > f_time
      then e_time := f_time
      else e_time := steptable[r].timebreak;
    ratestep := steptable[r].ratestep;
    periods[ratestep] := periods[ratestep] + e_time-s_time;
    cost := cost + (e_time-s_time)*ratetable[ch, steptable[r].ratestep];
    s_time := e_time;
    end;
  write('  ', telnumber);
  for ratestep := DayRate to NightRate do write(periods[ratestep]:6);
  writeln('  ', ch, cost:8:2);
  read(ch) end;
end. {of program}
