/*
    Panel management header file
    Copyright (c) Tudor Hulubei & Andrei Pitis, April 1994

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __PANEL_H
#define __PANEL_H


#include <dirent.h>
#include <limits.h>
#include "edit.h"
#include "config.h"


#define MAX_ENTRIES	0x400


#define act_NOACTION		 0
#define act_ENTER		 1
#define act_COPY		 2
#define act_DELETE		 3
#define act_SELECT		 4
#define act_SELECTALL		 5
#define act_UNSELECTALL		 6
#define act_TOGGLE		 7
#define act_MODE		 8
#define act_MKDIR		 9
#define act_MOVE		10
#define act_UP			11
#define act_DOWN		12
#define act_PGUP		13
#define act_PGDOWN		14
#define act_HOME		15
#define act_END			16
#define act_CHDIR    		17
#define act_REFRESH		18
#define act_SWITCH		19


 
#define DIR_ENTRY		0 
#define FILE_ENTRY		1
#define SYMLINK_ENTRY		2
#define FIFO_ENTRY		3
#define SOCKET_ENTRY		4


typedef struct
{
    char *name;
    unsigned char selected   : 1,
    		  type       : 4,
    		  executable : 1;
    int  size, mode, uid, gid;
    char owner[8];
    char group[8];
    char date[15];
} _dir_entry;


typedef struct
{
    int on_screen;
    int current_entry;
    int first_on_screen;
    int last_index, found_selection, end;
    int lines, columns, begin_x, begin_y;
    int mode, chkdest, info_dirty;
    int entries, focus, selected_files;
    unsigned int maxname;
    edit *edt;
    DIR *dir;
    window *win;
    char path[PATH_MAX];
    _dir_entry dir_entry[MAX_ENTRIES];
} panel;

void panel_recover(panel *this);
void panel_update(panel *this);  
void panel_update_frame(panel *this);
void panel_update_info(panel *this);
void panel_update_path(panel *this);
void panel_update_size(panel *this);
void panel_update_entry(panel *this, int entry);
void panel_trunc_fname(char *fname, char *dest, int len);
int  panel_move(panel *this, char *from, char *to);
int  panel_copy(panel *this, char *src, char *dest, int mode);
int  panel_verify_name(char *file_name);
int  panel_getnext(panel *this);
int  panel_getindex(panel *this, char *str);
int  panel_getdirinfo(panel *this, char *directory, int verify);

panel *panel_init(int lines, int columns, int begin_x, int begin_y, char *path, 
		  edit *edt, int *UserHeartAttack, configuration *config);
void  panel_end(panel *this);
void  panel_setfocus(panel *this, int status, panel *link);
void  panel_nooptimizations(panel *this);
int   panel_action(panel *this, int action, panel *link,
		   void *aux_info, int repeat_count);
char *panel_getpath(panel *this, char *temppath, unsigned len);
char *panel_getcurrentfilename(panel *this);
int   panel_getcurrentfileuid(panel *this);
int   panel_getcurrentfilegid(panel *this);
int   panel_getcurrentfilemode(panel *this);
int   panel_getcurrentfiletype(panel *this);


#endif
