/***********************************************************
*  Mirror Magic II -- McDuffins Revenge                    *
*----------------------------------------------------------*
*  1994 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.ms.sub.org                  *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
*----------------------------------------------------------*
*  events.c                                                *
*                                                          *
*  Letzte Aenderung: 29.09.1994                            *
***********************************************************/

#include "events.h"
#include "tools.h"
#include "game.h"

void EventLoop(void)
{
  XEvent event;
  int pending;

  for(;;)
  {
    pending=XPending(display);

    if (pending)	/* got an event */
    {
      for(; pending>0; pending--)
      {
	XNextEvent(display, &event);
	switch(event.type)
	{
	  case Expose:
	    HandleExposeEvent((XExposeEvent *) &event);
	    break;
	  case ButtonPress:
	    button_status = ((XButtonEvent *) &event)->button;
	    HandleButtonEvent((XButtonEvent *) &event);
	    break;
	  case ButtonRelease:
	    button_status = MB_UNPRESSED;
	    HandleButtonEvent((XButtonEvent *) &event);
	    break;
	  case MotionNotify:
	    HandleMotionEvent((XMotionEvent *) &event);
	    break;
	  case KeyPress:
	  case KeyRelease:
	    HandleKeyEvent((XKeyEvent *) &event);
	    break;
	  default:
	    break;
	}
      }
    }
    else		/* got no event, but don't be lazy... */
      HandleButton(-1,-1,button_status);

    if (game_status==EXITGAME)
      return;
  }
}

void HandleExposeEvent(XExposeEvent *event)
{
  int x=event->x, y=event->y;
  int w=event->width, h=event->height;

  XCopyArea(display,pix[DB_BACK],window,gc,x,y,w,h,x,y);
}

void HandleButtonEvent(XButtonEvent *event)
{
  HandleButton(event->x, event->y, button_status);
}

void HandleMotionEvent(XMotionEvent *event)
{
  if (game_status!=PLAYING)
    HandleButton(event->x, event->y, button_status);
}

void HandleButton(int mx, int my, int button)
{
  static int old_mx=0, old_my=0;
  int delay;

  if (mx<0 || my<0)
  {
    mx=old_mx;
    my=old_my;
  }
  else
  {
    old_mx=mx;
    old_my=my;
  }

  ColorCycling();

  switch(game_status)
  {
    case MAINMENU:
      HandleMainMenu(mx,my,button);
      break;
    case CHOOSENAME:
      HandleNameInput(mx,my,button);
      break;
    case HALLOFFAME:
      HandleHallOfFame(button);
      break;
    case LEVELED:
      LevelEd(mx,my,button);
      break;
    case HELPSCREEN:
      HandleHelpScreen(button);
      break;
    case PLAYING:
      delay=Counter();
      ClickElement(mx,my,button);
      if (WN)
	GameWon();
      else
      {
	switch(GameActions(mx,my,button))
	{
	  case 1:
	    game_status=MAINMENU;
	    DrawMainMenu();
	    BackToFront();
	    break;
	  case 2:
	    game_status=PLAYING;
	    DrawLevel();
	    InitGame();
	    ScanLaser();
	    break;
	  default:
	    break;
	}
      }
      if (!button && !OL && delay<=Counter())
	WaitCounter(delay+3);
      break;
    default:
      Delay(1000);
      break;
  }
}

void HandleKeyEvent(XKeyEvent *event)
{
  KeySym key = XLookupKeysym(event,event->state);

  switch(game_status)
  {
    case TYPENAME:
      HandleNameTyping(0,key);
      break;
    case MAINMENU:
      switch(key)
      {
	case XK_S:
	case XK_s:
	  sound_on=!sound_on;
	  break;
	case XK_T:
	case XK_t:
	  toons_status=!toons_status;
	  break;
	default:
	  break;
      }
    default:
      break;
  }

/*
  key = XLookupKeysym(event,event->state);
  switch(key)
  {
    case XK_Q:
    case XK_q:
      printf("BYE!\n");
      game_status=EXITGAME;
      break;
    case XK_X:
    case XK_x:
    {
      int xw_screen_num = DefaultScreen(display);
      XImage *xi;
      int i;
    
      xi = XGetImage(display,
		     RootWindow(display,xw_screen_num),
		     0,0,160,100,AllPlanes,ZPixmap);
    
      for(i=0;i<100;i++)
	XPutImage(display,window,gc,xi,0,0,i,i,160,100);
    
      XDestroyImage(xi);
      break;
    }
    case XK_Y:
    case XK_y:
    {
      int i;

      for(i=0;i<10;i++)
      {
	XCopyArea(display,pix[BACK],window,gc,0,0,WIN_XSIZE,WIN_YSIZE,0,0);
	XFlush(display);
      }

      for(i=0;i<10;i++)
      {
	int x,y;

	XCopyArea(display,pix[BACK],window,gc,0,0,WIN_XSIZE,WIN_YSIZE,0,0);
	XFlush(display);

	for (y=0;y<12;y++)
	  for(x=0;x<16;x++)
	    XCopyArea(display,pix[BACK],window,gc,
		      8,104,32,32,8+x*32,8+y*32);
	XFlush(display);
      }
      break;
    }    
    default:
      break;
  }
*/
}
