/*
** Astrolog (Version 4.00) File: placalc.h
**
** IMPORTANT NOTICE: the graphics database and chart display routines
** used in this program are Copyright (C) 1991-1993 by Walter D. Pullen
** (cruiser1@stein.u.washington.edu). Permission is granted to freely
** use and distribute these routines provided one doesn't sell,
** restrict, or profit from them in any way. Modification is allowed
** provided these notices remain with any altered or edited versions of
** the program.
**
** The main planetary calculation routines used in this program have
** been Copyrighted and the core of this program is basically a
** conversion to C of the routines created by James Neely as listed in
** Michael Erlewine's 'Manual of Computer Programming for Astrologers',
** available from Matrix Software. The copyright gives us permission to
** use the routines for personal use but not to sell them or profit from
** them in any way.
**
** The PostScript code within the core graphics routines are programmed
** and Copyright (C) 1992-1993 by Brian D. Willoughby
** (brianw@sounds.wa.com). Conditions are identical to those above.
**
** The extended accurate ephemeris databases and formulas are from the
** calculation routines in the program "Placalc" and are programmed and
** Copyright (C) 1989,1991,1993 by Astrodienst AG and Alois Treindl
** (alois@azur.ch). The use of that source code is subject to
** regulations made by Astrodienst Zurich, and the code is not in the
** public domain. This copyright notice must not be changed or removed
** by any user of this program.
**
** Initial programming 8/28,30, 9/10,13,16,20,23, 10/3,6,7, 11/7,10,21/1991.
** X Window graphics initially programmed 10/23-29/1991.
** PostScript graphics initially programmed 11/29-30/1992.
** Last code change made 12/31/1993.
*/

#include "astrolog.h"

#ifdef ASTROLOG
#define EPHE_PATH EPHE_DIR
extern int lrz_file_posit();
extern int chi_file_posit();
extern int outer_hel();
extern void longreorder();
extern int inpolq();
#endif
#ifdef PLACALC
#ifdef ASTROLOG
/* Begin contents of astrolib.h */
#endif
/************************************************************
   $Header: placalc.h,v 1.4 93/03/22 10:08:39 alois Exp $
   definitions and constants for planetary routines

   ATTENTION: PLACALC USERS ON MSDOS:
   See the note close to the end of this file regarding EPHE_PATH.

  ---------------------------------------------------------------
  | Copyright Astrodienst AG and Alois Treindl, 1991, 1993.	|
  | The use of this source code is subject to regulations made	|
  | by Astrodienst Zurich. The code is NOT in the public domain.|
  |								|
  | This copyright notice must not be changed or removed	|
  | by any user of this program.				|
  ---------------------------------------------------------------

************************************************************/
# ifndef _PLACALC_INCLUDED
# define _PLACALC_INCLUDED

#ifndef ASTROLOG
#include "ourdef.h"	/* this is the basic include files which
			contains many definitions used throughout
			Astrodienst's programs.
			*/
#else /* ASTROLOG */
#ifdef ASTROLOG
/* Begin contents of ourdef.h */
#endif
/************************************************************
   $Header: ourdef.h,v 1.2 91/11/16 16:21:37 alois Exp $
   definitions and constants for all Astrodienst C programs
   contains only declarations and #defines, no global variables.
   auto-dectection of MSDOS (TURBO_C or MS_C) or HPUNIX
   
************************************************************/

#ifndef _OURDEF_INCLUDED /* allow multiple #includes of ourdef.h */
#define _OURDEF_INCLUDED
 
# define MY_TRUE 1	/* for use in other defines, before TRUE is defined */
# define MY_FALSE 0	/* for use in other defines, before TRUE is defined */

#ifdef MSDOS	/* already defined by some DOS compilers */
# undef MSDOS
# define MSDOS MY_TRUE
#endif

#ifdef __TURBOC__	/* defined by  turboc */
# ifndef MSDOS
#   define MSDOS MY_TRUE
# endif
# define TURBO_C
#endif

#if MSDOS
#  define HPUNIX MY_FALSE
#  ifndef TURBO_C
#    define MS_C	/* assume Microsoft C compiler */
#  endif
#else
#  define MSDOS MY_FALSE
#  define HPUNIX MY_TRUE
#  ifndef _HPUX_SOURCE
#    define _HPUX_SOURCE
#  endif
#endif

#include <math.h>
#ifndef FILE
#include <stdio.h>
#endif

#include <stdlib.h>
# if HPUNIX
#include <unistd.h>
# endif

#ifndef TRUE 
#define TRUE 1
#define FALSE 0
#endif

#ifndef OK 
#define OK (0)
#define ERR (-1)
#endif


# define UCHP	(unsigned char*)	/* used for casting *char  */
# define UCP	(unsigned char*)	/* used for casting *char  */
# define SCP	(char*)			/* used for casting *unsigned char */
# define UCHAR	unsigned char
 
#if HPUNIX
#include <malloc.h>
  typedef double  REAL8;  /* real with at least 64 bit precision */
  typedef float   REAL4;  /* real with at least 32 bit precision */
  typedef long     INT4;   /* signed integer with at least 32 bit precision */
  typedef unsigned long UINT4; 
			/* unsigned integer with at least 32 bit precision */
  typedef int     INT2;   /* signed integer with at least 16 bit precision */
  typedef int     INT1;   /* signed integer with at least 8  bit precision */
# ifndef dbd_VERSION	/* db_vista defines boolean in vista.h already */
			/* vista.h must be included before ourdef.h */
  typedef int     BOOLEAN;
# endif
  typedef unsigned short UINT2;	/* unsigned 16 bits */
# define ABS4	abs		/* abs function for long */
# define CHARSET_HP TRUE	/* used by ctype256 */
# define START_OF_EXTRA_CHAR 161
# define DEGREE_CHAR 179	/* HP degree character */
# endif

#if MSDOS 
#ifdef TURBO_C
#  include <alloc.h>		/* MSC needs malloc ! */
#else
#  include <malloc.h>
#endif
#include <stdlib.h>
#define HUGE 1.7E+308     /* biggest value for REAL8 */
#undef M_PI
#define M_PI 3.14159265358979323846
  typedef double  REAL8;  /* real with at least 64 bit precision */
  typedef float   REAL4;  /* real with at least 32 bit precision */
  typedef long    INT4;   /* signed integer with at least 32 bit precision */
  typedef unsigned long UINT4;
                          /* unsigned integer with at least 32 bit precision */
  typedef int     INT2;   /* signed integer with at least 16 bit precision */
  typedef int     INT1; /* signed integer with at least 8  bit precision */
  typedef int     BOOLEAN;
  typedef unsigned int UINT2;	/* unsigned 16 bits */
# define ABS4	labs		/* abs function for long */ 
# define START_OF_EXTRA_CHAR 128
# define DEGREE_CHAR 248	/* MSDOS degree character */
# define CHARSET_IBM TRUE	/* remains undefined if not msdos */
#endif
 
#define forward extern

#define MINUTE_CHAR  39	/* minute character */
#define SECOND_CHAR  34	/* second character */
#define MAXCHAR 256     /* used for string declarations, allowing 255 char+\0 */
#define COMMA ','
 
#define COS8 cos
#define SIN8 sin
#define ASIN8 asin
#define TAN8 tan
#define ATAN8 atan
#define ATAN28 atan2
#define EXP10(x) pow(10.0,(x))
#define ABS8(x) fabs(x)
 
#define TANERRLIMIT 1.0E-10     /* used to check for arguments close to pi */
#define NEAR_ZERO   1.0E-16     /* used to compare for divisors close to 0 */
#define BIGREAL  1.0E+38
 
#define DEGTORAD 0.0174532925199433
#define RADTODEG 57.2957795130823
 
typedef INT4    centisec;       /* centiseconds used for angles and times */
#define CS	(centisec)	/* use for casting */
#define CSEC	centisec	/* use for typing */
	

#define DEG     360000L  /* degree expressed in centiseconds */
#define DEG7_30 (2700000L)	/* 7.5 degrees */
#define DEG15   (15 * DEG)
#define DEG24   (24 * DEG)
#define DEG30   (30 * DEG)
#define DEG60   (60 * DEG)
#define DEG90   (90 * DEG)
#define DEG120  (120 * DEG)
#define DEG150  (150 * DEG)
#define DEG180  (180 * DEG)
#define DEG270  (270 * DEG)
#define DEG360  (360 * DEG)
 
#define CSTORAD  4.84813681109536E-08 /* centisec to rad: pi / 180 /3600/100 */
#define RADTOCS  2.06264806247096E+07 /* rad to centisec 180*3600*100/pi */
 
#define DEG2MSEC 3600000.0	/* degree to milliseconds */
#define DEG2CSEC 360000.0	/* degree to centiseconds */

#define SEC2CSEC	100	/* seconds to centiseconds */

#define CS2DEG	(1.0/360000.0)	/* centisec to degree */
#define CS2CIRCLE (CS2DEG/360.0)	/* centisec to circle */
#define AU2INT	 1e7		/* factor for long storage of A.U. */

#define CSMIN	6000L
#define CSSEC	100L

# define SINDEG(x)	sin(DEGTORAD * (x))
# define COSDEG(x)	cos(DEGTORAD * (x))
# define TANDEG(x)	tan(DEGTORAD * (x))
# define SINCS(x)	sin((double)(CSTORAD * (x)))
# define COSCS(x)	cos((double)(CSTORAD * (x)))
# define TANCS(x)	tan((double)(CSTORAD * (x)))

typedef long CMM;		/* plotmod unit 0.01 mm */
# define CMM2PT       0.028346457	/* factor for CMM to points */

typedef double *vector;
 
#endif /* _OURDEF_INCLUDED */
#ifdef ASTROLOG
/* End contents of ourdef.h */
#endif
#endif /* ASTROLOG */

/*************************************************************
 Exported functions:

 In all functions the variable jd_ad indicates the use of
 Astrodienst relative julian days, and jd the use of absolute
 julian days.
*************************************************************/
extern int nacalc(REAL8 jd_ad, centisec *plon, centisec *pspe);
extern int calcserv(int id, REAL8 t, int flag, int plalist, char *so);
extern void helup(REAL8 jd_ad);
extern void togeo(REAL8 le, REAL8 re, REAL8 l, REAL8 r, REAL8 z, REAL8 *alg, REAL8 *arg);
extern int  calc(int p,
		 REAL8 jd_ad,
		 int flag, 
		 REAL8 *alng,
		 REAL8 *arad,
		 REAL8 *alat,
		 REAL8 *alngspeed);
extern int rel_geo(int planet, double rau);
extern int hel( int	planet,	/* planet index as defined by placalc.h */
		REAL8	jd_ad,	/* relative juliand date, ephemeris time */
				/* Now come 6 pointers to return values. */
		REAL8	*al,	/* longitude in degrees */
		REAL8   *ar,	/* radius in AU */
		REAL8   *az,	/* distance from ecliptic in AU */
		REAL8   *alp, 	/* speed in longitude, degrees per day */
		REAL8   *arp,	/* speed in radius, AU per day */
		REAL8   *azp);   /* speed in z, AU per day */
extern int  moon(REAL8 *al, REAL8 *ar, REAL8 *az);
extern REAL8 fraction(REAL8 t);
extern REAL8 sidtime(REAL8 jd_ad, REAL8 ecl, REAL8 nuta);
extern REAL8 smod8360(REAL8 x);
extern REAL8 mod8360(REAL8 x);
extern REAL8 diff8360(REAL8 x, REAL8 y);
extern REAL8 test_near_zero(REAL8 x);
extern REAL8 deltat(REAL8 jd_ad);
extern void to_mean_ekl (double jd, double xyz[], double lrz[]);

/*
 * get the planet index for an AFL letter
 * returns -1 if the letter does not correspond to a planet.
 */
extern int afl2planet(int apl);
 
/*************************************************************
	exported variables
*************************************************************/
extern REAL8 meanekl;
extern REAL8 ekl;
extern REAL8 nut;

extern struct elements { /* actual elements at time thelup */
  REAL8 tj,     /* centuries from epoch */
        lg,     /* mean longitude in degrees of arc*/
        pe,     /* longitude of the perihelion in degrees of arc*/
        ex,     /* excentricity in degrees of arc*/
        kn,     /* longitude of node in degrees of arc*/
        in,     /* inclination of the orbit in degrees of arc*/
        ma;     /* mean anomaly in degrees of arc*/
   } el [];

extern char *ephe_path;
extern char *placalc_err_text;
  
/*************************************************************
	definitions
*************************************************************/

/*
 * planet index numbers, used to identify a planet in calc() and
 * other related functions.
 */
#define CALC_ONLY_ECL_NUT -1	/* pseudo planet index for calls to calc */
#define SUN	0		/* used synonymously for earth too */
#define EARTH	0
#define MOON	1
#define MERCURY 2
#define VENUS	3
#define MARS	4
#define JUPITER	5
#define SATURN	6
#define URANUS	7
#define NEPTUNE 8
#define PLUTO	9
#define LASTPLANET PLUTO
#define MEAN_NODE  10
#define TRUE_NODE  11
#define CHIRON	   12
#define CALC_N	   13	/* number of planets in placalc module */
#define LILITH	   13	/* Lilith is separate, not included in standard set
			   of placalc planets. This is required because
			   otherwise some string server calls would
			   suddenly return a higher number of fields.
			   */

/*
 * houses and axes get also a 'planet' index number, but they
 * are not used by placalc itself
 * between chiron and AC we leave 6 places unused for some other celestial
 * bodies or chart factors.
 * Axes and houses cannot be computed with calls to calc(); they must
 * be computed with the housasp module functions.
 */
# define AC	   19
# define MC	   20
# define CALC_N_MC  21	/* number of normal natal factors */

# define FIRST_HSNR 21
# define LAST_HSNR 32
# define NO_OF_HOUSES 12
#define MAX_PL_INDEX 32
/*
 * in a bitlist flag each planet is represented by a bit;
 * all 13 defined planets can be called at once with
 * LILITH is not automatically included
 */
#define CALC_ALL_PLANET_BITS  ((1 << 13) - 1)	/* bits 0..12 set */

/*
 * AFL: Astrological factor letters for use in selections strings.
 * Each factor (planet, house cusp etc) has a typical letter which
 * can be combined in a selctions string for specifying a certain
 * sequence of factors for a table or other kind of display.
 * The function apl2planet() can be used to translate the AFL letters
 * into planet indices.
 */

# define AFL_SUN	'0'
# define AFL_MON	'1'
# define AFL_MER	'2'
# define AFL_VEN	'3'
# define AFL_MAR	'4'
# define AFL_JUP	'5'
# define AFL_SAT	'6'
# define AFL_URA	'7'
# define AFL_NEP	'8'
# define AFL_PLU	'9'
# define AFL_CHI	'c'
# define AFL_LIL	'i'	/* mean Lilith: direction of lunar aphel */
# define AFL_AC		'A'
# define AFL_MC		'M'
# define AFL_TNODE	'N'	/* TRUE_NODE */
# define AFL_MNODE	'n'	/* MEAN_NODE */

/*
 * other AFL definitions not recognized by afl2planet()
 */
# define AFL_SIDT	's'	/* sidereal time */
# define AFL_WDAY	'd'	/* day of week column */

# define apl2planet	afl2planet	/* change of original name */


# define J2000	2451545.0	/* Epoch of JPL ephemeris DE200, absolute */
# define J1950  2433282.423	/* Epoch of JPL ephemeris DE102 */
#define JUL_OFFSET 2433282.0	/* offset of Astrodienst relative Julian date */
#define EPOCH1850 -36524.0	/* jupiter,saturn 0 jan 1850, 12:00 */
#define EPOCH1900 -18262.0	/* inner planets  0 jan 1900, 12:00 */
#define EPOCH1950  0.0		/* pluto 	  0 jan 1950, 12:00 */
                                /* this is the origin of the Astrodienst
                                   relative julian calendar system */
#define EPOCH1960  3653.0	/* uranus,neptune 1 jan 1960, 12:00 */

#define ENDMARK  99		/* used to mark the end of disturbation terms */

#define NODE_INTERVAL	0.005	/* days, = 7m20s */
#define MOON_SPEED_INTERVAL  0.0001 /* 8.64 seconds later */

/*
 * flag bits used in calc and calcserv
 */
# define CALC_BIT_HELIO	1	/* geo/helio */
# define CALC_BIT_NOAPP	2	/* apparent/true positions */
# define CALC_BIT_NONUT	4	/* true eq. of date/ mean equ. of date */
# define CALC_BIT_EPHE	8	/* universal/ephemeris time */
# define CALC_BIT_SPEED	16	/* without/with speed */
# define CALC_BIT_BETA	32	/* without/with latitude */
# define CALC_BIT_RGEO	64	/* without/with relative rgeo */
# define CALC_BIT_RAU	128	/* without/with real radius */
# define CALC_BIT_MUST_USE_EPHE	256	/* epheserv may not use calc */
# define CALC_BIT_MAY_USE_EPHE	512	/* calcserv may use ephread */

# if HPUNIX
#   define XYZ_FILE  "/users/ephe/xyz1950"	/* for creating */
#   define LRZ_FILE "/users/ephe/LRZ5_"	/* for creating */
#   define OPEN_EPHE "r"	
#ifndef ASTROLOG
#   define EPHE_PATH "/users/ephe"	/* for  LRZ and CHI */
#endif
# else

/* ephemeris file path for MSDOS */

/*****************************************************************************
******************************************************************************
  ATTENTION: PLACALC USERS ON MSDOS:

  EPHE_PATH indicates where the ephemeris files LRZ_nnn and CHI_nnn
  are found in you system.
  EPHE_PATH is only used once at the beginning of placalc.c to initialize
  the global variable ephe_path.

  If you do not have the ephemeris files in \PAIR\EPHE, you must do one of
  two things:
  - change the #define statement below to point to your ephemeris directory
  - OR change the global char *ephe_path before  you call any placalc
  function.
  Take care, that ephe_path ends NOT with the directory character ('\' in DOS).
******************************************************************************
*****************************************************************************/
#ifndef ASTROLOG
#   define EPHE_PATH "\\pair\\ephe"	
#endif

#   define OPEN_EPHE "rb"		/* read binary */
# endif

# define EPHE_STEP	80		/* days step in LRZ ephe */
# define EPHE_DAYS_PER_FILE 100000	/* days per ephe file */
# define EPHE_OUTER "LRZ5_"		/* file name prefix */
# define EPHE_OUTER_BSIZE	60	/* blocksize  */
# define EPHE_CHIRON "CHI_"		/* file name prefix */
# define EPHE_CHIRON_BSIZE	12	/* blocksize  */

/********************************************
  About the format of the ephemeris files
  ----------------------------------------
  We use currently ephemeris files with steps of 80 days.
  There are 1250 "records" in each file, so that one file
  spans 100000 days.
  We have two types of ephemeris files:
  LRZ5_nn 	for the outer planets Jupiter ... Pluto
  CHI_nn	for Chiron.
  nn is an expression derived from the first julian daynumber on the
  file. Jd 2100'000 to 2199'920 is on file LRZ5_21 and CHI_21;
  for negative Jd we use the filenames LRZ5_Mxx  with M indicating the minus.

  Given the jd for which you want the ephemeris, it is simple to build
  the filename and use fseek() within the file to go where the data is.
  This is done by the functions lrz_file_posit() and chi_file_posit().

  The stored coordinates are for each date and planet:
  L = ecliptic longitude relative to mean exquinox of date,
      in units of milliseconds of acr (1/3600000 degree) as type long;
  R = radius vector, units of 10-7 AU, as type long.
  Z = disctance of ecliptic; Z = R * sin(latitude); in units of 10-7 AU,
      as type long.
  The data is stored in the byte ordering of the Astrodienst HPUX machines,
  which is most significant byte first. It is not the same byte ordering
  as on Intel processors; the function longreorder() converts between
  the disk file format and the internal format of MSDOS machines.

  For LRZ5- files, we have 60-byte records LRZ(Jupiter),LRZ(Saturn),
  LRZ(Uranus), LRZ(Neptune), LRZ(Pluto). 
  For CHI-files we have 12-byte records LRZ.

************************************************/

# endif /* _PLACALC_INCLUDED */
#ifdef ASTROLOG
#ifdef ASTROLOG
/* Begin contents of astrolib.h */
#endif
/*******************************************
$Header: astrolib.h,v 1.2 91/11/16 16:21:02 alois Exp $
astrolib.h

NOTE for users of the PLACALC package:
This include files declares many function which
are NOT part of the PLACALC package. It is only
included because it also declares some items contained
in PLACALC.

ourdef.h should be included before this!

*******************************************/
# ifndef _ASTROLIB_INCLUDED
# define _ASTROLIB_INCLUDED

/* define days of the week for day_of_week() results */
# define DOW_MONDAY	0
# define DOW_SUNDAY	6

# define ORD_DIV	10000		/* for kdv and clients */

/* makros for bit operations */
# define clear_bit(v,bit_nr) 	((v) & ~(1L << (bit_nr)))
# define set_bit(v,bit_nr) 	((v) | (1L << (bit_nr)))
# define bit(bit_nr)		(1L << (bit_nr))
# define check_bit(v,bit_nr)	((v) & (1L << (bit_nr)))

# define SPLIT_CS_ROUND_SEC    1
# define SPLIT_CS_ROUND_MIN    2
# define SPLIT_CS_ROUND_DEG    4
# define SPLIT_CS_ROUND_ASTRO  8
# define SPLIT_CS_MOD_360      16
# define SPLIT_CS_MOD_24       32

/*******************************************
type definitions
********************************************/
struct adate {	/* date structure used by revjuls and juldays */
       int day, month, year;
       centisec csec;
       };

struct spl_cs {
  centisec cs;
  int sign;
  int degree;
  int min;
  int sec;
};

extern UCHAR *atl_collaps (UCHAR *isp, UCHAR *osp);	/* atlclps.c */
extern UCHAR *atl_uncollaps (UCHAR *isp, UCHAR *osp);

extern isalpha256(int);				/* ctype256.c	*/
extern isalnum256(int);
extern isupper256(int);
extern toupper256(int);
extern tolower256(int);
extern isspace256(int);

/* functions exported by gettext.c */
  extern open_text( char *filename, int max);	/* returns OK or ERR */
  extern void close_text();	
  extern char *get_text(int nr);
  extern char get_textc(int nr);
  extern get_text_array(char *array[], int nr, int arraysie);
	/* returns OK or ERR */

# define isdigit256(x) (isascii(x) && isdigit(x))

/****************************************
  converts astrodienst daynumber to string
****************************************/
extern char *adate_to_asc(char *cp, int adate);

extern double adate_to_julday(int adate);

extern int cut_string(char *s, char *cpos[], int nmax);		/* cutstr.c */
extern char *remove_nl(char *s);	
extern int comma_count(char *s);

extern int cut_string_any(char *s, char *cutlist, char *cpos[], int nmax);
		/* cutstr2.c	*/

extern long d2l(double x);				/* d2l.c	*/

extern int date_conversion 				/* dateconv.c */
	    (int d,
	     int m,
	     int y,		/* day, month, year */
	     centisec gmtime, 	/* greenwich time in centiseconds */
	     char c, 	/* calendar g[regorian]|j[ulian]|a[stro = greg] */
	     REAL8 *tgmt	/* julian date relative 0.Jan.1950 12:00 gmt */
				/* shift is 2433282 from absolute Julian date */
	    );			/* return OK or ERR */

extern int degstr_conversion (char *s, centisec *t);		/* degstr.c */

extern int day_of_week(double jd);			/* julday.c */
	/* monday = 0, ... sunday = 6 */

extern double dtime(void);				/* ourtime.c */
	/* returns seconds since 1970, with fraction
	   and a resolution of microseconds */

extern void ecl_to_equ(double al, double ab, double obl, double *ra, double *d);
							/* ecl2equ.c */

/****************************************
 * gets astrodienst daynumber from system time
****************************************/
extern int get_adate(void);

/* get a long consisting of hhmmss of current time */
extern long get_hms(void);				/* ourtime.c */

extern int get_lpb(char *pname);			/* get_lpb.c */

extern int hp2ibm(int c);				/* hp2ibm.c	*/

extern int ibm2hp(int c);				/* ibm2hp.c	*/

/*
 * interpolation of third order with Newton and Stirling formulas for
 * vectors of double or long.
 * One needs n+1 input values for n output values.
 * u is the normalized x-value to which we interpolate.
 * u is legal within -0.5 .. + 1.0
 * The same array can be used for output and input; the last value will
 * then be unchanged after the call.
 * Attention, the function values must be steady; they cannot have jumps
 * like typical planetary longitudes have when they cross zero degree.
 * You must use make_steady() before calling interpol() otherwise,
 * and later  use norm_range() to normalize again into your range.
 */
extern int interpod(double in[], double out[], double u, int n); /*interpod.c */
extern void make_steady_d(double x[], int n, double range);
extern double norm_range_d(double x, double range);

extern int interpol(long in[], long out[], double u, int n); /* interpol.c */
extern void make_steady_l(long x[], int n, long range);
extern long norm_range_l(long x, long range);


extern double julday(int month, int day, int year, double hour, int gregflag);
							/* julday.c	*/
extern double juldays(int gregflag, struct adate *adp); /* juldays.c	*/

extern char *kdv_collaps (char *osp, char *isp);	/* kdvclps.c */
extern char *kdv_collaps_w (char *osp, char *isp, char *w);
extern char *string_to_lower(char *c);

extern void log_report(FILE *fp, char *s1, char *s2);	/* writelog.c */

extern char *get_file_name(char *file_path );
extern char *makepath(char *d, char *s);	/* makepath.c 	*/

extern char *out_ll(char *s, centisec l, char ch_dflt, char ch_opps);
						/* outll.c	*/
extern char *out_merid(char *s, centisec l);	/* outmerid.c	*/

extern char *nord_to_date(char *cp, long nord);	/* outnord.c */
extern char *out_nord (char *s, long nord);	/* outnord.c */
extern char *out_nords (long nord);		/* outnord.c */
extern char *out_nordhs (long nord, int nhor);/* outnord.c */

extern char *out_time(char *s, centisec l);	/* outtime.c	*/

extern char *print_date_time(char *s);
/*
 * output current date and time in Format: 20-Jul-89 23:20
 */

extern char *print_date_time_sec(char *s);
/*
 * output current date and time with 1/100th of second precision
 */

extern char *print_timestamp(char *s, long ntst);
/*
 * output ntst date and time in format: 20-Jul-89 23:20
 */

extern void revjul (double u,			/* revjul.c */
	      int gregflag,
	      int *jmon, int *jday, int *jyear,
	      double *jut);

extern void revjuls(double u, int gregflag, struct adate *adp); /* revjuls.c */

extern char *rm_nonprint( char *);			/* rmuscore.c	*/
extern char *rm_uscore( char *);			/* rmuscore.c	*/

extern void split_cs(struct spl_cs *psplit, int roundflag); /* splitcs.c */

extern char *stristr(char *si, char *pi);		/* stristr.c	*/
/* extern char *strstr(char *si, char *pi);		 stristr.c	*/

extern char *sread(char *s, char *r, int max);		/* sread.c	*/

extern centisec simple_degstr_conversion(char *s);	/* sdegstr.c	*/

extern int timestr_conversion(char *s, centisec *t);	/* timestr.c	*/

extern char *upcase_first_letters( char *s);		/* upcase1.c	*/

extern char *TimeString (CSEC t, int sep, BOOLEAN suppressZero); /* outdeg.c */
extern char *LonLatString (CSEC t, char pchar, char mchar);	/* outdeg.c */
extern char *DegreeString (CSEC t);				/* outdeg.c */

/********************************************************
functions from csec.c
********************************************************/

/*
 * round the arguments to full seconds, takes care with zodiac sign changes:
 * does not round 2929'59.6" to 0 of next sign but to 2929'59"
 */
extern centisec roundsec(centisec x);

/* normalizes p into 0..DEG360 by doing a kind of modulo */
extern centisec csnorm(centisec p);
/* the same for degree instead of centisec */
extern double degnorm(double x);

/* normalized circle distance p1 - p2, result in [0..360[ */
extern centisec difcsn(centisec p1, centisec p2);	
extern double  difdegn(double x1, double x2);

/* normalized circle distance p1 - p2, result in [-180..180[ */
extern centisec difcs2n(centisec p1, centisec p2);	
extern double  difdeg2n(double x1, double x2);

extern double dcos(centisec x);			/* trigo. functions for CSEC */
extern double dsin(centisec x);
extern double dtan(centisec x);
extern centisec datan(double x);
extern centisec dasin(double x);

# endif /* _ASTROLIB_INCLUDED */
#ifdef ASTROLOG
/* End contents of astrolib.h */
#endif
#endif /* ASTROLOG */
#endif /* PLACALC */
#ifdef ASTROLOG
/* End contents of placalc.h */
#endif
