/* File: borg6.h */

/* Purpose: Header file for "borg6.c" -BEN- */

#ifndef INCLUDED_BORG6_H
#define INCLUDED_BORG6_H

#include "angband.h"

#ifdef ALLOW_BORG

/*
 * This file provides support for "borg6.c".
 */

#include "borg1.h"
#include "borg2.h"
#include "borg3.h"


/*
 * Possible values of "goal"
 */
#define GOAL_KILL	1		/* Monsters */
#define GOAL_TAKE	2		/* Objects */
#define GOAL_MISC	3		/* Stores */
#define GOAL_DARK	4		/* Exploring */
#define GOAL_XTRA	5		/* Searching */
#define GOAL_FLEE	6		/* Leaving */


/*
 * Minimum "harmless" food
 */

#define SV_FOOD_MIN_OKAY	SV_FOOD_CURE_POISON



/*
 * Attempt to induce "word of recall"
 */
extern bool borg_recall(void);

/*
 * Low level goals
 */
extern bool borg_caution(void);
extern bool borg_attack(void);
extern bool borg_recover(void);

/*
 * Twitchy goals
 */
extern bool borg_charge_kill(void);
extern bool borg_charge_take(void);
extern bool borg_twitchy(void);



/*
 * Continue a high level goal
 */
extern bool borg_flow_old(void);

/*
 * Flee the level
 */
extern bool borg_flow_stair_both(void);

/*
 * Flow to stairs
 */
extern bool borg_flow_stair_less(void);
extern bool borg_flow_stair_more(void);

/*
 * Flow to shops
 */
extern bool borg_flow_shop_visit(void);
extern bool borg_flow_shop_entry(int n);

/*
 * Flow towards monsters/objects
 */
extern bool borg_flow_kill(bool viewable);
extern bool borg_flow_take(bool viewable);

/*
 * Flow towards "interesting" grids
 */
extern bool borg_flow_dark_1(void);
extern bool borg_flow_dark_2(void);
extern bool borg_flow_dark_3(void);
extern bool borg_flow_dark_4(void);

/*
 * Search for secret doors
 */
extern bool borg_flow_spastic(bool bored);



/*
 * Initialize this file
 */
extern void borg_init_6(void);




#endif

#endif

