  global FileWindows
  set n [Unique]
  set win .file$n
  set FileWindows [linsert $FileWindows 0 $win]

  LinkWindow $head.file $win
  LinkWindow $win.head $head

# catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  wm title $win {File Selector}
  wm iconname $win {File Selector}
  wm geometry $win 350x480+5+5
  wm positionfrom $win user
  wm sizefrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 100 100
  wm protocol $win WM_DELETE_WINDOW "DeleteWindow file FileWindows $win"

  # Based on xf file selection box code by:
  #   garfield@cs.tu-berlin.de
  #   svoboda@transam.ece.cmu.edu (David Svoboda)

  message $win.message1 \
    -aspect 1500 \
    -anchor n \
    -justify center \
    -relief flat \
    -font [Font $win Large] \
    -text ""

  frame $win.frame1 -borderwidth 0
  button $win.frame1.ok -text {OK} -font [Font $win Large]
  button $win.frame1.rescan -text {Rescan} -font [Font $win Large]
  button $win.frame1.cancel -text {Cancel} -font [Font $win Large]

  frame $win.path -borderwidth 0

  label $win.path.pathlabel -text {Directory:} -font [Font $win Large]
  entry $win.path.path -relief sunken -font [Font $win Large]

  frame $win.files \
    -borderwidth 0

  scrollbar $win.files.vscroll \
    -command "$win.files.files yview"

  scrollbar $win.files.hscroll \
    -orient horizontal \
    -command "$win.files.files xview"

  listbox $win.files.files \
    -exportselection false \
    -font [Font $win Large] \
    -xscrollcommand "$win.files.hscroll set" \
    -yscrollcommand "$win.files.vscroll set"

  pack append $win.files \
              $win.files.files {left fill expand} \
              $win.files.vscroll {left filly} \
              $win.files.hscroll {bottom fillx}

  frame $win.file \
    -borderwidth 0 \
    -relief raised

  label $win.file.labelfile \
    -relief flat \
    -font [Font $win Large] \
    -text "File:"

  entry $win.file.file \
    -font [Font $win Large] \
    -relief sunken

  pack append $win.file \
              $win.file.labelfile {left} \
              $win.file.file {left fill expand}

  bind $win.files.files <ButtonPress-1> "FileSelect $win %W %y"
  bind $win.files.files <Button1-Motion> "FileSelect $win %W %y"
  bind $win.files.files <Shift-Button1-Motion> "FileSelect $win %W %y"
  bind $win.files.files <Shift-ButtonPress-1> "FileSelect $win %W %y"

  bind $win.path.path <Tab> "NameComplete $win path"
  catch "bind $win.path.path <Up> {}"
  bind $win.path.path <Down> "
    $win.file.file cursor 0
    focus $win.file.file"

  bind $win.file.file <Tab> "NameComplete $win file"
  bind $win.file.file <Up> "
    $win.path.path cursor 0
    focus $win.path.path"
  catch "bind $win.path.path <Down> {}"

  pack append $win.frame1 \
              $win.frame1.ok {left fill expand} \
              $win.frame1.rescan {left fill expand} \
              $win.frame1.cancel {left fill expand}
  pack append $win.path \
              $win.path.pathlabel {left} \
              $win.path.path {left fill expand}
  pack append $win \
              $win.message1 {top fill} \
              $win.frame1 {bottom fill} \
              $win.file {bottom fill} \
              $win.path {bottom fill} \
              $win.files {left fill expand}

  update idletasks
  return $win
