/*
 * This file is provided for unrestricted use
 * provided that this legend is included on all tape media
 * and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/* For using uucp AND nntp (it's spooky, isn't it ?) define this... */
#define UUCP

/* Location of your inews-Program (only relevant, if UUCP has been defined) */
#define INEWS "/usr/local/lib/news/inews"

/* Sets the default company name. Can be overridden by setting $ORGANIZATION */
#define ORGANIZATION    "This is asgard. The gods' own place"

/* The default NNTP server to connect to. Can be overridden by setting $NNTPSERVER */
#define NNTPSERVER	"asgard.do.open.de"

/* The domain to use. Sets everything after the @ sign for postings. Can be
   overridden by setting $DOMAIN.
 */
#define DOMAIN 		"asgard.do.open.de"

#ifdef SVR4
#define SYSV
#endif

#include <xview/xview.h>
#include <xview/cursor.h>
#include <xview/font.h>

extern Attr_attribute POST_PARENT;
extern Attr_attribute PROPS_POPUP;
extern Attr_attribute SAVE_POPUP;
extern Attr_attribute POST_POPUP;
extern Attr_attribute POST_TYPE;
extern Attr_attribute SEARCH_POPUP;
extern Attr_attribute KILL_POPUP;
extern Attr_attribute UNDELETE_POPUP;
extern Attr_attribute LOAD_POPUP;

#define BUFFERLEN       3072
#define GROUP_MODE 1
#define SUBSCRIBED 1
#define UNSUBSCRIBED 0
#define NO_GROUP 411
#define SUBJECT_LENGTH 48
#define AUTHOR_LENGTH 23
#define ARTICLE_MODE 0
#define NEW_GROUPS 2
#define ALL_GROUPS 3
#define SUB_GROUPS 5
#define UNSUB_GROUPS 6
#define MATCH_GROUPS 7
#define ALL_ARTICLES 4
#define MAX_COMMAND_LEN 128
#define MAX_MESSAGE_LEN 512
#define MAX_ARTICLE_LEN 1024
#define POSTED_OK 240
#define NEWS_POST 1
#define MAIL_POST 0
#define MAX_NEWS_GROUPS 1000
#define MAX_ARTICLES    5000
#define MAX_SUBSCRIBED_GROUPS   100

struct kill_node {
	char	*string;
	int subject;
	int junk;
	int place;
	struct kill_node *next;
} ;

struct kill_list {
	int article;
	int global;
	int junk;
	int place;
	struct kill_list *next;
} ;

struct newsrc_node {
        char    *newsgroup;
        char    *description;
        int     subscribed;
        int     articles;
        int     last_article;
	struct	kill_node *kill;
        struct newsrc_node      *nextgroup;
        struct article_node     *artlist;
} ;

struct article_node {
        int     first;
        int     last;
        struct article_node     *nextart;
} ;

struct globals {
        int     mode;
        int     post;
        int     post_popups;
        int     unread;
        int     dragging;
        int     check_drag;
        int     total;
        int     list;
        int     multiclick;
        int     article;
	int	nnrp;
        char    group[64];
        char    next_group[64];
	char	newsdir[256];
	char	newsrc[256];
	char	*single;
        Xv_Cursor       copyso_cursor;
        Xv_font  listfont;
	Icon	news_icon;
        struct newsrc_node *head;
	struct kill_node *kill;
} ;

#ifdef SVR4

#include "xvnews_ui.h"

extern char * groupDir(char *);
extern int processKill(char *, struct kill_node *, int *);
extern int parseKillFiles(char *, struct newsrc_node *);
extern clearKills(struct kill_node *);
extern addKill(kill_popup_objects *, char *, char *, int, int);
extern makeKillFile(char *);
extern generateKillList(struct newsrc_node *);
extern articleKill(xvnews_xvnews_window_objects *, struct kill_list *);
extern struct kill_list * generateKill(struct kill_list *, int, int, int, int);
extern headerKill(struct kill_node *);
extern struct kill_list * killHeaders(struct kill_node *, struct kill_node *, int, int, struct kill_list *);
extern getHeadList(struct kill_node *, char *, int *);
extern struct kill_list * subjectKill(char *, struct kill_node *, struct kill_list *);
extern char * currentSubject(xvnews_xvnews_window_objects *, int);
extern char * currentAuthor(int);
extern fillKillText(xvnews_xvnews_window_objects *, kill_popup_objects *);
extern loadKill(kill_popup_objects *, char *);
extern saveKillFile(kill_popup_objects *);
#endif
