.TH XCORAL 1 
.SH NAME
xcoral - yet another text editor for X Window System
.SH SYNTAX
\fBxcoral\fP [ \fI-options\fP ...] [ filename ]
.SH DESCRIPTION
.I Xcoral
is a multiwindows mouse-based text editor with a built-in browser for C functions
and C++ classes, methods, files etc... Xcoral provides variables width fonts,
menus, scrollbars, buttons, search, regions, kill-buffers and 3D look.
Commands  are accessible from menus or standard key bindings.
Xcoral is a direct Xlib client and runs on color/bw X Display.
.SH OPTIONS
.TP 8
.BI \=WxH+X+Y
Specifies the geometry in pixels of a text window ( Width, Height and top-left position ).
.TP 8
.BI \-display " host:0.0 "
Specifies X Server connection.
.TP 8
.BI \-fn " fontname "
Specifies font in text window.
.TP 8
.BI \-bg " colorname "
Specifies background color in text window.
.TP 8
.BI \-fg " colorname "
Specifies foreground color in text window.
.TP 8
.BI \-mfn " fontname "
Specifies font in menu.
.TP8
.BI \-mbg " colorname "
Specifies background color in menu
.TP8
.BI \-mfg " colorname "
Specifies foreground color in menu
.TP8
.BI \-dbg " colorname "
Specifies background color in bottom dialog box
.TP8
.BI \-dfg " colorname "
Specifies foreground color in bottom dialog box
.TP 8
.BI \-dw
Display browser warnings.
.TP 8
.BI \-textmode " mode "
Specifie current mode : C, C++ or text.
.TP 8
.BI \-help
This causes \fIxcoral\fP to print out a verbose message describing its options.
.TP 8
.I filename
Specifies the file that is to be loaded during start-up.
.SH EDITING
The application provides  an edition area with text window, menubar, scrollbar and
control-panel for commands line, messages window and buttons. If a text window
has the focus, the caracters typed are insered at the current position (cursor) .
.br
Six buttons are used to move through the buffer (top, bottom, smooth scroll up
and down, previous and next page). Mouse button1 (left)  can be use to move the cursor
in the current page.
.br
During a session, several edition areas can be used (Max : 16). A new edition area
is opened with 'New text window' in Window menu. Each of them inherites of the current
directory of its parent. The first window has the current working directory.
The directory of a text window is that of the loaded file.
.SH COMMANDS 
Most commands available from menus have their corresponding standard keybinds
which are  'Control with key' or 'Escape then key'.  Control-g, aborts current command.
.SH SEARCH
Forward and backward searching (Boyer-Moore) uses a global buffer to store
patterns and are available in all edition area. Crl-g, reset searching buffer.
.SH KILL-BUFFERS
When deleted, lines or regions are stored in a kill-buffer which is a 20 entries LIFO .
This kill-buffer can be mapped with the beginning of each entry.  A piece of text,
when selected, can be restored at the current position. The kill-buffer is global to the
application.
.SH REGION
A region is a piece of text between the cursor and a mark. A region can be copied,
deleted and restored. It is possible to exchange cursor and mark (in fact move
from current position to the mark). 
.SH MOUSE
All buttons can be used to manage menus, buttons or scroolbars. The selection mechanism
is available to exchange text between windows.
.TP 8
.BI \-LeftButton
Change cursor position in page.
.TP 8
.BI \-MiddleButton
Restore the previous selection at the current position
.TP 8
.BI \-RightButton
Selection. The cursor moves to the selected point and come back to the
previous location. 
.TP 8
.BI \-MiddleButton+ControlKey
Delete the previous selection.
.SH BROWSER
A browser is available, in C or C++ mode, to navigate through C functions and C++ class
hierarchies. The names of files, C functions, classes, parents, children and methods are listed
in subwindows of the main browser window. An object selected (one click) in these subwindows
is viewed in a 'Visit Window'. A double click opens an edition area and loads the current
selected object.

.br
During start-up, all files with one of the suffixes `.c', `.cc', `cxx',`.C', `.h' or `.hxx' in the
current directory,  are parsed and all informations are loaded in the database.

The 'Add' button is used to load a selected file or directory. If nothing is selected in
the file selection box, all the files of the current directory and the subdirectories are
recursively parsed.
The 'Del' button is used to delete file or directory from browser database.
One file or all files can be deleted.

The Decl/Impl is a toggle button to see Declaration or Implementation of selected
methods. The 'Edit' button opens an edition area and loads the current selected object.

.br
The browser database is updated after all write/save file operation.

.br
Some additionnal informations appear in class and method windows.
.br
.RS
.TP 10
.B [c/d]
Constructor and destructor (Methods).
.TP
.B [v]
Virtual definition from parents (Methods).
.TP
.B [V]
First virtual definition (Methods).
.TP
.B [L]
Locally defined in current class  (Methods).
.TP
.B [d]
Declared (Classes, methods).
.TP
.B [i]
Implemented (Classes, methods).
.TP
.B [?]
Not implemented (Classes, methods).
.TP
.B [n]
Inherited level number (Methods).
.SH MODE
As of now, a very simple autoindent has been implemented in C and C++ mode.
.SH ENVIRONNEMENT
XCORAL_TAB_WIDTH is used to set tab width. Default is standard width tab.
.br
XCORAL_INDENT_WIDTH is used in C or C++ mode to set auto indent width.
Default is 3 blanks and -1 for tab.
.br
XCORAL_VISIT_RAISE is used in browser to raise or not the visit window during
a select operation. Default is True.
XCORAL_PARSE_FILES_AT_STARTUP is used at start-up to parse files of the
current directory. Default is True. 
XCORAL_PARSE_PATH is used by the browser to parse the specified directories at
startup (the separator must be ':' ). These directories will be parsed recursively. 
This environnemet variable is avalaible only if the previous is True.
.SH SCROLL
In all Text Windows, a horizontal scroll must be handled with the left mouse button on the
caracter still visible at right or left.
.SH COMMANDS LIST
.BR
.TP 20
.B \Ctrl f/b
Forward/backward char.
.TP
.B \Crtl d
Delete current character.
.TP
.B \Crtl a/e
Go to beginning/end of line.
.TP
.B \Crtl g
Abort current command.
.TP
.B \Crtl h
Delete previous caracter.
.TP
.B \Crtl k
Delete end of line
.TP
.B \Ctrl s/r
Forward/Backward search
.TP
.B \Ctrl l
Refresh current page
.TP
.B \Ctrl n/p
Move to next/previous line
.TP
.B \Ctrl v, Esc v
Move to next/previous page.
.TP
.B \Ctrl y
Restore previous kill
.TP
.B \Esc q, Esq r
Query and global replace.
.TP
.B \Ctrl x b
Display open files
.TP
.B \Ctrl x Ctrl r
Read File
.TP
.B \Ctrl x i
Insert File
.TP
.B \Ctrl x Ctrl w
Write file as
.TP
.B \Ctrl x Ctrl s
Save file
.TP
.B \Ctrl x Ctrl c
Delete window
.TP
.B \Ctrl x 2
Open new edition area
.TP
.B \Ctrl x k
Clear current buffer.
.TP
.B \Ctrl x l
Go to line number
.TP
.B \Ctrl space
Set mark
.TP
.B \Ctrl x Ctrl x
Exchange cursor/mark.
.TP
.B \Ctrl w
Kill region.
.TP
.B \Esc w
Copy region.
.TP
.B \Ctrl o
Open space
.SH RESOURCES
The resources available are fonts (text, menu), foreground, background
(text, menu, bottom dialog), textmode, displaywarning and geometry.
.br
Here, a simple .Xdefaults for xcoral :
.sp
xcoral*geometry:	=600x500+200+100
.br
xcoral*background: midnightblue /*text window background*/
.br
xcoral*foreground: darkseagreen1 /*text window foreground*/
.br
xcoral*font: 9x15bold /* text window font */
.br
xcoral*mbg: lightslategray /*menu background*/
.br
xcoral*dbg: lightslategray /*bottom dialog background*/
.br
xcoral*textmode:	C++
.br
xcoral*displaywarning: True
.sp
.SH RESTRICTIONS
\fICpp\fP is not used before parsing files and some of them may be ignored by the browser
(macros definitions are not resolved). In methods, data members are not parsed as of today
(not trivial).
.br
\fITemplates\fP are ignored.
.br
There is no \fIundo\fP function.
.br
When an operation uses the file selector, the current window must be full viewable, otherwize,
it is just raised.
.br
Dialog box and input string operation 'grab' the pointer. (brrr... yes, it's annoying)
.br
These problems will be fixed in later versions.
.SH BUGS
No bugs... may be... some... many...
.br
Please send bug reports, fixes, new features etc. to
.br
lf@lri.lri.fr
.SH AUTHORS
Lionel Fournigault
.br
Dominique Leveque (internal browser database).

