//start of HashShort.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * HashShort.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import jp.gr.java_conf.dangan.util.lha.HashMethod;

//import exceptions


/**
 * f[^p^̐擪2oCg
 * 0 ` 4095 ̃nbVl𐶐nbV֐B
 * 
 * <pre>
 * -- revision history --
 * $Log: HashShort.java,v $
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     HashMethod ̃C^tFCXύXɂ킹ăCetFCXύXB
 * [maintanance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class HashShort implements HashMethod{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  private byte[] TextBuffer
    //------------------------------------------------------------------
    /**
     * LZSSk{߂̃obt@B
     * Ö͎A
     * 㔼͈k{߂̃f[^̓obt@B
     * HashMethod̎ł Hashl̐̂߂̓ǂݍ݂ɂ̂ݎgpB
     */
    private byte[] TextBuffer;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private HashShort()
    //  public HashShort( byte[] TextBuffer )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gps
     */
    private HashShort(){    }

    /**
     * f[^p^̐擪2oCg 0x000 ` 0xFFF ܂ł̒l𐶐
     * nbV֐\zB
     * 
     * @param TextBuffer LZSSkp̃obt@B
     *                   Hashl̂ߓǂݍݗpɎgpB
     */
    public HashShort( byte[] TextBuffer ){
        this.TextBuffer = TextBuffer;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.HashMethod
    //------------------------------------------------------------------
    //  public int hash( int position )
    //  public int hashRequires()
    //  public int tableSize()
    //------------------------------------------------------------------
    /**
     * nbV֐B
     * RXgN^œnꂽ TextBuffer  position 
     * f[^p^ hashl𐶐B
     *
     * @param position f[^p^̊Jnʒu
     * 
     * @return nbVl
     */
    public int hash( int position ){
        return ( ( ( ( this.TextBuffer[ position + 1 ] & 0x0F ) << 8 )
                 | ( ( this.TextBuffer[ position + 1 ] & 0xFF ) >> 4 ) )
               ^ ( ( this.TextBuffer[ position  ] & 0xFF ) << 2 ) );
    }

    /**
     * nbV֐nbVl𐶐邽߂ɎgpoCg𓾂B<br>
     * ̃nbV֐̓f[^p^̐擪 2 oCg̃f[^
     * nbVl𐶐邽߁Ã\bh͏ 2 ԂB
     * 
     * @return  2
     */
    public int hashRequires(){
        return 2;
    }

    /**
     * nbVe[ũTCY𓾂B<br>
     * ̃nbV֐ 0x000 ` 0xFFF ܂ł̃nbVl𐶐邽
     * ̃\bh͏ 0x1000(4096) ԂB
     * 
     * @return  0x1000(4096) 
     */
    public int tableSize(){
        return 0x1000;
    }


}
//end of HashShort.java
