/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.AttributeTypeAndValuePair;
import org.apache.harmony.security.x509.DNParser;

public class RelaxedDnParser
extends DNParser {
    private static final char[] specialChars = new char[]{'!', '$', '%', '&', '\'', '(', ')', '*', '/', ':', '<', '=', '>', '?', '@', '[', ']', '^', '_', '`', '{', '|', '}', '~', '\"', '#', '+', ',', '\\', ';'};

    public RelaxedDnParser(String dn) throws IOException {
        super(dn);
    }

    protected String nextAT() throws IOException {
        int equalIndex = this.pos;
        try {
            while (this.chars[equalIndex] != '=') {
                ++equalIndex;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(Messages.getString("ldap.1C"));
        }
        int i = this.pos;
        while (i < equalIndex) {
            if (this.chars[i] == '\\') {
                throw new IOException(Messages.getString("ldap.1D"));
            }
            int j = 0;
            while (j < specialChars.length) {
                if (this.chars[i] == specialChars[j]) {
                    throw new IOException(Messages.getString("ldap.1E"));
                }
                ++j;
            }
            ++i;
        }
        return super.nextAT();
    }

    /*
     * Unable to fully structure code
     */
    protected String hexAV() throws IOException {
        this.beg = this.pos++;
        while (true) {
            block4: {
                if (this.pos != this.length && this.chars[this.pos] != '+' && this.chars[this.pos] != ',' && this.chars[this.pos] != ';') break block4;
                this.end = this.pos;
                if (true) ** GOTO lbl14
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                v0 = this.pos;
                this.chars[v0] = (char)(this.chars[v0] + 32);
            }
            ++this.pos;
        }
        do {
            --this.end;
lbl14:
            // 2 sources

        } while (this.end > this.beg + 1 && this.chars[this.end - 1] == ' ');
        hexLen = this.end - this.beg;
        this.encoded = new byte[hexLen / 2];
        i = 0;
        p = this.beg + 1;
        while (i < this.encoded.length) {
            this.encoded[i] = (byte)this.getByte(p);
            p += 2;
            ++i;
        }
        return new String(this.chars, this.beg, hexLen);
    }

    public List parse() throws IOException {
        ArrayList list = new ArrayList();
        String attType = this.nextAT();
        ArrayList<AttributeTypeAndValuePair> atav = new ArrayList<AttributeTypeAndValuePair>();
        String charCopy = new String(this.chars);
        while (true) {
            if (this.pos == this.length) {
                atav.add(new AttributeTypeAndValuePair(attType, ""));
                list.add(0, atav);
                return list;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    int p;
                    String attValue = this.quotedAV();
                    if (attValue.length() > 0 && attValue.charAt(attValue.length() - 1) == ' ') {
                        p = this.pos - 1;
                        while (p >= 0 && charCopy.charAt(p) == ' ') {
                            --p;
                        }
                        if (p >= 3 && charCopy.substring(p - 3, p + 1).equals("\\20\"")) {
                            attValue = attValue.substring(0, attValue.length() - 1);
                        }
                    }
                    atav.add(new AttributeTypeAndValuePair(attType, attValue));
                    break;
                }
                case '#': {
                    String attValue = this.hexAV();
                    atav.add(new AttributeTypeAndValuePair(attType, Rdn.unescapeValue(attValue)));
                    break;
                }
                case '+': {
                    atav.add(new AttributeTypeAndValuePair(attType, ""));
                    break;
                }
                default: {
                    int p;
                    String attValue = this.escapedAV();
                    if (attValue.length() > 0 && attValue.charAt(attValue.length() - 1) == ' ') {
                        p = this.pos - 1;
                        while (p >= 0 && charCopy.charAt(p) == ' ') {
                            --p;
                        }
                        if (p >= 2 && charCopy.substring(p - 2, p + 1).equals("\\20")) {
                            attValue = attValue.substring(0, attValue.length() - 1);
                        }
                    }
                    atav.add(new AttributeTypeAndValuePair(attType, attValue));
                }
            }
            if (this.pos >= this.length) {
                list.add(0, atav);
                return list;
            }
            if (this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                throw new IOException(Messages.getString("ldap.1F"));
            }
            ++this.pos;
            attType = this.nextAT();
        }
    }

    protected char getEscaped() throws IOException {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IOException(Messages.getString("ldap.1F"));
        }
        switch (this.chars[this.pos]) {
            case '\"': {
                return this.chars[this.pos];
            }
            case '\\': {
                this.hasQE = true;
                return RelaxedDnParser.hexToUTF8(new String(this.chars, this.pos++, 2)).charValue();
            }
            case ' ': 
            case '#': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': {
                return this.chars[this.pos];
            }
        }
        return super.getUTF8();
    }

    public static Character hexToUTF8(String hex) throws IOException {
        try {
            return new Character((char)Integer.parseInt(hex, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(Messages.getString("ldap.20"));
        }
    }
}

