/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.harmony.sql.tests.java.sql.TestHelper_Connection1;

public class TestHelper_Driver4
implements Driver {
    int majorVersion = 1;
    int minorVersion = 0;
    String baseURL = "jdbc:mikes4";
    String[] dataSources = new String[]{"data1", "data2", "data3"};
    static String validuser;
    static String validpassword;
    static String userProperty;
    static String passwordProperty;

    static {
        TestHelper_Driver4 theDriver = new TestHelper_Driver4();
        try {
            DriverManager.registerDriver((Driver)theDriver);
        }
        catch (SQLException e) {
            System.out.println("Failed to register driver!");
        }
        validuser = "theuser";
        validpassword = "thepassword";
        userProperty = "user";
        passwordProperty = "password";
    }

    protected TestHelper_Driver4() {
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.startsWith(this.baseURL);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            String datasource = url.substring(this.baseURL.length() + 1);
            String[] stringArray = this.dataSources;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String element = stringArray[n];
                if (datasource.equals(element)) {
                    if (!datasource.equals("data1")) {
                        if (info == null) {
                            throw new SQLException("Properties bundle is null");
                        }
                        String user = (String)info.get(userProperty);
                        String password = (String)info.get(passwordProperty);
                        if (user == null || password == null) {
                            throw new SQLException("Userid and/or password not supplied");
                        }
                        if (!user.equals(validuser) || !password.equals(validpassword)) {
                            throw new SQLException("Userid and/or password not valid");
                        }
                    }
                    TestHelper_Connection1 connection = new TestHelper_Connection1();
                    return connection;
                }
                ++n;
            }
        }
        return null;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] theInfos = new DriverPropertyInfo[]{new DriverPropertyInfo(userProperty, "*"), new DriverPropertyInfo(passwordProperty, "*")};
        return theInfos;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

