/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ReportInstanceStatus
extends BaseCmd {
    protected static final int MAX_DESCRIPTION_LENGTH = 1000;
    protected static final String DESCRIPTION_DESCRIPTION = "Descriptive text that provides the details about the instance(s) status. Can be up to 1000 characters long.";
    protected static final String REASON_CODES = "reason";
    protected static final String REASON_CODES_ARG = "REASON_CODES";
    protected static final String[] REASON_CODES_DESCRIPTION = new String[]{"Reason must be one of the following strings:", "  instance-stuck-in-state", "  unresponsive", "  not-accepting-credentials", "  password-not-available", "  performance-network", "  performance-instance-store", "  performance-ebs-volume", "  performance-other", "  other"};
    protected static final String STATUS_ARG = "STATUS";
    protected static final String STATUS_SHORT_OPT = "s";
    protected static final String STATUS_LONG_OPT = "status";
    protected static final String STATUS_DESCRIPTION = "Report the instance as 'ok' or 'impaired'.";
    protected static final String START_TIME_ARG = "START_TIME";
    protected static final String[] START_TIME_DESCRIPTION = new String[]{"An optional date field indicating the time when the instance status started being incorrect.", "   The date uses the format: yyyy-MM-dd'T'HH:mm:ss", "   e.g. 2011-07-25T14:00:00"};
    protected static final String END_TIME_ARG = "END_TIME";
    protected static final String[] END_TIME_DESCRIPTION = new String[]{"An optional date field indicating the time when the instance status ended being incorrect.", "   The date uses the format: yyyy-MM-dd'T'HH:mm:ss", "   e.g. 2011-07-25T14:00:00"};
    protected static final String[] validReasonStrings = new String[]{"instance-stuck-in-state", "unresponsive", "not-accepting-credentials", "password-not-available", "performance-network", "performance-instance-store", "performance-ebs-volume", "performance-other", "other"};
    protected Hashtable<String, Boolean> validReasonCodes = new Hashtable();
    protected static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    protected void initReasonLookup() {
        for (int i = 0; i < validReasonStrings.length; ++i) {
            this.validReasonCodes.put(validReasonStrings[i], new Boolean(true));
        }
    }

    public ReportInstanceStatus(String[] args) {
        super("ec2rep", "ec2-report-instance-status");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)STATUS_LONG_OPT);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)STATUS_ARG);
        OptionBuilder.withDescription((String)STATUS_DESCRIPTION);
        o.addOption(OptionBuilder.create((String)STATUS_SHORT_OPT));
        OptionBuilder.withLongOpt((String)REASON_CODES);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)REASON_CODES_ARG);
        OptionBuilder.withDescription((String)ReportInstanceStatus.joinDescription(REASON_CODES_DESCRIPTION));
        o.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"description");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DESCRIPTION");
        OptionBuilder.withDescription((String)DESCRIPTION_DESCRIPTION);
        o.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"start-time");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)START_TIME_ARG);
        OptionBuilder.withDescription((String)ReportInstanceStatus.joinDescription(START_TIME_DESCRIPTION));
        o.addOption(OptionBuilder.create((String)STATUS_SHORT_OPT));
        OptionBuilder.withLongOpt((String)"end-time");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)END_TIME_ARG);
        OptionBuilder.withDescription((String)ReportInstanceStatus.joinDescription(END_TIME_DESCRIPTION));
        o.addOption(OptionBuilder.create((String)"e"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "INSTANCE [INSTANCE [...]] -status STATUS [-r REASON [-r REASON [...]]] [-d DESCRIPTION] [-s START-TIME] [-e END-TIME]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Report a discrepancy in the status of one or more of your instances.");
        System.out.println("     The INSTANCE parameter is the instance ID(s) to report on.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(STATUS_LONG_OPT);
        this.printOption(REASON_CODES);
        this.printOption("description");
        this.printOption("start-time");
        this.printOption("end-time");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INSTANCE");
        this.assertOptionSet(STATUS_LONG_OPT);
        String[] instanceIds = this.getNonOptions();
        String status = this.getOptionValue(STATUS_LONG_OPT);
        if (!status.toLowerCase().equals("ok") && !status.toLowerCase().equals("impaired")) {
            throw new InvalidArgument(STATUS_LONG_OPT, status);
        }
        GregorianCalendar start = null;
        GregorianCalendar end = null;
        XMLGregorianCalendar xmlStartTime = null;
        XMLGregorianCalendar xmlEndTime = null;
        String[] reasonCodes = new String[]{};
        if (this.isOptionSet(REASON_CODES)) {
            reasonCodes = this.getOptionValues(REASON_CODES);
        }
        String description = null;
        if (this.isOptionSet("description") && (description = this.getOptionValue("description")).length() > 1000) {
            throw new InvalidArgument("description", "Cannot be longer than 1000 characters.");
        }
        String startTime = null;
        if (this.isOptionSet("start-time")) {
            startTime = this.getOptionValue("start-time");
            Date localDate = dateFormat.parse(startTime);
            start = new GregorianCalendar();
            start.setTimeZone(TimeZone.getTimeZone("UTC"));
            start.setTime(localDate);
            xmlStartTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(start);
        }
        String endTime = null;
        if (this.isOptionSet("end-time")) {
            endTime = this.getOptionValue("end-time");
            Date localDate = dateFormat.parse(endTime);
            end = new GregorianCalendar();
            end.setTimeZone(TimeZone.getTimeZone("UTC"));
            end.setTime(localDate);
            xmlEndTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(end);
        }
        RequestResultPair rsp = jec2.reportInstanceStatus(instanceIds, status, xmlStartTime, xmlEndTime, reasonCodes, description);
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected String getReasonList() {
        String reasonList = "\n\t";
        for (int index = 0; index < validReasonStrings.length; ++index) {
            reasonList = reasonList + validReasonStrings[index] + "\n\t";
        }
        return reasonList;
    }

    protected String[] getImpairmentReasons() throws Exception {
        String[] reasons = this.getOptionValues(REASON_CODES);
        this.initReasonLookup();
        for (int i = 0; i < reasons.length; ++i) {
            String reason = reasons[i].toLowerCase();
            if (this.validReasonCodes.containsKey(reason)) continue;
            throw new GeneralError("'" + reasons[i] + "' is not a valid reason code. Reason must be one of ... " + this.getReasonList());
        }
        return reasons;
    }

    public static void main(String[] args) {
        new ReportInstanceStatus(args).invoke();
    }
}

