/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;

public class Executable
extends Instruction {
    private Configuration config;
    private Mode stripperRules;
    private boolean stripsWhitespace;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private int numberOfVariables = 0;
    private String defaultCollationName;
    private HashMap sortKeyTable;
    private Properties defaultOutputProperties;
    private HashMap namedTemplateTable = new HashMap();
    private int largestStackFrame = 0;
    private HashMap collationTable = new HashMap();
    private String[] moduleArray;
    private HashMap characterMapIndex;

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("transform");
    }

    public void setModuleArray(String[] stringArray) {
        this.moduleArray = stringArray;
    }

    public String getSystemId(int n) {
        return this.moduleArray[n];
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setNamedTemplateTable(HashMap hashMap) {
        this.namedTemplateTable = hashMap;
    }

    public HashMap getNamedTemplateTable() {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new HashMap();
        }
        return this.namedTemplateTable;
    }

    public void setSortKeyTable(HashMap hashMap) {
        this.sortKeyTable = hashMap;
    }

    public HashMap getSortKeyTable() {
        if (this.sortKeyTable == null) {
            this.sortKeyTable = new HashMap();
        }
        return this.sortKeyTable;
    }

    public void setCharacterMapIndex(HashMap hashMap) {
        this.characterMapIndex = hashMap;
    }

    public HashMap getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new HashMap();
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(Mode mode) {
        this.stripperRules = mode;
    }

    public void setStripsWhitespace(boolean bl) {
        this.stripsWhitespace = bl;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager();
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setDefaultCollationName(String string) {
        this.defaultCollationName = string;
    }

    public Comparator getDefaultCollation() {
        if (this.defaultCollationName == null) {
            return CodepointCollator.getInstance();
        }
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setCollationTable(HashMap hashMap) {
        this.collationTable = hashMap;
    }

    public Comparator getNamedCollation(String string) {
        if (this.collationTable == null) {
            this.collationTable = new HashMap();
        }
        return (Comparator)this.collationTable.get(string);
    }

    public void setSlotSpace(int n, int n2) {
        this.numberOfVariables = n;
        this.largestStackFrame = n2;
    }

    public void initialiseBindery(Bindery bindery) {
        bindery.allocateGlobals(this.numberOfVariables + 1);
        bindery.allocateLocals(this.largestStackFrame + 2);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        return null;
    }
}

