.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
Juggler3D - a 3D juggling simulation.
.SH SYNOPSIS
.B juggler3d
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-speed \fInumber\fP]
[\-trans \fInumber\fP]
[\-spin \fInumber\fP]
[\-maxobjs \fInumber\fP]
[\-minobjs \fInumber\fP]
[\-maxhinc \fInumber\fP]
[\-minhinc \fInumber\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
Displays a 3D simulation of a juggler performing with balls, clubs and rings. 
Juggling patterns are either created randomly using siteswaps or from a 
small library of predefined patterns.  \fBjuggler3d\fP is partially based on the
Win32 screensaver Juggle Saver (www.jugglesaver.co.uk) by the same author.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.02 seconds.).
.TP 8
.B \-speed \fInumber\fP
Speed of objects being juggled in beats per seconds.  Default: 2.2.
.TP 8
.B \-trans \fInumber\fP
Speed of horizontal juggler movement (translational) across the screen in
degrees/seconds.  Default: 0.1
.TP 8
.B \-spin \fInumber\fP
Speed of juggler rotation in degrees/seconds.  Default: 20
.TP 8
.B \-maxobj \fInumber\fP
Maximum number of objects used in a random juggling pattern. 3 - 36.
.TP 8
.B \-minobj \fInumber\fP
Minimum number of objects used in a random juggling pattern. 3 - \fBmaxobj\fP.
.TP 8
.B \-minhinc \fInumber\fP | -maxhinc \fInumber\fP
Used to determine maximum throw weight in random siteswap.  Options refer to
minimum height increment and maximum height increment.  Maximum weight chosen
will lie between \fBmaxobj\fP + \fBminhinc\fP and \fBmaxobj\fP + \fBmaxhinc\fP.
Defaults: \fBminhinc\fP=1 and \fBmaxhinc\fP=6.
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2005 by Brian Apps.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Brian Apps <brian@jugglesaver.co.uk>
