/*
 *	pop3d		- IP/TCP/POP3 server for UNIX 4.3BSD
 *			  Post Office Protocol - Version 3 (RFC1225)
 *
 *      (C) Copyright 1991 Regents of the University of California
 *
 *      Permission to use, copy, modify, and distribute this program
 *      for any purpose and without fee is hereby granted, provided
 *      that this copyright and permission notice appear on all copies
 *      and supporting documentation, the name of University of California
 *      not be used in advertising or publicity pertaining to distribution
 *      of the program without specific prior permission, and notice be
 *      given in supporting documentation that copying and distribution is
 *      by permission of the University of California.
 *      The University of California makes no representations about
 *      the suitability of this software for any purpose.  It is provided
 *      "as is" without express or implied warranty.
 *
 *	Katie Stevens
 *	dkstevens@ucdavis.edu
 * 	Information Technology -- Technology Support Program
 *	University of California, Davis
 *
 **************************************
 *
 *	pop3.h
 *
 *	REVISIONS:
 *		02-27-90 [ks]	original implementation
 *	1.000	03-04-90 [ks]
 *	1.001	06-24-90 [ks]	allow TRANS state if 0 msgs in folder
 *				implement optional TOP command
 *	1.002	07-22-91 [ks]	-- reset index counter after folder rewind
 *				   in fld_release (Thanks to John Briggs,
 *				   Vitro Corporation, Silver Spring, MD
 *				   for finding this bug!)
 *				-- set umask() value explicitly (Thanks to
 *				   Vikas Aggarwal, JvNCnet, Princeton, NJ
 *				   for suggesting this)
 *				-- remove unnecessary 'return' at end
 *				   of void functions
 *	1.003	03-92    [ks]	close folder before return from main()
 *	1.004   11-13-91 [ks]	leave original mailbox intact during POP
 *				session (Thanks to Dave Cooley,
 *				dwcooley@colby.edu, for suggesting this)
 *		08-93	 [ks]	Thanks to Kurt Jordan, Purdue Calumet
 *				for the port to SVR3.2
 *	1.005	06-17-94 [ks]	port to SVR4/ANSIC; fold BSD, SVR3.2, SVR4
 *				into one source ( Thanks to Mark Horstman,
 *				Southwester Bell Telephone for this work )
 *	1.006	07-20-94 [ks]   add hooks for syslog tracking of POP
 *                              sessions; conditional compilation ( Thanks
 *				to David Wong, UC Davis for this work )
 *	1.007	07-29-94 [ks]	add '\r' to POP server greeting string
 *	1.008	03-23-95 [ks]	check for occupied lock on mailbox
 *      1.009   10-26-95 [ks]   remove fld_write_ok flag; thanks to
 *                              Craig D. von Land for pointing out a bug
 *      1.010   06-07-96 [ks]   -- added AIX define conditional compilation
 *                              flag to open in r+ mode before file lock.
 *                              Thanks to Danny Cohen for this suggestion.
 *                              -- moved HOST and MBOX extension commands
 *                              and routines to conditional compilation
 *                              status HOST_EXT; no longer used at UC Davis
 *                              -- add separate conditional compilation flag,
 *                              SHADOW_PASS, for shadow password support.
 *                              Thanks to Peter Tobias for this suggestion.
 *                              -- corrected response to TOP n 0 command. 
 *                              Thanks to Stephen R. van den Berg.
 *                              -- add UIDL command, under conditional
 *                              compilation flag UIDL_OKAY ( FromSP only ).
 *                              Thanks to Henry Holtzman for his patches.
 *      1.011  01-21-97 [ks]    -- added code to prevent duplicated
 *                              messages and left-over /tmp files. Thanks
 *                              to Blaise Camp, UC Davis for his patches.
 *                              -- no need to rewrite mailbox unless one
 *                              or more messages were deleted. Thanks to
 *                              Jim Stevens, JRCS Ltd for his help.
 *	1.012  03-28-97 [ks]    -- bug fix: handle condition when UIDL_OKAY
 *                              and missing Message-Id header
 *      			-- correct #ifdef condition for struct spwd
 *                              declaration in verify_user()
 *				-- add NO_MULTIPLE conditional compilation
 *                              code to disallow multiple simultaneous
 *                              POP3 sessions on a single mailbox.
 *      1.013   07-17-97 [ks]   -- correct #ifdef condition for shadow.h
 *                                 #include in util.c; thanks to Daniel Roche
 *                              -- add LOCK_EX flag to flock() call in
 *                                 folder.c; thanks to Shao Hua for this fix
 *      1.014  02-11-98 [ks]    -- added patches provided by Blaise Camp.
 *                              Create lockfile only if mailbox is non-zero
 *                              size.
 *      1.015  02-19-98 [ks]    -- added patches provided by Blaise Camp.
 *				Add an expiration time on the lockfiles.
 *      1.016  02-23-98 [ks]    -- added signal handler for SIGPIPE.
 *                              Thanks to Blaise Camp for his suggestion.
 */
#ifdef notdef
extern char *malloc();
extern char *realloc();
#endif
extern char *crypt();

/* In main.c: */
extern char *svr_hostname;
#ifdef DEBUG
extern FILE *logfp;
#endif /* DEBUG */

/* In folder.c: */
extern int fld_bsmtp();
extern int fld_fromsp();

extern void fld_delete();
extern void fld_last();
extern void fld_list();
extern void fld_reset();
#ifdef LOG_SESSIONS
extern int fld_retr();
#else
extern void fld_retr();
#endif
extern void fld_stat();
extern void fld_top();
#ifdef UIDL_OKAY /* [1.010] */
extern void fld_uidl();
#endif

extern void fld_release();

/* In util.c: */
extern int verify_user();
extern long fgetl();
extern void cmd_prepare();
extern void fail();

#ifdef NO_MULTIPLE		/* [1.015] */
/* [1.015] Here is where the lockfile expiration timeout value is set. */
/* [1.015] It is measured in seconds. You may increase or decrease     */
/* [1.015] the timeout value as needed at your site.                   */
#define LOCK_EXPIRE_TIME        5400          	/* 5400 -> 1.5 hours */
#endif

#ifdef UCD
#define POPHOSTS                "blue(pop1), green(pop2), scarlet(pop3)"
#define LOGINPOP                "mailbox(sol), dilbert, dogbert, catbert, rocky"
#define TMP_DIR                 "/var/tmp/"
#endif


#ifdef STANDALONE
#define MYPORT 110
#define QUEUE_LIMIT 200
#endif /* STANDALONE */


#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 8
#endif /* MAXHOSTNAMELEN */

#define SVR_LISTEN_STATE	0x00		/* Wait for client connection */
#define SVR_AUTH_STATE		0x01		/* Expecting USER command */
#define SVR_PASS_STATE		0x02		/* Expecting PASS command */
#define SVR_TRANS_STATE		0x03		/* Process mailbox commands */
#define SVR_FOLD_STATE		0x04		/* Need to open another mbox */
#define SVR_DONE_STATE		-1

#define SVR_TIMEOUT_CLI		600		/* 10 minutes */
#define SVR_TIMEOUT_SEND	120		/* 02 minutes */
#define SVR_BUFSIZ		1024
#define CLI_BUFSIZ		128
#ifdef QMAIL
#define CLI_DIRSIZ              256
#endif /* QMAIL */

#ifdef QMAIL
#define DEF_MBOX_NAME           "/Mailbox"
#define DEF_POP3_DIR            "/var/qmail/pop/"
#else /* !QMAIL */
#if   defined (SYSV)
#define DEF_MAIL_DIR		"/usr/mail/"
#define DEF_POP3_DIR		"/usr/spool/pop/"
#elif defined (SVR4)
#define DEF_MAIL_DIR		"/var/mail/"
#define DEF_POP3_DIR		"/var/spool/pop/"
#else /* !(defined(SYSV) || defined(SVR4)) */
#define DEF_MAIL_DIR		"/usr/spool/mail/"
#define DEF_POP3_DIR		"/usr/spool/pop/"
#endif /* defined(SYSV) || defined(SVR4) */
#endif /* QMAIL */

#define POP3_TMPFILE		"/var/tmp/pop3XXXXXX"	 /* [1.015] */
#define POP3_NOMULTIPLE_STUB	"/var/tmp/pop_lockfile_" /* [1.015] */
#define POP3_RCPT_HDR		"X-POP3-Rcpt:"
#define MESSAGE_ID_HDR		"Message-ID:"

#define BSMTP_HELO_STATE	0x00		/* Expecting HELO command */
#define BSMTP_MAIL_STATE	0x01		/* Expecting MAIL command */
#define BSMTP_RCPT_STATE	0x02		/* Processing RCPT cmds */
#define BSMTP_DATA_STATE	0x03		/* Processing message */

struct fld_item {
	long fmsg_entry;		/* Index in file of start of msg */
	long bcount;			/* #bytes this msg (for scan listing) */
	int status;			/* Status of this message */
#define MSG_DELETED	0x01			/* Msg marked for deletion */
	char *pop_hdr;			/* Extra header for POP3 client */
#ifdef UIDL_OKAY /* [1.010] */
        char *msg_id;			/* Message-ID of message */
#endif
#ifdef PINE_IMAP
	char *header_lines;
#endif
};
#define FLD_ENTRY_BLOCK		16
#define get_e_array(a,m) {\
	a = (struct fld_item *)malloc(sizeof(struct fld_item)*( (m) + 1));\
}
#define chk_e_size(a,m,i) {\
	if ( ( (i) ) && (!( (i) % (m) )) ) {\
		a = (struct fld_item *)realloc( (a), (sizeof(struct fld_item)*( (i) + (m) + 1)));\
	}\
}

#ifdef DEBUG
#if   defined (SYSV)
#define LOGFILE			"/var/log/pop3d.debug.log"
#elif defined (SVR4)
#define LOGFILE			"/var/log/pop3d.debug.log"
#else /* defined(SYSV) || defined(SVR4) */
#define LOGFILE			"/var/log/pop3d.debug.log"
#endif /* defined(SYSV) || defined(SVR4) */
#endif /* DEBUG */

#define FAIL_CONFUSION		51		/* unknown error */
#define FAIL_FILE_ERROR		52		/* file read/write error */
#define FAIL_HANGUP		53		/* client hung up on us */
#define FAIL_LOST_CLIENT	54		/* timeout waiting for client */
#define FAIL_OUT_OF_MEMORY	55		/* out of system memory */
#define FAIL_PROGERR		56		/* unexpected program error */

#define NULL_CHAR	'\0'
#define LF_CHAR		'\n'
#define CR_CHAR		'\r'
#define SPACE_CHAR	' '
#define DOT_CHAR	'.'
#define LANKLE_CHAR	'<'
#define RANKLE_CHAR	'>'

#define EATSPACE(s)	while (isspace((int)*s)&&(*s != NULL_CHAR)) ++s
