#include "support.h"
#include "callbacks.h"

#include "syncscope.h"
#include "main.h"
#include "trx.h"

#define	NUMTRACES	1

static GdkPixmap *syncscopepixmap = NULL;
static GdkGC *gc_black;
static GdkGC *gc_green;
static GdkGC *gc_red;

void syncscope_init(void)
{
	GdkColor color;
	GdkColormap *cmap;

	cmap = gdk_colormap_get_system();

	/* get black foreground */
	gdk_color_parse("black", &color); 
	if (!gdk_color_alloc(cmap, &color))
		g_error("Couldn't allocate color");
	gc_black = gdk_gc_new(syncscopepixmap);
	gdk_gc_set_foreground(gc_black, &color);

	/* get green foreground */
	gdk_color_parse("green", &color);
	if (!gdk_color_alloc(cmap, &color))
		g_error("Couldn't allocate color");
	gc_green = gdk_gc_new(syncscopepixmap);
	gdk_gc_set_foreground(gc_green, &color);

	/* get red foreground */
	gdk_color_parse("red", &color);
	if (!gdk_color_alloc(cmap, &color))
		g_error("Couldn't allocate color");
	gc_red = gdk_gc_new(syncscopepixmap);
	gdk_gc_set_foreground(gc_red, &color);
}

void syncscope_draw(guchar *data)
{
	GtkWidget *widget;
	static GdkPoint pt[NUMTRACES][SYNCSCOPE_WIDTH], syn[2];
	gint x, y, i;
	gfloat sync;
	static gint idx = 0;

	widget = lookup_widget(appwindow, "syncscope_darea");

	if (!GTK_WIDGET_DRAWABLE(widget))
		return;

	x = widget->allocation.width;
	y = widget->allocation.height;

	if (x > SYNCSCOPE_WIDTH)
		x = SYNCSCOPE_WIDTH;

	for (i = 0; i < x; i++) {
		pt[idx][i].x = i;
		pt[idx][i].y = (255 - data[i]) * y / 256;
	}

	gdk_draw_rectangle(syncscopepixmap,
			   widget->style->black_gc,
			   TRUE,
			   0, 0,
			   x, y);

	for (i = 0; i < NUMTRACES; i++)
		gdk_draw_lines(syncscopepixmap, gc_green, pt[i], x);

	if ((sync = trx_get_sync()) != -1) {
		syn[0].x = x * sync;
		syn[0].y = 0;
		syn[1].x = x * sync;
		syn[1].y = y;
		gdk_draw_lines(syncscopepixmap, gc_red, syn, 2);
	}

	gdk_draw_pixmap(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			syncscopepixmap,
			0, 0,
			0, 0,
			x, y);

	idx = (idx + 1) % NUMTRACES;
}

/*
 * Callbacks...
 */
gboolean on_syncscope_darea_configure_event(GtkWidget *widget,
					    GdkEventConfigure *event,
					    gpointer user_data)
{
	if (syncscopepixmap)
		gdk_pixmap_unref(syncscopepixmap);

	syncscopepixmap = gdk_pixmap_new(widget->window,
					 widget->allocation.width,
					 widget->allocation.height, -1);

	gdk_draw_rectangle(syncscopepixmap,
			   widget->style->black_gc,
			   TRUE,
			   0, 0,
			   widget->allocation.width,
			   widget->allocation.height);

	return TRUE;
}

gboolean on_syncscope_darea_expose_event(GtkWidget *widget,
					 GdkEventExpose *event,
					 gpointer user_data)
{
	gdk_draw_pixmap(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			syncscopepixmap,
			event->area.x, event->area.y,
			event->area.x, event->area.y,
			event->area.width, event->area.height);
	return TRUE;
}

gboolean on_syncscope_darea_button_press_event(GtkWidget *widget,
					       GdkEventButton *event,
					       gpointer user_data)
{
	gfloat pos;

	pos = event->x / widget->allocation.width;
	trx_set_sync(pos);

	return FALSE;
}

