/*
 * models for the xss chess screensavers
 * hacked from:
 *
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2006  John-Paul Gignac <jjgignac@users.sf.net>
 *
 * Copyright (C) 2002  Robert  Ancell <bob27@users.sourceforge.net>
 *                     Michael Duelli <duelli@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* chessmodels.c: Contains the code for piece model creation */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */

#include <math.h>
#include <stdlib.h>

#ifndef HAVE_COCOA
# include <GL/glx.h>
# include <GL/gl.h>
#endif

#ifdef HAVE_JWZGLES
# include "jwzgles.h"
#endif /* HAVE_JWZGLES */

#include "chessmodels.h"

/* End of Data */
#define ENDOFDATA 65535

/* Section headers */
#define SPIN 65534
#define VERTICES 65533
#define QUADS 65532
#define TRIANGLES 65531
#define POLARQUADSTRIP 65530
#define QUADSTRIP 65529

/* Special spin-related commands */
#define SEAM 65528
#define PATTERN 65527
#define STEPUP 65526
#define STEPDOWN 65525
#define SETBACKREF 65524
#define BACKREF 65523

static unsigned short classic_pawn_data[] = {
  SPIN,16,
  350,0,SEAM,350,200,SEAM,250,300,SEAM,250,400,SEAM,150,600,SEAM,100,880,
  SEAM,180,880,SEAM,100,920,SEAM,200,1160,SEAM,100,1340,0,1340,
  ENDOFDATA
};

static unsigned short classic_rook_data[] = {
  SPIN,16,
  380,0,SEAM,380,200,SEAM,260,500,SEAM,200,1020,SEAM,280,1020,SEAM,280,1360,SEAM,220,1360,SEAM,220,1300,0,1300,
  ENDOFDATA
};

static unsigned short classic_knight_data[] = {
  SPIN,16,
  410,0,SEAM,410,200,SEAM,200,360,SEAM,200,480,260,580,

  VERTICES,
  260,580,260, -260,580,260, -260,580,-80, 260,580,-80, 80,1620,400,
  100,1680,340, -100,1680,340, -80,1620,400, 100,1680,340, 100,1680,300,
  -100,1680,300, -100,1680,340, 100,1680,300, 50,1680,160, -50,1680,160,
  -100,1680,300, 50,1680,160, 100,1680,20, -100,1680,20, -50,1680,160,
  100,1680,20, 100,1680,-20, -100,1680,-20, -100,1680,20, 100,1680,-20,
  40,1680,-110, -40,1680,-110, -100,1680,-20, 40,1680,-110,
  100,1680,-200, -100,1680,-200, -40,1680,-110, 100,1680,-200,
  100,1680,-440, -100,1680,-440, -100,1680,-200, -100,1680,-440,
  100,1680,-440, 100,1500,-440, -100,1500,-440, -100,1500,-440,
  100,1500,-440, 55,1480,-280, -55,1480,-280, -100,1680,300, -50,1680,160,
  -100,1400,130, -120,1380,240, -50,1680,160, -80,1680,20, -120,1380,20,
  -100,1400,130, -83,1660,20, -80,1680,20, -100,1680,-20, -100,1660,-38,
  -120,1380,20, -88,1620,20, -100,1620,-74, -120,1360,-20, -120,1360,-20,
  -100,1620,-74, -100,1580,-110, -60,1400,-140, -100,1680,-200,
  -55,1480,-280, -60,1400,-140, -100,1580,-110, -100,1680,-200,
  -100,1680,-440, -100,1500,-440, -55,1480,-280, 100,1680,300,
  120,1380,240, 100,1400,130, 50,1680,160, 50,1680,160, 100,1400,130,
  120,1380,20, 80,1680,20, 83,1660,20, 100,1660,-38, 100,1680,-20,
  80,1680,20, 120,1380,20, 120,1360,-20, 100,1620,-74, 88,1620,20,
  120,1360,-20, 60,1400,-140, 100,1580,-110, 100,1620,-74, 100,1680,-200,
  100,1580,-110, 60,1400,-140, 55,1480,-280, 100,1680,-200, 55,1480,-280,
  100,1500,-440, 100,1680,-440, 88,1620,20, 100,1620,-74, 80,1640,-56,
  61,1640,20, 61,1640,20, 80,1640,-56, 100,1660,-38, 83,1660,20,
  -88,1620,20, -61,1640,20, -80,1640,-56, -100,1620,-74, -61,1640,20,
  -83,1660,20, -100,1660,-38, -80,1640,-56, 35,1780,-80, 35,1780,-440,
  -35,1780,-440, -35,1780,-80, 35,1780,-80, 35,1680,-80, 35,1680,-440,
  35,1780,-440, -35,1780,-80, -35,1780,-440, -35,1680,-440, -35,1680,-80,
  35,1780,-80, -35,1780,-80, -35,1680,-80, 35,1680,-80, 35,1780,-440,
  35,1680,-440, -35,1680,-440, -35,1780,-440, -100,1400,130, -120,1380,20,
  120,1380,20, 100,1400,130, -100,1400,130, 100,1400,130, 120,1380,240,
  -120,1380,240, -260,580,-80, -55,1480,-280, 0,1500,-360, 0,780,-400,
  260,580,-80, 0,780,-400, 0,1500,-360, 55,1480,-280, -50,1380,40,
  -200,880,400, 200,880,400, 50,1380,40, -200,880,400, -260,580,260,
  260,580,260, 200,880,400, -50,1380,40, -140,1220,-40, -260,580,260,
  -200,880,400, -140,1220,-40, -114,1220,-222, -260,580,-80, -260,580,260,
  -55,1480,-280, -114,1220,-222, -140,1220,-40, -60,1400,-140,
  50,1380,40, 200,880,400, 260,580,260, 140,1220,-40, 140,1220,-40,
  260,580,260, 260,580,-80, 114,1220,-222, 55,1480,-280, 60,1400,-140,
  140,1220,-40, 114,1220,-222, 260,580,-80, 144,580,-260, 0,780,-400,
  144,580,-260, -144,580,-260, 0,780,-400, -260,580,-80, 0,780,-400,
  -144,580,-260, 0,1400,400, 80,1620,400, -80,1620,400, 0,1400,400,
  -80,1620,400, -120,1380,240, -120,1380,240, -80,1620,400, -100,1680,340,
  -120,1380,240, -100,1680,340, -100,1680,300, 0,1400,400, 120,1380,240,
  80,1620,400, 120,1380,240, 100,1680,340, 80,1620,400, 120,1380,240,
  100,1680,300, 100,1680,340, 0,1400,400, -120,1380,240, 120,1380,240,
  -60,1400,-140, -140,1220,-40, -45,1380,-20, -45,1380,-20, -140,1220,-40,
  -50,1380,40, 60,1400,-140, 45,1380,-20, 140,1220,-40, 45,1380,-20,
  50,1380,40, 140,1220,-40, 60,1400,-140, 120,1360,-20, 45,1380,-20,
  50,1380,40, 45,1380,-20, 120,1360,-20, 50,1380,40, 120,1360,-20,
  120,1380,20, -60,1400,-140, -45,1380,-20, -120,1360,-20, -50,1380,40,
  -120,1360,-20, -45,1380,-20, -50,1380,40, -120,1380,20, -120,1360,-20,
  88,1620,20, 61,1640,20, 83,1660,20, 100,1620,-74, 100,1660,-38,
  80,1640,-56, -88,1620,20, -83,1660,20, -61,1640,20, -100,1620,-74,
  -80,1640,-56, -100,1660,-38, -40,1680,-110, -100,1680,-200,
  -100,1580,-110, -100,1680,-20, -40,1680,-110, -100,1580,-110,
  40,1680,-110, 100,1580,-110, 100,1680,-200, 100,1680,-20, 100,1580,-110,
  40,1680,-110,

  QUADS, 0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15, 16,17,18,19,
  20,21,22,23, 24,25,26,27, 28,29,30,31, 32,33,34,35, 36,37,38,39,
  40,41,42,43, 44,45,46,47, 48,49,50,51, 52,53,54,55, 56,57,58,59,
  60,61,62,63, 64,65,66,67, 68,69,70,71, 72,73,74,75, 76,77,78,79,
  80,81,82,83, 84,85,86,87, 88,89,90,91, 92,93,94,95, 96,97,98,99,
  100,101,102,103, 104,105,106,107, 108,109,110,111, 112,113,114,115,
  116,117,118,119, 120,121,122,123, 124,125,126,127, 128,129,130,131,
  132,133,134,135, 136,137,138,139, 140,141,142,143, 144,145,146,147,
  148,149,150,151, 152,153,154,155, 156,157,158,159, 160,161,162,163,
  164,165,166,167, 168,169,170,171, 172,173,174,175, 176,177,178,179,
  180,181,182,183,

  TRIANGLES, 184,185,186, 187,188,189, 190,191,192, 193,194,195,
  196,197,198, 199,200,201, 202,203,204, 205,206,207, 208,209,210,
  211,212,213, 214,215,216, 217,218,219, 220,221,222, 223,224,225,
  226,227,228, 229,230,231, 232,233,234, 235,236,237, 238,239,240,
  241,242,243, 244,245,246, 247,248,249, 250,251,252, 253,254,255,
  256,257,258, 259,260,261, 262,263,264, 265,266,267, 268,269,270,

  ENDOFDATA
};

static unsigned short classic_bishop_data[] = {
  SPIN,16,
  400,0,SEAM,400,200,SEAM,250,300,SEAM,250,400,SEAM,150,700,SEAM,120,940,
  SEAM,250,940,SEAM,170,1100,SEAM,170,1220,SEAM,220,1320,SEAM,220,1480,
  SEAM,100,1600,SEAM,80,1700,SEAM,120,1770,SEAM,80,1840,0,1840,
  ENDOFDATA
};

static unsigned short classic_queen_data[] = {
  SPIN,16,
  480,0,SEAM,480,220,SEAM,340,400,SEAM,340,500,SEAM,180,800,SEAM,140,1180,
  SEAM,290,1180,SEAM,180,1360,SEAM,180,1520,SEAM,200,1780,SEAM,270,1920,
  SEAM,240,2000,SEAM,170,2000,SEAM,95,2080,SEAM,70,2080,SEAM,90,2140,
  SEAM,70,2200,0,2200,
  ENDOFDATA
};

static unsigned short classic_king_data[] = {
  SPIN,16,
  500,0,SEAM,500,200,SEAM,350,300,SEAM,350,460,SEAM,200,760,SEAM,140,1260,
  SEAM,300,1260,SEAM,200,1460,SEAM,200,1560,SEAM,280,1910,SEAM,160,1970,
  SEAM,160,2010,0,2010,

  VERTICES, 
  -30,2010,35, 30,2010,35, 30,2310,35, -30,2310,35, -90,2110,35,
  -30,2110,35, -30,2210,35, -90,2210,35, 90,2110,35, 90,2210,35,
  30,2210,35, 30,2110,35, 30,2010,-35, -30,2010,-35, -30,2310,-35,
  30,2310,-35, -30,2110,-35, -90,2110,-35, -90,2210,-35, -30,2210,-35,
  30,2110,-35, 30,2210,-35, 90,2210,-35, 90,2110,-35, -90,2110,35,
  -90,2210,35, -90,2210,-35, -90,2110,-35, -30,2010,35, -30,2110,35,
  -30,2110,-35, -30,2010,-35, -30,2210,30, -30,2310,30, -30,2310,-30,
  -30,2210,-30, 90,2110,-35, 90,2210,-35, 90,2210,35, 90,2110,35,
  30,2010,-35, 30,2110,-35, 30,2110,35, 30,2010,35, 30,2210,-35,
  30,2310,-35, 30,2310,35, 30,2210,35, -90,2210,-35, -90,2210,35,
  -30,2210,35, -30,2210,-35, 30,2210,-35, 30,2210,35, 90,2210,35,
  90,2210,-35, -30,2310,-35, -30,2310,35, 30,2310,35, 30,2310,-35,

  QUADS, 0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15, 16,17,18,19,
  20,21,22,23, 24,25,26,27, 28,29,30,31, 32,33,34,35, 36,37,38,39,
  40,41,42,43, 44,45,46,47, 48,49,50,51, 52,53,54,55, 56,57,58,59,

  ENDOFDATA
};

static unsigned short knight_data[] = {
  VERTICES, SETBACKREF,0, 7910,8863,0, 7790,8863,1326, 7433,8863,2611,
  6850,8863,3817, 6059,8863,4907, 5084,8863,5847, 3955,8863,6611,
  2705,8863,7173, 1373,8863,7517, 0,8863,7633, -1373,8863,7517,
  -2705,8863,7173, -3955,8863,6611, -5084,8863,5847, -6059,8863,4907,
  -6850,8863,3817, -7433,8863,2611, -7790,8863,1326, -7910,8863,0,
  -7790,8863,-1326, -7433,8863,-2611, -6850,8863,-3817,
  -6059,8863,-4907, -5066,8863,-5896, -3955,8863,-6611,
  -2705,8863,-7173, -1373,8863,-7517, 0,8863,-7633, 1373,8863,-7517,
  2705,8863,-7173, 3955,8863,-6611, 5066,8863,-5896, 6059,8863,-4907,
  6850,8863,-3817, 7433,8863,-2611, 7790,8863,-1326, -1183,11744,7939,
  -1183,12003,7939, -1183,14019,6547, -1183,16307,5288,
  -1183,16555,5281, -1183,20128,2191, -1134,20304,2131,
  -1183,20516,2156, -1417,21874,1842, -1417,23109,2185,
  -1417,23961,3121, -1417,24001,4252, 0,23917,5637, -1418,23893,5418,
  -1151,23389,6664, -1151,23501,6906, -1151,23806,6987,
  -1151,24102,6987, -1151,24209,7189, -1151,24371,7513,
  -1151,24605,7715, -1151,24939,7674, -1313,25568,7149,
  -1313,25695,7149, -1598,26707,7610, 0,26837,7841, 0,27354,8076,
  -1598,27262,7839, -1598,27842,7723, 0,27919,7998, 0,28449,7606,
  -1598,28309,7303, -1302,28414,6723, 0,28544,6980, 0,28540,6197,
  -1187,28523,5990, -1304,28447,4204, -1158,28789,1627,
  -561,28931,-1220, -357,29608,-1244, -357,30527,-1441,
  -357,31249,-1837, -357,31511,-2627, -357,31511,-3484,
  -357,31118,-4143, -357,30264,-4538, -436,29406,-5256, 0,29409,-5243,
  -2207,29018,-6763, -914,28658,-6964, 0,26292,-7237, -1305,26324,-7143,
  -806,23401,-6784, -812,20723,-6228, -796,16757,-6210,
  -1559,24934,7435, -1566,24633,7460, -1531,24429,7334,
  -1475,24293,7131, -1440,24203,7004, -1372,23935,7015,
  -1364,23606,6868, -1389,23515,6705, -1687,28010,6952,
  -1687,27926,7343, -1687,27629,7491, -1687,27324,7552,
  -1687,27032,7432, -1687,26791,7148, -1642,27135,7165,
  -1642,27254,7304, -1642,27397,7364, -1642,27546,7334,
  -1642,27693,7261, -1642,27737,7088, -1611,10591,8159,
  -888,9327,-8560, -4491,13292,1032, -3840,15084,786, -3412,17397,397,
  -2937,20005,-35, -5108,11669,1240, -6344,10251,1395, -6345,10246,1248,
  -5109,11664,1092, -2964,20022,-132, -3413,17393,250, -3841,15079,638,
  -4491,13288,885, -3743,13207,-535, -3085,15092,-710, -2727,17642,-878,
  -2569,20636,-797, -4348,11575,-324, -5584,10108,-169,
  -5403,10079,-1732, -4167,11644,-1888, -2465,20842,-2651,
  -2522,18130,-2392, -2905,15407,-2077, -3562,13227,-1951,
  -3901,13568,-3294, -3243,15993,-3519, -2861,18863,-3735,
  -2776,22447,-4309, -4486,11792,-3132, -5783,9930,-2931,
  -5783,9930,-3054, -4486,11792,-3255, -2776,22438,-4430,
  -2861,18863,-3858, -3243,15993,-3641, -3901,13568,-3417,
  -6199,9466,4558, -5766,10642,5726, -5228,11829,6090, -4801,12891,6048,
  -4155,14560,5246, -3546,16847,3719, -3334,17643,2937,
  -2860,20062,1230, -4822,12054,7102, -5325,10909,7208,
  -5732,9938,6026, -4026,14701,5522, -2852,20170,1447, -3319,17801,3175,
  -3538,16955,3935, -4090,13256,1679, -2874,20073,676, -3706,15083,1464,
  -3301,17348,1117, -5931,10206,1996, -4695,11624,1840,
  -4445,11658,2844, -5681,10240,3000, -3074,17398,2202,
  -3456,15117,2468, -3840,13290,2683, -4642,13358,4019,
  -4257,15194,3908, -6017,10188,3746, -5237,11714,4039,
  -5621,11218,5077, -5026,12862,5058, -5134,10861,-3154,
  -4193,12680,-3336, -2832,20609,-4118, -3052,17428,-3750,
  -3572,14780,-3529, -3579,14774,-3623, -3059,17422,-3843,
  -2839,20596,-4211, -4200,12674,-3429, -5141,10855,-3248,
  -3908,13562,-3510, -3250,15987,-3735, -2868,18857,-3952,
  -4492,11786,-3348, -5789,9924,-3148, -4817,11321,-3298,
  -5465,10389,-3198, -4054,13118,-3470, -4346,12230,-3389,
  -2853,19681,-4056, -2825,21511,-4367, -3155,16705,-3789,
  -2963,18140,-3897, -3744,14168,-3567, -3415,15381,-3679,
  -845,13482,-6604, -945,10997,-7893, -981,11110,-7735,
  -859,13469,-6526, -899,9307,-8439, -813,16486,-6146, -832,20681,-6100,
  -826,23358,-6656, -882,10149,-8148, -913,12323,-7139,
  -822,14910,-6353, -817,18235,-6210, -827,21937,-6382,
  -846,21937,-6341, -841,14912,-6313, -931,12326,-7098,
  -901,10152,-8107, -844,23359,-6615, -851,20681,-6059,
  -831,16487,-6105, -919,9307,-8399, -869,13482,-6492, -999,11113,-7694,
  -860,9726,-8255, -942,10578,-7958, -962,11715,-7413, -900,12896,-6796,
  -863,14065,-6404, -818,15760,-6221, -828,17367,-6171,
  -854,19800,-5994, -848,21309,-6200, -843,22566,-6482,
  -3407,15409,-3785, -3736,14196,-3673, -2911,18365,-4048,
  -3147,16733,-3895, -2726,21608,-4455, -2808,19905,-4191,
  -4338,12259,-3495, -4046,13146,-3576, -5457,10418,-3304,
  -4809,11349,-3404, -4484,11815,-3454, -2715,22288,-4534,
  -2832,19035,-4066, -3242,16015,-3841, -3900,13590,-3616,
  -5133,10883,-3354, -4171,12742,-3524, -2803,20773,-4339,
  -3051,17450,-3949, -3571,14803,-3729, -4979,11072,-3368,
  -5619,10185,-3279, -4119,12924,-3556, -4411,12037,-3475,
  -2801,20363,-4269, -2721,21826,-4489, -3099,17092,-3922,
  -2887,18618,-4038, -3653,14499,-3701, -3325,15712,-3813,
  -3489,15106,-3757, -3818,13893,-3645, -3011,17758,-3971,
  -3194,16374,-3868, -2755,21085,-4385, -2815,19494,-4139,
  -4265,12481,-3515, -3973,13368,-3596, -5304,10595,-3318,
  -4664,11477,-3407, -5441,10207,-3361, -5350,10338,-3375,
  -5139,10672,-3428, -5058,10742,-3431, -4831,11101,-3457,
  -4742,11228,-3470, -4516,11559,-3504, -4423,11693,-3518,
  -4277,12079,-3558, -4232,12180,-3571, -4138,12522,-3597,
  -4094,12603,-3609, -3979,12935,-3675, -3943,13043,-3671,
  -3852,13383,-3699, -3813,13496,-3705, -3692,13947,-3767,
  -3653,14073,-3790, -3506,14587,-3772, -3467,14685,-3777,
  -3349,15192,-3888, -3308,15317,-3887, -3162,15800,-3957,
  -3119,15954,-3961, -3009,16528,-3946, -3002,16637,-3937,
  -2914,17260,-4014, -2909,17347,-4006, -2834,17893,-4049,
  -2813,18060,-4060, -2760,18849,-4232, -2746,18968,-4242,
  -850,22569,-6438, -855,21313,-6156, -861,19804,-5949,
  -834,17371,-6127, -824,15765,-6176, -869,14070,-6360,
  -906,12901,-6751, -968,11720,-7368, -948,10645,-7895, -865,9731,-8211,
  -1006,11164,-7630, -875,13487,-6447, -926,9310,-8354,
  -837,16490,-6061, -857,20684,-6015, -867,23379,-6515,
  -907,10157,-8062, -937,12331,-7053, -847,14917,-6268,
  -842,18236,-6111, -852,21941,-6297, -885,9891,-8156, -985,10905,-7724,
  -947,11969,-7255, -885,13125,-6649, -858,14493,-6314,
  -839,16049,-6111, -836,17735,-6083, -859,20244,-5982,
  -891,21559,-6157, -848,22883,-6508, -851,22255,-6367,
  -856,20999,-6085, -867,19042,-6000, -836,16930,-6094,
  -835,15341,-6222, -880,13646,-6405, -916,12540,-6953,
  -981,11337,-7564, -927,10370,-7988, -932,9518,-8285, -931,9583,-8174,
  -863,9671,-8145, -892,9982,-8037, -903,10075,-7996, -952,10454,-7865,
  -961,10550,-7832, -1008,10963,-7617, -1018,11105,-7567,
  -996,11458,-7405, -992,11582,-7342, -972,12080,-7057,
  -968,12210,-6984, -935,12620,-6792, -931,12759,-6714,
  -914,13199,-6441, -910,13346,-6359, -915,13767,-6194,
  -910,13941,-6175, -890,14633,-6107, -886,14783,-6091,
  -864,15476,-6035, -859,15645,-6017, -870,16062,-5957,
  -873,16231,-5936, -853,17048,-5965, -861,17185,-5974,
  -879,17812,-5997, -885,17961,-5997, -851,18486,-6138,
  -865,18526,-5933, -872,18761,-5875, -870,19337,-5971,
  -864,19470,-5784, -937,19590,-5786, -833,19023,-6126,
  -851,20344,-5894, -851,20576,-5912, -855,21086,-5973,
  -854,21224,-6003, -871,21651,-6070, -852,21853,-6116,
  -850,22332,-6224, -849,22490,-6259, -831,22924,-6338,
  -834,23240,-6364, -2743,19661,-4287, -2740,19863,-4312,
  -2723,20501,-4469, -2705,20711,-4503, -2661,21262,-4565,
  -2658,21427,-4593, -2687,22088,-4631, -2695,22209,-4643,
  -2774,23170,-4392, -2633,23103,-4527, -2681,22439,-4516,
  -2656,22665,-4573, -2552,22727,-4653, -2534,23015,-4628,
  -2607,23397,-4556, -2759,23681,-4398, -2740,24136,-4370,
  -2610,24100,-4580, -2412,24481,-5089, -2671,24389,-4569,
  -2397,24935,-5652, -2562,25022,-5528, -939,23708,-6566,
  -1009,24359,-6776, -1095,24912,-6886, -1049,24117,-6493,
  -990,23894,-6415, -2290,23837,-4814, -2312,23612,-4723,
  -2183,24804,-5574, -2191,24632,-5391, -1156,24771,-6650,
  -1154,24624,-6586, -1104,24526,-6656, -1281,9161,-8432,
  -2524,9161,-8046, -3691,9161,-7572, -4745,9161,-6945,
  -5662,9127,-6096, -3697,9192,-7581, -2531,9192,-8056,
  -4753,9183,-6951, -5664,9161,-6101, -5664,9185,-6101,
  -4753,9207,-6951, -2531,9216,-8055, -3697,9216,-7581,
  -3684,9232,-7560, -2518,9232,-8034, -4740,9223,-6930,
  -5651,9200,-6080, -2828,20259,1366, -2798,20256,1187, -2820,20237,692,
  -2843,20292,-25, -2874,20473,735, -2975,20508,90, -2474,20772,-759,
  -2660,20879,-691, -2471,21553,-1445, -2498,22175,-1940,
  -2471,24346,-2830, -2556,22373,-1903, -2528,21595,-1351,
  -2493,24314,-2936, -2576,22239,-2123, -2548,21461,-1571,
  -2823,20635,1307, -2741,20503,1328, -1490,23972,5392,
  -1489,24080,4226, -1489,24040,3095, -1489,23188,2159,
  -1489,21953,1816, -2479,22156,182, -1515,23830,2117, -1605,24415,3131,
  -1599,24460,4263, -1580,24357,5431, -1448,23885,6743,
  -1252,24770,5442, -1271,24873,4274, -1277,24828,3142,
  -1389,24618,2016, -1479,24733,1993, -1301,25010,3165,
  -1295,25055,4297, -1391,24890,5460, -1512,25216,5507,
  -1602,25353,4317, -1608,25308,3186, -1979,23458,-29, -1320,25312,1928,
  -1495,25055,546, -2438,25790,-488, -1605,25585,5599, -1583,26793,6150,
  -1850,26272,4298, -1578,27435,7117, -1658,27625,6884,
  -1671,27398,6846, -1678,27176,6937, -1715,27784,6626,
  -1744,27323,6551, -1753,26904,6776, -1884,28809,-1688,
  -1555,28655,1620, -1658,28252,4204, -1581,28263,5997,
  -1567,28312,6790, -1935,27827,4220, -1818,28249,1603,
  -1570,27742,6195, -1532,27288,6120, -2038,27074,4245, -1418,28416,228,
  -413,30264,-4539, -424,31094,-4152, -418,31478,-3497,
  -410,31453,-2653, -410,31190,-1863, -410,30468,-1467,
  -410,29550,-1270, -411,31041,-1902, -448,31253,-2696,
  -449,31323,-3466, -425,31182,-3496, -411,31060,-2738,
  -387,30899,-1932, -316,30806,-1957, -335,30952,-2766,
  -353,31089,-3521, -322,31007,-3540, -303,30871,-2786,
  -284,30725,-1976, -304,30630,-1993, -323,30776,-2802,
  -342,30912,-3557, -396,30843,-3565, -378,30707,-2811,
  -358,30561,-2001, -414,30477,-2013, -433,30623,-2822,
  -452,30759,-3576, -474,30560,-3616, -456,30424,-2861,
  -436,30278,-2052, -349,30194,-2077, -368,30340,-2886,
  -386,30477,-3641, -309,30389,-3665, -291,30253,-2911,
  -271,30107,-2102, -267,29996,-2124, -286,30142,-2933,
  -305,30278,-3688, -376,30179,-3700, -357,30043,-2945,
  -338,29897,-2136, -420,29789,-2150, -439,29935,-2959,
  -458,30071,-3713, -500,29883,-3751, -463,29601,-2187,
  -470,30974,-4049, -462,30153,-4391, -466,30563,-4220,
  -410,30009,-1368, -725,29372,-3225, -677,29335,-5130,
  -908,29205,-3300, -632,29533,-4803, -2587,28768,-3408,
  -2730,28611,-3456, -2404,28568,-6916, -2413,28849,-6612,
  -1904,26715,1801, -1394,25919,831, -2224,27270,-3994,
  -2730,28438,-3011, -2587,28570,-2864, -2826,28152,-3163,
  -2476,28668,-6523, -2476,28433,-6776, -2787,28338,-3507,
  -2216,27658,-3972, -2207,27950,-5907, -2311,28216,-6128,
  -2320,27876,-3971, -2311,28118,-6301, -2311,27845,-6252,
  -2320,27703,-3749, -2320,27084,-3798, -2320,26986,-4070,
  -2698,26705,-4014, -2557,26974,-3547, -2557,27739,-3485,
  -2572,27738,-6362, -2436,28204,-6533, -2436,28421,-6303,
  -2556,28092,-3822, -2431,28142,-6975, -2544,27863,-6726,
  -2266,28229,-1686, -1939,28156,-1065, -2569,27943,-2270,
  -2381,27545,-1682, -2799,27594,-3104, -2750,27866,-2738,
  -2539,27578,-6309, -2720,26853,-3133, -2788,26461,-3776,
  -1061,27543,-7078, -1780,27941,135, -1859,27747,-527, -1756,27784,691,
  -1855,27001,736, -1950,26711,19, -1964,27006,-630, -2342,26955,-1898,
  -2595,25515,-3113, -2147,27855,132, -2126,27722,601, -2213,27691,-428,
  -2210,27061,639, -2290,26816,34, -2302,27065,-515, -2347,27680,100,
  -2335,27602,376, -2386,27584,-229, -2385,27213,398, -2432,27069,42,
  -2439,27215,-281, -2481,27452,103, -1786,24263,399, -2278,24851,-562,
  -2372,25143,-1163, 7383,9172,0, 7270,9172,-1487, 6937,9172,-2929,
  6393,9172,-4281, 1282,9172,-8433, 0,9172,-8563, 1301,9439,8159,
  2371,9313,7844, 3857,9286,7355, 4477,9172,6559, 5704,9174,5179,
  6393,9172,4281, 6937,9172,2929, 7270,9172,1487, -7270,9172,-1487,
  -6937,9172,-2929, -6393,9172,-4281, -1282,9172,-8433, 0,9339,8274,
  -1301,9439,8159, -2371,9313,7844, -3857,9286,7355, -4477,9172,6559,
  -5704,9174,5179, -6393,9172,4281, -6937,9172,2929, -7270,9172,1487,
  -796,9467,8260, 0,9503,8356, 0,9667,8438, -796,9666,8325,
  -807,10584,8327, -7383,9172,0, 796,9467,8260, 796,9666,8325,
  807,10584,8327, 0,10584,8457, 0,11744,8130, 1183,11744,7939,
  1183,12003,7939, 0,12003,8130, 0,14019,6737, 1183,14019,6547,
  1183,16307,5288, 0,16307,5479, 0,16555,5472, 1183,16555,5281,
  1183,20128,2191, 0,20128,2382, 0,20304,2322, 1134,20304,2131,
  1183,20516,2156, 0,20516,2346, 0,21898,2060, 1417,21874,1842,
  1417,23109,2185, 0,23133,2404, 0,23985,3339, 1417,23961,3121,
  1417,24001,4252, 0,24025,4470, 1418,23893,5418, 1151,23389,6664,
  0,23394,6882, 0,23506,7125, 1151,23501,6906, 1151,23806,6987,
  0,23811,7205, 0,24107,7205, 1151,24102,6987, 1151,24209,7189,
  0,24213,7407, 0,24376,7731, 1151,24371,7513, 1151,24605,7715,
  0,24610,7933, 0,24944,7892, 1151,24939,7674, 1313,25568,7149,
  0,25562,7367, 0,25689,7367, 1313,25695,7149, 1598,26707,7610,
  1598,27262,7839, 1598,27842,7723, 1598,28309,7303, 1302,28414,6723,
  1187,28523,5990, 1304,28447,4204, 0,28469,4435, 0,28654,1893,
  1158,28789,1627, 561,28931,-1220, 0,29310,-864, 0,29574,-1062,
  357,29608,-1244, 357,30527,-1441, 0,30496,-1259, 0,31221,-1655,
  357,31249,-1837, 357,31511,-2627, 0,31485,-2445, 0,31485,-3302,
  357,31511,-3484, 357,31118,-4143, 0,31089,-3961, 0,30233,-4356,
  357,30264,-4538, 436,29406,-5256, 0,29018,-6407, 2207,29018,-6763,
  914,28658,-6964, 0,28472,-7040, 1305,26324,-7143, 806,23401,-6784,
  0,23246,-6890, 0,20735,-6319, 812,20723,-6228, 796,16757,-6210,
  0,17171,-6133, 1559,24934,7435, 1566,24633,7460, 1531,24429,7334,
  1475,24293,7131, 1440,24203,7004, 1372,23935,7015, 1364,23606,6868,
  1389,23515,6705, 1687,28010,6952, 1687,27926,7343, 1687,27629,7491,
  1687,27324,7552, 1687,27032,7432, 1687,26791,7148, 1642,27135,7165,
  1642,27254,7304, 1642,27397,7364, 1642,27546,7334, 1642,27693,7261,
  1642,27737,7088, 1611,10591,8159, 888,9327,-8560, 4491,13292,1032,
  3840,15084,786, 3412,17397,397, 2937,20005,-35, 5108,11669,1240,
  6344,10251,1395, 6345,10246,1248, 5109,11664,1092, 2964,20022,-132,
  3413,17393,250, 3841,15079,638, 4491,13288,885, 3743,13207,-535,
  3085,15092,-710, 2727,17642,-878, 2569,20636,-797, 4348,11575,-324,
  5584,10108,-169, 5403,10079,-1732, 4167,11644,-1888,
  2465,20842,-2651, 2522,18130,-2392, 2905,15407,-2077,
  3562,13227,-1951, 3901,13568,-3294, 3243,15993,-3519,
  2861,18863,-3735, 2776,22447,-4309, 4486,11792,-3132, 5783,9930,-2931,
  5783,9930,-3054, 4486,11792,-3255, 2776,22438,-4430, 2861,18863,-3858,
  3243,15993,-3641, 3901,13568,-3417, 6199,9466,4558, 5766,10642,5726,
  5228,11829,6090, 4801,12891,6048, 4155,14560,5246, 3546,16847,3719,
  3334,17643,2937, 2860,20062,1230, 4822,12054,7102, 5325,10909,7208,
  5732,9938,6026, 4026,14701,5522, 2852,20170,1447, 3319,17801,3175,
  3538,16955,3935, 4090,13256,1679, 2874,20073,676, 3706,15083,1464,
  3301,17348,1117, 5931,10206,1996, 4695,11624,1840, 4445,11658,2844,
  5681,10240,3000, 3074,17398,2202, 3456,15117,2468, 3840,13290,2683,
  4642,13358,4019, 4257,15194,3908, 6017,10188,3746, 5237,11714,4039,
  5621,11218,5077, 5026,12862,5058, 5134,10861,-3154, 4193,12680,-3336,
  2832,20609,-4118, 3052,17428,-3750, 3572,14780,-3529,
  3579,14774,-3623, 3059,17422,-3843, 2839,20596,-4211,
  4200,12674,-3429, 5141,10855,-3248, 3908,13562,-3510,
  3250,15987,-3735, 2868,18857,-3952, 4492,11786,-3348, 5789,9924,-3148,
  4817,11321,-3298, 5465,10389,-3198, 4054,13118,-3470,
  4346,12230,-3389, 2853,19681,-4056, 2825,21511,-4367,
  3155,16705,-3789, 2963,18140,-3897, 3744,14168,-3567,
  3415,15381,-3679, 0,14037,-6616, 845,13482,-6604, 945,10997,-7893,
  0,11066,-7866, 981,11110,-7735, 859,13469,-6526, 899,9307,-8439,
  813,16486,-6146, 832,20681,-6100, 826,23358,-6656, 882,10149,-8148,
  913,12323,-7139, 822,14910,-6353, 817,18235,-6210, 827,21937,-6382,
  846,21937,-6341, 841,14912,-6313, 931,12326,-7098, 901,10152,-8107,
  844,23359,-6615, 851,20681,-6059, 831,16487,-6105, 919,9307,-8399,
  869,13482,-6492, 999,11113,-7694, 860,9726,-8255, 942,10578,-7958,
  962,11715,-7413, 900,12896,-6796, 863,14065,-6404, 818,15760,-6221,
  828,17367,-6171, 854,19800,-5994, 848,21309,-6200, 843,22566,-6482,
  3407,15409,-3785, 3736,14196,-3673, 2911,18365,-4048,
  3147,16733,-3895, 2726,21608,-4455, 2808,19905,-4191,
  4338,12259,-3495, 4046,13146,-3576, 5457,10418,-3304,
  4809,11349,-3404, 4484,11815,-3454, 2715,22288,-4534,
  2832,19035,-4066, 3242,16015,-3841, 3900,13590,-3616,
  5133,10883,-3354, 4171,12742,-3524, 2803,20773,-4339,
  3051,17450,-3949, 3571,14803,-3729, 4979,11072,-3368,
  5619,10185,-3279, 4119,12924,-3556, 4411,12037,-3475,
  2801,20363,-4269, 2721,21826,-4489, 3099,17092,-3922,
  2887,18618,-4038, 3653,14499,-3701, 3325,15712,-3813,
  3489,15106,-3757, 3818,13893,-3645, 3011,17758,-3971,
  3194,16374,-3868, 2755,21085,-4385, 2815,19494,-4139,
  4265,12481,-3515, 3973,13368,-3596, 5304,10595,-3318,
  4664,11477,-3407, 5441,10207,-3361, 5350,10338,-3375,
  5139,10672,-3428, 5058,10742,-3431, 4831,11101,-3457,
  4742,11228,-3470, 4516,11559,-3504, 4423,11693,-3518,
  4277,12079,-3558, 4232,12180,-3571, 4138,12522,-3597,
  4094,12603,-3609, 3979,12935,-3675, 3943,13043,-3671,
  3852,13383,-3699, 3813,13496,-3705, 3692,13947,-3767,
  3653,14073,-3790, 3506,14587,-3772, 3467,14685,-3777,
  3349,15192,-3888, 3308,15317,-3887, 3162,15800,-3957,
  3119,15954,-3961, 3009,16528,-3946, 3002,16637,-3937,
  2914,17260,-4014, 2909,17347,-4006, 2834,17893,-4049,
  2813,18060,-4060, 2760,18849,-4232, 2746,18968,-4242, 850,22569,-6438,
  855,21313,-6156, 860,19804,-5949, 834,17371,-6127, 824,15765,-6176,
  869,14070,-6360, 906,12901,-6751, 968,11720,-7368, 948,10645,-7895,
  865,9731,-8211, 1006,11164,-7630, 875,13487,-6447, 926,9310,-8354,
  837,16490,-6061, 857,20684,-6015, 867,23379,-6515, 907,10157,-8062,
  937,12331,-7053, 847,14917,-6268, 842,18236,-6111, 852,21941,-6297,
  885,9891,-8156, 985,10905,-7724, 947,11969,-7255, 885,13125,-6649,
  858,14493,-6314, 839,16049,-6111, 836,17735,-6083, 859,20244,-5982,
  891,21559,-6157, 848,22883,-6508, 851,22255,-6367, 856,20999,-6085,
  867,19042,-6000, 836,16930,-6094, 835,15341,-6222, 880,13646,-6405,
  916,12540,-6953, 981,11337,-7564, 927,10370,-7988, 932,9518,-8285,
  931,9583,-8174, 863,9671,-8145, 892,9982,-8037, 903,10075,-7996,
  952,10454,-7865, 961,10550,-7832, 1008,10963,-7617, 1018,11105,-7567,
  996,11458,-7405, 992,11582,-7342, 972,12080,-7057, 968,12210,-6984,
  935,12620,-6792, 931,12759,-6714, 914,13199,-6441, 910,13346,-6359,
  915,13767,-6194, 910,13941,-6175, 890,14633,-6107, 886,14783,-6091,
  864,15476,-6035, 859,15645,-6017, 870,16062,-5957, 873,16231,-5936,
  853,17048,-5965, 861,17185,-5974, 879,17812,-5997, 885,17961,-5997,
  851,18486,-6138, 865,18526,-5933, 872,18761,-5875, 870,19337,-5971,
  864,19470,-5784, 937,19590,-5786, 833,19023,-6126, 851,20344,-5894,
  851,20576,-5912, 855,21086,-5973, 854,21224,-6003, 871,21651,-6070,
  852,21853,-6116, 850,22332,-6224, 849,22490,-6259, 831,22924,-6338,
  834,23240,-6364, 2743,19661,-4287, 2740,19863,-4312, 2723,20501,-4469,
  2705,20711,-4503, 2661,21262,-4565, 2658,21427,-4593,
  2687,22088,-4631, 2695,22209,-4643, 2774,23170,-4392,
  2633,23103,-4527, 2681,22439,-4516, 2656,22665,-4573,
  2552,22727,-4653, 2534,23015,-4628, 2607,23397,-4556,
  2759,23681,-4398, 2740,24136,-4370, 2610,24100,-4580,
  2412,24481,-5089, 2671,24389,-4569, 2397,24935,-5652,
  2562,25022,-5528, 939,23708,-6566, 1009,24359,-6776, 1095,24912,-6886,
  1049,24117,-6493, 990,23894,-6415, 2290,23837,-4814, 2312,23612,-4723,
  2183,24804,-5574, 2191,24632,-5391, 1156,24771,-6650,
  1154,24624,-6586, 1104,24526,-6656, 0,9161,-8562, 1281,9161,-8432,
  2524,9161,-8046, 3691,9161,-7572, 4745,9161,-6945, 5662,9127,-6096,
  3697,9192,-7581, 2531,9192,-8056, 4753,9183,-6951, 5664,9161,-6101,
  5664,9185,-6101, 4753,9207,-6951, 2531,9216,-8055, 3697,9216,-7581,
  3684,9232,-7560, 2518,9232,-8034, 4740,9223,-6930, 5651,9200,-6080,
  2828,20259,1366, 2798,20256,1187, 2820,20237,692, 2843,20292,-25,
  2874,20473,735, 2975,20508,90, 2474,20772,-759, 2660,20879,-691,
  2471,21553,-1445, 2498,22175,-1940, 2471,24346,-2830,
  2556,22373,-1903, 2528,21595,-1351, 2493,24314,-2936,
  2576,22239,-2123, 2548,21461,-1571, 2823,20635,1307, 2741,20503,1328,
  1490,23972,5392, 1489,24080,4226, 1489,24040,3095, 1489,23188,2159,
  1489,21953,1816, 2479,22156,182, 1515,23830,2117, 1605,24415,3131,
  1599,24460,4263, 1580,24357,5431, 1448,23885,6743, 1252,24770,5442,
  1271,24873,4274, 1277,24828,3142, 1389,24618,2016, 1479,24733,1993,
  1301,25010,3165, 1295,25055,4297, 1391,24890,5460, 1512,25216,5507,
  1602,25353,4317, 1608,25308,3186, 1979,23458,-29, 1320,25312,1928,
  1495,25055,546, 2438,25790,-488, 1605,25585,5599, 1583,26793,6150,
  1850,26272,4298, 1578,27435,7117, 1658,27625,6884, 1671,27398,6846,
  1678,27176,6937, 1715,27784,6626, 1744,27323,6551, 1753,26904,6776,
  1884,28809,-1688, 1555,28655,1620, 1658,28252,4204, 1581,28263,5997,
  1567,28312,6790, 1935,27827,4220, 1818,28249,1603, 1570,27742,6195,
  1532,27288,6120, 2038,27074,4245, 1418,28416,228, 413,30264,-4539,
  424,31094,-4152, 418,31478,-3497, 410,31453,-2653, 410,31190,-1863,
  410,30468,-1467, 410,29550,-1270, 411,31041,-1902, 448,31253,-2696,
  449,31323,-3466, 425,31182,-3496, 411,31060,-2738, 387,30899,-1932,
  316,30806,-1957, 335,30952,-2766, 353,31089,-3521, 322,31007,-3540,
  303,30871,-2786, 284,30725,-1976, 304,30630,-1993, 323,30776,-2802,
  342,30912,-3557, 396,30843,-3565, 378,30707,-2811, 358,30561,-2001,
  414,30477,-2013, 433,30623,-2822, 452,30759,-3576, 474,30560,-3616,
  456,30424,-2861, 436,30278,-2052, 349,30194,-2077, 368,30340,-2886,
  386,30477,-3641, 309,30389,-3665, 291,30253,-2911, 271,30107,-2102,
  267,29996,-2124, 286,30142,-2933, 305,30278,-3688, 376,30179,-3700,
  357,30043,-2945, 338,29897,-2136, 420,29789,-2150, 439,29935,-2959,
  458,30071,-3713, 500,29883,-3751, 463,29601,-2187, 470,30974,-4049,
  462,30153,-4391, 466,30563,-4220, 410,30009,-1368, 725,29372,-3225,
  677,29335,-5130, 908,29205,-3300, 632,29533,-4803, 2587,28768,-3408,
  2730,28611,-3456, 2404,28568,-6916, 2413,28849,-6612,
  1904,26715,1801, 1394,25919,831, 2224,27270,-3994, 2730,28438,-3011,
  2587,28570,-2864, 2826,28152,-3163, 2476,28668,-6523,
  2476,28433,-6776, 2787,28338,-3507, 2216,27658,-3972,
  2207,27950,-5907, 2311,28216,-6128, 2320,27876,-3971,
  2311,28118,-6301, 2311,27845,-6252, 2320,27703,-3749,
  2320,27084,-3798, 2320,26986,-4070, 2698,26705,-4014,
  2557,26974,-3547, 2557,27739,-3485, 2572,27738,-6362,
  2436,28204,-6533, 2436,28421,-6303, 2556,28092,-3822,
  2431,28142,-6975, 2544,27863,-6726, 2266,28229,-1686,
  1939,28156,-1065, 2569,27943,-2270, 2381,27545,-1682,
  2799,27594,-3104, 2750,27866,-2738, 2539,27578,-6309,
  2720,26853,-3133, 2788,26461,-3776, 1061,27543,-7078, 1780,27941,135,
  1859,27747,-527, 1756,27784,691, 1855,27001,736, 1950,26711,19,
  1964,27006,-630, 2342,26955,-1898, 2595,25515,-3113, 2147,27855,132,
  2126,27722,601, 2213,27691,-428, 2210,27061,639, 2290,26816,34,
  2302,27065,-515, 2347,27680,100, 2335,27602,376, 2386,27584,-229,
  2385,27213,398, 2432,27069,42, 2439,27215,-281, 2481,27452,103,
  1786,24263,399, 2278,24851,-562, 2372,25143,-1163, -2567,23141,-2607,
  -2513,23156,-2494, 2513,23156,-2494, 2567,23141,-2607,

  TRIANGLES, 657,656,159, 100,506,99, 1003,900,995, 1048,1009,901,
  1051,901,1009, 1070,1073,1071, 1070,803,808, 1071,1077,1070,
  1072,1006,1073, 1072,808,915, 1073,808,1072, 1077,1071,1076,
  1078,1283,1127, 1081,1078,1079, 1081,1079,1080, 1083,1082,1086,
  1083,747,1274, 1084,888,1085, 1085,878,1086, 1085,1086,1095,
  1086,747,1083, 1093,1095,1086, 1094,1095,1093, 658,657,149,
  1101,637,32, 1103,638,1108, 1105,637,1101, 1106,637,1105,
  1108,638,1111, 111,36,158, 111,653,665, 111,665,36, 1110,858,1112,
  1111,988,1110, 1111,638,891, 1111,891,988, 1112,858,1113,
  1113,637,1106, 1117,779,784, 112,214,207, 112,651,210, 1124,1297,1154,
  1125,1123,1128, 1125,1302,1154, 1127,1077,1078, 1129,791,796,
  1130,1118,1137, 1136,1130,1137, 1137,1118,1119, 1137,1119,1121,
  1137,1121,1126, 1142,758,759, 1142,759,760, 1142,760,761,
  1147,1146,1154, 1150,755,756, 1150,756,757, 1154,1302,1124,
  1155,1147,1154, 1155,1297,1156, 1155,1154,1297, 1156,1240,1155,
  1156,1298,1157, 1157,1240,1156, 1157,1299,1273, 1157,1282,1281,
  1158,1151,1152, 1161,768,1164, 1162,773,1161, 1162,1161,1163,
  1163,1161,1164, 1165,1172,762, 1168,726,1178, 1168,1267,1266,
  1169,1178,725, 1171,1172,1165, 1171,720,1172, 1171,1165,1175,
  1178,1169,1174, 1178,1174,1278, 1179,1229,1228, 118,660,168,
  1180,1229,1179, 1185,726,1226, 1186,1183,1184, 1186,1184,1191,
  119,660,118, 1191,1184,1192, 1192,1184,1197, 1197,1184,1198,
  1198,1184,1203, 1203,1184,1204, 121,116,451, 1210,1209,1230,
  1215,1210,1230, 1216,1215,1230, 1221,1216,1230, 1222,1185,1226,
  1222,1221,1230, 1223,1222,1226, 1224,1223,1225, 1225,1223,1226,
  1226,726,1231, 1227,1188,1189, 1227,1189,1194, 1227,1194,1195,
  1227,1195,1200, 1227,1200,1201, 1227,1201,1206, 1228,1224,1225,
  1228,1225,1234, 1229,1207,1212, 1229,1212,1213, 1229,1213,1218,
  1229,1218,1219, 1229,1219,1224, 1229,1180,1227, 1229,1224,1228,
  1230,729,1185, 1230,1185,1222, 1231,1225,1226, 1232,1179,1234,
  1233,744,1232, 1234,1179,1228, 1234,1225,1231, 1235,744,1233,
  1237,744,1238, 1239,1155,1240, 1240,1157,1239, 1243,1168,1266,
  1248,1241,1249, 1250,1249,1252, 1252,1249,1253, 1254,1248,1251,
  1256,1241,1255, 1259,1244,1270, 1264,745,1237, 1265,1260,1272,
  1267,1168,1178, 1267,1178,1277, 1269,1282,1270, 1270,1282,1273,
  1271,1268,1269, 1271,1269,1270, 1273,1283,1274, 1274,1078,1081,
  1274,1081,1083, 1274,747,1275, 1275,745,1264, 1275,1264,1265,
  1275,1265,1272, 1275,1272,1274, 1276,1178,1278, 1277,1178,1276,
  1280,1157,1281, 1281,1269,1277, 1282,1157,1273, 1282,1269,1281,
  1283,1078,1274, 1292,1290,1296, 1295,1292,1296, 1296,1290,1291,
  1296,1291,1293, 1296,1293,1294, 1296,1294,1295, 1297,1298,1156,
  1297,1124,1298, 1298,1124,1299, 1299,1124,1273, 1299,1157,1298,
  660,659,168, 133,128,463, 137,182,141, 138,185,137, 139,184,138,
  140,183,139, 141,181,142, 141,182,144, 142,181,143, 143,649,142,
  143,197,195, 144,196,181, 144,199,194, 145,183,140, 145,201,183,
  145,140,405, 146,184,139, 146,139,183, 146,203,184, 147,185,138,
  147,138,184, 147,205,185, 148,198,182, 148,137,185, 149,657,159,
  150,149,159, 151,150,157, 152,151,157, 153,152,157, 157,150,158,
  157,38,160, 157,37,38, 158,150,159, 160,153,157, 160,39,163,
  160,38,39, 162,41,161, 163,39,40, 168,659,171, 172,155,156,
  176,153,154, 176,154,155, 177,658,149, 179,149,150, 179,150,151,
  180,152,153, 181,197,143, 181,141,144, 181,196,190, 182,199,144,
  182,137,148, 182,198,189, 183,200,146, 184,202,147, 185,204,148,
  186,204,185, 186,267,204, 186,185,205, 187,202,184, 187,265,202,
  187,184,203, 188,200,183, 188,263,200, 188,183,201, 189,275,199,
  189,261,255, 190,277,197, 190,259,254, 191,276,198, 191,148,204,
  192,205,147, 192,147,202, 192,268,205, 193,203,146, 193,146,200,
  193,266,203, 194,278,196, 194,262,249, 196,259,190, 196,144,194,
  196,278,248, 197,181,190, 197,260,195, 197,277,247, 198,261,189,
  198,148,191, 198,276,246, 199,182,189, 199,262,194, 199,275,245,
  200,274,193, 201,273,188, 202,272,192, 203,271,187, 204,270,191,
  205,269,186, 206,215,209, 206,216,90, 207,215,206, 207,214,208,
  208,231,215, 208,230,228, 209,233,216, 209,232,227, 210,229,214,
  210,651,226, 211,235,217, 211,234,225, 212,237,218, 212,236,224,
  212,386,236, 213,238,223, 213,421,88, 214,230,208, 214,112,210,
  214,229,222, 215,207,208, 215,232,209, 215,231,221, 216,206,209,
  216,234,211, 216,233,220, 217,90,211, 217,386,212, 218,89,212,
  218,238,213, 218,237,219, 219,342,238, 219,340,331, 220,346,234,
  220,336,329, 221,348,232, 221,334,328, 222,350,230, 222,332,327,
  223,341,326, 224,343,237, 224,339,325, 225,345,235, 225,337,324,
  226,351,229, 226,651,445, 227,347,233, 227,335,322, 228,349,231,
  228,333,321, 229,332,222, 229,210,226, 229,351,320, 230,214,222,
  230,333,228, 230,350,319, 231,334,221, 231,208,228, 231,349,318,
  232,215,221, 232,335,227, 232,348,317, 233,336,220, 233,209,227,
  233,347,316, 234,216,220, 234,337,225, 234,346,315, 235,211,225,
  235,345,314, 236,339,224, 236,383,313, 236,344,383, 237,340,219,
  237,212,224, 237,343,312, 238,218,219, 238,341,223, 238,342,311,
  239,269,205, 239,205,268, 240,270,204, 240,204,267, 241,271,203,
  241,203,266, 242,272,202, 242,202,265, 243,273,201, 243,201,264,
  244,274,200, 244,200,263, 250,145,407, 251,266,193, 251,193,274,
  252,268,192, 252,192,272, 253,191,270, 256,263,188, 256,188,273,
  257,265,187, 257,187,271, 258,267,186, 258,186,269, 259,196,248,
  22,650,435, 260,197,247, 261,198,246, 262,199,245, 21,650,22,
  275,189,255, 276,191,253, 277,190,254, 278,194,249, 323,226,445,
  330,217,235, 330,235,338, 332,229,320, 333,230,319, 334,231,318,
  335,232,317, 336,233,316, 337,234,315, 338,235,314, 339,236,313,
  664,653,661, 340,237,312, 341,238,311, 342,219,331, 343,224,325,
  344,236,386, 345,225,324, 346,220,329, 347,227,322, 348,221,328,
  349,228,321, 665,653,664, 350,222,327, 351,226,323, 380,217,330,
  405,408,145, 405,412,406, 406,408,405, 407,145,408, 408,341,407,
  411,406,412, 413,412,461, 414,413,416, 415,414,416, 416,413,608,
  418,87,421, 418,416,608, 419,223,326, 420,213,223, 420,223,419,
  421,417,418, 421,213,420, 421,430,428, 421,87,88, 428,430,429,
  430,421,420, 435,650,439, 439,650,440, 440,650,447, 442,651,437,
  444,195,323, 444,323,445, 445,651,442, 446,195,444, 447,650,195,
  447,195,446, 453,452,471, 455,453,471, 460,455,471, 461,617,413,
  462,457,459, 465,43,44, 471,452,464, 471,464,470, 486,485,492,
  488,458,1301, 488,631,458, 488,1301,459, 488,480,481, 488,481,489,
  489,574,490, 490,631,489, 490,574,491, 490,632,631, 491,632,490,
  495,105,106, 495,106,107, 495,107,108, 495,108,109, 495,109,110,
  495,110,496, 497,495,496, 498,105,495, 498,495,497, 499,506,505,
  505,68,71, 506,68,505, 506,67,68, 508,503,512, 509,499,505,
  512,74,502, 512,502,601, 513,563,514, 518,517,520, 518,564,76,
  519,75,564, 519,74,75, 523,522,561, 525,518,520, 526,518,525,
  528,523,561, 529,528,561, 531,518,526, 532,518,531, 534,529,561,
  535,534,561, 537,518,532, 538,518,537, 540,535,561, 546,541,563,
  547,546,563, 552,547,563, 553,552,563, 556,519,564, 558,553,563,
  559,557,558, 559,558,562, 560,74,519, 560,519,556, 560,556,557,
  560,557,559, 560,559,565, 561,514,563, 562,563,513, 562,558,563,
  562,513,568, 564,543,544, 564,544,549, 564,549,550, 564,550,555,
  564,555,556, 565,74,560, 565,559,568, 566,84,567, 567,84,569,
  568,559,562, 568,513,566, 571,85,598, 571,84,85, 572,84,571,
  573,491,574, 574,489,573, 583,575,582, 585,582,588, 586,583,584,
  587,583,586, 589,575,590, 598,85,609, 599,598,609, 653,111,654,
  600,601,502, 600,502,577, 603,602,605, 604,578,593, 604,616,603,
  604,603,605, 606,594,599, 606,599,609, 607,633,491, 607,616,604,
  607,491,616, 607,458,633, 608,87,418, 608,617,607, 608,606,609,
  608,413,617, 609,87,608, 609,86,87, 610,512,611, 611,512,601,
  611,603,615, 612,508,512, 612,512,610, 615,616,491, 615,491,614,
  615,603,616, 625,624,630, 627,625,630, 628,627,630, 629,628,630,
  630,624,626, 630,626,629, 631,488,489, 632,458,631, 632,491,633,
  633,458,632, 639,651,112, 641,774,640, 32,637,33, 667,640,668,
  668,640,669, 669,640,774, 67,506,100, 672,669,774, 676,673,820,
  677,676,823, 680,677,826, 688,685,1131, 712,711,754, 720,719,1172,
  721,720,1171, 725,1178,726, 729,726,1185, 729,1230,730, 73,512,503,
  730,1230,1184, 74,512,73, 743,82,83, 745,744,1237, 745,743,744,
  745,1275,746, 746,85,743, 746,743,745, 746,609,85, 746,1275,86,
  747,86,1275, 748,747,1086, 748,883,751, 748,1086,878, 751,882,752,
  752,881,870, 76,564,75, 762,1172,763, 763,1172,719, 769,768,1161,
  770,769,1161, 771,770,1161, 772,771,1161, 773,772,1161, 774,641,642,
  775,638,639, 781,647,782, 655,654,111, 800,848,801, 801,847,802,
  801,848,810, 802,846,803, 802,847,809, 803,846,808, 804,845,800,
  805,844,804, 805,636,806, 806,844,805, 806,860,844, 807,845,804,
  807,804,844, 807,862,845, 808,1073,1070, 809,863,846, 809,866,856,
  810,865,847, 810,868,855, 811,800,845, 811,867,848, 812,644,645,
  812,645,840, 813,812,842, 814,813,842, 816,815,843, 817,816,839,
  818,817,839, 819,818,835, 820,813,814, 820,814,815, 820,815,816,
  820,816,823, 821,672,774, 821,813,820, 822,642,643, 822,643,644,
  822,644,812, 822,812,813, 822,813,821, 823,676,820, 824,681,825,
  826,677,823, 83,742,743, 831,646,647, 831,647,781, 834,646,831,
  844,859,807, 845,861,811, 846,864,808, 846,802,809, 846,863,851,
  847,866,809, 847,801,810, 847,865,850, 848,868,810, 848,800,811,
  848,867,849, 849,934,868, 849,932,923, 85,84,743, 850,936,866,
  850,930,922, 851,938,864, 851,928,921, 852,861,845, 852,926,861,
  852,845,862, 853,859,844, 853,924,859, 853,844,860, 854,811,861,
  854,935,867, 855,937,865, 855,933,917, 856,939,863, 856,931,916,
  857,862,807, 857,807,859, 857,927,862, 858,637,1113, 858,860,806,
  858,925,860, 859,943,857, 86,609,746, 860,942,853, 861,941,854,
  862,940,852, 863,928,851, 863,809,856, 863,939,909, 864,846,851,
  864,938,908, 865,930,850, 865,810,855, 865,937,907, 866,847,850,
  866,931,856, 866,936,906, 867,932,849, 867,811,854, 867,935,905,
  868,848,849, 868,933,855, 868,934,904, 870,880,871, 871,879,775,
  873,879,871, 873,895,879, 873,871,880, 874,880,870, 874,897,880,
  874,870,881, 875,638,775, 875,775,879, 876,881,752, 876,899,881,
  876,752,882, 877,882,751, 877,1051,882, 877,751,883, 878,883,748,
  878,903,883, 879,894,875, 88,218,213, 880,896,873, 881,898,874,
  882,900,876, 883,902,877, 884,902,883, 884,1005,902, 884,883,903,
  885,898,881, 885,1001,898, 885,881,899, 886,896,880, 886,999,896,
  886,880,897, 887,894,879, 887,997,894, 887,879,895, 888,878,1085,
  888,903,878, 888,1006,903, 889,901,877, 889,1004,901, 889,877,902,
  89,217,212, 89,218,88, 890,899,876, 890,1002,899, 890,876,900,
  891,638,875, 891,875,894, 892,897,874, 892,1000,897, 892,874,898,
  893,895,873, 893,998,895, 893,873,896, 894,1016,891, 895,1015,887,
  896,1014,893, 897,1013,886, 898,1012,892, 899,1011,885, 656,655,159,
  90,216,211, 90,217,89, 900,1010,890, 900,882,995, 901,1051,877,
  902,1008,889, 903,1007,884, 91,57,58, 910,940,862, 910,862,927,
  911,941,861, 911,861,926, 912,942,860, 912,860,925, 913,943,859,
  913,859,924, 914,927,857, 914,857,943, 918,854,941, 919,924,853,
  919,853,942, 920,926,852, 920,852,940, 928,863,909, 929,864,908,
  93,92,484, 930,865,907, 931,866,906, 932,867,905, 933,868,904,
  934,849,923, 935,854,918, 936,850,922, 937,855,917, 938,851,921,
  939,856,916, 94,93,484, 96,95,476, 97,96,476, 976,903,1006,
  976,1007,903, 977,902,1005, 977,1008,902, 978,901,1004, 978,1048,901,
  979,900,1003, 979,1010,900, 98,97,476, 980,899,1002, 980,1011,899,
  981,898,1001, 981,1012,898, 982,897,1000, 982,1013,897, 983,1014,896,
  983,896,999, 984,1015,895, 984,895,998, 985,1016,894, 985,894,997,
  986,893,1014, 986,998,893, 987,892,1012, 987,1000,892, 988,891,1016,
  988,858,1110, 989,890,1010, 989,1002,890, 99,506,499, 990,889,1008,
  990,1004,889, 991,888,1084, 991,1006,888, 992,887,1015, 992,997,887,
  993,886,1013, 993,999,886, 994,885,1011, 994,1001,885, 995,882,1045,
  996,884,1007, 996,1005,884,

  QUADS, 648,666,130,131, 648,649,20,19, 657,658,15,14,
  1000,987,1032,1031, 1001,994,1036,1035, 1002,989,1040,1039,
  1003,995,1044,1043, 1004,990,1053,1052, 1005,996,1057,1056,
  1006,991,1061,1060, 1007,976,1059,1058, 1008,977,1055,1054,
  1009,906,973,1047, 101,64,67,100, 1010,979,1042,1041,
  1011,980,1038,1037, 1012,981,1034,1033, 1013,982,1030,1029,
  1014,983,1026,1025, 1015,984,1022,1021, 1016,985,1018,1017,
  102,63,64,101, 103,60,63,102, 104,59,60,103, 1045,882,1051,1009,
  1045,1009,1047,1046, 1048,978,1050,1049, 105,104,103,106,
  106,103,102,107, 1061,991,1071,1075, 1062,939,1004,1052,
  1062,1052,1053,1063, 1063,909,939,1062, 1064,928,1008,1054,
  1064,1054,1055,1065, 1065,921,928,1064, 1066,938,1005,1056,
  1066,1056,1057,1067, 1067,908,938,1066, 1068,929,1007,1058,
  1068,1058,1059,1069, 1069,915,929,1068, 107,102,101,108,
  1071,991,1084,1076, 1072,915,976,1006, 1073,1006,1060,1074,
  1074,1060,1061,1075, 1075,1071,1073,1074, 1078,1077,1076,1079,
  108,101,100,109, 1080,1079,1085,1095, 1081,1080,1082,1083,
  1082,1080,1092,1091, 1084,1085,1087,1088, 1085,1079,1089,1087,
  1086,1082,1091,1093, 1088,1087,1089,1090, 1089,1079,1076,1090,
  109,100,99,110, 1090,1076,1084,1088, 1092,1080,1095,1094,
  1093,1091,1092,1094, 1096,27,26,431, 1097,638,1103,1098,
  658,659,16,15, 110,99,499,496, 1100,1099,1102,1104,
  1101,1100,1104,1105, 1102,1099,1098,1103, 1106,1105,1104,1107,
  1107,1104,1102,1109, 1109,1102,1103,1108, 1110,1109,1108,1111,
  1112,1107,1109,1110, 1113,1106,1107,1112, 1115,819,828,1116,
  1117,784,791,1120, 1118,1116,1117,1119, 1119,1117,1120,1121,
  1120,791,1129,1122, 1121,1120,1122,1126, 1122,1123,1125,1126,
  1126,1125,1154,1137, 1127,1124,1302,1303, 1128,1123,1122,1129,
  1128,803,1070,1303, 1129,796,803,1128, 113,114,123,124,
  1130,1115,1116,1118, 1131,1114,1115,1130, 1132,1133,1140,1141,
  1133,1134,1139,1140, 1134,1135,1138,1139, 1136,688,1131,1130,
  1138,1135,1136,1137, 1138,1137,1154,1146, 1139,1138,1146,1145,
  114,115,122,123, 1140,1139,1145,1144, 1141,1140,1144,1143,
  1142,761,1132,1141, 1143,758,1142,1141, 1143,1144,1149,1150,
  1144,1145,1148,1149, 1145,1146,1147,1148, 1148,1147,1155,1153,
  1149,1148,1153,1152, 115,116,121,122, 115,114,166,167,
  1150,757,758,1143, 1150,1149,1152,1151, 1151,754,755,1150,
  1158,712,754,1151, 1158,1152,1160,1159, 1160,1152,1153,1155,
  1160,1155,1239,1177, 1165,762,773,1162, 1165,1162,1163,1166,
  1166,1163,1164,1167, 1167,1159,1176,1166, 1169,1170,1173,1174,
  1173,1170,1171,1175, 1174,1173,1177,1239, 1175,1165,1166,1176,
  1176,1159,1160,1177, 1177,1173,1175,1176, 1182,1183,1186,1187,
  1187,1186,1191,1190, 1188,1181,1182,1187, 1189,1188,1187,1190,
  119,118,117,120, 1190,1191,1192,1193, 1193,1192,1197,1196,
  1194,1189,1190,1193, 1195,1194,1193,1196, 1196,1197,1198,1199,
  1199,1198,1203,1202, 659,660,17,16, 659,658,177,171, 120,117,113,124,
  1200,1195,1196,1199, 1201,1200,1199,1202, 1202,1203,1204,1205,
  1204,1184,1230,1209, 1205,1204,1209,1208, 1206,1201,1202,1205,
  1207,1206,1205,1208, 1208,1209,1210,1211, 1211,1210,1215,1214,
  1212,1207,1208,1211, 1213,1212,1211,1214, 1214,1215,1216,1217,
  1217,1216,1221,1220, 1218,1213,1214,1217, 1219,1218,1217,1220,
  122,121,128,127, 1220,1221,1222,1223, 1224,1219,1220,1223,
  1227,1180,1181,1188, 1227,1206,1207,1229, 123,122,127,126,
  1231,726,1168,1233, 1233,1168,1243,1235, 1234,1231,1233,1232,
  1236,1235,1243,1242, 1236,1242,1244,1247, 1237,1238,1245,1246,
  1238,744,1235,1236, 1239,1157,1280,1279, 124,123,126,125,
  1244,1242,1271,1270, 1245,1238,1236,1247, 1246,1245,1262,1261,
  1247,1244,1259,1263, 1249,1241,1256,1253, 125,126,135,136,
  1251,1248,1249,1250, 1251,1250,1262,1263, 1254,1251,1263,1259,
  1255,1241,1248,1254, 1257,1256,1255,1258, 1258,1255,1254,1259,
  126,127,134,135, 1260,1253,1256,1257, 1261,1252,1253,1260,
  1262,1250,1252,1261, 1262,1245,1247,1263, 1264,1237,1246,1265,
  1265,1246,1261,1260, 1268,1243,1266,1269, 1269,1266,1267,1277,
  127,128,133,134, 1271,1242,1243,1268, 1272,1260,1257,1274,
  1273,1258,1259,1270, 1273,1124,1127,1283, 1274,1257,1258,1273,
  1278,1174,1239,1279, 128,121,451,454, 1284,1276,1278,1285,
  1285,1278,1279,1287, 1286,1277,1276,1284, 1287,1279,1280,1288,
  1288,1280,1281,1289, 1289,1281,1277,1286, 129,120,124,125,
  1290,1284,1285,1291, 1291,1285,1287,1293, 1292,1286,1284,1290,
  1293,1287,1288,1294, 1294,1288,1289,1295, 1295,1289,1286,1292,
  660,666,18,17, 130,666,660,119, 130,119,120,129, 1301,458,461,1300,
  1301,1300,462,459, 1303,1070,1077,1127, 1303,1302,1125,1128,
  131,130,129,132, 132,129,125,136, 134,133,140,139, 135,134,139,138,
  136,135,138,137, 140,133,463,462, 141,132,136,137, 142,131,132,141,
  154,153,160,163, 158,36,37,157, 159,655,111,158, 161,156,155,162,
  161,41,42,448, 162,155,154,163, 163,40,41,162, 164,113,117,169,
  164,169,170,174, 165,116,115,167, 165,156,449,450, 166,114,113,164,
  167,166,173,172, 169,117,118,168, 170,169,168,171, 172,156,165,167,
  173,166,164,174, 174,170,178,175, 175,178,179,180, 176,155,172,173,
  176,173,174,175, 177,149,179,178, 178,170,171,177, 179,151,152,180,
  180,153,176,175, 649,648,131,142, 649,650,21,20, 201,145,250,264,
  206,90,753,869, 207,206,869,872, 263,256,400,399, 264,250,404,403,
  265,257,306,305, 266,251,310,309, 267,258,298,297, 268,252,302,301,
  269,239,300,299, 270,240,296,295, 271,241,308,307, 272,242,304,303,
  273,243,402,401, 274,244,398,397, 279,260,247,280, 280,247,320,353,
  281,277,254,282, 282,254,327,355, 283,259,248,284, 284,248,319,357,
  285,278,249,286, 286,249,321,359, 287,262,245,288, 288,245,318,361,
  289,275,255,290, 19,18,666,648, 290,255,328,363, 291,261,246,292,
  292,246,317,365, 293,276,253,294, 294,253,322,367, 296,240,316,369,
  298,258,329,371, 650,649,143,195, 300,239,315,373, 302,252,324,375,
  304,242,314,377, 306,257,330,379, 308,241,344,382, 661,653,652,662,
  310,251,313,385, 311,250,407,341, 312,256,273,340, 313,251,274,339,
  314,242,265,338, 315,239,268,337, 316,240,267,336, 317,246,276,335,
  318,245,275,334, 319,248,278,333, 662,667,668,663, 320,247,277,332,
  321,249,262,349, 322,253,270,347, 323,195,260,351, 324,252,272,345,
  325,244,263,343, 327,254,259,350, 328,255,261,348, 329,258,269,346,
  663,668,669,670, 330,257,271,380, 331,243,264,342, 332,277,281,354,
  333,278,285,358, 334,275,289,362, 335,276,293,366, 336,267,297,370,
  337,268,301,374, 338,265,305,378, 339,274,397,387, 664,661,662,663,
  340,273,401,391, 342,264,403,393, 343,263,399,389, 344,241,266,383,
  345,272,303,376, 346,269,299,372, 347,270,295,368, 348,261,291,364,
  349,262,287,360, 665,664,663,670, 350,259,283,356, 351,260,279,352,
  352,279,280,353, 353,320,351,352, 354,281,282,355, 355,327,332,354,
  356,283,284,357, 357,319,350,356, 358,285,286,359, 359,321,333,358,
  36,665,670,671, 360,287,288,361, 361,318,349,360, 362,289,290,363,
  363,328,334,362, 364,291,292,365, 365,317,348,364, 366,293,294,367,
  367,322,335,366, 368,295,296,369, 369,316,347,368, 37,36,671,674,
  370,297,298,371, 371,329,336,370, 372,299,300,373, 373,315,346,372,
  374,301,302,375, 375,324,337,374, 376,303,304,377, 377,314,345,376,
  378,305,306,379, 379,330,338,378, 38,37,674,675, 380,271,307,381,
  381,307,308,382, 382,344,380,381, 383,266,309,384, 384,309,310,385,
  385,313,383,384, 386,217,380,344, 388,325,339,387, 388,387,397,398,
  39,38,675,678, 390,312,343,389, 390,389,399,400, 392,331,340,391,
  392,391,401,402, 394,311,342,393, 394,393,403,404, 395,341,408,409,
  396,326,341,395, 396,395,409,410, 398,244,325,388, 40,39,678,679,
  400,256,312,390, 402,243,331,392, 404,250,311,394, 405,140,462,1300,
  406,326,396,410, 408,406,410,409, 41,40,679,682, 411,412,413,414,
  411,414,424,425, 412,405,1300,461, 417,415,416,418, 419,326,406,411,
  419,411,425,423, 42,41,682,683, 420,414,415,430, 422,420,419,423,
  424,414,420,422, 424,422,423,425, 426,417,421,428, 427,415,417,426,
  427,426,428,429, 43,42,683,686, 430,415,427,429, 431,651,639,1096,
  431,26,25,432, 432,25,24,433, 432,433,436,437, 433,24,23,434,
  434,23,22,435, 436,433,434,438, 436,438,441,443, 437,651,431,432,
  437,436,443,442, 438,434,435,439, 438,439,440,441, 44,43,686,687,
  441,440,447,446, 442,443,444,445, 443,441,446,444, 448,42,43,465,
  449,156,161,448, 449,448,465,464, 45,44,687,690, 450,449,464,452,
  451,116,165,450, 451,450,452,453, 454,451,453,455, 456,454,455,460,
  456,457,462,463, 459,457,456,460, 46,45,690,691, 461,458,607,617,
  463,128,454,456, 465,44,470,464, 466,98,476,475, 466,49,50,98,
  467,47,49,466, 468,46,47,467, 469,45,46,468, 47,46,691,694,
  470,44,45,469, 470,469,472,471, 472,469,468,473, 473,468,467,474,
  474,467,466,475, 476,95,477,475, 478,474,475,477, 479,473,474,478,
  48,695,696,697, 480,472,473,479, 481,480,479,482, 482,479,478,483,
  483,478,477,484, 486,483,484,485, 487,482,483,486, 487,486,494,489,
  488,459,460,471, 488,471,472,480, 489,481,482,487, 49,47,694,48,
  492,58,59,493, 493,59,104,501, 494,486,492,493, 494,493,510,511,
  497,496,499,500, 498,497,500,501, 652,640,667,662, 652,653,10,9,
  50,49,48,697, 500,499,509,510, 501,104,105,498, 502,74,565,567,
  504,72,73,503, 505,71,72,504, 505,504,507,509, 507,504,503,508,
  509,507,511,510, 51,50,697,698, 510,493,501,500, 511,507,508,573,
  513,81,82,566, 514,80,81,513, 515,79,80,514, 515,514,561,522,
  516,78,79,515, 516,515,522,521, 517,77,78,516, 518,76,77,517,
  52,51,698,701, 520,517,516,521, 521,522,523,524, 524,523,528,527,
  525,520,521,524, 526,525,524,527, 527,528,529,530, 53,52,701,702,
  530,529,534,533, 531,526,527,530, 532,531,530,533, 533,534,535,536,
  536,535,540,539, 537,532,533,536, 538,537,536,539, 539,540,541,542,
  54,53,702,705, 541,540,561,563, 542,541,546,545, 543,538,539,542,
  544,543,542,545, 545,546,547,548, 548,547,552,551, 549,544,545,548,
  55,54,705,706, 550,549,548,551, 551,552,553,554, 554,553,558,557,
  555,550,551,554, 556,555,554,557, 56,55,706,709, 564,518,538,543,
  566,82,743,84, 567,565,568,566, 569,84,572,570, 57,56,709,710,
  570,572,579,581, 573,489,494,511, 573,508,612,613, 577,502,567,569,
  577,569,570,576, 577,576,605,602, 578,576,570,581, 579,572,571,580,
  58,57,710,713, 580,571,598,599, 581,579,596,597, 582,575,589,588,
  583,582,585,584, 586,584,596,595, 587,586,595,594, 588,589,592,593,
  589,590,591,592, 59,58,713,714, 590,575,583,587, 590,587,594,591,
  591,594,606,608, 592,591,608,607, 593,578,581,597, 593,592,607,604,
  595,580,599,594, 596,579,580,595, 596,584,585,597, 597,585,588,593,
  653,654,11,10, 60,59,714,61, 600,577,602,603, 601,600,603,611,
  605,576,578,604, 61,716,717,62, 610,611,620,618, 611,615,623,620,
  612,610,618,619, 613,612,619,621, 614,491,573,613, 614,613,621,622,
  615,614,622,623, 618,620,626,624, 619,618,624,625, 62,717,718,65,
  620,623,629,626, 621,619,625,627, 622,621,627,628, 623,622,628,629,
  63,60,61,62, 639,638,1097,1096, 64,63,62,65, 647,634,793,782,
  1,647,646,2, 2,646,645,3, 65,718,719,66, 3,645,644,4, 4,644,643,5,
  5,643,642,6, 6,642,641,7, 7,641,640,8, 8,640,652,9, 28,27,1096,1097,
  29,28,1097,1098, 66,719,720,69, 30,29,1098,1099, 31,30,1099,1100,
  32,31,1100,1101, 33,637,636,34, 34,636,635,35, 35,635,634,0,
  0,634,647,1, 67,64,65,66, 670,669,672,671, 671,672,673,674,
  673,672,821,820, 674,673,676,675, 675,676,677,678, 678,677,680,679,
  679,680,681,682, 68,67,66,69, 681,680,826,825, 682,681,684,683,
  683,684,685,686, 684,681,824,1114, 685,684,1114,1131,
  686,685,688,687, 687,688,689,690, 689,688,1136,1135, 69,720,721,70,
  690,689,692,691, 691,692,693,694, 692,689,1135,1134,
  693,692,1134,1133, 694,693,695,48, 695,693,1133,1132,
  696,695,1132,761, 697,696,699,698, 698,699,700,701, 699,696,761,760,
  654,655,12,11, 70,721,722,723, 700,699,760,759, 701,700,703,702,
  702,703,704,705, 703,700,759,758, 704,703,758,757, 705,704,707,706,
  706,707,708,709, 707,704,757,756, 708,707,756,755, 709,708,711,710,
  71,68,69,70, 710,711,712,713, 711,708,755,754, 713,712,715,714,
  714,715,716,61, 715,712,1158,1159, 716,715,767,766, 717,716,766,765,
  718,717,765,764, 719,718,764,763, 72,71,70,723, 722,721,1171,1170,
  723,722,725,724, 724,725,726,727, 725,722,1170,1169, 727,726,729,728,
  728,729,730,731, 73,72,723,724, 731,730,733,732, 732,733,734,735,
  733,730,1184,1183, 734,733,1183,1182, 735,734,737,736,
  736,737,738,739, 737,734,1182,1181, 738,737,1181,1180,
  739,738,741,740, 74,73,724,727, 740,741,742,83, 741,738,1180,1179,
  742,741,1179,1232, 743,742,1232,744, 749,748,751,750, 75,74,727,728,
  750,751,752,753, 753,752,870,869, 76,75,728,731, 762,763,772,773,
  763,764,771,772, 764,765,770,771, 765,766,769,770, 766,767,768,769,
  767,715,1159,1167, 768,767,1167,1164, 77,76,731,732, 774,642,822,821,
  775,639,872,871, 776,780,783,787, 776,777,829,827, 778,779,828,830,
  78,77,732,735, 780,781,782,783, 780,776,827,832, 781,780,832,831,
  783,782,793,792, 784,779,778,785, 785,778,777,786, 786,777,776,787,
  787,783,792,788, 788,792,795,799, 789,786,787,788, 79,78,735,736,
  790,785,786,789, 791,784,785,790, 792,793,794,795, 793,634,635,794,
  794,635,636,805, 795,794,805,804, 796,791,790,797, 797,790,789,798,
  798,789,788,799, 799,795,804,800, 655,656,13,12, 80,79,736,739,
  801,798,799,800, 802,797,798,801, 803,796,797,802, 806,636,637,858,
  81,80,739,740, 815,814,842,843, 817,818,825,826, 818,819,824,825,
  82,81,740,83, 823,816,817,826, 824,819,1115,1114, 827,829,836,837,
  828,779,1117,1116, 828,819,835,830, 829,777,778,830, 831,832,833,834,
  833,832,827,837, 834,833,841,840, 835,818,839,836, 836,829,830,835,
  837,836,839,838, 839,816,843,838, 840,645,646,834, 841,833,837,838,
  842,812,840,841, 842,841,838,843, 86,747,748,749, 869,870,871,872,
  872,639,112,207, 88,87,86,749, 89,88,749,750, 656,657,14,13,
  90,89,750,753, 91,58,492,485, 910,927,952,953, 911,926,956,957,
  912,925,944,945, 913,924,948,949, 914,943,950,951, 915,808,864,929,
  918,941,958,959, 919,942,946,947, 92,91,485,484, 92,56,57,91,
  920,940,954,955, 924,919,992,1015, 925,858,988,1016, 926,920,993,1013,
  927,914,986,1014, 928,909,990,1008, 929,908,996,1007, 93,55,56,92,
  930,907,979,1003, 931,906,1009,1048, 932,905,981,1001,
  933,904,980,1002, 934,923,994,1011, 935,918,987,1012,
  936,922,995,1045, 937,917,989,1010, 938,921,977,1005,
  939,916,978,1004, 94,54,55,93, 940,910,983,999, 941,911,982,1000,
  942,912,985,997, 943,913,984,998, 944,925,1016,1017,
  945,944,1017,1018, 946,942,997,1019, 947,946,1019,1020,
  948,924,1015,1021, 949,948,1021,1022, 95,94,484,477, 95,53,54,94,
  950,943,998,1023, 951,950,1023,1024, 952,927,1014,1025,
  953,952,1025,1026, 954,940,999,1027, 955,954,1027,1028,
  956,926,1013,1029, 957,956,1029,1030, 958,941,1000,1031,
  959,958,1031,1032, 96,52,53,95, 960,935,1012,1033, 961,960,1033,1034,
  961,905,935,960, 962,932,1001,1035, 963,962,1035,1036,
  963,923,932,962, 964,934,1011,1037, 965,964,1037,1038,
  965,904,934,964, 966,933,1002,1039, 967,966,1039,1040,
  967,917,933,966, 968,937,1010,1041, 969,968,1041,1042,
  969,907,937,968, 97,51,52,96, 970,930,1003,1043, 971,970,1043,1044,
  971,922,930,970, 972,936,1045,1046, 973,972,1046,1047,
  973,906,936,972, 974,931,1048,1049, 975,974,1049,1050,
  975,916,931,974, 976,915,1069,1059, 977,921,1065,1055,
  978,916,975,1050, 979,907,969,1042, 98,50,51,97, 980,904,965,1038,
  981,905,961,1034, 982,911,957,1030, 983,910,953,1026,
  984,913,949,1022, 985,912,945,1018, 986,914,951,1024,
  987,918,959,1032, 989,917,967,1040, 990,909,1063,1053,
  992,919,947,1020, 993,920,955,1028, 994,923,963,1036,
  995,922,971,1044, 996,908,1067,1057, 997,992,1020,1019,
  998,986,1024,1023, 999,993,1028,1027,

  /* The base of the knight */
  SPIN,18,
  9510,0, 9510,756, SEAM, 9134,1129, 9447,1487,
  9447,1951, 9103,2371, STEPDOWN, 8211,3083,
  7167,4242, 6662,5664, 7040,7142, STEPUP, SEAM, 7935,8560,
  STEPUP, BACKREF,0,

  ENDOFDATA
};

static unsigned short bishop_data[] = {
  VERTICES, SETBACKREF,0, 5233,26960,0, 5154,26960,909, 4918,26960,1790,
  4532,26960,2617, 4009,26960,3364, 3364,26960,4009, 2617,26960,4532,
  1790,26960,4918, 909,26960,5154, 0,26833,5233, -909,26960,5154,
  -1790,26960,4918, -2617,26960,4532, -3364,26960,4009,
  -4009,26960,3364, -4532,26960,2617, -4918,26960,1790,
  -5154,26960,909, -5233,26960,0, -5154,26960,-909, -4918,26960,-1790,
  -4532,26960,-2617, -4009,26960,-3364, -3364,26960,-4009,
  -2617,26960,-4532, -1790,26960,-4918, -909,26960,-5154, 0,26833,-5233,
  909,26960,-5154, 1790,26960,-4918, 2617,26960,-4532, 3364,26960,-4009,
  4009,26960,-3364, 4532,26960,-2617, 4918,26960,-1790, 5154,26960,-909,
  SETBACKREF,1, 3812,31178,0, 3765,31144,729, 3624,31040,1435,
  3395,30872,2153, 3084,30642,2820, 2701,30360,3389, 2076,29899,4102,
  1492,30015,4340, 845,30033,4442, 0,30044,4511, -657,30063,4443,
  -1481,30081,4214, -2190,30081,3884, -2830,30081,3435,
  -3383,30081,2883, -3831,30081,2242, -4162,30081,1534,
  -4364,30081,779, -4432,30081,0, -4364,30081,-779, -4162,30081,-1534,
  -3831,30081,-2242, -3383,30081,-2883, -2830,30081,-3435,
  -2190,30081,-3884, -1481,30081,-4214, -657,30063,-4443, 0,30044,-4511,
  845,30033,-4442, 1492,30015,-4340, 2076,29899,-4102, 2701,30360,-3388,
  3084,30642,-2820, 3395,30872,-2153, 3624,31040,-1435, 3765,31144,-729,
  240,28546,-4957, 884,29021,-4784, 1490,29467,-4537, 2076,29899,-4102,
  2701,30360,-3388, 3084,30642,-2820, 3395,30872,-2153,
  3624,31040,-1435, 3765,31144,-729, 2177,28477,4637, 1021,27605,5037,
  1021,27605,-5042, 2170,28478,-4644, 0,26833,-5233, 0,26833,5233,
  -3153,28619,-3758, 240,28546,4957, 884,29021,4784, 2076,29899,4102,
  2701,30360,3389, 3084,30642,2820, 3395,30872,2153, 3624,31040,1435,
  3765,31144,729, -719,28582,4883, 4863,28569,977, 4560,28569,1925,
  4064,28569,2815, 3465,28569,3723, 2622,28569,4448, 2621,28583,-4401,
  3473,28588,-3691, 4064,28569,-2815, 4560,28569,-1925, 4863,28569,-977,
  4965,28569,0, -1678,28619,4610, -3153,28619,3758, -2453,28619,4248,
  -4248,28619,2453, -3758,28619,3153, -4831,28619,852, -4906,28619,0,
  -4831,28619,-852, -4610,28619,-1678, -4248,28619,-2453,
  -3758,28619,-3153, -1678,28619,-4610, -2453,28619,-4248,
  -644,27895,5037, -644,27895,-5037, -4610,28619,1678, -719,28582,-4883,
  2170,28478,-4644, 1021,27605,-5042, 1021,27605,5037, 2177,28477,4637,
  0,26833,-5233, 0,26833,5233, -644,27895,-5037, -644,27895,5037,
  -644,27895,5037, -644,27895,-5037, 1490,29467,-4537, 884,29021,-4784,
  240,28546,-4957, 240,28546,4957, 884,29021,4784, 3812,31178,0,
  4349,30116,-867, 4197,30001,-1705, 3948,29813,-2492, 3610,29558,-3203,
  3193,29244,-3817, 2711,28880,-4315, 4349,30116,-867, 4197,30001,-1705,
  3948,29813,-2492, 3610,29558,-3203, 3193,29244,-3817,
  2711,28880,-4315, 1608,28047,-4906, 1608,28047,4901, 2711,28880,4310,
  3193,29244,3812, 3610,29558,3198, 3948,29813,2487, 4197,30001,1701,
  4349,30116,862, 4401,30155,-176, 1490,29467,4537, 1490,29467,4537,
  4401,30155,-176, 4349,30116,862, 4197,30001,1701, 3948,29813,2487,
  3610,29558,3198, 3193,29244,3812, 2711,28880,4310, 1608,28047,4901,
  1608,28047,-4906,

  TRIANGLES, 8,127,9, 7,128,154, 2,98,3, 121,96,10, 121,10,9, 121,138,96,
  122,27,26, 27,126,28, 66,135,65, 162,42,43, 165,164,141, 80,140,95,
  103,151,150, 102,125,152, 101,155,128, 100,157,156, 124,137,122,
  33,105,34, 29,153,125, 26,124,122,

  QUADS, 22,118,87,23, 21,117,118,22, 20,116,117,21, 19,115,116,20,
  18,114,115,19, 17,113,114,18, 16,123,113,17, 15,111,123,16, 14,112,111,15,
  13,109,112,14, 12,110,109,13, 11,108,110,12, 7,154,127,8, 110,108,47,48,
  135,136,64,65, 136,137,63,64, 138,139,44,45, 139,162,43,44, 109,110,48,49,
  147,161,107,106, 166,165,141,142, 167,166,142,143, 168,167,143,144,
  169,168,144,145, 112,109,49,50, 170,169,145,146, 171,81,84,172,
  111,112,50,51, 72,88,133,134, 73,89,88,72, 74,163,89,73, 75,90,163,74,
  76,91,90,75, 77,92,91,76, 78,93,92,77, 79,94,93,78, 80,95,94,79,
  81,170,146,84, 82,171,172,83, 86,82,83,85, 130,129,131,132, 123,111,51,52,
  113,123,52,53, 114,113,53,54, 115,114,54,55, 116,115,55,56, 117,116,56,57,
  118,117,57,58, 87,118,58,59, 120,87,59,60, 119,120,60,61, 107,161,160,97,
  106,107,0,35, 105,148,147,106, 105,106,35,34, 104,149,148,105,
  104,105,33,32, 103,150,149,104, 103,104,32,31, 102,152,151,103,
  102,103,31,30, 101,128,7,6, 100,101,6,5, 100,156,155,101, 99,100,5,4,
  99,158,157,100, 98,99,4,3, 98,159,158,99, 97,98,2,1, 97,160,159,98,
  96,108,11,10, 96,138,45,46, 124,119,61,62, 47,108,96,46, 63,137,124,62,
  0,107,97,1, 29,125,102,30, 28,126,153,29, 25,119,124,26, 24,120,119,25,
  23,87,120,24,

  /* Everything above the slit */
  SPIN,18,
  8870,0,8870,731,SEAM,8519,1091,8811,1438,8811,1886,8626,2292,
  STEPDOWN,6989,2980,5927,4133,5548,5735,
  STEPUP,5388,7642,5228,7807,STEPDOWN,4427,8149,4057,8434,
  3493,9185,2816,13524,SEAM,2690,18532,5301,18690,
  STEPUP,6810,19005,6861,19277,6804,19625,STEPDOWN,6502,19845,
  SEAM,4305,20394,STEPUP,4796,20522,4924,20759,4778,20979,
  STEPDOWN,SEAM,3727,21207,SEAM,3726,22181,STEPUP,SEAM,4546,22705,
  SEAM,3846,23385,4718,24227,5226,25516,STEPUP,BACKREF,0,

  /* Everything below the slit */
  SPIN,36,
  BACKREF,1,STEPDOWN,3548,31590,STEPDOWN,2724,32633,SEAM,1581,33500,
  2013,33901,STEPUP,2281,34500,2281,34936,STEPDOWN,1947,35372,
  STEPDOWN,1233,35734,STEPDOWN,0,35891,

  ENDOFDATA
};

static unsigned short king_data[] = {
  SPIN,20,
  11378,0,11378,856,SEAM,10928,1152,
  11302,1684,11302,2209,11065,2684,
  STEPDOWN,8964,3490,7603,4841,7116,6717,
  STEPUP,6911,8950,6705,9144,STEPDOWN,5678,9545,5204,9878,
  4481,10758,3696,14808,SEAM,3065,26979,
  5813,27155,STEPUP,7145,27507,7424,27812,7352,28288,7131,28533,
  5477,28882,5397,29010,5406,29363,4903,29934,
  STEPDOWN,SEAM,3944,30227,
  SEAM,3974,31478,4703,31849,STEPUP,4832,32092,4756,32370,
  SEAM,3975,32620,6899,39055,6877,39351,2833,39514,
  2786,39612,2786,39807,2734,39856,STEPDOWN,STEPDOWN,2590,39905,0,39969,
  /* The cross */
  SETBACKREF,0,
  QUADSTRIP,-1613,39866,0,-1543,39866,702,-1651,40481,0,-1580,40590,702,
  -1531,40917,0,-1465,41008,702,
  QUADSTRIP,-1531,40917,0,-1465,41008,702,-2956,41104,0,-2829,41187,702,
  -3075,41520,0,-2943,41585,702,-3075,43849,0,-2943,43805,702,
  -2862,44347,0,-2739,44282,702,-1116,44636,0,-1068,44554,702,
  QUADSTRIP,-1116,44636,0,-1068,44554,702,-1102,45692,0,-1054,45576,702,
  -973,45829,0,-973,45747,702,973,45829,0,973,45747,702,1102,45692,0,
  1054,45576,702,1116,44636,0,1068,44554,702,
  QUADSTRIP,1116,44636,0,1068,44554,702,2862,44347,0,2739,44282,702,
  3075,43849,0,2943,43805,702,3075,41520,0,2943,41585,702,2956,41104,0,
  2829,41187,702,1531,40917,0,1465,41008,702,
  QUADSTRIP,1531,40917,0,1465,41008,702,1651,40481,0,1580,40590,702,
  1613,39866,0,1543,39866,702,
  QUADSTRIP,-1543,39866,702,1543,39866,702,-1580,40590,702,
  1580,40590,702,-1465,41008,702,1465,41008,702,-2829,41187,702,
  2829,41187,702,-2943,41585,702,2943,41585,702,-2943,43805,702,
  2943,43805,702,-2739,44282,702,2739,44282,702,-1068,44554,702,
  1068,44554,702,-1054,45576,702,1054,45576,702,-973,45747,702,
  973,45747,702,
  QUADSTRIP,-1543,39866,-702,BACKREF,0,0,-1580,40590,-702,BACKREF,0,2,
  -1465,41008,-702,BACKREF,0,4,
  QUADSTRIP,-1465,41008,-702,BACKREF,0,6,-2829,41187,-702,BACKREF,0,8,
  -2943,41585,-702,BACKREF,0,10,-2943,43805,-702,BACKREF,0,12,
  -2739,44282,-702,BACKREF,0,14,-1068,44554,-702,BACKREF,0,16,
  QUADSTRIP,-1068,44554,-702,BACKREF,0,18,-1054,45576,-702,
  BACKREF,0,20,-973,45747,-702,BACKREF,0,22,973,45747,-702,BACKREF,0,24,
  1054,45576,-702,BACKREF,0,26,1068,44554,-702,BACKREF,0,28,
  QUADSTRIP,1068,44554,-702,BACKREF,0,30,2739,44282,-702,
  BACKREF,0,32,2943,43805,-702,BACKREF,0,34,2943,41585,-702,BACKREF,0,36,
  2829,41187,-702,BACKREF,0,38,1465,41008,-702,BACKREF,0,40,
  QUADSTRIP,1465,41008,-702,BACKREF,0,42,1580,40590,-702,
  BACKREF,0,44,1543,39866,-702,BACKREF,0,46,
  QUADSTRIP,1543,39866,-702,-1543,39866,-702,1580,40590,-702,
  -1580,40590,-702,1465,41008,-702,-1465,41008,-702,2829,41187,-702,
  -2829,41187,-702,2943,41585,-702,-2943,41585,-702,2943,43805,-702,
  -2943,43805,-702,2739,44282,-702,-2739,44282,-702,1068,44554,-702,
  -1068,44554,-702,1054,45576,-702,-1054,45576,-702,973,45747,-702,
  -973,45747,-702,
  ENDOFDATA
};

static unsigned short queen_data[] = {
  SPIN,24,
  11092,0,11092,914,SEAM,10653,1284,
  11018,1798,11018,2358,10787,2866,
  STEPDOWN,8739,3726,7412,5168,6937,7171,
  STEPUP,6737,9556,6537,9762,STEPDOWN,5536,10191,5073,10546,
  4368,11485,3678,15137,SEAM,3259,26879,
  5966,27091,STEPUP,7332,27515,7619,27882,7545,28455,7317,28751,
  5654,29177,5538,29326,5542,29982,5377,30278,
  STEPDOWN,SEAM,4194,30585,
  SEAM,4226,31822,5002,32218,STEPUP,5139,32477,5058,32774,
  SEAM,4227,33040,STEPDOWN,4421,34778,5042,36612,5874,38429,
  STEPUP,SEAM,PATTERN,3,6018,39660,6018,39660,6804,39977,
  SEAM,PATTERN,3,5015,41139,5015,41139,5673,41460,
  SEAM,4349,40044,
  STEPDOWN,SEAM,1381,41188,
  1396,42332,STEPDOWN,1082,43072,481,43476,0,43543,
  ENDOFDATA
};

static unsigned short pawn_data[] = {
  SPIN,16,
  7395,0,7395,609,
  SEAM,7102,910,7345,1199,7345,1572,7191,1910,
  STEPDOWN,5826,2484,4941,3446,4625,4781,
  STEPUP,4492,6371,4358,6508,
  STEPDOWN,3691,6794,2912,7657,2473,10091,
  SEAM,2100,15344,
  STEPUP,4518,15697,4695,15900,4649,16218,4509,16382,
  STEPDOWN,SEAM,3150,16755,STEPUP,3858,17678,4303,18752,4455,19905,
  4303,21058,3858,22132,
  STEPDOWN,3150,23055,2227,23763,STEPDOWN,1153,24208,0,24360,
  ENDOFDATA
};

static unsigned short rook_data[] = {
  SPIN,20,
  9374,0,9374,756,SEAM,9003,1062,9311,1487,
  9311,1951,9116,2371,8521,3083,6701,5807,SEAM,6009,7595,
  6167,7812,6138,8066,5926,8460,5216,12608,
  SEAM,4883,21434,
  SEAM,5140,21608,
  SEAM,5176,22792,
  SEAM,5953,23030,
/* SEAM,PATTERN,5,6103,26819,6143,27971,6143,27971,6143,27971,6103,26819, */
/* SEAM,PATTERN,5, 5020,26819,5053,27971,5053,27971,5053,27971, 5020,26819, */
  SETBACKREF,0,
  6103,26819,

  SETBACKREF,1,
  SPIN,20,
  5020,26819,5020,26114,4906,25858,0,25666,

  POLARQUADSTRIP,20,BACKREF,0,1,1,6143,27971,BACKREF,0,2,2,6143,27971,
  BACKREF,0,3,3,6143,27971,BACKREF,0,4,4,6143,27971,
  POLARQUADSTRIP,20,BACKREF,0,6,6,6143,27971,BACKREF,0,7,7,6143,27971,
  BACKREF,0,8,8,6143,27971,BACKREF,0,9,9,6143,27971,
  POLARQUADSTRIP,20,BACKREF,0,11,11,6143,27971,BACKREF,0,12,12,6143,27971,
  BACKREF,0,13,13,6143,27971,BACKREF,0,14,14,6143,27971,
  POLARQUADSTRIP,20,BACKREF,0,16,16,6143,27971,BACKREF,0,17,17,6143,27971,
  BACKREF,0,18,18,6143,27971,BACKREF,0,19,19,6143,27971,

  POLARQUADSTRIP,20,1,5053,27971,BACKREF,1,1,2,5053,27971,BACKREF,1,2,
  3,5053,27971,BACKREF,1,3,4,5053,27971,BACKREF,1,4,
  POLARQUADSTRIP,20,6,5053,27971,BACKREF,1,6,7,5053,27971,BACKREF,1,7,
  8,5053,27971,BACKREF,1,8,9,5053,27971,BACKREF,1,9,
  POLARQUADSTRIP,20,11,5053,27971,BACKREF,1,11,12,5053,27971,BACKREF,1,12,
  13,5053,27971,BACKREF,1,13,14,5053,27971,BACKREF,1,14,
  POLARQUADSTRIP,20,16,5053,27971,BACKREF,1,16,17,5053,27971,BACKREF,1,17,
  18,5053,27971,BACKREF,1,18,19,5053,27971,BACKREF,1,19,

  POLARQUADSTRIP,20,1,5020,26819,1,6103,26819,
  0,5020,26819,0,6103,26819,19,5020,26819,19,6103,26819,
  POLARQUADSTRIP,20,6,5020,26819,6,6103,26819,
  5,5020,26819,5,6103,26819,4,5020,26819,4,6103,26819,
  POLARQUADSTRIP,20,11,5020,26819,11,6103,26819,
  10,5020,26819,10,6103,26819,9,5020,26819,9,6103,26819,
  POLARQUADSTRIP,20,16,5020,26819,16,6103,26819,
  15,5020,26819,15,6103,26819,14,5020,26819,14,6103,26819,

  POLARQUADSTRIP,20,1,5053,27971,1,6143,27971,1,5020,26819,1,6103,26819,
  POLARQUADSTRIP,20,4,5020,26819,4,6103,26819,4,5053,27971,4,6143,27971,
  POLARQUADSTRIP,20,6,5053,27971,6,6143,27971,6,5020,26819,6,6103,26819,
  POLARQUADSTRIP,20,9,5020,26819,9,6103,26819,9,5053,27971,9,6143,27971,
  POLARQUADSTRIP,20,11,5053,27971,11,6143,27971,11,5020,26819,11,6103,26819,
  POLARQUADSTRIP,20,14,5020,26819,14,6103,26819,14,5053,27971,14,6143,27971,
  POLARQUADSTRIP,20,16,5053,27971,16,6143,27971,16,5020,26819,16,6103,26819,
  POLARQUADSTRIP,20,19,5020,26819,19,6103,26819,19,5053,27971,19,6143,27971,

  POLARQUADSTRIP,20,1,6143,27971,1,5053,27971,2,6143,27971,2,5053,27971,
  3,6143,27971,3,5053,27971,4,6143,27971,4,5053,27971,
  POLARQUADSTRIP,20,6,6143,27971,6,5053,27971,7,6143,27971,7,5053,27971,
  8,6143,27971,8,5053,27971,9,6143,27971,9,5053,27971,
  POLARQUADSTRIP,20,11,6143,27971,11,5053,27971,12,6143,27971,12,5053,27971,
  13,6143,27971,13,5053,27971,14,6143,27971,14,5053,27971,
  POLARQUADSTRIP,20,16,6143,27971,16,5053,27971,17,6143,27971,17,5053,27971,
  18,6143,27971,18,5053,27971,19,6143,27971,19,5053,27971,

  ENDOFDATA
};

static double piece_size;

static int
enumerate_ring_vertices( int steps, unsigned short *data, void *h,
  void (*process_vertex)(void *h,double x,double y,double z))
{
  int patlen = 1,i;
  unsigned short *pts = data;
  double dtheta = M_PI * 2 / steps;

  if( data[0] == PATTERN) {
	patlen = data[1];
	pts += 2;
  }

  if( pts[0] == 0) steps = 1;

  for( i=0; i < steps; i++) {
	double r = pts[(i % patlen)*2] * piece_size;
	double y = pts[(i % patlen)*2+1] * piece_size;
	double theta = dtheta * i;

	process_vertex( h, r * cos(theta), y, r * sin(theta));
  }

  return pts + patlen * 2 - data;
}

static void
enumerate_vertices( unsigned short *data, void *h,
  void (*process_vertex)(void *h,double x,double y,double z))
{
  while(1) {
	if( data[0] == SPIN) {
	  int steps;
	  steps = data[1];
	  data += 2;

	  while(data[0] <= SEAM) {
		if( data[0] == SETBACKREF || data[0] == BACKREF) {
		  data += 2;
		  continue;
		} else if( data[0] == STEPUP) {
		  steps *= 2;
		  data++;
		  continue;
		} else if( data[0] == STEPDOWN) {
		  steps /= 2;
		  data++;
		  continue;
		} else if( data[0] == SEAM) {
		  data ++;
		  /* Visit seam vertices twice */
		  enumerate_ring_vertices( steps, data,
			h, process_vertex);
		  data += enumerate_ring_vertices( steps, data,
			h, process_vertex);
		} else {
		  data += enumerate_ring_vertices( steps, data,
			h, process_vertex);
		}
	  }
	} else if( data[0] == POLARQUADSTRIP) {
	  int steps = data[1];
	  double dtheta;
	  data += 2;

	  dtheta = M_PI * 2 / steps;

	  while(data[0] <= SEAM) {
		if( data[0] != BACKREF) {
		  double theta = dtheta * data[0];
		  double r = data[1] * piece_size;
		  double y = data[2] * piece_size;
		  process_vertex( h, r * cos(theta), y, r * sin(theta));
		}
		data += 3;
	  }
	} else if( data[0] == QUADSTRIP || data[0] == VERTICES) {
	  data ++;

	  while(data[0] <= SEAM) {
		if( data[0] == SETBACKREF) {
		  data += 2;
		  continue;
		}

		if( data[0] != BACKREF) {
		  double x = (signed short)data[0] * piece_size;
		  double y = data[1] * piece_size;
		  double z = (signed short)data[2] * piece_size;
		  process_vertex( h, x, y, z);
		}
		data += 3;
	  }
	} else if( data[0] == QUADS || data[0] == TRIANGLES) {
	  data ++;
	  while( data[0] <= SEAM) data++;
	} else {
	  break;
	}
  }
}

static void
enumerate_ring_faces( int basevertex, int steps,
  int prevbase, int prevsteps, void *h, int *count_ret,
  void (*process_face)(void *h,int v1,int v2,int v3,int v4))
{
  int i,j;

  if( steps == 1) {
	for( i=0; i < prevsteps; i++) {
	  process_face( h,
		basevertex,
		prevbase + i,
		prevbase + (i ? i-1 : prevsteps-1),
		-1);
          if (count_ret) (*count_ret)++;
	}
  } else if( steps == prevsteps) {
	for( i=0; i < steps; i++) {
	  process_face( h,
		basevertex + i,
		prevbase + i,
		prevbase + (i ? i-1 : steps-1),
		basevertex + (i ? i-1 : steps-1));
          if (count_ret) (*count_ret)++;
	}
  } else {
	j = 0;
	for( i=0;; i++) {
	  while( j < prevsteps && steps*(1+2*j) < prevsteps*(1+2*i)) {
		process_face( h,
		  basevertex + (i%steps),
		  prevbase + ((j+1)%prevsteps),
		  prevbase + j,
		  -1);
                if (count_ret) (*count_ret)++;
		j++;
	  }
	  if( i == steps) break;
	  process_face( h,
		basevertex + i,
		basevertex + ((i+1)%steps),
		prevbase + (j%prevsteps),
		-1);
          if (count_ret) (*count_ret)++;
	}
  }
}

static void
enumerate_faces( unsigned short *data, void *h, int *count_ret,
  void (*process_face)(void *h,int v1,int v2,int v3,int v4))
{
  int basevertex = 0, startofvertices = 0;
  int backrefs[5];

  while(1) {
	if( data[0] == SPIN) {
	  int steps;
	  int prevsteps = -1,prevbase = 0;

	  steps = data[1];
	  data += 2;

	  while( data[0] <= SEAM) {
		if( data[0] == SETBACKREF) {
		  backrefs[data[1]] = basevertex;
		  data += 2;
		  continue;
		}

		if( data[0] == STEPUP) {
		  steps *= 2;
		  data++;
		  continue;
		} else if( data[0] == STEPDOWN) {
		  steps /= 2;
		  data++;
		  continue;
		}

		if( data[0] == BACKREF) {
		  if( prevsteps != -1) {
			enumerate_ring_faces( backrefs[data[1]], steps,
                                              prevbase, prevsteps, h, 
                                              count_ret, process_face);
		  }

		  prevbase = backrefs[data[1]];
		  data += 2;
		} else {
		  int isseam = 0;
		  if( data[0] == SEAM) {
			isseam = 1;
			data++;
		  }

		  if( data[0] == PATTERN) {
			data += 2 + data[1]*2;
		  } else {
			if( data[0] == 0) steps = 1;
			data += 2;
		  }

		  if( prevsteps != -1) {
			enumerate_ring_faces( basevertex, steps,
                                              prevbase, prevsteps, h, 
                                              count_ret, process_face);
		  }

		  if( isseam) basevertex += steps;
		  prevbase = basevertex;
		  basevertex += steps;
		}

		prevsteps = steps;
	  }
	} else if( data[0] == POLARQUADSTRIP || data[0] == QUADSTRIP) {
	  int v0=-1,v1=0,v2,v3;
	  if( data[0] == POLARQUADSTRIP) data += 2;
	  else data ++;
	  while(data[0] <= SEAM) {
		if( data[0] == BACKREF) {
		  v2 = backrefs[data[1]]+data[2];
		} else {
		  v2 = basevertex;
		  basevertex++;
		}
		if( data[3] == BACKREF) {
		  v3 = backrefs[data[4]]+data[5];
		} else {
		  v3 = basevertex;
		  basevertex++;
		}
		data += 6;
		if( v0 != -1) {
                  process_face( h, v0, v1, v3, v2);
                  if (count_ret) (*count_ret)++;
                }
		v0 = v2;
		v1 = v3;
	  }
	} else if( data[0] == VERTICES) {
	  data ++;
	  startofvertices = basevertex;
	  while( data[0] <= SEAM) {
		if( data[0] == SETBACKREF) {
		  backrefs[data[1]] = basevertex;
		  data += 2;
		  continue;
		}
		data += 3;
		basevertex ++;
	  }
	} else if( data[0] == QUADS) {
	  data ++;
	  while( data[0] <= SEAM) {
		process_face( h,
		  data[0] + startofvertices,
		  data[1] + startofvertices,
		  data[2] + startofvertices,
		  data[3] + startofvertices);
                if (count_ret) (*count_ret)++;
		data += 4;
	  }
	} else if( data[0] == TRIANGLES) {
	  data ++;
	  while( data[0] <= SEAM) {
		process_face( h,
		  data[0] + startofvertices,
		  data[1] + startofvertices,
		  data[2] + startofvertices, -1);
                if (count_ret) (*count_ret)++;
		data += 3;
	  }
	} else {
	  break;
	}
  }
}

static void
normalize( float v[3]) {
  float d = sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);

  if( d == 0.0) {
	/* The direction is undefined - normalize it anyway */
	v[0] = 1.0;
	v[1] = 0.0;
	v[2] = 0.0;
	return;
  }

  v[0] /= d;
  v[1] /= d;
  v[2] /= d;
}

static void
normcrossprod( float v1[3], float v2[3], float out[3])
{
  out[0] = v1[1] * v2[2] - v1[2] * v2[1];
  out[1] = v1[2] * v2[0] - v1[0] * v2[2];
  out[2] = v1[0] * v2[1] - v1[1] * v2[0];
  normalize( out);
}

#define vectordiff(v1,v2,out) \
	((out)[0] = (v1)[0] - (v2)[0], \
	(out)[1] = (v1)[1] - (v2)[1], \
	(out)[2] = (v1)[2] - (v2)[2])

#define vectoradd(v1,v2) \
	((v1)[0] += (v2)[0], \
	 (v1)[1] += (v2)[1], \
	 (v1)[2] += (v2)[2])

static int numverts;
static float *vertices;
static float *normals;

static void
count_vertex( void *dummy, double x, double y, double z)
{
  numverts++;
}

static void
add_normal( void *dummy, int v1, int v2, int v3, int v4)
{
  float surfnormal[3],d1[3],d2[3];

  if( v4 == -1) {
	vectordiff( vertices + 3 * v2, vertices + 3 * v1, d1);
	vectordiff( vertices + 3 * v3, vertices + 3 * v1, d2);
	normcrossprod( d1, d2, surfnormal);
	vectoradd( normals + 3 * v1, surfnormal);
	vectoradd( normals + 3 * v2, surfnormal);
	vectoradd( normals + 3 * v3, surfnormal);
  } else {
	vectordiff( vertices + 3 * v2, vertices + 3 * v1, d1);
	vectordiff( vertices + 3 * v4, vertices + 3 * v1, d2);
	normcrossprod( d1, d2, surfnormal);
	vectoradd( normals + 3 * v1, surfnormal);
	vectordiff( vertices + 3 * v3, vertices + 3 * v2, d1);
	vectordiff( vertices + 3 * v1, vertices + 3 * v2, d2);
	normcrossprod( d1, d2, surfnormal);
	vectoradd( normals + 3 * v2, surfnormal);
	vectordiff( vertices + 3 * v4, vertices + 3 * v3, d1);
	vectordiff( vertices + 3 * v2, vertices + 3 * v3, d2);
	normcrossprod( d1, d2, surfnormal);
	vectoradd( normals + 3 * v3, surfnormal);
	vectordiff( vertices + 3 * v1, vertices + 3 * v4, d1);
	vectordiff( vertices + 3 * v3, vertices + 3 * v4, d2);
	normcrossprod( d1, d2, surfnormal);
	vectoradd( normals + 3 * v4, surfnormal);
  }
}

static void
collect_vertex( void *curvert, double x, double y, double z)
{
  (*(float**)curvert)[0] = x;
  (*(float**)curvert)[1] = y;
  (*(float**)curvert)[2] = z;
  (*(float**)curvert) += 3;
}

static void
draw_face( void *dummy, int v1, int v2, int v3, int v4)
{
  glBegin( v4 == -1 ? GL_TRIANGLES : GL_QUADS);
  glNormal3f( normals[v1*3], normals[v1*3+1], normals[v1*3+2]);
  glVertex3f( vertices[v1*3], vertices[v1*3+1], vertices[v1*3+2]);
  glNormal3f( normals[v2*3], normals[v2*3+1], normals[v2*3+2]);
  glVertex3f( vertices[v2*3], vertices[v2*3+1], vertices[v2*3+2]);
  glNormal3f( normals[v3*3], normals[v3*3+1], normals[v3*3+2]);
  glVertex3f( vertices[v3*3], vertices[v3*3+1], vertices[v3*3+2]);
  if( v4 != -1) {
	glNormal3f( normals[v4*3], normals[v4*3+1], normals[v4*3+2]);
	glVertex3f( vertices[v4*3], vertices[v4*3+1], vertices[v4*3+2]);
  }
  glEnd();
}

static int
draw_piece( unsigned short *piece_data)
{
  int i;
  float *curvert;
  int count = 0;

  /* Count how many vertices this piece has */
  enumerate_vertices( piece_data, NULL, count_vertex);

  /* Allocate memory for the vertices and for the vertex normals */
  vertices = malloc( sizeof(float) * 3 * numverts);
  normals = malloc( sizeof(float) * 3 * numverts);
  if( !vertices || !normals) exit(1);

  /* Collect the vertex coordinates */
  curvert = vertices;
  enumerate_vertices( piece_data, &curvert, collect_vertex);

  /* Zero out the normals */
  for( i=0; i < numverts * 3; i++) {
	normals[i] = 0.0;
  }

  /* Add up all the face normals at each vertex */
  enumerate_faces( piece_data, NULL, NULL, add_normal);

  /* Normalize the vertex normals */
  for( i=0; i < numverts; i++) {
	normalize( normals + i * 3);
  }

  /* Now draw the faces */
  enumerate_faces( piece_data, NULL, &count, draw_face);

  free( normals);
  free( vertices);

  if (count <= 1) abort();
  return count;
}

void chessmodels_gen_lists( int classic, int poly_count[PIECES]) {

  Bool queen_only_p = classic < 0;
  if (classic < 0) classic = 0;

  piece_size = classic ? 0.095 / 100 : 0.3 / 8192;

  glGenLists (20); /* this is horrible! List numbers are hardcoded! */

  glNewList(QUEEN, GL_COMPILE);
  poly_count[QUEEN] = draw_piece( classic ? classic_queen_data : queen_data);
  glEndList();

  if (queen_only_p) return;

  glNewList(KING, GL_COMPILE);
  poly_count[KING] = draw_piece( classic ? classic_king_data : king_data);
  glEndList();

  glNewList(BISHOP, GL_COMPILE);
  poly_count[BISHOP] = draw_piece( classic ? classic_bishop_data : bishop_data);
  glEndList();

  glNewList(KNIGHT, GL_COMPILE);
  poly_count[KNIGHT] = draw_piece( classic ? classic_knight_data : knight_data);
  glEndList();

  glNewList(ROOK, GL_COMPILE);
  poly_count[ROOK] = draw_piece( classic ? classic_rook_data : rook_data);
  glEndList();

  glNewList(PAWN, GL_COMPILE);
  poly_count[PAWN] = draw_piece( classic ? classic_pawn_data : pawn_data);
  glEndList();
}
