/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationInvocationHandler;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.AnnotationTypeMismatchExceptionProxy;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.scope.ClassScope;
import sun.reflect.generics.tree.TypeSignature;
import sun.reflect.generics.visitor.Reifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParser {
    private static final Annotation[] EMPTY_ANNOTATIONS_ARRAY = new Annotation[0];

    public static Map<Class, Annotation> parseAnnotations(byte[] byArray, ConstantPool constantPool, Class clazz) {
        if (byArray == null) {
            return Collections.emptyMap();
        }
        try {
            return AnnotationParser.parseAnnotations2(byArray, constantPool, clazz);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new AnnotationFormatError("Unexpected end of annotations.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnnotationFormatError(illegalArgumentException);
        }
    }

    private static Map<Class, Annotation> parseAnnotations2(byte[] byArray, ConstantPool constantPool, Class clazz) {
        LinkedHashMap<Class, Annotation> linkedHashMap = new LinkedHashMap<Class, Annotation>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = byteBuffer.getShort() & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            Class<? extends Annotation> clazz2;
            AnnotationType annotationType;
            Annotation annotation = AnnotationParser.parseAnnotation(byteBuffer, constantPool, clazz, false);
            if (annotation == null || (annotationType = AnnotationType.getInstance(clazz2 = annotation.annotationType())).retention() != RetentionPolicy.RUNTIME || linkedHashMap.put(clazz2, annotation) == null) continue;
            throw new AnnotationFormatError("Duplicate annotation for class: " + clazz2 + ": " + annotation);
        }
        return linkedHashMap;
    }

    public static Annotation[][] parseParameterAnnotations(byte[] byArray, ConstantPool constantPool, Class clazz) {
        try {
            return AnnotationParser.parseParameterAnnotations2(byArray, constantPool, clazz);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new AnnotationFormatError("Unexpected end of parameter annotations.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnnotationFormatError(illegalArgumentException);
        }
    }

    private static Annotation[][] parseParameterAnnotations2(byte[] byArray, ConstantPool constantPool, Class clazz) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = byteBuffer.get() & 0xFF;
        Annotation[][] annotationArray = new Annotation[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getShort() & 0xFFFF;
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(n2);
            for (int j = 0; j < n2; ++j) {
                AnnotationType annotationType;
                Annotation annotation = AnnotationParser.parseAnnotation(byteBuffer, constantPool, clazz, false);
                if (annotation == null || (annotationType = AnnotationType.getInstance(annotation.annotationType())).retention() != RetentionPolicy.RUNTIME) continue;
                arrayList.add(annotation);
            }
            annotationArray[i] = arrayList.toArray(EMPTY_ANNOTATIONS_ARRAY);
        }
        return annotationArray;
    }

    private static Annotation parseAnnotation(ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz, boolean bl) {
        int n = byteBuffer.getShort() & 0xFFFF;
        Class<?> clazz2 = null;
        String string = "[unknown]";
        try {
            try {
                string = constantPool.getUTF8At(n);
                clazz2 = AnnotationParser.parseSig(string, clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                clazz2 = constantPool.getClassAt(n);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (bl) {
                throw new TypeNotPresentException(string, noClassDefFoundError);
            }
            AnnotationParser.skipAnnotation(byteBuffer, false);
            return null;
        }
        catch (TypeNotPresentException typeNotPresentException) {
            if (bl) {
                throw typeNotPresentException;
            }
            AnnotationParser.skipAnnotation(byteBuffer, false);
            return null;
        }
        AnnotationType annotationType = null;
        try {
            annotationType = AnnotationType.getInstance(clazz2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AnnotationParser.skipAnnotation(byteBuffer, false);
            return null;
        }
        Map<String, Class> map = annotationType.memberTypes();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(annotationType.memberDefaults());
        int n2 = byteBuffer.getShort() & 0xFFFF;
        for (int i = 0; i < n2; ++i) {
            int n3 = byteBuffer.getShort() & 0xFFFF;
            String string2 = constantPool.getUTF8At(n3);
            Class clazz3 = map.get(string2);
            if (clazz3 == null) {
                AnnotationParser.skipMemberValue(byteBuffer);
                continue;
            }
            Object object = AnnotationParser.parseMemberValue(clazz3, byteBuffer, constantPool, clazz);
            if (object instanceof AnnotationTypeMismatchExceptionProxy) {
                ((AnnotationTypeMismatchExceptionProxy)object).setMember(annotationType.members().get(string2));
            }
            linkedHashMap.put(string2, object);
        }
        return AnnotationParser.annotationForMap(clazz2, linkedHashMap);
    }

    public static Annotation annotationForMap(Class clazz, Map<String, Object> map) {
        return (Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new AnnotationInvocationHandler(clazz, map));
    }

    public static Object parseMemberValue(Class clazz, ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz2) {
        Object object = null;
        byte by = byteBuffer.get();
        switch (by) {
            case 101: {
                return AnnotationParser.parseEnumValue(clazz, byteBuffer, constantPool, clazz2);
            }
            case 99: {
                object = AnnotationParser.parseClassValue(byteBuffer, constantPool, clazz2);
                break;
            }
            case 64: {
                object = AnnotationParser.parseAnnotation(byteBuffer, constantPool, clazz2, true);
                break;
            }
            case 91: {
                return AnnotationParser.parseArray(clazz, byteBuffer, constantPool, clazz2);
            }
            default: {
                object = AnnotationParser.parseConst(by, byteBuffer, constantPool);
            }
        }
        if (!(object instanceof ExceptionProxy) && !clazz.isInstance(object)) {
            object = new AnnotationTypeMismatchExceptionProxy(object.getClass() + "[" + object + "]");
        }
        return object;
    }

    private static Object parseConst(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        int n2 = byteBuffer.getShort() & 0xFFFF;
        switch (n) {
            case 66: {
                return (byte)constantPool.getIntAt(n2);
            }
            case 67: {
                return Character.valueOf((char)constantPool.getIntAt(n2));
            }
            case 68: {
                return constantPool.getDoubleAt(n2);
            }
            case 70: {
                return Float.valueOf(constantPool.getFloatAt(n2));
            }
            case 73: {
                return constantPool.getIntAt(n2);
            }
            case 74: {
                return constantPool.getLongAt(n2);
            }
            case 83: {
                return (short)constantPool.getIntAt(n2);
            }
            case 90: {
                return constantPool.getIntAt(n2) != 0;
            }
            case 115: {
                return constantPool.getUTF8At(n2);
            }
        }
        throw new AnnotationFormatError("Invalid member-value tag in annotation: " + n);
    }

    private static Object parseClassValue(ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz) {
        int n = byteBuffer.getShort() & 0xFFFF;
        try {
            try {
                String string = constantPool.getUTF8At(n);
                return AnnotationParser.parseSig(string, clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return constantPool.getClassAt(n);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new TypeNotPresentExceptionProxy("[unknown]", noClassDefFoundError);
        }
        catch (TypeNotPresentException typeNotPresentException) {
            return new TypeNotPresentExceptionProxy(typeNotPresentException.typeName(), typeNotPresentException.getCause());
        }
    }

    private static Class<?> parseSig(String string, Class clazz) {
        if (string.equals("V")) {
            return Void.TYPE;
        }
        SignatureParser signatureParser = SignatureParser.make();
        TypeSignature typeSignature = signatureParser.parseTypeSig(string);
        CoreReflectionFactory coreReflectionFactory = CoreReflectionFactory.make(clazz, ClassScope.make(clazz));
        Reifier reifier = Reifier.make(coreReflectionFactory);
        typeSignature.accept(reifier);
        Type type = reifier.getResult();
        return AnnotationParser.toClass(type);
    }

    static Class toClass(Type type) {
        if (type instanceof GenericArrayType) {
            return Array.newInstance(AnnotationParser.toClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return (Class)type;
    }

    private static Object parseEnumValue(Class clazz, ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz2) {
        int n = byteBuffer.getShort() & 0xFFFF;
        String string = constantPool.getUTF8At(n);
        int n2 = byteBuffer.getShort() & 0xFFFF;
        String string2 = constantPool.getUTF8At(n2);
        if (!string.endsWith(";") ? !clazz.getName().equals(string) : clazz != AnnotationParser.parseSig(string, clazz2)) {
            return new AnnotationTypeMismatchExceptionProxy(string + "." + string2);
        }
        try {
            return Enum.valueOf(clazz, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new EnumConstantNotPresentExceptionProxy(clazz, string2);
        }
    }

    private static Object parseArray(Class clazz, ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz2) {
        int n = byteBuffer.getShort() & 0xFFFF;
        Class<?> clazz3 = clazz.getComponentType();
        if (clazz3 == Byte.TYPE) {
            return AnnotationParser.parseByteArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Character.TYPE) {
            return AnnotationParser.parseCharArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Double.TYPE) {
            return AnnotationParser.parseDoubleArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Float.TYPE) {
            return AnnotationParser.parseFloatArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Integer.TYPE) {
            return AnnotationParser.parseIntArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Long.TYPE) {
            return AnnotationParser.parseLongArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Short.TYPE) {
            return AnnotationParser.parseShortArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Boolean.TYPE) {
            return AnnotationParser.parseBooleanArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == String.class) {
            return AnnotationParser.parseStringArray(n, byteBuffer, constantPool);
        }
        if (clazz3 == Class.class) {
            return AnnotationParser.parseClassArray(n, byteBuffer, constantPool, clazz2);
        }
        if (clazz3.isEnum()) {
            return AnnotationParser.parseEnumArray(n, clazz3, byteBuffer, constantPool, clazz2);
        }
        assert (clazz3.isAnnotation());
        return AnnotationParser.parseAnnotationArray(n, clazz3, byteBuffer, constantPool, clazz2);
    }

    private static Object parseByteArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        byte[] byArray = new byte[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 66) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                byArray[i] = (byte)constantPool.getIntAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : byArray;
    }

    private static Object parseCharArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        char[] cArray = new char[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 67) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                cArray[i] = (char)constantPool.getIntAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : cArray;
    }

    private static Object parseDoubleArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        double[] dArray = new double[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 68) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                dArray[i] = constantPool.getDoubleAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : dArray;
    }

    private static Object parseFloatArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        float[] fArray = new float[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 70) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                fArray[i] = constantPool.getFloatAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : fArray;
    }

    private static Object parseIntArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        int[] nArray = new int[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 73) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                nArray[i] = constantPool.getIntAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : nArray;
    }

    private static Object parseLongArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        long[] lArray = new long[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 74) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                lArray[i] = constantPool.getLongAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : lArray;
    }

    private static Object parseShortArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        short[] sArray = new short[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 83) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                sArray[i] = (short)constantPool.getIntAt(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : sArray;
    }

    private static Object parseBooleanArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        boolean[] blArray = new boolean[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 90) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                blArray[i] = constantPool.getIntAt(n2) != 0;
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? (Object)AnnotationParser.exceptionProxy(by) : blArray;
    }

    private static Object parseStringArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool) {
        String[] stringArray = new String[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 115) {
                int n2 = byteBuffer.getShort() & 0xFFFF;
                stringArray[i] = constantPool.getUTF8At(n2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? AnnotationParser.exceptionProxy(by) : stringArray;
    }

    private static Object parseClassArray(int n, ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz) {
        Class[] classArray = new Class[n];
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 99) {
                classArray[i] = AnnotationParser.parseClassValue(byteBuffer, constantPool, clazz);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? AnnotationParser.exceptionProxy(by) : classArray;
    }

    private static Object parseEnumArray(int n, Class clazz, ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz2) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 101) {
                objectArray[i] = AnnotationParser.parseEnumValue(clazz, byteBuffer, constantPool, clazz2);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? AnnotationParser.exceptionProxy(by) : objectArray;
    }

    private static Object parseAnnotationArray(int n, Class clazz, ByteBuffer byteBuffer, ConstantPool constantPool, Class clazz2) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        boolean bl = false;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byteBuffer.get();
            if (by == 64) {
                objectArray[i] = AnnotationParser.parseAnnotation(byteBuffer, constantPool, clazz2, true);
                continue;
            }
            AnnotationParser.skipMemberValue(by, byteBuffer);
            bl = true;
        }
        return bl ? AnnotationParser.exceptionProxy(by) : objectArray;
    }

    private static ExceptionProxy exceptionProxy(int n) {
        return new AnnotationTypeMismatchExceptionProxy("Array with component tag: " + n);
    }

    private static void skipAnnotation(ByteBuffer byteBuffer, boolean bl) {
        if (bl) {
            byteBuffer.getShort();
        }
        int n = byteBuffer.getShort() & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            byteBuffer.getShort();
            AnnotationParser.skipMemberValue(byteBuffer);
        }
    }

    private static void skipMemberValue(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        AnnotationParser.skipMemberValue(by, byteBuffer);
    }

    private static void skipMemberValue(int n, ByteBuffer byteBuffer) {
        switch (n) {
            case 101: {
                byteBuffer.getInt();
                break;
            }
            case 64: {
                AnnotationParser.skipAnnotation(byteBuffer, true);
                break;
            }
            case 91: {
                AnnotationParser.skipArray(byteBuffer);
                break;
            }
            default: {
                byteBuffer.getShort();
            }
        }
    }

    private static void skipArray(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort() & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            AnnotationParser.skipMemberValue(byteBuffer);
        }
    }
}

