/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api;

import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.ServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSService
extends ServiceDelegate {
    protected WSService() {
    }

    public abstract <T> T getPort(WSEndpointReference var1, Class<T> var2, WebServiceFeature ... var3);

    public abstract <T> Dispatch<T> createDispatch(QName var1, WSEndpointReference var2, Class<T> var3, Service.Mode var4, WebServiceFeature ... var5);

    public abstract Dispatch<Object> createDispatch(QName var1, WSEndpointReference var2, JAXBContext var3, Service.Mode var4, WebServiceFeature ... var5);

    public static WSService create(URL uRL, QName qName) {
        return new WSServiceDelegate(uRL, qName, Service.class);
    }

    public static WSService create(QName qName) {
        return WSService.create(null, qName);
    }

    public static WSService create() {
        return WSService.create(null, new QName(WSService.class.getName(), "dummy"));
    }

    public static WSService unwrap(final Service service) {
        return AccessController.doPrivileged(new PrivilegedAction<WSService>(){

            @Override
            public WSService run() {
                try {
                    Field field = service.getClass().getField("delegate");
                    field.setAccessible(true);
                    Object object = field.get(service);
                    if (!(object instanceof WSService)) {
                        throw new IllegalArgumentException();
                    }
                    return (WSService)object;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    AssertionError assertionError = new AssertionError((Object)"Unexpected service API implementation");
                    ((Throwable)((Object)assertionError)).initCause(noSuchFieldException);
                    throw assertionError;
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessError illegalAccessError = new IllegalAccessError(illegalAccessException.getMessage());
                    illegalAccessError.initCause(illegalAccessException);
                    throw illegalAccessError;
                }
            }
        });
    }
}

