/* Declarations for ptimer.c.
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Wget.

GNU Wget is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GNU Wget is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Wget; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

In addition, as a special exception, the Free Software Foundation
gives permission to link the code of its release of Wget with the
OpenSSL project's "OpenSSL" library (or with modified versions of it
that use the same license as the "OpenSSL" library), and distribute
the linked executables.  You must obey the GNU General Public License
in all respects for all of the code used other than "OpenSSL".  If you
modify this file, you may extend this exception to your version of the
file, but you are not obligated to do so.  If you do not wish to do
so, delete this exception statement from your version.  */

#ifndef PTIMER_H
#define PTIMER_H

struct ptimer;			/* forward declaration; all struct
                                   members are private */

struct ptimer *ptimer_new PARAMS ((void));
void ptimer_destroy PARAMS ((struct ptimer *));

void ptimer_reset PARAMS ((struct ptimer *));
double ptimer_measure PARAMS ((struct ptimer *));
double ptimer_read PARAMS ((const struct ptimer *));

double ptimer_resolution PARAMS ((void));

#endif /* PTIMER_H */
