--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- @file merchant-0019.sql
-- @brief Tables for statistics
-- @author Christian Grothoff


BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('merchant-0019', NULL, NULL);

SET search_path TO merchant;

ALTER TABLE merchant_inventory
  ADD product_name TEXT;
-- We use existing description as the product name for
-- products that existed in the inventory prior to the migration.
UPDATE merchant_inventory
  SET product_name=description;
ALTER TABLE merchant_inventory
  ALTER COLUMN product_name SET NOT NULL;


COMMENT ON COLUMN merchant_inventory.product_name
  IS 'Name of the product';

COMMIT;
