/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (sort-opts.c)
 *
 *  It has been AutoGen-ed
 *  From the definitions    sort-opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:1:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This source file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the sort-pw-cfg author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 */

#ifndef __doxygen__
#define OPTION_CODE_COMPILE 1
#include "sort-opts.h"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef  __cplusplus
extern "C" {
#endif
extern FILE * option_usage_fp;
#define zCopyright      NULL
#define zLicenseDescrip NULL
/*
 *  global included definitions
 */
char const * config_file_name    = NULL;
char const * leader_text         = NULL;
size_t       config_file_size    = 0;
extern sort_pw_cfg_exit_code_t emit_new_text(void);

#ifndef NULL
#  define NULL 0
#endif

/**
 *  static const strings for sort-pw-cfg options
 */
static char const sort_pw_cfg_opt_strs[948] =
/*     0 */ "send result to this file\0"
/*    25 */ "OUTPUT\0"
/*    32 */ "output\0"
/*    39 */ "select default config file for first input file\0"
/*    87 */ "DEFAULT\0"
/*    95 */ "default\0"
/*   103 */ "display extended usage information and exit\0"
/*   147 */ "help\0"
/*   152 */ "extended usage information passed thru pager\0"
/*   197 */ "more-help\0"
/*   207 */ "output version information and exit\0"
/*   243 */ "version\0"
/*   251 */ "SORT_PW_CFG\0"
/*   263 */ "sort-pw-cfg - sort/merge password config file - Ver. 1.5\n"
            "Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... \\\n"
            "\t\t[ <cfg-file> ...]\n\0"
/*   400 */ "\n"
            "If no arguments are provided, input arguments are read from stdin,\n"
            "one per line; blank and '#'-prefixed lines are comments.\n"
            "'stdin' may not be a terminal (tty).\n\0"
/*   563 */ "This program will sort (and merge) the per-domain password attributes.  If\n"
            "there are duplicate entries, the last entry seen will survive.  The result\n"
            "will be sorted by password id hash code and option name.\n\n"
            "The \"header\" portion of the config file (the seeds and the <program...>\n"
            "marker) are taken from the first config file listed and ignored in the\n"
            "remaining files.\n\0"
/*   932 */ "sort-pw-cfg 1.5";

/**
 *  output option description:
 */
/** Descriptive text for the output option */
#define OUTPUT_DESC      (sort_pw_cfg_opt_strs+0)
/** Upper-cased name for the output option */
#define OUTPUT_NAME      (sort_pw_cfg_opt_strs+25)
/** Name string for the output option */
#define OUTPUT_name      (sort_pw_cfg_opt_strs+32)
/** Compiled in flag settings for the output option */
#define OUTPUT_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_FILE))

/**
 *  default option description:
 */
/** Descriptive text for the default option */
#define DEFAULT_DESC      (sort_pw_cfg_opt_strs+39)
/** Upper-cased name for the default option */
#define DEFAULT_NAME      (sort_pw_cfg_opt_strs+87)
/** Name string for the default option */
#define DEFAULT_name      (sort_pw_cfg_opt_strs+95)
/** Compiled in flag settings for the default option */
#define DEFAULT_FLAGS     (OPTST_DISABLED)

/*
 *  Help/More_Help/Version option descriptions:
 */
#define HELP_DESC       (sort_pw_cfg_opt_strs+103)
#define HELP_name       (sort_pw_cfg_opt_strs+147)
#ifdef HAVE_WORKING_FORK
#define MORE_HELP_DESC  (sort_pw_cfg_opt_strs+152)
#define MORE_HELP_name  (sort_pw_cfg_opt_strs+197)
#define MORE_HELP_FLAGS (OPTST_IMM | OPTST_NO_INIT)
#else
#define MORE_HELP_DESC  HELP_DESC
#define MORE_HELP_name  HELP_name
#define MORE_HELP_FLAGS (OPTST_OMITTED | OPTST_NO_INIT)
#endif
#ifdef NO_OPTIONAL_OPT_ARGS
#  define VER_FLAGS     (OPTST_IMM | OPTST_NO_INIT)
#else
#  define VER_FLAGS     (OPTST_SET_ARGTYPE(OPARG_TYPE_STRING) | \
                         OPTST_ARG_OPTIONAL | OPTST_IMM | OPTST_NO_INIT)
#endif
#define VER_DESC        (sort_pw_cfg_opt_strs+207)
#define VER_name        (sort_pw_cfg_opt_strs+243)
/**
 *  Declare option callback procedures
 */
extern tOptProc
    optionBooleanVal,   optionNestedVal,    optionNumericVal,
    optionPagedUsage,   optionPrintVersion, optionResetOpt,
    optionStackArg,     optionTimeDate,     optionTimeVal,
    optionUnstackArg,   optionVendorOption;
static tOptProc
    doOptOutput, doUsageOpt;
#define VER_PROC        optionPrintVersion

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Define the sort-pw-cfg Option Descriptions.
 * This is an array of OPTION_CT entries, one for each
 * option that the sort-pw-cfg program responds to.
 */
static tOptDesc optDesc[OPTION_CT] = {
  {  /* entry idx, value */ 0, VALUE_OPT_OUTPUT,
     /* equiv idx, value */ 0, VALUE_OPT_OUTPUT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OUTPUT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --output */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptOutput,
     /* desc, NAME, name */ OUTPUT_DESC, OUTPUT_NAME, OUTPUT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_DEFAULT,
     /* equiv idx, value */ 1, VALUE_OPT_DEFAULT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DEFAULT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --default */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DEFAULT_DESC, DEFAULT_NAME, DEFAULT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VER_FLAGS, AOUSE_VERSION,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ VER_PROC,
     /* desc, NAME, name */ VER_DESC, NULL, VER_name,
     /* disablement strs */ NULL, NULL },



  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, AOUSE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ HELP_DESC, NULL, HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_MORE_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MORE_HELP_FLAGS, AOUSE_MORE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ MORE_HELP_DESC, NULL, MORE_HELP_name,
     /* disablement strs */ NULL, NULL }
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/** Reference to the upper cased version of sort-pw-cfg. */
#define zPROGNAME       (sort_pw_cfg_opt_strs+251)
/** Reference to the title line for sort-pw-cfg usage. */
#define zUsageTitle     (sort_pw_cfg_opt_strs+263)
/** There is no sort-pw-cfg configuration file. */
#define zRcName         NULL
/** There are no directories to search for sort-pw-cfg config files. */
#define apzHomeList     NULL
/** The sort-pw-cfg program bug email address. */
#define zBugsAddr       (NULL)
/** Clarification/explanation of what sort-pw-cfg does. */
#define zExplain        (sort_pw_cfg_opt_strs+400)
/** Extra detail explaining what sort-pw-cfg does. */
#define zDetail         (sort_pw_cfg_opt_strs+563)
/** The full version string for sort-pw-cfg. */
#define zFullVersion    (sort_pw_cfg_opt_strs+932)
/* extracted from optcode.tlib near line 364 */

#define OPTPROC_BASE OPTPROC_NONE
#define translate_option_strings NULL

#define sort_pw_cfg_full_usage (NULL)
#define sort_pw_cfg_short_usage (NULL)

#endif /* not defined __doxygen__ */

/*
 *  Create the static procedure(s) declared above.
 */
/**
 * The callout function that invokes the optionUsage function.
 *
 * @param[in] opts the AutoOpts option description structure
 * @param[in] od   the descriptor for the "help" (usage) option.
 * @noreturn
 */
static void
doUsageOpt(tOptions * opts, tOptDesc * od)
{
    int ex_code;
    ex_code = SORT_PW_CFG_EXIT_SUCCESS;
    optionUsage(&sort_pw_cfgOptions, ex_code);
    /* NOTREACHED */
    exit(SORT_PW_CFG_EXIT_INVALID);
    (void)opts;
    (void)od;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the output option.
 * Normally, the first named file is rewritten with the entries
 * ordered by the hash code with duplicates removed.  Use this
 * option to redirect output to the named file.
 * @param[in] pOptions the sort-pw-cfg options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptOutput(tOptions* pOptions, tOptDesc* pOptDesc)
{
    static teOptFileType const  type =
        FTYPE_MODE_MAY_EXIST + FTYPE_MODE_NO_OPEN;
    static tuFileMode           mode;
#ifndef O_CLOEXEC
#  define O_CLOEXEC 0
#endif
    mode.file_flags = O_CLOEXEC;

    /*
     * This function handles special invalid values for "pOptions"
     */
    optionFileCheck(pOptions, pOptDesc, type, mode);
}
/* extracted from optmain.tlib near line 116 */


extern int load_domain_attrs(char const * fname, char * file_text, size_t text_size);
/* extracted from optmain.tlib near line 204 */

/**
 * validate file name and dispach callout procedure.
 * This procedure is generated by AutoOpts.
 * It will make sure that the input file name refers to a file
 * that has been read into memory as text.
 *
 * @param fname the name of the file to process
 * @returns program exit code flag
 */
static sort_pw_cfg_exit_code_t
validate_fname(char const * fname)
{
    static char const * err_str = NULL;
    char*  file_text;
    size_t text_size;
    int    res;

    if (err_str == NULL)
        err_str = _("fs error %d (%s) %s-ing %s\n");
    {
        struct stat sb;
        if (stat(fname, &sb) < 0) {
            fprintf(stderr, err_str, errno, strerror(errno), "stat",
                    fname);
            return SORT_PW_CFG_EXIT_INVALID;
        }

        if (! S_ISREG(sb.st_mode)) {
            fprintf(stderr, err_str, EINVAL, strerror(EINVAL),
                    _("not regular file:"), fname);
            return SORT_PW_CFG_EXIT_INVALID;
        }

        if (sb.st_size == 0) {
            fprintf(stderr, err_str, EINVAL, strerror(EINVAL),
                    _("empty file:"), fname);
            return SORT_PW_CFG_EXIT_INVALID;
        }

        text_size = sb.st_size;
    }
/* extracted from optmain.tlib near line 311 */

    file_text = malloc(text_size + 1);
    if (file_text == NULL) {
        fprintf(stderr, _("cannot allocate %u bytes for %s file text\n"),
                (unsigned int)text_size+1, fname);
        exit(SORT_PW_CFG_EXIT_NO_MEM);
    }

    {
        char*   pz = file_text;
        size_t  sz = text_size;
        int     fd = open(fname, O_RDONLY);
        int     try_ct = 0;

        if (fd < 0) {
            fprintf(stderr, err_str, errno, strerror(errno), "open", fname);
            free(file_text);
            return SORT_PW_CFG_EXIT_INVALID;
        }

        while (sz > 0) {
            ssize_t rd_ct = read(fd, pz, sz);
            /*
             *  a read count of zero is theoretically okay, but we've already
             *  checked the file size, so we shoud be reading more.
             *  For us, a count of zero is an error.
             */
            if (rd_ct <= 0) {
                /*
                 * Try retriable errors up to 10 times.  Then bomb out.
                 */
                if (  ((errno == EAGAIN) || (errno == EINTR))
                   && (++try_ct < 10)  )
                    continue;

                fprintf(stderr, err_str, errno, strerror(errno), "read", fname);
                exit(SORT_PW_CFG_EXIT_INVALID);
            }
            pz += rd_ct;
            sz -= rd_ct;
        }
        close(fd);
    }

    /*
     *  Just in case it is a text file, we have an extra byte to NUL
     *  terminate the thing.
     */
    file_text[ text_size ] = '\0';
    res = load_domain_attrs(fname, file_text, text_size);
    return res;
}
/* extracted from optmain.tlib near line 131 */

/**
 * strip (destructively) the leading and trailing white space.
 * Trailing white space is trimmed with a NUL byte.
 * The returned address is that of the first character after the
 * leading white space.  Characters are not moved.
 *
 * @param[in,out] pz_s source text pointer
 * @returns pointer to the same text buffer, but after skipping over the
 * leading white space characters.
 */
static char *
trim_input_line(char * src_str)
{
    while ((unsigned int)isspace(*src_str))
        src_str++;

    {
        char * end = src_str + strlen(src_str);
        while ((end > src_str) && isspace((unsigned int)end[-1]))
            end--;
        *end = '\0';
    }

    switch (*src_str) {
    case '\0':
    case '#':
        return NULL;
    default:
        return src_str;
    }
}

/**
 * Generated main procedure.  This will call the validate_fname procedure
 * for every operand on the command line.  If there are no operands, then stdin
 * is read for a list of file names to process.  stdin must not be a terminal.
 * It must be a pipe or a file.
 *
 * @param[in] argc argument count
 * @param[in] argv argument vector
 * @returns program exit code
 */
int
main(int argc, char ** argv)
{
    int res     = 0;
    int proc_ct = 0;
    int arg_ix  = optionProcess(&sort_pw_cfgOptions, argc, argv);
    
/* extracted from sort-opts.def near line 70 */

    if (HAVE_OPT(DEFAULT)) {
        char * fname = find_cfg_name();
        res |= validate_fname(fname);
        free(fname);
    }

/* extracted from optmain.tlib near line 160 */

    /*
     *  IF the input list is from the command line...
     */
    if (arg_ix < argc) {
        for (; arg_ix < argc; arg_ix++) {
            char * arg = argv[arg_ix];
            res |= validate_fname(arg);
            proc_ct++;
        }
    }
    /*
     *  Input list from tty input
     */
    else if (isatty(STDIN_FILENO)) {
        fputs(_("sort-pw-cfg ERROR: input list is a tty\n"), stderr);
        USAGE(SORT_PW_CFG_EXIT_INVALID);
        /* NOTREACHED */
    }

    /*
     *  Input list from a pipe or file or some such
     */
    else {
        long pg_size = sysconf(_SC_PAGESIZE);
        char * buf   = malloc((size_t)pg_size);
        if (buf == NULL) {
            fputs(_("sort-pw-cfg ERROR: no memory for input list\n"), stderr);
            return SORT_PW_CFG_EXIT_NO_MEM;
        }

        for (;;) {
            char * pz = fgets(buf, (ssize_t)pg_size, stdin);
            if (pz == NULL)
                break;

            pz = trim_input_line(pz);
            if (pz == NULL)
                continue;
            res |= validate_fname(pz);
            proc_ct++;
        }

        if (proc_ct == 0)
            fputs(_("sort-pw-cfg Warning:  no input lines were read\n"), stderr);
        free(buf);
    }

    
/* extracted from sort-opts.def near line 68 */

    res |= emit_new_text();
    return res;
}
/* extracted from optmain.tlib near line 1250 */

/**
 * Print a usage message with a format and va_list argument.
 * The optionUsage function is then invoked to print
 * the error usage text (somewhat abbreviated) and then exit.
 *
 * @param[in] fmt the message format string
 * @param[in] ap  the var-arg list.
 * @noreturn
 */
void
vusage_message(char const * fmt, va_list ap)
{
    char const * er_leader = _("sort-pw-cfg usage error:\n");
    fputs(er_leader, stderr);
    vfprintf(stderr, fmt, ap);
    optionUsage(&sort_pw_cfgOptions, SORT_PW_CFG_EXIT_USAGE_ERROR);
    /* NOTREACHED */
    exit(1);
}

/**
 * Print a usage message with a format and a variable argument list.
 * vusage_message() is called to do the work.
 *
 * @param[in] fmt the message format string
 * @param[in] ... the argument list for the message
 * @noreturn
 */
void
usage_message(char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vusage_message(fmt, ap);
    /* NOTREACHED */
    va_end(ap);
}

/**
 * Print a fatal error message and die, \a va_list style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ap         the argument list for the message
 * @noreturn
 */
void
vdie(int exit_code, char const * fmt, va_list ap)
{
    char const * die_leader = _("sort-pw-cfg fatal error:\n");
    fputs(die_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
    exit(exit_code);
    /* NOTREACHED */
}

/**
 * Print a fatal error message and die, var-arg style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ...        the list of arguments for the message
 * @noreturn
 */
void
die(int exit_code, char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vdie(exit_code, fmt, ap);
    /* NOTREACHED */
    va_end(ap);
}

/**
 * Print a file system error fatal error message and die.
 *
 * @param[in] exit_code  the value to call exit(3) with.
 * @param[in] op         the operation that failed.
 * @param[in] fname      the file name the operation was on.
 * @noreturn
 */
void
fserr(int exit_code, char const * op, char const * fname)
{
    char const * fserr_fmt = _("fserr %d (%s) performing '%s' on %s\n");
    die(exit_code, fserr_fmt, errno, strerror(errno), op, fname);
    /* NOTREACHED */
}

/**
 * Print a warning message, \a va_list style.
 *
 * @param[in] fmt        the "something awry" message
 * @param[in] ap         the argument list for the message
 */
void
vwarning_msg(char const * fmt, va_list ap)
{
    char const * warn_leader = _("sort-pw-cfg WARNING:\n");
    fputs(warn_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
}

/**
 * Print a warning message, var-arg style.
 *
 * @param[in] fmt        the "something awry" message
 * @param[in] ...        the list of arguments for the message
 */
void
warning_msg(char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vwarning_msg(fmt, ap);
    va_end(ap);
}

/**
 * The directory containing the data associated with sort-pw-cfg.
 */
#ifndef  PKGDATADIR
# define PKGDATADIR ""
#endif

/**
 * Information about the person or institution that packaged sort-pw-cfg
 * for the current distribution.
 */
#ifndef  WITH_PACKAGER
# define sort_pw_cfg_packager_info NULL
#else
/** Packager information for sort-pw-cfg. */
static char const sort_pw_cfg_packager_info[] =
    "Packaged by " WITH_PACKAGER

# ifdef WITH_PACKAGER_VERSION
        " ("WITH_PACKAGER_VERSION")"
# endif

# ifdef WITH_PACKAGER_BUG_REPORTS
    "\nReport sort_pw_cfg bugs to " WITH_PACKAGER_BUG_REPORTS
# endif
    "\n";
#endif
#ifndef __doxygen__

#endif /* __doxygen__ */
/**
 * The option definitions for sort-pw-cfg.  The one structure that
 * binds them all.
 */
tOptions sort_pw_cfgOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zLicenseDescrip,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage, /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP, /* more-help option index */
      NO_EQUIVALENT, /* save option index */
      NO_EQUIVALENT, /* '-#' option index */
      NO_EQUIVALENT /* index of default opt */
    },
    5 /* full option count */, 2 /* user option count */,
    sort_pw_cfg_full_usage, sort_pw_cfg_short_usage,
    NULL, NULL,
    PKGDATADIR, sort_pw_cfg_packager_info
};

#ifdef  __cplusplus
}
#endif
/* sort-opts.c ends here */
