/*
  GNU Gama C++ library tests/statan
  Copyright (C) 2018  Ales Cepek <cepek@gnu.org>

  This file is part of the GNU Gama C++ library
  
  GNU Gama is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  GNU Gama is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Gama.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <iostream>
#include <vector>
#include <cmath>
#include "gnu_gama/statan.h"

using namespace GNU_gama;
using namespace std;

/*
  Testing data generated from the Octave script:

  % normal distribution - probability and cumulative distribution

  N = 100;
  x = -6*N:6*N;

  f = normpdf(x/N);
  c = normcdf(x/N);

  printf('  std::vector<double> X = {\n');
  printf('    %6.3f,\n', x/N);
  printf('  };\n\n');

  printf('  std::vector<double> F = {\n');
  printf('    %20.16f,\n', f);
  printf('  };\n\n');

  printf('  std::vector<double> C = {\n');
  printf('    %20.16f,\n', c);
  printf('  };\n\n');

*/

int main()
{
  std::vector<double> X = {
    -6.000,
    -5.990,
    -5.980,
    -5.970,
    -5.960,
    -5.950,
    -5.940,
    -5.930,
    -5.920,
    -5.910,
    -5.900,
    -5.890,
    -5.880,
    -5.870,
    -5.860,
    -5.850,
    -5.840,
    -5.830,
    -5.820,
    -5.810,
    -5.800,
    -5.790,
    -5.780,
    -5.770,
    -5.760,
    -5.750,
    -5.740,
    -5.730,
    -5.720,
    -5.710,
    -5.700,
    -5.690,
    -5.680,
    -5.670,
    -5.660,
    -5.650,
    -5.640,
    -5.630,
    -5.620,
    -5.610,
    -5.600,
    -5.590,
    -5.580,
    -5.570,
    -5.560,
    -5.550,
    -5.540,
    -5.530,
    -5.520,
    -5.510,
    -5.500,
    -5.490,
    -5.480,
    -5.470,
    -5.460,
    -5.450,
    -5.440,
    -5.430,
    -5.420,
    -5.410,
    -5.400,
    -5.390,
    -5.380,
    -5.370,
    -5.360,
    -5.350,
    -5.340,
    -5.330,
    -5.320,
    -5.310,
    -5.300,
    -5.290,
    -5.280,
    -5.270,
    -5.260,
    -5.250,
    -5.240,
    -5.230,
    -5.220,
    -5.210,
    -5.200,
    -5.190,
    -5.180,
    -5.170,
    -5.160,
    -5.150,
    -5.140,
    -5.130,
    -5.120,
    -5.110,
    -5.100,
    -5.090,
    -5.080,
    -5.070,
    -5.060,
    -5.050,
    -5.040,
    -5.030,
    -5.020,
    -5.010,
    -5.000,
    -4.990,
    -4.980,
    -4.970,
    -4.960,
    -4.950,
    -4.940,
    -4.930,
    -4.920,
    -4.910,
    -4.900,
    -4.890,
    -4.880,
    -4.870,
    -4.860,
    -4.850,
    -4.840,
    -4.830,
    -4.820,
    -4.810,
    -4.800,
    -4.790,
    -4.780,
    -4.770,
    -4.760,
    -4.750,
    -4.740,
    -4.730,
    -4.720,
    -4.710,
    -4.700,
    -4.690,
    -4.680,
    -4.670,
    -4.660,
    -4.650,
    -4.640,
    -4.630,
    -4.620,
    -4.610,
    -4.600,
    -4.590,
    -4.580,
    -4.570,
    -4.560,
    -4.550,
    -4.540,
    -4.530,
    -4.520,
    -4.510,
    -4.500,
    -4.490,
    -4.480,
    -4.470,
    -4.460,
    -4.450,
    -4.440,
    -4.430,
    -4.420,
    -4.410,
    -4.400,
    -4.390,
    -4.380,
    -4.370,
    -4.360,
    -4.350,
    -4.340,
    -4.330,
    -4.320,
    -4.310,
    -4.300,
    -4.290,
    -4.280,
    -4.270,
    -4.260,
    -4.250,
    -4.240,
    -4.230,
    -4.220,
    -4.210,
    -4.200,
    -4.190,
    -4.180,
    -4.170,
    -4.160,
    -4.150,
    -4.140,
    -4.130,
    -4.120,
    -4.110,
    -4.100,
    -4.090,
    -4.080,
    -4.070,
    -4.060,
    -4.050,
    -4.040,
    -4.030,
    -4.020,
    -4.010,
    -4.000,
    -3.990,
    -3.980,
    -3.970,
    -3.960,
    -3.950,
    -3.940,
    -3.930,
    -3.920,
    -3.910,
    -3.900,
    -3.890,
    -3.880,
    -3.870,
    -3.860,
    -3.850,
    -3.840,
    -3.830,
    -3.820,
    -3.810,
    -3.800,
    -3.790,
    -3.780,
    -3.770,
    -3.760,
    -3.750,
    -3.740,
    -3.730,
    -3.720,
    -3.710,
    -3.700,
    -3.690,
    -3.680,
    -3.670,
    -3.660,
    -3.650,
    -3.640,
    -3.630,
    -3.620,
    -3.610,
    -3.600,
    -3.590,
    -3.580,
    -3.570,
    -3.560,
    -3.550,
    -3.540,
    -3.530,
    -3.520,
    -3.510,
    -3.500,
    -3.490,
    -3.480,
    -3.470,
    -3.460,
    -3.450,
    -3.440,
    -3.430,
    -3.420,
    -3.410,
    -3.400,
    -3.390,
    -3.380,
    -3.370,
    -3.360,
    -3.350,
    -3.340,
    -3.330,
    -3.320,
    -3.310,
    -3.300,
    -3.290,
    -3.280,
    -3.270,
    -3.260,
    -3.250,
    -3.240,
    -3.230,
    -3.220,
    -3.210,
    -3.200,
    -3.190,
    -3.180,
    -3.170,
    -3.160,
    -3.150,
    -3.140,
    -3.130,
    -3.120,
    -3.110,
    -3.100,
    -3.090,
    -3.080,
    -3.070,
    -3.060,
    -3.050,
    -3.040,
    -3.030,
    -3.020,
    -3.010,
    -3.000,
    -2.990,
    -2.980,
    -2.970,
    -2.960,
    -2.950,
    -2.940,
    -2.930,
    -2.920,
    -2.910,
    -2.900,
    -2.890,
    -2.880,
    -2.870,
    -2.860,
    -2.850,
    -2.840,
    -2.830,
    -2.820,
    -2.810,
    -2.800,
    -2.790,
    -2.780,
    -2.770,
    -2.760,
    -2.750,
    -2.740,
    -2.730,
    -2.720,
    -2.710,
    -2.700,
    -2.690,
    -2.680,
    -2.670,
    -2.660,
    -2.650,
    -2.640,
    -2.630,
    -2.620,
    -2.610,
    -2.600,
    -2.590,
    -2.580,
    -2.570,
    -2.560,
    -2.550,
    -2.540,
    -2.530,
    -2.520,
    -2.510,
    -2.500,
    -2.490,
    -2.480,
    -2.470,
    -2.460,
    -2.450,
    -2.440,
    -2.430,
    -2.420,
    -2.410,
    -2.400,
    -2.390,
    -2.380,
    -2.370,
    -2.360,
    -2.350,
    -2.340,
    -2.330,
    -2.320,
    -2.310,
    -2.300,
    -2.290,
    -2.280,
    -2.270,
    -2.260,
    -2.250,
    -2.240,
    -2.230,
    -2.220,
    -2.210,
    -2.200,
    -2.190,
    -2.180,
    -2.170,
    -2.160,
    -2.150,
    -2.140,
    -2.130,
    -2.120,
    -2.110,
    -2.100,
    -2.090,
    -2.080,
    -2.070,
    -2.060,
    -2.050,
    -2.040,
    -2.030,
    -2.020,
    -2.010,
    -2.000,
    -1.990,
    -1.980,
    -1.970,
    -1.960,
    -1.950,
    -1.940,
    -1.930,
    -1.920,
    -1.910,
    -1.900,
    -1.890,
    -1.880,
    -1.870,
    -1.860,
    -1.850,
    -1.840,
    -1.830,
    -1.820,
    -1.810,
    -1.800,
    -1.790,
    -1.780,
    -1.770,
    -1.760,
    -1.750,
    -1.740,
    -1.730,
    -1.720,
    -1.710,
    -1.700,
    -1.690,
    -1.680,
    -1.670,
    -1.660,
    -1.650,
    -1.640,
    -1.630,
    -1.620,
    -1.610,
    -1.600,
    -1.590,
    -1.580,
    -1.570,
    -1.560,
    -1.550,
    -1.540,
    -1.530,
    -1.520,
    -1.510,
    -1.500,
    -1.490,
    -1.480,
    -1.470,
    -1.460,
    -1.450,
    -1.440,
    -1.430,
    -1.420,
    -1.410,
    -1.400,
    -1.390,
    -1.380,
    -1.370,
    -1.360,
    -1.350,
    -1.340,
    -1.330,
    -1.320,
    -1.310,
    -1.300,
    -1.290,
    -1.280,
    -1.270,
    -1.260,
    -1.250,
    -1.240,
    -1.230,
    -1.220,
    -1.210,
    -1.200,
    -1.190,
    -1.180,
    -1.170,
    -1.160,
    -1.150,
    -1.140,
    -1.130,
    -1.120,
    -1.110,
    -1.100,
    -1.090,
    -1.080,
    -1.070,
    -1.060,
    -1.050,
    -1.040,
    -1.030,
    -1.020,
    -1.010,
    -1.000,
    -0.990,
    -0.980,
    -0.970,
    -0.960,
    -0.950,
    -0.940,
    -0.930,
    -0.920,
    -0.910,
    -0.900,
    -0.890,
    -0.880,
    -0.870,
    -0.860,
    -0.850,
    -0.840,
    -0.830,
    -0.820,
    -0.810,
    -0.800,
    -0.790,
    -0.780,
    -0.770,
    -0.760,
    -0.750,
    -0.740,
    -0.730,
    -0.720,
    -0.710,
    -0.700,
    -0.690,
    -0.680,
    -0.670,
    -0.660,
    -0.650,
    -0.640,
    -0.630,
    -0.620,
    -0.610,
    -0.600,
    -0.590,
    -0.580,
    -0.570,
    -0.560,
    -0.550,
    -0.540,
    -0.530,
    -0.520,
    -0.510,
    -0.500,
    -0.490,
    -0.480,
    -0.470,
    -0.460,
    -0.450,
    -0.440,
    -0.430,
    -0.420,
    -0.410,
    -0.400,
    -0.390,
    -0.380,
    -0.370,
    -0.360,
    -0.350,
    -0.340,
    -0.330,
    -0.320,
    -0.310,
    -0.300,
    -0.290,
    -0.280,
    -0.270,
    -0.260,
    -0.250,
    -0.240,
    -0.230,
    -0.220,
    -0.210,
    -0.200,
    -0.190,
    -0.180,
    -0.170,
    -0.160,
    -0.150,
    -0.140,
    -0.130,
    -0.120,
    -0.110,
    -0.100,
    -0.090,
    -0.080,
    -0.070,
    -0.060,
    -0.050,
    -0.040,
    -0.030,
    -0.020,
    -0.010,
     0.000,
     0.010,
     0.020,
     0.030,
     0.040,
     0.050,
     0.060,
     0.070,
     0.080,
     0.090,
     0.100,
     0.110,
     0.120,
     0.130,
     0.140,
     0.150,
     0.160,
     0.170,
     0.180,
     0.190,
     0.200,
     0.210,
     0.220,
     0.230,
     0.240,
     0.250,
     0.260,
     0.270,
     0.280,
     0.290,
     0.300,
     0.310,
     0.320,
     0.330,
     0.340,
     0.350,
     0.360,
     0.370,
     0.380,
     0.390,
     0.400,
     0.410,
     0.420,
     0.430,
     0.440,
     0.450,
     0.460,
     0.470,
     0.480,
     0.490,
     0.500,
     0.510,
     0.520,
     0.530,
     0.540,
     0.550,
     0.560,
     0.570,
     0.580,
     0.590,
     0.600,
     0.610,
     0.620,
     0.630,
     0.640,
     0.650,
     0.660,
     0.670,
     0.680,
     0.690,
     0.700,
     0.710,
     0.720,
     0.730,
     0.740,
     0.750,
     0.760,
     0.770,
     0.780,
     0.790,
     0.800,
     0.810,
     0.820,
     0.830,
     0.840,
     0.850,
     0.860,
     0.870,
     0.880,
     0.890,
     0.900,
     0.910,
     0.920,
     0.930,
     0.940,
     0.950,
     0.960,
     0.970,
     0.980,
     0.990,
     1.000,
     1.010,
     1.020,
     1.030,
     1.040,
     1.050,
     1.060,
     1.070,
     1.080,
     1.090,
     1.100,
     1.110,
     1.120,
     1.130,
     1.140,
     1.150,
     1.160,
     1.170,
     1.180,
     1.190,
     1.200,
     1.210,
     1.220,
     1.230,
     1.240,
     1.250,
     1.260,
     1.270,
     1.280,
     1.290,
     1.300,
     1.310,
     1.320,
     1.330,
     1.340,
     1.350,
     1.360,
     1.370,
     1.380,
     1.390,
     1.400,
     1.410,
     1.420,
     1.430,
     1.440,
     1.450,
     1.460,
     1.470,
     1.480,
     1.490,
     1.500,
     1.510,
     1.520,
     1.530,
     1.540,
     1.550,
     1.560,
     1.570,
     1.580,
     1.590,
     1.600,
     1.610,
     1.620,
     1.630,
     1.640,
     1.650,
     1.660,
     1.670,
     1.680,
     1.690,
     1.700,
     1.710,
     1.720,
     1.730,
     1.740,
     1.750,
     1.760,
     1.770,
     1.780,
     1.790,
     1.800,
     1.810,
     1.820,
     1.830,
     1.840,
     1.850,
     1.860,
     1.870,
     1.880,
     1.890,
     1.900,
     1.910,
     1.920,
     1.930,
     1.940,
     1.950,
     1.960,
     1.970,
     1.980,
     1.990,
     2.000,
     2.010,
     2.020,
     2.030,
     2.040,
     2.050,
     2.060,
     2.070,
     2.080,
     2.090,
     2.100,
     2.110,
     2.120,
     2.130,
     2.140,
     2.150,
     2.160,
     2.170,
     2.180,
     2.190,
     2.200,
     2.210,
     2.220,
     2.230,
     2.240,
     2.250,
     2.260,
     2.270,
     2.280,
     2.290,
     2.300,
     2.310,
     2.320,
     2.330,
     2.340,
     2.350,
     2.360,
     2.370,
     2.380,
     2.390,
     2.400,
     2.410,
     2.420,
     2.430,
     2.440,
     2.450,
     2.460,
     2.470,
     2.480,
     2.490,
     2.500,
     2.510,
     2.520,
     2.530,
     2.540,
     2.550,
     2.560,
     2.570,
     2.580,
     2.590,
     2.600,
     2.610,
     2.620,
     2.630,
     2.640,
     2.650,
     2.660,
     2.670,
     2.680,
     2.690,
     2.700,
     2.710,
     2.720,
     2.730,
     2.740,
     2.750,
     2.760,
     2.770,
     2.780,
     2.790,
     2.800,
     2.810,
     2.820,
     2.830,
     2.840,
     2.850,
     2.860,
     2.870,
     2.880,
     2.890,
     2.900,
     2.910,
     2.920,
     2.930,
     2.940,
     2.950,
     2.960,
     2.970,
     2.980,
     2.990,
     3.000,
     3.010,
     3.020,
     3.030,
     3.040,
     3.050,
     3.060,
     3.070,
     3.080,
     3.090,
     3.100,
     3.110,
     3.120,
     3.130,
     3.140,
     3.150,
     3.160,
     3.170,
     3.180,
     3.190,
     3.200,
     3.210,
     3.220,
     3.230,
     3.240,
     3.250,
     3.260,
     3.270,
     3.280,
     3.290,
     3.300,
     3.310,
     3.320,
     3.330,
     3.340,
     3.350,
     3.360,
     3.370,
     3.380,
     3.390,
     3.400,
     3.410,
     3.420,
     3.430,
     3.440,
     3.450,
     3.460,
     3.470,
     3.480,
     3.490,
     3.500,
     3.510,
     3.520,
     3.530,
     3.540,
     3.550,
     3.560,
     3.570,
     3.580,
     3.590,
     3.600,
     3.610,
     3.620,
     3.630,
     3.640,
     3.650,
     3.660,
     3.670,
     3.680,
     3.690,
     3.700,
     3.710,
     3.720,
     3.730,
     3.740,
     3.750,
     3.760,
     3.770,
     3.780,
     3.790,
     3.800,
     3.810,
     3.820,
     3.830,
     3.840,
     3.850,
     3.860,
     3.870,
     3.880,
     3.890,
     3.900,
     3.910,
     3.920,
     3.930,
     3.940,
     3.950,
     3.960,
     3.970,
     3.980,
     3.990,
     4.000,
     4.010,
     4.020,
     4.030,
     4.040,
     4.050,
     4.060,
     4.070,
     4.080,
     4.090,
     4.100,
     4.110,
     4.120,
     4.130,
     4.140,
     4.150,
     4.160,
     4.170,
     4.180,
     4.190,
     4.200,
     4.210,
     4.220,
     4.230,
     4.240,
     4.250,
     4.260,
     4.270,
     4.280,
     4.290,
     4.300,
     4.310,
     4.320,
     4.330,
     4.340,
     4.350,
     4.360,
     4.370,
     4.380,
     4.390,
     4.400,
     4.410,
     4.420,
     4.430,
     4.440,
     4.450,
     4.460,
     4.470,
     4.480,
     4.490,
     4.500,
     4.510,
     4.520,
     4.530,
     4.540,
     4.550,
     4.560,
     4.570,
     4.580,
     4.590,
     4.600,
     4.610,
     4.620,
     4.630,
     4.640,
     4.650,
     4.660,
     4.670,
     4.680,
     4.690,
     4.700,
     4.710,
     4.720,
     4.730,
     4.740,
     4.750,
     4.760,
     4.770,
     4.780,
     4.790,
     4.800,
     4.810,
     4.820,
     4.830,
     4.840,
     4.850,
     4.860,
     4.870,
     4.880,
     4.890,
     4.900,
     4.910,
     4.920,
     4.930,
     4.940,
     4.950,
     4.960,
     4.970,
     4.980,
     4.990,
     5.000,
     5.010,
     5.020,
     5.030,
     5.040,
     5.050,
     5.060,
     5.070,
     5.080,
     5.090,
     5.100,
     5.110,
     5.120,
     5.130,
     5.140,
     5.150,
     5.160,
     5.170,
     5.180,
     5.190,
     5.200,
     5.210,
     5.220,
     5.230,
     5.240,
     5.250,
     5.260,
     5.270,
     5.280,
     5.290,
     5.300,
     5.310,
     5.320,
     5.330,
     5.340,
     5.350,
     5.360,
     5.370,
     5.380,
     5.390,
     5.400,
     5.410,
     5.420,
     5.430,
     5.440,
     5.450,
     5.460,
     5.470,
     5.480,
     5.490,
     5.500,
     5.510,
     5.520,
     5.530,
     5.540,
     5.550,
     5.560,
     5.570,
     5.580,
     5.590,
     5.600,
     5.610,
     5.620,
     5.630,
     5.640,
     5.650,
     5.660,
     5.670,
     5.680,
     5.690,
     5.700,
     5.710,
     5.720,
     5.730,
     5.740,
     5.750,
     5.760,
     5.770,
     5.780,
     5.790,
     5.800,
     5.810,
     5.820,
     5.830,
     5.840,
     5.850,
     5.860,
     5.870,
     5.880,
     5.890,
     5.900,
     5.910,
     5.920,
     5.930,
     5.940,
     5.950,
     5.960,
     5.970,
     5.980,
     5.990,
     6.000,
  };

  std::vector<double> F = {
      0.0000000060758828,
      0.0000000064512719,
      0.0000000068491688,
      0.0000000072708798,
      0.0000000077177842,
      0.0000000081913384,
      0.0000000086930800,
      0.0000000092246321,
      0.0000000097877079,
      0.0000000103841157,
      0.0000000110157636,
      0.0000000116846651,
      0.0000000123929443,
      0.0000000131428424,
      0.0000000139367231,
      0.0000000147770796,
      0.0000000156665412,
      0.0000000166078804,
      0.0000000176040203,
      0.0000000186580428,
      0.0000000197731964,
      0.0000000209529051,
      0.0000000222007773,
      0.0000000235206158,
      0.0000000249164270,
      0.0000000263924320,
      0.0000000279530776,
      0.0000000296030473,
      0.0000000313472738,
      0.0000000331909518,
      0.0000000351395509,
      0.0000000371988298,
      0.0000000393748506,
      0.0000000416739946,
      0.0000000441029778,
      0.0000000466688680,
      0.0000000493791023,
      0.0000000522415055,
      0.0000000552643096,
      0.0000000584561736,
      0.0000000618262050,
      0.0000000653839819,
      0.0000000691395761,
      0.0000000731035774,
      0.0000000772871189,
      0.0000000817019038,
      0.0000000863602330,
      0.0000000912750343,
      0.0000000964598928,
      0.0000001019290827,
      0.0000001076976004,
      0.0000001137811998,
      0.0000001201964279,
      0.0000001269606637,
      0.0000001340921572,
      0.0000001416100713,
      0.0000001495345252,
      0.0000001578866395,
      0.0000001666885838,
      0.0000001759636261,
      0.0000001857361845,
      0.0000001960318809,
      0.0000002068775979,
      0.0000002183015369,
      0.0000002303332800,
      0.0000002430038541,
      0.0000002563457973,
      0.0000002703932292,
      0.0000002851819232,
      0.0000003007493831,
      0.0000003171349217,
      0.0000003343797435,
      0.0000003525270313,
      0.0000003716220353,
      0.0000003917121676,
      0.0000004128470989,
      0.0000004350788608,
      0.0000004584619516,
      0.0000004830534469,
      0.0000005089131146,
      0.0000005361035345,
      0.0000005646902235,
      0.0000005947417655,
      0.0000006263299468,
      0.0000006595298969,
      0.0000006944202354,
      0.0000007310832247,
      0.0000007696049288,
      0.0000008100753789,
      0.0000008525887453,
      0.0000008972435162,
      0.0000009441426847,
      0.0000009933939413,
      0.0000010451098764,
      0.0000010994081887,
      0.0000011564119036,
      0.0000012162495989,
      0.0000012790556405,
      0.0000013449704261,
      0.0000014141406396,
      0.0000014867195147,
      0.0000015628671089,
      0.0000016427505880,
      0.0000017265445217,
      0.0000018144311902,
      0.0000019066009031,
      0.0000020032523299,
      0.0000021045928432,
      0.0000022108388746,
      0.0000023222162846,
      0.0000024389607459,
      0.0000025613181409,
      0.0000026895449743,
      0.0000028239088008,
      0.0000029646886685,
      0.0000031121755791,
      0.0000032666729640,
      0.0000034284971784,
      0.0000035979780135,
      0.0000037754592267,
      0.0000039612990910,
      0.0000041558709645,
      0.0000043595638797,
      0.0000045727831539,
      0.0000047959510216,
      0.0000050295072886,
      0.0000052739100096,
      0.0000055296361890,
      0.0000057971825064,
      0.0000060770660671,
      0.0000063698251789,
      0.0000066760201546,
      0.0000069962341433,
      0.0000073310739886,
      0.0000076811711173,
      0.0000080471824565,
      0.0000084297913832,
      0.0000088297087044,
      0.0000092476736700,
      0.0000096844550201,
      0.0000101408520655,
      0.0000106176958050,
      0.0000111158500782,
      0.0000116362127560,
      0.0000121797169703,
      0.0000127473323818,
      0.0000133400664904,
      0.0000139589659852,
      0.0000146051181392,
      0.0000152796522468,
      0.0000159837411069,
      0.0000167186025524,
      0.0000174855010266,
      0.0000182857492095,
      0.0000191207096928,
      0.0000199917967069,
      0.0000209004779005,
      0.0000218482761733,
      0.0000228367715651,
      0.0000238676032002,
      0.0000249424712901,
      0.0000260631391959,
      0.0000272314355510,
      0.0000284492564458,
      0.0000297185676764,
      0.0000310414070579,
      0.0000324198868042,
      0.0000338561959768,
      0.0000353526030018,
      0.0000369114582587,
      0.0000385351967421,
      0.0000402263407973,
      0.0000419875029316,
      0.0000438213887038,
      0.0000457307996916,
      0.0000477186365412,
      0.0000497879020980,
      0.0000519417046222,
      0.0000541832610895,
      0.0000565159005803,
      0.0000589430677565,
      0.0000614683264308,
      0.0000640953632271,
      0.0000668279913367,
      0.0000696701543692,
      0.0000726259303023,
      0.0000756995355302,
      0.0000788953290143,
      0.0000822178165363,
      0.0000856716550562,
      0.0000892616571771,
      0.0000929927957184,
      0.0000968702083987,
      0.0001008992026308,
      0.0001050852604304,
      0.0001094340434398,
      0.0001139513980689,
      0.0001186433607546,
      0.0001235161633410,
      0.0001285762385816,
      0.0001338302257649,
      0.0001392849764658,
      0.0001449475604239,
      0.0001508252715505,
      0.0001569256340655,
      0.0001632564087662,
      0.0001698255994293,
      0.0001766414593476,
      0.0001837124980025,
      0.0001910474878746,
      0.0001986554713928,
      0.0002065457680232,
      0.0002147279815004,
      0.0002232120072001,
      0.0002320080396569,
      0.0002411265802260,
      0.0002505784448909,
      0.0002603747722184,
      0.0002705270314615,
      0.0002810470308100,
      0.0002919469257915,
      0.0003032392278220,
      0.0003149368129075,
      0.0003270529304964,
      0.0003396012124837,
      0.0003525956823674,
      0.0003660507645573,
      0.0003799812938353,
      0.0003944025249692,
      0.0004093301424781,
      0.0004247802705508,
      0.0004407694831151,
      0.0004573148140599,
      0.0004744337676066,
      0.0004921443288329,
      0.0005104649743442,
      0.0005294146830949,
      0.0005490129473570,
      0.0005692797838343,
      0.0005902357449228,
      0.0006119019301138,
      0.0006342999975388,
      0.0006574521756547,
      0.0006813812750669,
      0.0007061107004880,
      0.0007316644628303,
      0.0007580671914287,
      0.0007853441463925,
      0.0008135212310818,
      0.0008426250047069,
      0.0008726826950458,
      0.0009037222112775,
      0.0009357721569275,
      0.0009688618429198,
      0.0010030213007342,
      0.0010382812956614,
      0.0010746733401537,
      0.0011122297072656,
      0.0011509834441785,
      0.0011909683858061,
      0.0012322191684730,
      0.0012747712436618,
      0.0013186608918227,
      0.0013639252362389,
      0.0014106022569414,
      0.0014587308046667,
      0.0015083506148503,
      0.0015595023216477,
      0.0016122274719771,
      0.0016665685395746,
      0.0017225689390537,
      0.0017802730399619,
      0.0018397261808243,
      0.0019009746831661,
      0.0019640658655044,
      0.0020290480572998,
      0.0020959706128579,
      0.0021648839251711,
      0.0022358394396885,
      0.0023088896680065,
      0.0023840882014648,
      0.0024614897246407,
      0.0025411500287265,
      0.0026231260247810,
      0.0027074757568407,
      0.0027942584148794,
      0.0028835343476034,
      0.0029753650750683,
      0.0030698133011047,
      0.0031669429255401,
      0.0032668190561999,
      0.0033695080206775,
      0.0034750773778549,
      0.0035835959291624,
      0.0036951337295590,
      0.0038097620982218,
      0.0039275536289248,
      0.0040485822000944,
      0.0041729229845240,
      0.0043006524587304,
      0.0044318484119380,
      0.0045665899546701,
      0.0047049575269340,
      0.0048470329059789,
      0.0049928992136124,
      0.0051426409230539,
      0.0052963438653110,
      0.0054540952350565,
      0.0056159835959910,
      0.0057820988856695,
      0.0059525324197759,
      0.0061273768958237,
      0.0063067263962659,
      0.0064906763909934,
      0.0066793237392026,
      0.0068727666906140,
      0.0070711048860194,
      0.0072744393571412,
      0.0074828725257806,
      0.0076965082022373,
      0.0079154515829800,
      0.0081398092475460,
      0.0083696891546530,
      0.0086052006374997,
      0.0088464543982372,
      0.0090935625015911,
      0.0093466383676123,
      0.0096057967635396,
      0.0098711537947511,
      0.0101428268947871,
      0.0104209348144226,
      0.0107055976097722,
      0.0109969366294056,
      0.0112950745004561,
      0.0116001351137026,
      0.0119122436076052,
      0.0122315263512780,
      0.0125581109263782,
      0.0128921261078953,
      0.0132337018438214,
      0.0135829692336856,
      0.0139400605059358,
      0.0143051089941497,
      0.0146782491120600,
      0.0150596163273774,
      0.0154493471343952,
      0.0158475790253608,
      0.0162544504606005,
      0.0166701008373811,
      0.0170946704574970,
      0.0175283004935685,
      0.0179711329540396,
      0.0184233106468620,
      0.0188849771418562,
      0.0193562767317370,
      0.0198373543917953,
      0.0203283557382258,
      0.0208294269850922,
      0.0213407148999228,
      0.0218623667579294,
      0.0223945302948429,
      0.0229373536583607,
      0.0234909853582014,
      0.0240555742147630,
      0.0246312693063825,
      0.0252182199151944,
      0.0258165754715877,
      0.0264264854972617,
      0.0270480995468818,
      0.0276815671483366,
      0.0283270377416012,
      0.0289846606162094,
      0.0296545848473413,
      0.0303369592305316,
      0.0310319322150083,
      0.0317396518356674,
      0.0324602656436974,
      0.0331939206358611,
      0.0339407631824492,
      0.0347009389539188,
      0.0354745928462314,
      0.0362618689049062,
      0.0370629102478065,
      0.0378778589866775,
      0.0387068561474556,
      0.0395500415893702,
      0.0404075539228603,
      0.0412795304263304,
      0.0421661069617703,
      0.0430674178892657,
      0.0439835959804272,
      0.0449147723307671,
      0.0458610762710549,
      0.0468226352776832,
      0.0477995748820770,
      0.0487920185791828,
      0.0498000877350708,
      0.0508239014936912,
      0.0518635766828206,
      0.0529192277192403,
      0.0539909665131881,
      0.0550789023721258,
      0.0561831419038680,
      0.0573037889191171,
      0.0584409443334515,
      0.0595947060688161,
      0.0607651689545648,
      0.0619524246281052,
      0.0631565614351987,
      0.0643776643299694,
      0.0656158147746766,
      0.0668710906393072,
      0.0681435661010446,
      0.0694333115436742,
      0.0707403934569834,
      0.0720648743362180,
      0.0734068125816569,
      0.0747662623983676,
      0.0761432736962073,
      0.0775378919901340,
      0.0789501583008941,
      0.0803801090561542,
      0.0818277759921428,
      0.0832931860558745,
      0.0847763613080222,
      0.0862773188265115,
      0.0877960706109056,
      0.0893326234876550,
      0.0908869790162829,
      0.0924591333965807,
      0.0940490773768869,
      0.0956567961635240,
      0.0972822693314675,
      0.0989254707363237,
      0.1005863684276906,
      0.1022649245639780,
      0.1039610953287642,
      0.1056748308487636,
      0.1074060751134838,
      0.1091547658966474,
      0.1109208346794555,
      0.1127042065757706,
      0.1145048002592924,
      0.1163225278928071,
      0.1181572950595823,
      0.1200090006969856,
      0.1218775370324018,
      0.1237627895215231,
      0.1256646367890882,
      0.1275829505721419,
      0.1295175956658917,
      0.1314684298722310,
      0.1334353039510023,
      0.1354180615740713,
      0.1374165392822818,
      0.1394305664453603,
      0.1414599652248388,
      0.1435045505400624,
      0.1455641300373476,
      0.1476385040623557,
      0.1497274656357449,
      0.1518308004321617,
      0.1539482867626337,
      0.1560796955604208,
      0.1582247903703830,
      0.1603833273419196,
      0.1625550552255341,
      0.1647397153730768,
      0.1669370417417138,
      0.1691467609016724,
      0.1713685920478074,
      0.1736022470150330,
      0.1758474302976624,
      0.1781038390726936,
      0.1803711632270803,
      0.1826490853890219,
      0.1849372809633053,
      0.1872354181707296,
      0.1895431580916402,
      0.1918601547135994,
      0.1941860549832130,
      0.1965204988621365,
      0.1988631193872759,
      0.2012135427351974,
      0.2035713882907594,
      0.2059362687199748,
      0.2083077900471084,
      0.2106855517360153,
      0.2130691467757178,
      0.2154581617702197,
      0.2178521770325505,
      0.2202507666830333,
      0.2226534987517611,
      0.2250599352852697,
      0.2274696324573859,
      0.2298821406842330,
      0.2322970047433662,
      0.2347137638970118,
      0.2371319520193796,
      0.2395510977280134,
      0.2419707245191434,
      0.2443903509069996,
      0.2468094905670427,
      0.2492276524830659,
      0.2516443410981171,
      0.2540590564691890,
      0.2564712944256203,
      0.2588805467311488,
      0.2612863012495532,
      0.2636880421138181,
      0.2660852498987548,
      0.2684774017970024,
      0.2708639717983380,
      0.2732444308722162,
      0.2756182471534567,
      0.2779848861309965,
      0.2803438108396206,
      0.2826944820545803,
      0.2850363584890073,
      0.2873688969940283,
      0.2896915527614827,
      0.2920037795291414,
      0.2943050297883251,
      0.2965947549938157,
      0.2988724057759528,
      0.3011374321548044,
      0.3033892837563001,
      0.3056274100302099,
      0.3078512604698529,
      0.3100602848334161,
      0.3122539333667613,
      0.3144316570275973,
      0.3165929077108928,
      0.3187371384754015,
      0.3208638037711725,
      0.3229723596679143,
      0.3250622640840822,
      0.3271329770165545,
      0.3291839607707648,
      0.3312146801911530,
      0.3332246028917997,
      0.3352131994871061,
      0.3371799438223806,
      0.3391243132041922,
      0.3410457886303526,
      0.3429438550193839,
      0.3448180014393333,
      0.3466677213357917,
      0.3484925127589745,
      0.3502918785897258,
      0.3520653267642995,
      0.3538123704977797,
      0.3555325285059971,
      0.3572253252258009,
      0.3588902910335446,
      0.3605269624616479,
      0.3621348824130922,
      0.3637136003737134,
      0.3652626726221539,
      0.3667816624373361,
      0.3682701403033233,
      0.3697276841114324,
      0.3711538793594660,
      0.3725483193479334,
      0.3739106053731284,
      0.3752403469169379,
      0.3765371618332539,
      0.3778006765308646,
      0.3790305261527017,
      0.3802263547513249,
      0.3813878154605241,
      0.3825145706629240,
      0.3836062921534786,
      0.3846626612987428,
      0.3856833691918161,
      0.3866681168028492,
      0.3876166151250142,
      0.3885285853158359,
      0.3894037588337904,
      0.3902418775700743,
      0.3910426939754559,
      0.3918059711821211,
      0.3925314831204289,
      0.3932190146304972,
      0.3938683615685408,
      0.3944793309078889,
      0.3950517408346113,
      0.3955854208376874,
      0.3960802117936561,
      0.3965359660456858,
      0.3969525474770118,
      0.3973298315786883,
      0.3976677055116088,
      0.3979660681627510,
      0.3982248301956069,
      0.3984439140947640,
      0.3986232542046050,
      0.3987627967620997,
      0.3988624999236661,
      0.3989223337860822,
      0.3989422804014327,
      0.3989223337860822,
      0.3988624999236661,
      0.3987627967620997,
      0.3986232542046050,
      0.3984439140947640,
      0.3982248301956069,
      0.3979660681627510,
      0.3976677055116088,
      0.3973298315786883,
      0.3969525474770118,
      0.3965359660456858,
      0.3960802117936561,
      0.3955854208376874,
      0.3950517408346113,
      0.3944793309078889,
      0.3938683615685408,
      0.3932190146304972,
      0.3925314831204289,
      0.3918059711821211,
      0.3910426939754559,
      0.3902418775700743,
      0.3894037588337904,
      0.3885285853158359,
      0.3876166151250142,
      0.3866681168028492,
      0.3856833691918161,
      0.3846626612987428,
      0.3836062921534786,
      0.3825145706629240,
      0.3813878154605241,
      0.3802263547513249,
      0.3790305261527017,
      0.3778006765308646,
      0.3765371618332539,
      0.3752403469169379,
      0.3739106053731284,
      0.3725483193479334,
      0.3711538793594660,
      0.3697276841114324,
      0.3682701403033233,
      0.3667816624373361,
      0.3652626726221539,
      0.3637136003737134,
      0.3621348824130922,
      0.3605269624616479,
      0.3588902910335446,
      0.3572253252258009,
      0.3555325285059971,
      0.3538123704977797,
      0.3520653267642995,
      0.3502918785897258,
      0.3484925127589745,
      0.3466677213357917,
      0.3448180014393333,
      0.3429438550193839,
      0.3410457886303526,
      0.3391243132041922,
      0.3371799438223806,
      0.3352131994871061,
      0.3332246028917997,
      0.3312146801911530,
      0.3291839607707648,
      0.3271329770165545,
      0.3250622640840822,
      0.3229723596679143,
      0.3208638037711725,
      0.3187371384754015,
      0.3165929077108928,
      0.3144316570275973,
      0.3122539333667613,
      0.3100602848334161,
      0.3078512604698529,
      0.3056274100302099,
      0.3033892837563001,
      0.3011374321548044,
      0.2988724057759528,
      0.2965947549938157,
      0.2943050297883251,
      0.2920037795291414,
      0.2896915527614827,
      0.2873688969940283,
      0.2850363584890073,
      0.2826944820545803,
      0.2803438108396206,
      0.2779848861309965,
      0.2756182471534567,
      0.2732444308722162,
      0.2708639717983380,
      0.2684774017970024,
      0.2660852498987548,
      0.2636880421138181,
      0.2612863012495532,
      0.2588805467311488,
      0.2564712944256203,
      0.2540590564691890,
      0.2516443410981171,
      0.2492276524830659,
      0.2468094905670427,
      0.2443903509069996,
      0.2419707245191434,
      0.2395510977280134,
      0.2371319520193796,
      0.2347137638970118,
      0.2322970047433662,
      0.2298821406842330,
      0.2274696324573859,
      0.2250599352852697,
      0.2226534987517611,
      0.2202507666830333,
      0.2178521770325505,
      0.2154581617702197,
      0.2130691467757178,
      0.2106855517360153,
      0.2083077900471084,
      0.2059362687199748,
      0.2035713882907594,
      0.2012135427351974,
      0.1988631193872759,
      0.1965204988621365,
      0.1941860549832130,
      0.1918601547135994,
      0.1895431580916402,
      0.1872354181707296,
      0.1849372809633053,
      0.1826490853890219,
      0.1803711632270803,
      0.1781038390726936,
      0.1758474302976624,
      0.1736022470150330,
      0.1713685920478074,
      0.1691467609016724,
      0.1669370417417138,
      0.1647397153730768,
      0.1625550552255341,
      0.1603833273419196,
      0.1582247903703830,
      0.1560796955604208,
      0.1539482867626337,
      0.1518308004321617,
      0.1497274656357449,
      0.1476385040623557,
      0.1455641300373476,
      0.1435045505400624,
      0.1414599652248388,
      0.1394305664453603,
      0.1374165392822818,
      0.1354180615740713,
      0.1334353039510023,
      0.1314684298722310,
      0.1295175956658917,
      0.1275829505721419,
      0.1256646367890882,
      0.1237627895215231,
      0.1218775370324018,
      0.1200090006969856,
      0.1181572950595823,
      0.1163225278928071,
      0.1145048002592924,
      0.1127042065757706,
      0.1109208346794555,
      0.1091547658966474,
      0.1074060751134838,
      0.1056748308487636,
      0.1039610953287642,
      0.1022649245639780,
      0.1005863684276906,
      0.0989254707363237,
      0.0972822693314675,
      0.0956567961635240,
      0.0940490773768869,
      0.0924591333965807,
      0.0908869790162829,
      0.0893326234876550,
      0.0877960706109056,
      0.0862773188265115,
      0.0847763613080222,
      0.0832931860558745,
      0.0818277759921428,
      0.0803801090561542,
      0.0789501583008941,
      0.0775378919901340,
      0.0761432736962073,
      0.0747662623983676,
      0.0734068125816569,
      0.0720648743362180,
      0.0707403934569834,
      0.0694333115436742,
      0.0681435661010446,
      0.0668710906393072,
      0.0656158147746766,
      0.0643776643299694,
      0.0631565614351987,
      0.0619524246281052,
      0.0607651689545648,
      0.0595947060688161,
      0.0584409443334515,
      0.0573037889191171,
      0.0561831419038680,
      0.0550789023721258,
      0.0539909665131881,
      0.0529192277192403,
      0.0518635766828206,
      0.0508239014936912,
      0.0498000877350708,
      0.0487920185791828,
      0.0477995748820770,
      0.0468226352776832,
      0.0458610762710549,
      0.0449147723307671,
      0.0439835959804272,
      0.0430674178892657,
      0.0421661069617703,
      0.0412795304263304,
      0.0404075539228603,
      0.0395500415893702,
      0.0387068561474556,
      0.0378778589866775,
      0.0370629102478065,
      0.0362618689049062,
      0.0354745928462314,
      0.0347009389539188,
      0.0339407631824492,
      0.0331939206358611,
      0.0324602656436974,
      0.0317396518356674,
      0.0310319322150083,
      0.0303369592305316,
      0.0296545848473413,
      0.0289846606162094,
      0.0283270377416012,
      0.0276815671483366,
      0.0270480995468818,
      0.0264264854972617,
      0.0258165754715877,
      0.0252182199151944,
      0.0246312693063825,
      0.0240555742147630,
      0.0234909853582014,
      0.0229373536583607,
      0.0223945302948429,
      0.0218623667579294,
      0.0213407148999228,
      0.0208294269850922,
      0.0203283557382258,
      0.0198373543917953,
      0.0193562767317370,
      0.0188849771418562,
      0.0184233106468620,
      0.0179711329540396,
      0.0175283004935685,
      0.0170946704574970,
      0.0166701008373811,
      0.0162544504606005,
      0.0158475790253608,
      0.0154493471343952,
      0.0150596163273774,
      0.0146782491120600,
      0.0143051089941497,
      0.0139400605059358,
      0.0135829692336856,
      0.0132337018438214,
      0.0128921261078953,
      0.0125581109263782,
      0.0122315263512780,
      0.0119122436076052,
      0.0116001351137026,
      0.0112950745004561,
      0.0109969366294056,
      0.0107055976097722,
      0.0104209348144226,
      0.0101428268947871,
      0.0098711537947511,
      0.0096057967635396,
      0.0093466383676123,
      0.0090935625015911,
      0.0088464543982372,
      0.0086052006374997,
      0.0083696891546530,
      0.0081398092475460,
      0.0079154515829800,
      0.0076965082022373,
      0.0074828725257806,
      0.0072744393571412,
      0.0070711048860194,
      0.0068727666906140,
      0.0066793237392026,
      0.0064906763909934,
      0.0063067263962659,
      0.0061273768958237,
      0.0059525324197759,
      0.0057820988856695,
      0.0056159835959910,
      0.0054540952350565,
      0.0052963438653110,
      0.0051426409230539,
      0.0049928992136124,
      0.0048470329059789,
      0.0047049575269340,
      0.0045665899546701,
      0.0044318484119380,
      0.0043006524587304,
      0.0041729229845240,
      0.0040485822000944,
      0.0039275536289248,
      0.0038097620982218,
      0.0036951337295590,
      0.0035835959291624,
      0.0034750773778549,
      0.0033695080206775,
      0.0032668190561999,
      0.0031669429255401,
      0.0030698133011047,
      0.0029753650750683,
      0.0028835343476034,
      0.0027942584148794,
      0.0027074757568407,
      0.0026231260247810,
      0.0025411500287265,
      0.0024614897246407,
      0.0023840882014648,
      0.0023088896680065,
      0.0022358394396885,
      0.0021648839251711,
      0.0020959706128579,
      0.0020290480572998,
      0.0019640658655044,
      0.0019009746831661,
      0.0018397261808243,
      0.0017802730399619,
      0.0017225689390537,
      0.0016665685395746,
      0.0016122274719771,
      0.0015595023216477,
      0.0015083506148503,
      0.0014587308046667,
      0.0014106022569414,
      0.0013639252362389,
      0.0013186608918227,
      0.0012747712436618,
      0.0012322191684730,
      0.0011909683858061,
      0.0011509834441785,
      0.0011122297072656,
      0.0010746733401537,
      0.0010382812956614,
      0.0010030213007342,
      0.0009688618429198,
      0.0009357721569275,
      0.0009037222112775,
      0.0008726826950458,
      0.0008426250047069,
      0.0008135212310818,
      0.0007853441463925,
      0.0007580671914287,
      0.0007316644628303,
      0.0007061107004880,
      0.0006813812750669,
      0.0006574521756547,
      0.0006342999975388,
      0.0006119019301138,
      0.0005902357449228,
      0.0005692797838343,
      0.0005490129473570,
      0.0005294146830949,
      0.0005104649743442,
      0.0004921443288329,
      0.0004744337676066,
      0.0004573148140599,
      0.0004407694831151,
      0.0004247802705508,
      0.0004093301424781,
      0.0003944025249692,
      0.0003799812938353,
      0.0003660507645573,
      0.0003525956823674,
      0.0003396012124837,
      0.0003270529304964,
      0.0003149368129075,
      0.0003032392278220,
      0.0002919469257915,
      0.0002810470308100,
      0.0002705270314615,
      0.0002603747722184,
      0.0002505784448909,
      0.0002411265802260,
      0.0002320080396569,
      0.0002232120072001,
      0.0002147279815004,
      0.0002065457680232,
      0.0001986554713928,
      0.0001910474878746,
      0.0001837124980025,
      0.0001766414593476,
      0.0001698255994293,
      0.0001632564087662,
      0.0001569256340655,
      0.0001508252715505,
      0.0001449475604239,
      0.0001392849764658,
      0.0001338302257649,
      0.0001285762385816,
      0.0001235161633410,
      0.0001186433607546,
      0.0001139513980689,
      0.0001094340434398,
      0.0001050852604304,
      0.0001008992026308,
      0.0000968702083987,
      0.0000929927957184,
      0.0000892616571771,
      0.0000856716550562,
      0.0000822178165363,
      0.0000788953290143,
      0.0000756995355302,
      0.0000726259303023,
      0.0000696701543692,
      0.0000668279913367,
      0.0000640953632271,
      0.0000614683264308,
      0.0000589430677565,
      0.0000565159005803,
      0.0000541832610895,
      0.0000519417046222,
      0.0000497879020980,
      0.0000477186365412,
      0.0000457307996916,
      0.0000438213887038,
      0.0000419875029316,
      0.0000402263407973,
      0.0000385351967421,
      0.0000369114582587,
      0.0000353526030018,
      0.0000338561959768,
      0.0000324198868042,
      0.0000310414070579,
      0.0000297185676764,
      0.0000284492564458,
      0.0000272314355510,
      0.0000260631391959,
      0.0000249424712901,
      0.0000238676032002,
      0.0000228367715651,
      0.0000218482761733,
      0.0000209004779005,
      0.0000199917967069,
      0.0000191207096928,
      0.0000182857492095,
      0.0000174855010266,
      0.0000167186025524,
      0.0000159837411069,
      0.0000152796522468,
      0.0000146051181392,
      0.0000139589659852,
      0.0000133400664904,
      0.0000127473323818,
      0.0000121797169703,
      0.0000116362127560,
      0.0000111158500782,
      0.0000106176958050,
      0.0000101408520655,
      0.0000096844550201,
      0.0000092476736700,
      0.0000088297087044,
      0.0000084297913832,
      0.0000080471824565,
      0.0000076811711173,
      0.0000073310739886,
      0.0000069962341433,
      0.0000066760201546,
      0.0000063698251789,
      0.0000060770660671,
      0.0000057971825064,
      0.0000055296361890,
      0.0000052739100096,
      0.0000050295072886,
      0.0000047959510216,
      0.0000045727831539,
      0.0000043595638797,
      0.0000041558709645,
      0.0000039612990910,
      0.0000037754592267,
      0.0000035979780135,
      0.0000034284971784,
      0.0000032666729640,
      0.0000031121755791,
      0.0000029646886685,
      0.0000028239088008,
      0.0000026895449743,
      0.0000025613181409,
      0.0000024389607459,
      0.0000023222162846,
      0.0000022108388746,
      0.0000021045928432,
      0.0000020032523299,
      0.0000019066009031,
      0.0000018144311902,
      0.0000017265445217,
      0.0000016427505880,
      0.0000015628671089,
      0.0000014867195147,
      0.0000014141406396,
      0.0000013449704261,
      0.0000012790556405,
      0.0000012162495989,
      0.0000011564119036,
      0.0000010994081887,
      0.0000010451098764,
      0.0000009933939413,
      0.0000009441426847,
      0.0000008972435162,
      0.0000008525887453,
      0.0000008100753789,
      0.0000007696049288,
      0.0000007310832247,
      0.0000006944202354,
      0.0000006595298969,
      0.0000006263299468,
      0.0000005947417655,
      0.0000005646902235,
      0.0000005361035345,
      0.0000005089131146,
      0.0000004830534469,
      0.0000004584619516,
      0.0000004350788608,
      0.0000004128470989,
      0.0000003917121676,
      0.0000003716220353,
      0.0000003525270313,
      0.0000003343797435,
      0.0000003171349217,
      0.0000003007493831,
      0.0000002851819232,
      0.0000002703932292,
      0.0000002563457973,
      0.0000002430038541,
      0.0000002303332800,
      0.0000002183015369,
      0.0000002068775979,
      0.0000001960318809,
      0.0000001857361845,
      0.0000001759636261,
      0.0000001666885838,
      0.0000001578866395,
      0.0000001495345252,
      0.0000001416100713,
      0.0000001340921572,
      0.0000001269606637,
      0.0000001201964279,
      0.0000001137811998,
      0.0000001076976004,
      0.0000001019290827,
      0.0000000964598928,
      0.0000000912750343,
      0.0000000863602330,
      0.0000000817019038,
      0.0000000772871189,
      0.0000000731035774,
      0.0000000691395761,
      0.0000000653839819,
      0.0000000618262050,
      0.0000000584561736,
      0.0000000552643096,
      0.0000000522415055,
      0.0000000493791023,
      0.0000000466688680,
      0.0000000441029778,
      0.0000000416739946,
      0.0000000393748506,
      0.0000000371988298,
      0.0000000351395509,
      0.0000000331909518,
      0.0000000313472738,
      0.0000000296030473,
      0.0000000279530776,
      0.0000000263924320,
      0.0000000249164270,
      0.0000000235206158,
      0.0000000222007773,
      0.0000000209529051,
      0.0000000197731964,
      0.0000000186580428,
      0.0000000176040203,
      0.0000000166078804,
      0.0000000156665412,
      0.0000000147770796,
      0.0000000139367231,
      0.0000000131428424,
      0.0000000123929443,
      0.0000000116846651,
      0.0000000110157636,
      0.0000000103841157,
      0.0000000097877079,
      0.0000000092246321,
      0.0000000086930800,
      0.0000000081913384,
      0.0000000077177842,
      0.0000000072708798,
      0.0000000068491688,
      0.0000000064512719,
      0.0000000060758828,
  };

  std::vector<double> C = {
      0.0000000009865876,
      0.0000000010492052,
      0.0000000011156881,
      0.0000000011862679,
      0.0000000012611897,
      0.0000000013407124,
      0.0000000014251104,
      0.0000000015146734,
      0.0000000016097081,
      0.0000000017105387,
      0.0000000018175079,
      0.0000000019309781,
      0.0000000020513324,
      0.0000000021789757,
      0.0000000023143359,
      0.0000000024578651,
      0.0000000026100411,
      0.0000000027713688,
      0.0000000029423814,
      0.0000000031236421,
      0.0000000033157460,
      0.0000000035193212,
      0.0000000037350313,
      0.0000000039635766,
      0.0000000042056968,
      0.0000000044621725,
      0.0000000047338276,
      0.0000000050215317,
      0.0000000053262027,
      0.0000000056488087,
      0.0000000059903714,
      0.0000000063519686,
      0.0000000067347371,
      0.0000000071398760,
      0.0000000075686498,
      0.0000000080223919,
      0.0000000085025082,
      0.0000000090104811,
      0.0000000095478729,
      0.0000000101163308,
      0.0000000107175903,
      0.0000000113534806,
      0.0000000120259292,
      0.0000000127369668,
      0.0000000134887325,
      0.0000000142834799,
      0.0000000151235823,
      0.0000000160115394,
      0.0000000169499831,
      0.0000000179416849,
      0.0000000189895625,
      0.0000000200966871,
      0.0000000212662918,
      0.0000000225017789,
      0.0000000238067292,
      0.0000000251849101,
      0.0000000266402856,
      0.0000000281770260,
      0.0000000297995177,
      0.0000000315123745,
      0.0000000333204485,
      0.0000000352288419,
      0.0000000372429194,
      0.0000000393683211,
      0.0000000416109759,
      0.0000000439771159,
      0.0000000464732908,
      0.0000000491063833,
      0.0000000518836260,
      0.0000000548126175,
      0.0000000579013404,
      0.0000000611581800,
      0.0000000645919433,
      0.0000000682118794,
      0.0000000720277008,
      0.0000000760496052,
      0.0000000802882986,
      0.0000000847550199,
      0.0000000894615654,
      0.0000000944203157,
      0.0000000996442632,
      0.0000001051470403,
      0.0000001109429501,
      0.0000001170469974,
      0.0000001234749212,
      0.0000001302432295,
      0.0000001373692344,
      0.0000001448710893,
      0.0000001527678283,
      0.0000001610794061,
      0.0000001698267407,
      0.0000001790317572,
      0.0000001887174342,
      0.0000001989078511,
      0.0000002096282390,
      0.0000002209050323,
      0.0000002327659230,
      0.0000002452399181,
      0.0000002583573976,
      0.0000002721501773,
      0.0000002866515719,
      0.0000003018964625,
      0.0000003179213662,
      0.0000003347645083,
      0.0000003524658982,
      0.0000003710674080,
      0.0000003906128543,
      0.0000004111480838,
      0.0000004327210619,
      0.0000004553819648,
      0.0000004791832766,
      0.0000005041798884,
      0.0000005304292030,
      0.0000005579912432,
      0.0000005869287645,
      0.0000006173073720,
      0.0000006491956429,
      0.0000006826652526,
      0.0000007177911069,
      0.0000007546514791,
      0.0000007933281520,
      0.0000008339065659,
      0.0000008764759729,
      0.0000009211295962,
      0.0000009679647960,
      0.0000010170832426,
      0.0000010685910945,
      0.0000011225991854,
      0.0000011792232165,
      0.0000012385839574,
      0.0000013008074539,
      0.0000013660252446,
      0.0000014343745844,
      0.0000015059986776,
      0.0000015810469190,
      0.0000016596751444,
      0.0000017420458903,
      0.0000018283286635,
      0.0000019187002200,
      0.0000020133448548,
      0.0000021124547025,
      0.0000022162300481,
      0.0000023248796499,
      0.0000024386210738,
      0.0000025576810395,
      0.0000026822957796,
      0.0000028127114117,
      0.0000029491843229,
      0.0000030919815690,
      0.0000032413812874,
      0.0000033976731247,
      0.0000035611586796,
      0.0000037321519605,
      0.0000039109798603,
      0.0000040979826466,
      0.0000042935144700,
      0.0000044979438886,
      0.0000047116544119,
      0.0000049350450625,
      0.0000051685309572,
      0.0000054125439077,
      0.0000056675330418,
      0.0000059339654456,
      0.0000062123268269,
      0.0000065031222010,
      0.0000068068765993,
      0.0000071241358015,
      0.0000074554670914,
      0.0000078014600381,
      0.0000081627273028,
      0.0000085399054710,
      0.0000089336559128,
      0.0000093446656702,
      0.0000097736483729,
      0.0000102213451840,
      0.0000106885257749,
      0.0000111759893321,
      0.0000116845655947,
      0.0000122151159253,
      0.0000127685344137,
      0.0000133457490159,
      0.0000139477227269,
      0.0000145754547909,
      0.0000152299819480,
      0.0000159123797191,
      0.0000166237637297,
      0.0000173652910736,
      0.0000181381617181,
      0.0000189436199506,
      0.0000197829558682,
      0.0000206575069125,
      0.0000215686594482,
      0.0000225178503885,
      0.0000235065688686,
      0.0000245363579664,
      0.0000256088164740,
      0.0000267256007195,
      0.0000278884264406,
      0.0000290990707119,
      0.0000303593739266,
      0.0000316712418331,
      0.0000330366476294,
      0.0000344576341151,
      0.0000359363159029,
      0.0000374748816911,
      0.0000390755965978,
      0.0000407408045586,
      0.0000424729307888,
      0.0000442744843121,
      0.0000461480605562,
      0.0000480963440176,
      0.0000501221109962,
      0.0000522282324018,
      0.0000544176766337,
      0.0000566935125343,
      0.0000590589124189,
      0.0000615171551833,
      0.0000640716294889,
      0.0000667258370297,
      0.0000694833958799,
      0.0000723480439251,
      0.0000753236423787,
      0.0000784141793836,
      0.0000816237737027,
      0.0000849566784980,
      0.0000884172852008,
      0.0000920101274741,
      0.0000957398852689,
      0.0000996113889759,
      0.0001036296236740,
      0.0001077997334774,
      0.0001121270259822,
      0.0001166169768154,
      0.0001212752342854,
      0.0001261076241385,
      0.0001311201544205,
      0.0001363190204458,
      0.0001417106098758,
      0.0001473015079075,
      0.0001530985025738,
      0.0001591085901575,
      0.0001653389807201,
      0.0001717971037459,
      0.0001784906139048,
      0.0001854273969333,
      0.0001926155756356,
      0.0002000635160073,
      0.0002077798334806,
      0.0002157733992947,
      0.0002240533469911,
      0.0002326290790355,
      0.0002415102735678,
      0.0002507068912805,
      0.0002602291824275,
      0.0002700876939635,
      0.0002802932768162,
      0.0002908570932907,
      0.0003017906246086,
      0.0003131056785812,
      0.0003248143974189,
      0.0003369292656769,
      0.0003494631183380,
      0.0003624291490330,
      0.0003758409184001,
      0.0003897123625820,
      0.0004040578018640,
      0.0004188919494504,
      0.0004342299203817,
      0.0004500872405921,
      0.0004664798561075,
      0.0004834241423838,
      0.0005009369137857,
      0.0005190354332070,
      0.0005377374218297,
      0.0005570610690246,
      0.0005770250423908,
      0.0005976484979344,
      0.0006189510903868,
      0.0006409529836601,
      0.0006636748614400,
      0.0006871379379158,
      0.0007113639686454,
      0.0007363752615539,
      0.0007621946880672,
      0.0007888456943756,
      0.0008163523128286,
      0.0008447391734586,
      0.0008740315156316,
      0.0009042551998223,
      0.0009354367195141,
      0.0009676032132184,
      0.0010007824766140,
      0.0010350029748028,
      0.0010702938546789,
      0.0011066849574092,
      0.0011442068310227,
      0.0011828907431044,
      0.0012227686935923,
      0.0012638734276723,
      0.0013062384487695,
      0.0013498980316301,
      0.0013948872354923,
      0.0014412419173400,
      0.0014889987452375,
      0.0015381952117381,
      0.0015888696473649,
      0.0016410612341570,
      0.0016948100192773,
      0.0017501569286761,
      0.0018071437808064,
      0.0018658133003840,
      0.0019262091321879,
      0.0019883758548943,
      0.0020523589949398,
      0.0021182050404046,
      0.0021859614549132,
      0.0022556766915423,
      0.0023274002067316,
      0.0024011824741893,
      0.0024770749987859,
      0.0025551303304279,
      0.0026354020779050,
      0.0027179449227013,
      0.0028028146327650,
      0.0028900680762261,
      0.0029797632350546,
      0.0030719592186505,
      0.0031667162773578,
      0.0032640958158913,
      0.0033641604066692,
      0.0034669738030407,
      0.0035726009523997,
      0.0036811080091750,
      0.0037925623476855,
      0.0039070325748528,
      0.0040245885427583,
      0.0041453013610360,
      0.0042692434090894,
      0.0043964883481213,
      0.0045271111329673,
      0.0046611880237188,
      0.0047987965971262,
      0.0049400157577706,
      0.0050849257489910,
      0.0052336081635558,
      0.0053861459540667,
      0.0055426234430826,
      0.0057031263329507,
      0.0058677417153326,
      0.0060365580804127,
      0.0062096653257761,
      0.0063871547649432,
      0.0065691191355468,
      0.0067556526071407,
      0.0069468507886243,
      0.0071428107352714,
      0.0073436309553484,
      0.0075494114163092,
      0.0077602535505536,
      0.0079762602607337,
      0.0081975359245961,
      0.0084241863993457,
      0.0086563190255166,
      0.0088940426303368,
      0.0091374675305727,
      0.0093867055348386,
      0.0096418699453583,
      0.0099030755591643,
      0.0101704386687197,
      0.0104440770619511,
      0.0107241100216758,
      0.0110106583244114,
      0.0113038442385528,
      0.0116037915219035,
      0.0119106254185471,
      0.0122244726550447,
      0.0125454614359466,
      0.0128737214386020,
      0.0132093838072563,
      0.0135525811464200,
      0.0139034475134986,
      0.0142621184106689,
      0.0146287307759893,
      0.0150034229737322,
      0.0153863347839255,
      0.0157776073910905,
      0.0161773833721661,
      0.0165858066836050,
      0.0170030226476328,
      0.0174291779376571,
      0.0178644205628166,
      0.0183088998516590,
      0.0187627664349378,
      0.0192261722275173,
      0.0196992704093769,
      0.0201822154057044,
      0.0206751628660701,
      0.0211782696426723,
      0.0216916937676468,
      0.0222155944294315,
      0.0227501319481792,
      0.0232954677502118,
      0.0238517643415085,
      0.0244191852802226,
      0.0249978951482204,
      0.0255880595216386,
      0.0261898449404527,
      0.0268034188770550,
      0.0274289497038368,
      0.0280666066597725,
      0.0287165598160018,
      0.0293789800404094,
      0.0300540389611998,
      0.0307419089294660,
      0.0314427629807527,
      0.0321567747956137,
      0.0328841186591639,
      0.0336249694196283,
      0.0343795024458900,
      0.0351478935840388,
      0.0359303191129258,
      0.0367269556987263,
      0.0375379803485168,
      0.0383635703628713,
      0.0392039032874827,
      0.0400591568638171,
      0.0409295089788074,
      0.0418151376135950,
      0.0427162207913289,
      0.0436329365240319,
      0.0445654627585431,
      0.0455139773215498,
      0.0464786578637201,
      0.0474596818029473,
      0.0484572262667228,
      0.0494714680336481,
      0.0505025834741037,
      0.0515507484900894,
      0.0526161384542520,
      0.0536989281481197,
      0.0547992916995580,
      0.0559174025194694,
      0.0570534332377542,
      0.0582075556385530,
      0.0593799405947931,
      0.0605707580020590,
      0.0617801767118119,
      0.0630083644639784,
      0.0642554878189358,
      0.0655217120889165,
      0.0668072012688581,
      0.0681121179667255,
      0.0694366233333318,
      0.0707808769916856,
      0.0721450369658938,
      0.0735292596096483,
      0.0749336995343271,
      0.0763585095367391,
      0.0778038405265464,
      0.0792698414533924,
      0.0807566592337711,
      0.0822644386776690,
      0.0837933224150143,
      0.0853434508219670,
      0.0869149619470850,
      0.0885079914374020,
      0.0901226724644525,
      0.0917591356502808,
      0.0934175089934718,
      0.0950979177952390,
      0.0968004845856103,
      0.0985253290497479,
      0.1002725679544421,
      0.1020423150748191,
      0.1038346811213004,
      0.1056497736668553,
      0.1074876970745869,
      0.1093485524256919,
      0.1112324374478346,
      0.1131394464439773,
      0.1150696702217083,
      0.1170231960231088,
      0.1190001074552007,
      0.1210004844210182,
      0.1230244030513434,
      0.1250719356371503,
      0.1271431505627983,
      0.1292381122400179,
      0.1313568810427307,
      0.1334995132427472,
      0.1356660609463827,
      0.1378565720320355,
      0.1400710900887691,
      0.1423096543559392,
      0.1445722996639096,
      0.1468590563758960,
      0.1491699503309814,
      0.1515050027883437,
      0.1538642303727348,
      0.1562476450212546,
      0.1586552539314571,
      0.1610870595108309,
      0.1635430593276924,
      0.1660232460635296,
      0.1685276074668378,
      0.1710561263084819,
      0.1736087803386246,
      0.1761855422452580,
      0.1787863796143717,
      0.1814112548917972,
      0.1840601253467595,
      0.1867329430371726,
      0.1894296547767121,
      0.1921502021036962,
      0.1948945212518084,
      0.1976625431226924,
      0.2004541932604497,
      0.2032693918280684,
      0.2061080535858131,
      0.2089700878716016,
      0.2118553985833967,
      0.2147638841636371,
      0.2176954375857332,
      0.2206499463426496,
      0.2236272924375994,
      0.2266273523768682,
      0.2296499971647906,
      0.2326950923008974,
      0.2357624977792512,
      0.2388520680899867,
      0.2419636522230731,
      0.2450970936743095,
      0.2482522304535705,
      0.2514288950953101,
      0.2546269146713361,
      0.2578461108058647,
      0.2610862996928616,
      0.2643472921156775,
      0.2676288934689831,
      0.2709309037830057,
      0.2742531177500736,
      0.2775953247534649,
      0.2809573088985644,
      0.2843388490463242,
      0.2877397188490270,
      0.2911596867883464,
      0.2945985162156980,
      0.2980559653948764,
      0.3015317875469662,
      0.3050257308975194,
      0.3085375387259869,
      0.3120669494173905,
      0.3156136965162226,
      0.3191775087825559,
      0.3227581102503477,
      0.3263552202879200,
      0.3299685536605936,
      0.3335978205954577,
      0.3372427268482495,
      0.3409029737723226,
      0.3445782583896758,
      0.3482682734640176,
      0.3519727075758372,
      0.3556912451994533,
      0.3594235667820088,
      0.3631693488243810,
      0.3669282639639719,
      0.3706999810593465,
      0.3744841652766800,
      0.3782804781779807,
      0.3820885778110474,
      0.3859081188011227,
      0.3897387524442028,
      0.3935801268019605,
      0.3974318867982395,
      0.4012936743170763,
      0.4051651283022042,
      0.4090458848579941,
      0.4129355773517854,
      0.4168338365175577,
      0.4207402905608970,
      0.4246545652652046,
      0.4285762840990993,
      0.4325050683249616,
      0.4364405371085672,
      0.4403823076297575,
      0.4443299951940936,
      0.4482832133454389,
      0.4522415739794162,
      0.4562046874576832,
      0.4601721627229710,
      0.4641436074148279,
      0.4681186279860126,
      0.4720968298194789,
      0.4760778173458932,
      0.4800611941616275,
      0.4840465631471693,
      0.4880335265858873,
      0.4920216862830980,
      0.4960106436853684,
      0.5000000000000000,
      0.5039893563146316,
      0.5079783137169019,
      0.5119664734141126,
      0.5159534368528308,
      0.5199388058383725,
      0.5239221826541068,
      0.5279031701805211,
      0.5318813720139873,
      0.5358563925851721,
      0.5398278372770290,
      0.5437953125423168,
      0.5477584260205839,
      0.5517167866545611,
      0.5556700048059064,
      0.5596176923702425,
      0.5635594628914329,
      0.5674949316750384,
      0.5714237159009007,
      0.5753454347347955,
      0.5792597094391030,
      0.5831661634824423,
      0.5870644226482146,
      0.5909541151420059,
      0.5948348716977958,
      0.5987063256829237,
      0.6025681132017605,
      0.6064198731980395,
      0.6102612475557972,
      0.6140918811988774,
      0.6179114221889526,
      0.6217195218220193,
      0.6255158347233201,
      0.6293000189406535,
      0.6330717360360281,
      0.6368306511756190,
      0.6405764332179913,
      0.6443087548005467,
      0.6480272924241628,
      0.6517317265359823,
      0.6554217416103242,
      0.6590970262276774,
      0.6627572731517505,
      0.6664021794045423,
      0.6700314463394064,
      0.6736447797120799,
      0.6772418897496523,
      0.6808224912174441,
      0.6843863034837774,
      0.6879330505826095,
      0.6914624612740131,
      0.6949742691024806,
      0.6984682124530338,
      0.7019440346051236,
      0.7054014837843019,
      0.7088403132116536,
      0.7122602811509730,
      0.7156611509536759,
      0.7190426911014356,
      0.7224046752465351,
      0.7257468822499265,
      0.7290690962169943,
      0.7323711065310170,
      0.7356527078843225,
      0.7389137003071384,
      0.7421538891941353,
      0.7453730853286639,
      0.7485711049046899,
      0.7517477695464294,
      0.7549029063256905,
      0.7580363477769270,
      0.7611479319100132,
      0.7642375022207488,
      0.7673049076991025,
      0.7703500028352094,
      0.7733726476231317,
      0.7763727075624005,
      0.7793500536573503,
      0.7823045624142668,
      0.7852361158363629,
      0.7881446014166034,
      0.7910299121283983,
      0.7938919464141869,
      0.7967306081719316,
      0.7995458067395502,
      0.8023374568773076,
      0.8051054787481916,
      0.8078497978963037,
      0.8105703452232879,
      0.8132670569628273,
      0.8159398746532405,
      0.8185887451082028,
      0.8212136203856283,
      0.8238144577547420,
      0.8263912196613754,
      0.8289438736915182,
      0.8314723925331622,
      0.8339767539364704,
      0.8364569406723077,
      0.8389129404891691,
      0.8413447460685429,
      0.8437523549787453,
      0.8461357696272651,
      0.8484949972116562,
      0.8508300496690185,
      0.8531409436241040,
      0.8554277003360904,
      0.8576903456440608,
      0.8599289099112309,
      0.8621434279679645,
      0.8643339390536173,
      0.8665004867572528,
      0.8686431189572692,
      0.8707618877599821,
      0.8728568494372018,
      0.8749280643628496,
      0.8769755969486566,
      0.8789995155789818,
      0.8809998925447993,
      0.8829768039768913,
      0.8849303297782917,
      0.8868605535560227,
      0.8887675625521654,
      0.8906514475743080,
      0.8925123029254131,
      0.8943502263331446,
      0.8961653188786995,
      0.8979576849251809,
      0.8997274320455579,
      0.9014746709502521,
      0.9031995154143897,
      0.9049020822047609,
      0.9065824910065282,
      0.9082408643497192,
      0.9098773275355475,
      0.9114920085625979,
      0.9130850380529150,
      0.9146565491780330,
      0.9162066775849858,
      0.9177355613223310,
      0.9192433407662289,
      0.9207301585466076,
      0.9221961594734536,
      0.9236414904632608,
      0.9250663004656730,
      0.9264707403903516,
      0.9278549630341062,
      0.9292191230083144,
      0.9305633766666683,
      0.9318878820332746,
      0.9331927987311419,
      0.9344782879110836,
      0.9357445121810641,
      0.9369916355360215,
      0.9382198232881881,
      0.9394292419979410,
      0.9406200594052070,
      0.9417924443614469,
      0.9429465667622458,
      0.9440825974805305,
      0.9452007083004420,
      0.9463010718518803,
      0.9473838615457479,
      0.9484492515099106,
      0.9494974165258963,
      0.9505285319663519,
      0.9515427737332771,
      0.9525403181970526,
      0.9535213421362799,
      0.9544860226784502,
      0.9554345372414570,
      0.9563670634759680,
      0.9572837792086710,
      0.9581848623864051,
      0.9590704910211927,
      0.9599408431361829,
      0.9607960967125173,
      0.9616364296371287,
      0.9624620196514831,
      0.9632730443012737,
      0.9640696808870742,
      0.9648521064159612,
      0.9656204975541101,
      0.9663750305803717,
      0.9671158813408361,
      0.9678432252043863,
      0.9685572370192472,
      0.9692580910705341,
      0.9699459610388002,
      0.9706210199595906,
      0.9712834401839981,
      0.9719333933402274,
      0.9725710502961632,
      0.9731965811229450,
      0.9738101550595473,
      0.9744119404783613,
      0.9750021048517795,
      0.9755808147197774,
      0.9761482356584915,
      0.9767045322497881,
      0.9772498680518208,
      0.9777844055705684,
      0.9783083062323532,
      0.9788217303573277,
      0.9793248371339299,
      0.9798177845942956,
      0.9803007295906231,
      0.9807738277724827,
      0.9812372335650622,
      0.9816911001483410,
      0.9821355794371834,
      0.9825708220623429,
      0.9829969773523672,
      0.9834141933163950,
      0.9838226166278339,
      0.9842223926089095,
      0.9846136652160745,
      0.9849965770262678,
      0.9853712692240107,
      0.9857378815893311,
      0.9860965524865014,
      0.9864474188535800,
      0.9867906161927438,
      0.9871262785613980,
      0.9874545385640534,
      0.9877755273449553,
      0.9880893745814530,
      0.9883962084780965,
      0.9886961557614472,
      0.9889893416755886,
      0.9892758899783242,
      0.9895559229380489,
      0.9898295613312803,
      0.9900969244408357,
      0.9903581300546417,
      0.9906132944651614,
      0.9908625324694273,
      0.9911059573696632,
      0.9913436809744834,
      0.9915758136006543,
      0.9918024640754038,
      0.9920237397392663,
      0.9922397464494463,
      0.9924505885836908,
      0.9926563690446516,
      0.9928571892647285,
      0.9930531492113757,
      0.9932443473928594,
      0.9934308808644532,
      0.9936128452350568,
      0.9937903346742238,
      0.9939634419195873,
      0.9941322582846674,
      0.9942968736670493,
      0.9944573765569173,
      0.9946138540459333,
      0.9947663918364442,
      0.9949150742510090,
      0.9950599842422293,
      0.9952012034028738,
      0.9953388119762813,
      0.9954728888670327,
      0.9956035116518787,
      0.9957307565909106,
      0.9958546986389639,
      0.9959754114572417,
      0.9960929674251472,
      0.9962074376523145,
      0.9963188919908250,
      0.9964273990476002,
      0.9965330261969594,
      0.9966358395933308,
      0.9967359041841087,
      0.9968332837226422,
      0.9969280407813496,
      0.9970202367649454,
      0.9971099319237738,
      0.9971971853672350,
      0.9972820550772987,
      0.9973645979220951,
      0.9974448696695720,
      0.9975229250012141,
      0.9975988175258107,
      0.9976725997932685,
      0.9977443233084576,
      0.9978140385450868,
      0.9978817949595954,
      0.9979476410050603,
      0.9980116241451057,
      0.9980737908678121,
      0.9981341866996160,
      0.9981928562191935,
      0.9982498430713239,
      0.9983051899807227,
      0.9983589387658430,
      0.9984111303526352,
      0.9984618047882620,
      0.9985110012547626,
      0.9985587580826600,
      0.9986051127645077,
      0.9986501019683699,
      0.9986937615512306,
      0.9987361265723277,
      0.9987772313064077,
      0.9988171092568956,
      0.9988557931689773,
      0.9988933150425907,
      0.9989297061453211,
      0.9989649970251971,
      0.9989992175233859,
      0.9990323967867817,
      0.9990645632804859,
      0.9990957448001777,
      0.9991259684843684,
      0.9991552608265414,
      0.9991836476871714,
      0.9992111543056245,
      0.9992378053119327,
      0.9992636247384461,
      0.9992886360313546,
      0.9993128620620841,
      0.9993363251385601,
      0.9993590470163399,
      0.9993810489096132,
      0.9994023515020656,
      0.9994229749576092,
      0.9994429389309754,
      0.9994622625781703,
      0.9994809645667930,
      0.9994990630862143,
      0.9995165758576162,
      0.9995335201438924,
      0.9995499127594079,
      0.9995657700796183,
      0.9995811080505497,
      0.9995959421981360,
      0.9996102876374180,
      0.9996241590816000,
      0.9996375708509669,
      0.9996505368816621,
      0.9996630707343231,
      0.9996751856025812,
      0.9996868943214188,
      0.9996982093753913,
      0.9997091429067092,
      0.9997197067231838,
      0.9997299123060365,
      0.9997397708175725,
      0.9997492931087195,
      0.9997584897264321,
      0.9997673709209645,
      0.9997759466530090,
      0.9997842266007053,
      0.9997922201665194,
      0.9997999364839927,
      0.9998073844243643,
      0.9998145726030667,
      0.9998215093860952,
      0.9998282028962541,
      0.9998346610192799,
      0.9998408914098424,
      0.9998469014974263,
      0.9998526984920926,
      0.9998582893901242,
      0.9998636809795542,
      0.9998688798455795,
      0.9998738923758616,
      0.9998787247657146,
      0.9998833830231846,
      0.9998878729740177,
      0.9998922002665226,
      0.9998963703763259,
      0.9999003886110240,
      0.9999042601147311,
      0.9999079898725259,
      0.9999115827147992,
      0.9999150433215021,
      0.9999183762262973,
      0.9999215858206164,
      0.9999246763576213,
      0.9999276519560749,
      0.9999305166041201,
      0.9999332741629703,
      0.9999359283705112,
      0.9999384828448168,
      0.9999409410875810,
      0.9999433064874658,
      0.9999455823233663,
      0.9999477717675982,
      0.9999498778890038,
      0.9999519036559824,
      0.9999538519394437,
      0.9999557255156879,
      0.9999575270692113,
      0.9999592591954415,
      0.9999609244034022,
      0.9999625251183090,
      0.9999640636840972,
      0.9999655423658850,
      0.9999669633523706,
      0.9999683287581669,
      0.9999696406260734,
      0.9999709009292881,
      0.9999721115735595,
      0.9999732743992805,
      0.9999743911835259,
      0.9999754636420336,
      0.9999764934311314,
      0.9999774821496115,
      0.9999784313405519,
      0.9999793424930875,
      0.9999802170441318,
      0.9999810563800494,
      0.9999818618382819,
      0.9999826347089263,
      0.9999833762362703,
      0.9999840876202809,
      0.9999847700180520,
      0.9999854245452091,
      0.9999860522772731,
      0.9999866542509841,
      0.9999872314655862,
      0.9999877848840747,
      0.9999883154344053,
      0.9999888240106679,
      0.9999893114742251,
      0.9999897786548160,
      0.9999902263516270,
      0.9999906553343298,
      0.9999910663440872,
      0.9999914600945290,
      0.9999918372726972,
      0.9999921985399619,
      0.9999925445329086,
      0.9999928758641985,
      0.9999931931234006,
      0.9999934968777990,
      0.9999937876731732,
      0.9999940660345544,
      0.9999943324669581,
      0.9999945874560923,
      0.9999948314690428,
      0.9999950649549375,
      0.9999952883455882,
      0.9999955020561114,
      0.9999957064855300,
      0.9999959020173533,
      0.9999960890201397,
      0.9999962678480395,
      0.9999964388413204,
      0.9999966023268753,
      0.9999967586187126,
      0.9999969080184310,
      0.9999970508156771,
      0.9999971872885883,
      0.9999973177042204,
      0.9999974423189606,
      0.9999975613789263,
      0.9999976751203501,
      0.9999977837699519,
      0.9999978875452975,
      0.9999979866551452,
      0.9999980812997801,
      0.9999981716713364,
      0.9999982579541097,
      0.9999983403248557,
      0.9999984189530811,
      0.9999984940013225,
      0.9999985656254156,
      0.9999986339747554,
      0.9999986991925461,
      0.9999987614160426,
      0.9999988207767835,
      0.9999988774008146,
      0.9999989314089055,
      0.9999989829167575,
      0.9999990320352040,
      0.9999990788704038,
      0.9999991235240271,
      0.9999991660934341,
      0.9999992066718481,
      0.9999992453485208,
      0.9999992822088930,
      0.9999993173347475,
      0.9999993508043571,
      0.9999993826926280,
      0.9999994130712355,
      0.9999994420087568,
      0.9999994695707970,
      0.9999994958201116,
      0.9999995208167234,
      0.9999995446180352,
      0.9999995672789381,
      0.9999995888519162,
      0.9999996093871457,
      0.9999996289325921,
      0.9999996475341019,
      0.9999996652354918,
      0.9999996820786338,
      0.9999996981035375,
      0.9999997133484281,
      0.9999997278498227,
      0.9999997416426024,
      0.9999997547600820,
      0.9999997672340769,
      0.9999997790949677,
      0.9999997903717610,
      0.9999998010921489,
      0.9999998112825659,
      0.9999998209682428,
      0.9999998301732593,
      0.9999998389205939,
      0.9999998472321717,
      0.9999998551289107,
      0.9999998626307657,
      0.9999998697567705,
      0.9999998765250787,
      0.9999998829530026,
      0.9999998890570498,
      0.9999998948529597,
      0.9999999003557368,
      0.9999999055796843,
      0.9999999105384346,
      0.9999999152449801,
      0.9999999197117014,
      0.9999999239503948,
      0.9999999279722992,
      0.9999999317881206,
      0.9999999354080568,
      0.9999999388418200,
      0.9999999420986596,
      0.9999999451873826,
      0.9999999481163739,
      0.9999999508936167,
      0.9999999535267092,
      0.9999999560228841,
      0.9999999583890240,
      0.9999999606316790,
      0.9999999627570807,
      0.9999999647711582,
      0.9999999666795515,
      0.9999999684876255,
      0.9999999702004823,
      0.9999999718229741,
      0.9999999733597144,
      0.9999999748150900,
      0.9999999761932709,
      0.9999999774982210,
      0.9999999787337082,
      0.9999999799033129,
      0.9999999810104375,
      0.9999999820583151,
      0.9999999830500169,
      0.9999999839884606,
      0.9999999848764176,
      0.9999999857165202,
      0.9999999865112675,
      0.9999999872630332,
      0.9999999879740707,
      0.9999999886465194,
      0.9999999892824097,
      0.9999999898836692,
      0.9999999904521271,
      0.9999999909895190,
      0.9999999914974917,
      0.9999999919776081,
      0.9999999924313503,
      0.9999999928601240,
      0.9999999932652629,
      0.9999999936480314,
      0.9999999940096286,
      0.9999999943511914,
      0.9999999946737973,
      0.9999999949784683,
      0.9999999952661724,
      0.9999999955378276,
      0.9999999957943032,
      0.9999999960364234,
      0.9999999962649687,
      0.9999999964806788,
      0.9999999966842540,
      0.9999999968763579,
      0.9999999970576187,
      0.9999999972286312,
      0.9999999973899589,
      0.9999999975421350,
      0.9999999976856642,
      0.9999999978210243,
      0.9999999979486676,
      0.9999999980690220,
      0.9999999981824922,
      0.9999999982894613,
      0.9999999983902919,
      0.9999999984853266,
      0.9999999985748896,
      0.9999999986592876,
      0.9999999987388103,
      0.9999999988137320,
      0.9999999988843119,
      0.9999999989507948,
      0.9999999990134123,
  };

  std::vector<double> Tc, Tp;
  for (double x : X) {
    double cumulative{}, probability{};
    NormalDistribution(x, cumulative, probability);
    Tc.push_back(cumulative);
    Tp.push_back(probability);
  }

  double maxc = 0, sumc = 0, diffc {};
  for (std::size_t i=0; i<C.size(); i++) {
    diffc = Tc[i] - C[i];
    sumc += diffc;
    if (abs(diffc) > abs(maxc)) maxc = diffc;
  }
  sumc /= Tp.size();

  double maxf = 0, sumf = 0, difff {};
  for (std::size_t i=0; i<F.size(); i++) {
    difff = Tp[i] - F[i];
    sumf += difff;
    if (abs(difff) > abs(maxf)) maxf = difff;
  }
  sumf /= Tp.size();

  cout << "Normal distribution - cumulative distribution function\n" << endl;
  cout << "diff max = " << maxc << "  avg = " << sumc << "\n\n";

  cout << "Normal distribution - probability density function\n" << endl;
  cout << "diff max = " << maxf << "  avg = " << sumf << endl;

  
  return max(abs(maxc), abs(maxf)) < 1e-12 ? 0 : 1;
}
