/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_INES_BUILDER
    Description : Build INES installation files from CLASS_METADATA object
    Author      : David Martnez Oliveira
    Date        : 26/02/2000
-----------------------------------------------------
  REVISIONS :
  * 2002, Aug, 8th
  * Save version information
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EDMA_INES_BUILDER
***************************************************
*/
 
/*
***************************************************
  Method Declaration for class 
***************************************************
*/
 
ESint32 EDMAPROC 
EDMA_INES_BUILDERbuildU32Z (OBJID IdObj,OBJID id,EPChar fname)
{
  FILE      *f;
  EUint32   i;
  ESint32   major_version, minor_version;
  EChar     temp[256];

  f=fopen(fname,"wt");
  if (f==NULL)
    {
      edma_printf_obj (IdObj,"Can't open file %s for writting",fname);
      return 1;
    }
  
  edma_rprop3 (id,"ClassName",temp);
  fprintf (f,"ClassName=%s",temp);
  edma_rprop3 (id,"NameSpace",temp);
  fprintf (f,"\nNameSpace=%s",temp);
  edma_rprop3 (id,"Machine",temp);
  fprintf (f,"\nMachine=%s",temp);
  edma_rprop3 (id,"OperatingSystem",temp);
  fprintf (f,"\nOperatingSystem=%s",temp);
  edma_rprop3 (id,"ModuleName" ,temp);
  fprintf (f,"\nImplementation=%s",temp);
  edma_rprop3 (id,"SIUProxy",temp);
  if (strcmp(temp,"NONE")!=0)
    fprintf (f,"\nSIUProxy=%s",temp);
  edma_rprop3 (id,"IDFParser",temp);
  fprintf (f,"\nIDFParser=%s",temp);
  edma_rprop3 (id,"IsSIUProxy",&i);
  if (i)
    fprintf (f,"\nIsSIUProxy=%ld",i);
  edma_rprop3 (id,"IsIDFParser",&i);
  if (i)
    fprintf (f,"\nIsIDFParser=%ld",i);
  edma_rprop3 (id,"IsEMI",&i);
  if (i)
    fprintf (f,"\nIsEMI=%ld",i);
  edma_rprop3 (id, "MajorVersion", &major_version);
  fprintf (f, "\nMajorVer=%ld", major_version);
  edma_rprop3 (id, "MinorVersion", &minor_version);
  fprintf (f, "\nMinorVer=%ld", minor_version);
  
  fprintf (f,"\n");
  fclose (f);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
