/*
 * This file is part of LibEuFin.
 * Copyright (C) 2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

package tech.libeufin.ebisync

import io.ktor.client.*
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.client.plugins.*
import io.ktor.client.plugins.api.*
import io.ktor.client.statement.*
import io.ktor.server.application.*
import io.ktor.http.*
import io.ktor.util.*
import tech.libeufin.ebics.*
import tech.libeufin.ebisync.*
import tech.libeufin.ebisync.db.Database
import tech.libeufin.ebisync.api.*
import tech.libeufin.ebisync.cli.*
import tech.libeufin.common.*
import tech.libeufin.common.api.*
import java.security.Key
import java.time.*
import java.time.format.DateTimeFormatter
import javax.crypto.Mac
import javax.crypto.spec.SecretKeySpec
import kotlinx.coroutines.runBlocking
import java.util.Base64
import com.github.ajalt.clikt.core.main
import kotlinx.serialization.Serializable
import kotlinx.serialization.Contextual
import java.nio.file.Path
import org.slf4j.Logger
import org.slf4j.LoggerFactory


fun main(args: Array<String>) {
    setupSecurityProperties()
    setupSecurityProperties()
    LibeufinEbisync().main(args)
}

fun Application.ebisyncApi(auth: AuthMethod, client: EbicsClient, spa: Path) = talerApi(LoggerFactory.getLogger("libeufin-ebisync-api")) {
    syncApi(auth, client, spa)
}

@Serializable
data class TaskStatus(
    @Contextual
    val last_successfull: Instant? = null,
    @Contextual
    val last_trial: Instant? = null
)