/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * $Id: DVMap.java,v 1.1 2001/11/07 22:37:07 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998,1999 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel;

/**
 * Provides the information about defined dynamic variables.
 * <P> Additionally to DVResolver it allows to translate variable names into
 * constants of Java primitive types at compile-time. See the section of the
 * manual on dynamic variables.
 */
public abstract class DVMap implements DVResolver {

  /**
   * This method is used to translate the variable name of type String to
   * a constant of another type.
   * <P> The performance of the compiled code can be sometimes improved
   * by letting it not to deal with strings. For example, in older JEL <=0.9.8
   * this method was absent, and, if the underlying representation of the
   * dynamic variables storage was an array, the translation of variable name
   * (represented by String) into integer index had to happen at run-time,
   * taking up the valuable processor cycles. Defining the proper 
   * DVResolver.translate one can perform the translation 
   * "variable name(String)"->"slot number(int)" at compile
   * time. There can be also other clever ways of using translation to
   * improve performance even if variables are not stored in an array or
   * vector.
   * <P> The default implementation provides the identity translation, which
   * simulates the behaviour of older versions of JEL.
   * <P>Introducing this method breaks the source code compatibility 
   * (requiring to add an identity translation) with version 0.9.8. The binary
   * compatibility is preserved, so that old code compiled against 0.9.8 will
   * run unchanged with 0.9.9 (or later up to JEL 1.0, where the workaround
   * will be removed), but the old code will not compile until the identity
   * translation is added. This incompatibility is the price to pay for
   * DVResolver being an interface.
   * 
   * @since 0.9.9
   * @param name Name of the variable to be translated.
   * @return Object representing the translated name, this object must be
   * either a reflection type wrapping a primitive (e.g. java.lang.Integer,
   * java.lang.Byte) or String. No other object is allowed, othwerwise an
   * exception will emerge at compile-time. This limitation is due to Java 
   * class file format not allowing to store constants of types other than
   * specified above.
   */
  public Object translate(String name) {
    return name;
  };

};
