/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript.qa.drivers;

import com.netscape.javascript.qa.drivers.LiveConnectEnv;
import com.netscape.javascript.qa.drivers.TestDriver;
import com.netscape.javascript.qa.drivers.TestFile;
import com.netscape.javascript.qa.drivers.TestSuite;
import java.io.File;
import java.io.FileOutputStream;

public class LiveConnectDrv
extends TestDriver {
    public LiveConnectDrv(String[] stringArray) {
        super(stringArray);
        this.setSuffix(".class");
    }

    public synchronized void executeSuite(TestSuite testSuite) {
        TestDriver.p("LiveConnectDrv.executeSuite " + testSuite.name);
        if (this.EXECUTABLE != null) {
            this.generateHelperFile();
        }
        int n = 0;
        while (n < testSuite.size()) {
            TestSuite testSuite2 = testSuite;
            synchronized (testSuite2) {
                LiveConnectEnv liveConnectEnv;
                TestFile testFile = (TestFile)testSuite.elementAt(n);
                TestDriver.p(testFile.name);
                LiveConnectEnv liveConnectEnv2 = liveConnectEnv = new LiveConnectEnv(testFile, testSuite, this);
                synchronized (liveConnectEnv2) {
                    liveConnectEnv.runTest();
                    liveConnectEnv.close();
                    liveConnectEnv = null;
                    if (!testFile.passed) {
                        testSuite.passed = false;
                    }
                }
            }
            ++n;
        }
        TestDriver.writeSuiteResult(testSuite, this.OUTPUT_DIRECTORY);
        TestDriver.writeSuiteSummary(testSuite, this.OUTPUT_DIRECTORY);
    }

    public void generateHelperFile() {
        try {
            this.HELPER_FUNCTIONS = new File(this.OUTPUT_DIRECTORY, "helper.js");
            TestDriver.p("HELPER FUNCTIONS FILE IS " + this.HELPER_FUNCTIONS);
            FileOutputStream fileOutputStream = new FileOutputStream(this.HELPER_FUNCTIONS);
            fileOutputStream.write(("var OUTPUT_DIRECTORY = \"" + this.OUTPUT_DIRECTORY + "\";").getBytes());
            fileOutputStream.write("var OUTPUT_FILE = arguments[1];".getBytes());
            fileOutputStream.write("var TestClassName = arguments[0];".getBytes());
            fileOutputStream.write("var TestClass = eval( TestClassName );".getBytes());
            fileOutputStream.write("var testclass = new TestClass();".getBytes());
            fileOutputStream.write("testclass.run();".getBytes());
            fileOutputStream.write("quit();".getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            TestDriver.p("generateHelperFile threw " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void getCases(TestSuite testSuite) {
        TestDriver.enablePrivileges();
        File file = new File(testSuite.filePath);
        String[] stringArray = file.list();
        String string = "Packages.com.netscape.javascript.qa.liveconnect." + testSuite.name + ".";
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(this.getSuffix())) {
                TestFile testFile = new TestFile(stringArray[n], String.valueOf(string) + stringArray[n].substring(0, stringArray[n].length() - this.getSuffix().length()));
                TestDriver.p(testFile.filePath);
                testSuite.addElement(testFile);
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        LiveConnectDrv liveConnectDrv = new LiveConnectDrv(stringArray);
        liveConnectDrv.start();
    }

    public boolean processOptions() {
        int n = this.ARGS.length;
        if (this.ARGS[0].startsWith("-")) {
            int n2 = 0;
            while (n2 < this.ARGS.length) {
                if (this.ARGS[n2].equals("-d")) {
                    File file;
                    if (this.ARGS[n2].endsWith(File.separator)) {
                        File file2 = new File(this.ARGS[++n2]);
                        file = file2;
                    } else {
                        file = this.TEST_DIRECTORY = new File(String.valueOf(this.ARGS[++n2]) + File.separator);
                    }
                    if (!this.TEST_DIRECTORY.isDirectory()) {
                        TestDriver.p("error:  " + this.TEST_DIRECTORY.getAbsolutePath() + " is not a directory.");
                        return false;
                    }
                } else {
                    if (this.ARGS[n2].equals("-s")) {
                        this.FILES = new String[20];
                        int n3 = ++n2;
                        int n4 = 0;
                        while (n3 < this.ARGS.length) {
                            if (this.ARGS[n3].startsWith("-")) break;
                            this.FILES[n4++] = this.ARGS[n3];
                            ++n3;
                        }
                    }
                    if (this.ARGS[n2].equals("-h")) {
                        this.HELPER_FUNCTIONS = new File(this.ARGS[++n2]);
                        if (!this.HELPER_FUNCTIONS.isFile()) {
                            TestDriver.p("error:  " + this.HELPER_FUNCTIONS.getAbsolutePath() + " file not found.");
                            return false;
                        }
                    }
                    if (this.ARGS[n2].equals("-o")) {
                        String string;
                        this.OUTPUT_DIRECTORY = new File((string = this.ARGS[++n2]).endsWith(File.separator) ? string : String.valueOf(string) + File.separator);
                        this.OUTPUT_DIRECTORY.mkdirs();
                        if (!this.OUTPUT_DIRECTORY.exists() || !this.OUTPUT_DIRECTORY.isDirectory()) {
                            TestDriver.p("error:  " + this.OUTPUT_DIRECTORY.getAbsolutePath() + " could not create directory.");
                            return false;
                        }
                    }
                    if (this.ARGS[n2].equals("-p")) {
                        this.OPT_LEVEL = Integer.parseInt(this.ARGS[++n2]);
                    }
                    if (this.ARGS[n2].equals("-db")) {
                        this.DEBUG_LEVEL = Integer.parseInt(this.ARGS[++n2]);
                        this.OPT_LEVEL = 0;
                    }
                    if (this.ARGS[n2].equals("-e")) {
                        this.EXECUTABLE = this.ARGS[++n2];
                    }
                }
                ++n2;
            }
            return true;
        }
        switch (this.ARGS.length) {
            case 0: {
                TestDriver.p("error:  specify location of JavaScript tests");
                return false;
            }
            case 1: {
                TestDriver.p("error:  specify location of JavaScript HELPER_FUNCTIONS file");
                return false;
            }
            case 2: {
                this.TEST_DIRECTORY = this.ARGS[0].endsWith(File.separator) ? new File(this.ARGS[0]) : new File(String.valueOf(this.ARGS[0]) + File.separator);
                this.HELPER_FUNCTIONS = new File(this.ARGS[1]);
                if (!this.TEST_DIRECTORY.isDirectory()) {
                    TestDriver.p("error:  " + this.TEST_DIRECTORY.getAbsolutePath() + " is not a directory.");
                    return false;
                }
                if (!this.HELPER_FUNCTIONS.isFile()) {
                    TestDriver.p("error:  " + this.HELPER_FUNCTIONS.getAbsolutePath() + " file not found.");
                    return false;
                }
                return true;
            }
        }
        TestDriver.p("could not understand arguments.");
        return false;
    }
}

