/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClassedPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import java.util.HashMap;
import java.util.Map;

class ComplexityCache {
    private final ComplexityVisitor complexityVisitor = new ComplexityVisitor();
    private final Map<Pattern, Complexity> cache = new HashMap<Pattern, Complexity>();

    ComplexityCache() {
    }

    public boolean isComplex(Pattern pattern) {
        return Complexity.isComplex(this.complexityVisitor.visit(pattern));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComplexityVisitor
    extends AbstractPatternVisitor<Complexity> {
        private ComplexityVisitor() {
        }

        Complexity visit(Pattern pattern) {
            Complexity complexity = (Complexity)ComplexityCache.this.cache.get(pattern);
            if (complexity == null) {
                complexity = pattern.accept(this);
                ComplexityCache.this.cache.put(pattern, complexity);
            }
            return complexity;
        }

        @Override
        public Complexity visitGrammar(GrammarPattern grammarPattern) {
            return Complexity.VERY_COMPLICATED;
        }

        @Override
        public Complexity visitNameClassed(NameClassedPattern nameClassedPattern) {
            return this.brace(nameClassedPattern);
        }

        @Override
        public Complexity visitList(ListPattern listPattern) {
            return this.brace(listPattern);
        }

        @Override
        public Complexity visitMixed(MixedPattern mixedPattern) {
            return this.brace(mixedPattern);
        }

        private Complexity brace(UnaryPattern unaryPattern) {
            return Complexity.brace(this.visit(unaryPattern.getChild()));
        }

        @Override
        public Complexity visitUnary(UnaryPattern unaryPattern) {
            return this.visit(unaryPattern.getChild());
        }

        @Override
        public Complexity visitData(DataPattern dataPattern) {
            Complexity complexity = Complexity.SIMPLE;
            if (dataPattern.getParams().size() > 0) {
                complexity = Complexity.brace(complexity);
            }
            if (dataPattern.getExcept() != null) {
                complexity = Complexity.max(complexity, this.visit(dataPattern.getExcept()));
            }
            return complexity;
        }

        @Override
        public Complexity visitComposite(CompositePattern compositePattern) {
            Complexity complexity = Complexity.SIMPLE;
            for (Pattern pattern : compositePattern.getChildren()) {
                complexity = Complexity.max(complexity, this.visit(pattern));
            }
            return Complexity.paren(complexity);
        }

        @Override
        public Complexity visitPattern(Pattern pattern) {
            return Complexity.SIMPLE;
        }
    }

    private static class Complexity {
        private int value;
        private static final int MAX_BRACE = 0;
        private static final int MAX_PAREN = 2;
        static final Complexity SIMPLE = new Complexity(0);
        static final Complexity VERY_COMPLICATED = new Complexity(1);

        private Complexity(int n) {
            this.value = n;
        }

        static Complexity max(Complexity complexity, Complexity complexity2) {
            int n = complexity.value;
            int n2 = complexity2.value;
            if (n > 0) {
                return n > n2 ? complexity : complexity2;
            }
            if (n2 > 0) {
                return complexity2;
            }
            return n < n2 ? complexity : complexity2;
        }

        static Complexity brace(Complexity complexity) {
            int n = complexity.value;
            return new Complexity(n <= 0 ? 1 : n + 1);
        }

        static Complexity paren(Complexity complexity) {
            int n = complexity.value;
            return n > 0 ? complexity : new Complexity(n - 1);
        }

        static boolean isComplex(Complexity complexity) {
            int n = complexity.value;
            return n > 0 || n < -2;
        }
    }
}

