/* automatically generated by rust-bindgen 0.68.1 */

#[doc = " Information about a display device.\n\n This includes at least one EDID or DisplayID blob.\n\n Use di_info_parse_edid() to create a struct di_info from an EDID blob.\n DisplayID blobs are not yet supported."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_info {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Parse an EDID blob.\n\n Callers do not need to keep the provided data pointer valid after calling\n this function. Callers should destroy the returned pointer via\n di_info_destroy()."]
    pub fn di_info_parse_edid(data: *const ::std::os::raw::c_void, size: usize) -> *mut di_info;
}
extern "C" {
    #[doc = " Destroy a display device information structure."]
    pub fn di_info_destroy(info: *mut di_info);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Returns the EDID the display device information was constructed with.\n\n The returned struct di_edid can be used to query low-level EDID information,\n see <libdisplay-info/edid.h>. Users should prefer the high-level API if\n possible.\n\n NULL is returned if the struct di_info doesn't contain an EDID. The returned\n struct di_edid is valid until di_info_destroy()."]
    pub fn di_info_get_edid(info: *const di_info) -> *const di_edid;
}
extern "C" {
    #[doc = " Get the failure messages for this blob.\n\n NULL is returned if the blob conforms to the relevant specifications."]
    pub fn di_info_get_failure_msg(info: *const di_info) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the make of the display device.\n\n This is the manufacturer name, either company name or PNP ID.\n This string is informational and not meant to be used in programmatic\n decisions, configuration keys, etc.\n\n The string is in UTF-8 and may contain any characters except ASCII control\n codes.\n\n The caller is responsible for free'ing the returned string.\n NULL is returned if the information is not available."]
    pub fn di_info_get_make(info: *const di_info) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the model of the display device.\n\n This is the product name/model string or product number.\n This string is informational and not meant to be used in programmatic\n decisions, configuration keys, etc.\n\n The string is in UTF-8 and may contain any characters except ASCII control\n codes.\n\n The caller is responsible for free'ing the returned string.\n NULL is returned if the information is not available."]
    pub fn di_info_get_model(info: *const di_info) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the serial of the display device.\n\n This is the product serial string or the serial number.\n This string is informational and not meant to be used in programmatic\n decisions, configuration keys, etc.\n\n The string is in UTF-8 and may contain any characters except ASCII control\n codes.\n\n The caller is responsible for free'ing the returned string.\n NULL is returned if the information is not available."]
    pub fn di_info_get_serial(info: *const di_info) -> *mut ::std::os::raw::c_char;
}
