/****************************************************************************
**
** Copyright (C) 2018 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui/qtguiglobal.h>
#if QT_CONFIG(accessibility)

#include "qwinrtuiaprovidercache.h"

QT_BEGIN_NAMESPACE

// Private constructor
QWinRTUiaProviderCache::QWinRTUiaProviderCache()
{
}

// shared instance
QWinRTUiaProviderCache *QWinRTUiaProviderCache::instance()
{
    static QWinRTUiaProviderCache providerCache;
    return &providerCache;
}

// Returns the provider instance associated with the ID, or nullptr.
QWinRTUiaBaseProvider *QWinRTUiaProviderCache::providerForId(QAccessible::Id id) const
{
    return m_providerTable.value(id);
}

// Inserts a provider in the cache and associates it with an accessibility ID.
void QWinRTUiaProviderCache::insert(QAccessible::Id id, QWinRTUiaBaseProvider *provider)
{
    remove(id);
    if (provider) {
        m_providerTable[id] = provider;
        m_inverseTable[provider] = id;
        // Connects the destroyed signal to our slot, to remove deleted objects from the cache.
        QObject::connect(provider, &QObject::destroyed, this, &QWinRTUiaProviderCache::objectDestroyed);
    }
}

// Removes deleted provider objects from the cache.
void QWinRTUiaProviderCache::objectDestroyed(QObject *obj)
{
    // We have to use the inverse table to map the object address back to its ID,
    // since at this point (called from QObject destructor), it has already been
    // partially destroyed and we cannot treat it as a provider.
    auto it = m_inverseTable.find(obj);
    if (it != m_inverseTable.end()) {
        m_providerTable.remove(*it);
        m_inverseTable.remove(obj);
    }
}

// Removes a provider with a given id from the cache.
void QWinRTUiaProviderCache::remove(QAccessible::Id id)
{
    m_inverseTable.remove(m_providerTable.value(id));
    m_providerTable.remove(id);
}

QT_END_NAMESPACE

#endif // QT_CONFIG(accessibility)
