// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is included from autogenerated files based on
// chrome/common/extensions/api/enterprise_platform_keys_internal.idl and
// chrome/common/extensions/api/enterprise_platform_keys.idl.

#ifndef CHROME_BROWSER_EXTENSIONS_API_ENTERPRISE_PLATFORM_KEYS_ENTERPRISE_PLATFORM_KEYS_API_H_
#define CHROME_BROWSER_EXTENSIONS_API_ENTERPRISE_PLATFORM_KEYS_ENTERPRISE_PLATFORM_KEYS_API_H_

#include <stdint.h>

#include <optional>
#include <string>
#include <vector>

#include "build/chromeos_buildflags.h"
#include "chromeos/crosapi/mojom/keystore_error.mojom.h"
#include "chromeos/crosapi/mojom/keystore_service.mojom.h"
#include "extensions/browser/extension_function.h"
#include "extensions/browser/extension_function_histogram_value.h"

class Extension;
class Profile;

namespace user_prefs {
class PrefRegistrySyncable;
}  // namespace user_prefs

namespace extensions {

namespace platform_keys {

void RegisterProfilePrefs(user_prefs::PrefRegistrySyncable* registry);
bool IsExtensionAllowed(Profile* profile, const Extension* extension);

}  // namespace platform_keys

class EnterprisePlatformKeysInternalGenerateKeyFunction
    : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysInternalGenerateKeyFunction() override;
  ResponseAction Run() override;

  // Called when the key was generated. If an error occurred, |public_key_der|
  // will be empty.
  void OnGeneratedKey(std::vector<uint8_t> public_key_der,
                      std::optional<crosapi::mojom::KeystoreError> error);

  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeysInternal.generateKey",
                             ENTERPRISE_PLATFORMKEYSINTERNAL_GENERATEKEY)
};

class EnterprisePlatformKeysGetCertificatesFunction : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysGetCertificatesFunction() override = default;
  ResponseAction Run() override;

  void OnGetCertificates(crosapi::mojom::GetCertificatesResultPtr result);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeys.getCertificates",
                             ENTERPRISE_PLATFORMKEYS_GETCERTIFICATES)
};

class EnterprisePlatformKeysImportCertificateFunction
    : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysImportCertificateFunction() override = default;
  ResponseAction Run() override;

  void OnAddCertificate(bool is_error,
                        crosapi::mojom::KeystoreError error_code);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeys.importCertificate",
                             ENTERPRISE_PLATFORMKEYS_IMPORTCERTIFICATE)
};

class EnterprisePlatformKeysRemoveCertificateFunction
    : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysRemoveCertificateFunction() override = default;
  ResponseAction Run() override;

  void OnRemoveCertificate(bool is_error, crosapi::mojom::KeystoreError error);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeys.removeCertificate",
                             ENTERPRISE_PLATFORMKEYS_REMOVECERTIFICATE)
};

class EnterprisePlatformKeysInternalGetTokensFunction
    : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysInternalGetTokensFunction() override = default;
  ResponseAction Run() override;

  void OnGetKeyStores(crosapi::mojom::GetKeyStoresResultPtr result);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeysInternal.getTokens",
                             ENTERPRISE_PLATFORMKEYSINTERNAL_GETTOKENS)
};

class EnterprisePlatformKeysChallengeMachineKeyFunction
    : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysChallengeMachineKeyFunction() override = default;
  ResponseAction Run() override;

  void OnChallengeAttestationOnlyKeystore(
      crosapi::mojom::ChallengeAttestationOnlyKeystoreResultPtr result);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeys.challengeMachineKey",
                             ENTERPRISE_PLATFORMKEYS_CHALLENGEMACHINEKEY)
};

class EnterprisePlatformKeysChallengeUserKeyFunction
    : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysChallengeUserKeyFunction() override = default;
  ResponseAction Run() override;

  void OnChallengeAttestationOnlyKeystore(
      crosapi::mojom::ChallengeAttestationOnlyKeystoreResultPtr result);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeys.challengeUserKey",
                             ENTERPRISE_PLATFORMKEYS_CHALLENGEUSERKEY)
};

class EnterprisePlatformKeysChallengeKeyFunction : public ExtensionFunction {
 private:
  ~EnterprisePlatformKeysChallengeKeyFunction() override = default;
  ResponseAction Run() override;

  void OnChallengeAttestationOnlyKeystore(
      crosapi::mojom::ChallengeAttestationOnlyKeystoreResultPtr result);
  DECLARE_EXTENSION_FUNCTION("enterprise.platformKeys.challengeKey",
                             ENTERPRISE_PLATFORMKEYS_CHALLENGEKEY)
};

}  // namespace extensions

#endif  // CHROME_BROWSER_EXTENSIONS_API_ENTERPRISE_PLATFORM_KEYS_ENTERPRISE_PLATFORM_KEYS_API_H_
