# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import AutoSuggestClientConfiguration
from .operations import AutoSuggestClientOperationsMixin
from . import models


class AutoSuggestClient(AutoSuggestClientOperationsMixin, SDKClient):
    """Autosuggest supplies search terms derived from a root text sent to the service.  The terms Autosuggest supplies are related to the root text based on similarity and their frequency or ratings of usefulness in other searches. For examples that show how to use Autosuggest, see [Search using AutoSuggest](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-autosuggest-api-v7-reference).

    :ivar config: Configuration for client.
    :vartype config: AutoSuggestClientConfiguration

    :param endpoint: Supported Cognitive Services endpoints (protocol and
     hostname, for example: "https://westus.api.cognitive.microsoft.com",
     "https://api.cognitive.microsoft.com").
    :type endpoint: str
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, endpoint, credentials):

        self.config = AutoSuggestClientConfiguration(endpoint, credentials)
        super(AutoSuggestClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.0'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

