---
id: fast-foundation.resolverbuilder
title: ResolverBuilder class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [ResolverBuilder](./fast-foundation.resolverbuilder.md)

## ResolverBuilder class

A utility class used that constructs and registers resolvers for a dependency injection container. Supports a standard set of object lifetimes.

<b>Signature:</b>

```typescript
export declare class ResolverBuilder<K> 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(container, key)](./fast-foundation.resolverbuilder._constructor_.md) |  | Constructs a new instance of the <code>ResolverBuilder</code> class |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [aliasTo(destinationKey)](./fast-foundation.resolverbuilder.aliasto.md) |  | Aliases the current key to a different key. |
|  [cachedCallback(value)](./fast-foundation.resolverbuilder.cachedcallback.md) |  | Creates a resolver that invokes a callback function the first time that a dependency resolution is requested. The returned value is then cached and provided for all subsequent requests. |
|  [callback(value)](./fast-foundation.resolverbuilder.callback.md) |  | Creates a resolver that invokes a callback function for every dependency resolution request, allowing custom logic to return the dependency. |
|  [instance(value)](./fast-foundation.resolverbuilder.instance.md) |  | Creates a resolver for an existing object instance. |
|  [singleton(value)](./fast-foundation.resolverbuilder.singleton.md) |  | Creates a resolver that enforces a singleton lifetime. |
|  [transient(value)](./fast-foundation.resolverbuilder.transient.md) |  | Creates a resolver that creates a new instance for every dependency request. |
