/* Do not edit this file. It is produced from the corresponding .m4 source */
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: test_get.m4 2672 2016-12-03 19:23:53Z wkliao $ */


#include "tests.h"

#ifdef USE_PNETCDF
#include <pnetcdf.h>
#ifndef PNETCDF_VERSION_MAJOR
#error("PNETCDF_VERSION_MAJOR is not defined in pnetcdf.h")
#endif
#ifndef PNETCDF_VERSION_MINOR
#error("PNETCDF_VERSION_MAJOR is not defined in pnetcdf.h")
#endif
#endif










int
test_nc_get_var1_text(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    text value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_text(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_text(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_text(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) ;


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_text(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_TEXT);
            err = nc_get_var1_text(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_TEXT)) {
                    if (1) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_TEXT)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_schar(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    schar value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_schar(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_schar(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_schar(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_schar(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_SCHAR);
            err = nc_get_var1_schar(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_SCHAR)) {
                    if ((expect >= schar_min && expect <= schar_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_SCHAR)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
#if defined(USE_PNETCDF) && PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR<7
                    else if (cdf_format < NC_FORMAT_CDF5) {
#else
                    else {
#endif
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_uchar(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    uchar value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_uchar(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_uchar(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_uchar(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_uchar(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_UCHAR);
            err = nc_get_var1_uchar(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_UCHAR)) {
                    if ((expect >= uchar_min && expect <= uchar_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect > schar_max) continue;
                            IF (!equal((double)value[0], expect, var_type[i], NCT_UCHAR)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=8)
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }
#endif

                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_short(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    short value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_short(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_short(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_short(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_short(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_SHORT);
            err = nc_get_var1_short(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_SHORT)) {
                    if ((expect >= short_min && expect <= short_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_SHORT)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_int(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    int value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_int(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_int(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_int(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_int(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_INT);
            err = nc_get_var1_int(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_INT)) {
                    if ((expect >= int_min && expect <= int_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_INT)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_long(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    long value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_long(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_long(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_long(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_long(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_LONG);
            err = nc_get_var1_long(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_LONG)) {
                    if ((expect >= long_min && expect <= long_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_LONG)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_float(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    float value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_float(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_float(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_float(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_float(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_FLOAT);
            err = nc_get_var1_float(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_FLOAT)) {
                    if ((expect >= float_min && expect <= float_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_FLOAT)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_double(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    double value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_double(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_double(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_double(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_double(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_DOUBLE);
            err = nc_get_var1_double(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_DOUBLE)) {
                    if ((expect >= double_min && expect <= double_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_DOUBLE)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_ushort(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    ushort value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_ushort(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_ushort(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_ushort(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_ushort(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_USHORT);
            err = nc_get_var1_ushort(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_USHORT)) {
                    if ((expect >= ushort_min && expect <= ushort_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_USHORT)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_uint(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    uint value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_uint(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_uint(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_uint(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_uint(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_UINT);
            err = nc_get_var1_uint(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_UINT)) {
                    if ((expect >= uint_min && expect <= uint_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_UINT)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_longlong(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    longlong value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_longlong(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_longlong(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_longlong(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_longlong(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_LONGLONG);
            err = nc_get_var1_longlong(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_LONGLONG)) {
                    if ((expect >= longlong_min && expect <= longlong_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_LONGLONG)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var1_ulonglong(void)
{
    int i, err, ncid, cdf_format;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect;
    ulonglong value[1];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var1_ulonglong(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var1_ulonglong(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var1_ulonglong(BAD_ID, i, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);


        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j];     /* out of boundary check */
            err = nc_get_var1_ulonglong(ncid, i, index, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            } else IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_ULONGLONG);
            err = nc_get_var1_ulonglong(ncid, i, index, value);
            if (canConvert) {
                if (inRange3(cdf_format, expect,var_type[i], NCT_ULONGLONG)) {
                    if ((expect >= ulonglong_min && expect <= ulonglong_max)) {
                        IF (err != NC_NOERR) {
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        } else {
                            
                            IF (!equal((double)value[0], expect, var_type[i], NCT_ULONGLONG)) {
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            }
                            ELSE_NOK
                        }
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                ELSE_NOK
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}




int
test_nc_get_var_text(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    text value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_text(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_text(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_text(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) ;

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_TEXT);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_TEXT)) {
                if (var_type[i] != NC_CHAR)
                    allInIntRange &= 1;
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_text(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (1) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_TEXT)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_uchar(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    uchar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_uchar(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_uchar(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_uchar(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_UCHAR);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_UCHAR)) {
                
                    allInIntRange &= (expect[j] >= uchar_min && expect[j] <= uchar_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_uchar(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=8)
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }
#endif

            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR) && (expect[j] >= uchar_min && expect[j] <= uchar_max)) {
                    
                    /* in put_vars(), API _put_vara_double() is used to
                     * write the NC_BYTE variables to files. In this
                     * case, NC_BYTE variables are treated as signed
                     * for CDF-1 and 2 formats. Thus, we must skip the
                     * equal test below for uchar.
                     */
                    if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_UCHAR)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_schar(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    schar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_schar(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_schar(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_schar(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_SCHAR);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_SCHAR)) {
                
                    allInIntRange &= (expect[j] >= schar_min && expect[j] <= schar_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_schar(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
#if defined(USE_PNETCDF) && PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR<7
                    else if (cdf_format < NC_FORMAT_CDF5) {
#else
                    else {
#endif
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR) && (expect[j] >= schar_min && expect[j] <= schar_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_SCHAR)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_short(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    short value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_short(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_short(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_short(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_SHORT);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_SHORT)) {
                
                    allInIntRange &= (expect[j] >= short_min && expect[j] <= short_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_short(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT) && (expect[j] >= short_min && expect[j] <= short_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_SHORT)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_int(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    int value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_int(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_int(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_int(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_INT);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_INT)) {
                
                    allInIntRange &= (expect[j] >= int_min && expect[j] <= int_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_int(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT) && (expect[j] >= int_min && expect[j] <= int_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_INT)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_long(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    long value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_long(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_long(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_long(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_LONG);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_LONG)) {
                
                    allInIntRange &= (expect[j] >= long_min && expect[j] <= long_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_long(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG) && (expect[j] >= long_min && expect[j] <= long_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_LONG)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_float(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    float value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_float(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_float(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_float(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_FLOAT);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_FLOAT)) {
                
                    allInIntRange &= (expect[j] >= float_min && expect[j] <= float_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_float(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT) && (expect[j] >= float_min && expect[j] <= float_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_FLOAT)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_double(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    double value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_double(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_double(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_double(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_DOUBLE);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_DOUBLE)) {
                
                    allInIntRange &= (expect[j] >= double_min && expect[j] <= double_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_double(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE) && (expect[j] >= double_min && expect[j] <= double_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_DOUBLE)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_ushort(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    ushort value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_ushort(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_ushort(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_ushort(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_USHORT);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_USHORT)) {
                
                    allInIntRange &= (expect[j] >= ushort_min && expect[j] <= ushort_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_ushort(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT) && (expect[j] >= ushort_min && expect[j] <= ushort_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_USHORT)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_uint(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    uint value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_uint(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_uint(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_uint(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_UINT);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_UINT)) {
                
                    allInIntRange &= (expect[j] >= uint_min && expect[j] <= uint_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_uint(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT) && (expect[j] >= uint_min && expect[j] <= uint_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_UINT)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_longlong(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    longlong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_longlong(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_longlong(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_longlong(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_LONGLONG);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_LONGLONG)) {
                
                    allInIntRange &= (expect[j] >= longlong_min && expect[j] <= longlong_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_longlong(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG) && (expect[j] >= longlong_min && expect[j] <= longlong_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_LONGLONG)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_var_ulonglong(void)
{
    int i, err, ncid, cdf_format;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, index[MAX_RANK];
    double expect[MAX_NELS];
    ulonglong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    /* check if can detect a bad file ID */
    err = nc_get_var_ulonglong(BAD_ID, 0, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = nc_get_var_ulonglong(ncid, BAD_VARID, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_var_ulonglong(BAD_ID, i, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);

        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_ULONGLONG);
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_ULONGLONG)) {
                
                    allInIntRange &= (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max);
            } else
                allInExtRange = 0;
        }
        err = nc_get_var_ulonglong(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                }
                
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG) && (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max)) {
                    
                    IF (!equal((double)value[j],expect[j],var_type[i],NCT_ULONGLONG)){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("var_type: %s, ", s_nc_type(var_type[i]));
                            error("element number: %d, ", j);
                            error("expect: %g, ", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            ELSE_NOK
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}




int
test_nc_get_vara_text(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    text value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_text(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_text(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_text(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) ;

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_text(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_text(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_text(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_text(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_text(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_TEXT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_TEXT) &&
                1) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_TEXT);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_TEXT)) {
		    if (var_type[i] != NC_CHAR)
                        allInIntRange &= 1;
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_text(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (1) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_TEXT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_uchar(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    uchar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_uchar(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_uchar(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_uchar(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_uchar(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_uchar(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_uchar(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_uchar(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_uchar(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_UCHAR);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_UCHAR) &&
                (expect[0] >= uchar_min && expect[0] <= uchar_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
#endif
        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_UCHAR);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR)) {
		    
                        allInIntRange &= (expect[j] >= uchar_min && expect[j] <= uchar_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_uchar(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=8)
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }
#endif

                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR) && (expect[j] >= uchar_min && expect[j] <= uchar_max)) {
                        
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_UCHAR)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_schar(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    schar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_schar(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_schar(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_schar(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_schar(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_schar(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_schar(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_schar(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_schar(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_SCHAR);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_SCHAR) &&
                (expect[0] >= schar_min && expect[0] <= schar_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_SCHAR);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR)) {
		    
                        allInIntRange &= (expect[j] >= schar_min && expect[j] <= schar_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_schar(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
#if defined(USE_PNETCDF) && PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR<7
                    else if (cdf_format < NC_FORMAT_CDF5) {
#else
                    else {
#endif
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR) && (expect[j] >= schar_min && expect[j] <= schar_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_SCHAR)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_short(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    short value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_short(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_short(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_short(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_short(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_short(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_short(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_short(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_short(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_SHORT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_SHORT) &&
                (expect[0] >= short_min && expect[0] <= short_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_SHORT);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT)) {
		    
                        allInIntRange &= (expect[j] >= short_min && expect[j] <= short_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_short(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT) && (expect[j] >= short_min && expect[j] <= short_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_SHORT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_int(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    int value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_int(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_int(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_int(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_int(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_int(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_int(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_int(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_int(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_INT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_INT) &&
                (expect[0] >= int_min && expect[0] <= int_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_INT);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT)) {
		    
                        allInIntRange &= (expect[j] >= int_min && expect[j] <= int_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_int(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT) && (expect[j] >= int_min && expect[j] <= int_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_INT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_long(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    long value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_long(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_long(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_long(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_long(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_long(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_long(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_long(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_long(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_LONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_LONG) &&
                (expect[0] >= long_min && expect[0] <= long_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_LONG);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG)) {
		    
                        allInIntRange &= (expect[j] >= long_min && expect[j] <= long_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_long(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG) && (expect[j] >= long_min && expect[j] <= long_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_LONG)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_float(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    float value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_float(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_float(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_float(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_float(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_float(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_float(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_float(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_float(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_FLOAT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_FLOAT) &&
                (expect[0] >= float_min && expect[0] <= float_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_FLOAT);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT)) {
		    
                        allInIntRange &= (expect[j] >= float_min && expect[j] <= float_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_float(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT) && (expect[j] >= float_min && expect[j] <= float_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_FLOAT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_double(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    double value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_double(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_double(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_double(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_double(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_double(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_double(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_double(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_double(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_DOUBLE);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_DOUBLE) &&
                (expect[0] >= double_min && expect[0] <= double_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_DOUBLE);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE)) {
		    
                        allInIntRange &= (expect[j] >= double_min && expect[j] <= double_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_double(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE) && (expect[j] >= double_min && expect[j] <= double_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_DOUBLE)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_ushort(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    ushort value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_ushort(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_ushort(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_ushort(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_ushort(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_ushort(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_ushort(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_ushort(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_ushort(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_USHORT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_USHORT) &&
                (expect[0] >= ushort_min && expect[0] <= ushort_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_USHORT);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT)) {
		    
                        allInIntRange &= (expect[j] >= ushort_min && expect[j] <= ushort_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_ushort(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT) && (expect[j] >= ushort_min && expect[j] <= ushort_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_USHORT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_uint(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    uint value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_uint(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_uint(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_uint(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_uint(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_uint(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_uint(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_uint(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_uint(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_UINT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_UINT) &&
                (expect[0] >= uint_min && expect[0] <= uint_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_UINT);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT)) {
		    
                        allInIntRange &= (expect[j] >= uint_min && expect[j] <= uint_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_uint(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT) && (expect[j] >= uint_min && expect[j] <= uint_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_UINT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_longlong(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    longlong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_longlong(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_longlong(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_longlong(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_longlong(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_longlong(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_longlong(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_longlong(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_longlong(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_LONGLONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_LONGLONG) &&
                (expect[0] >= longlong_min && expect[0] <= longlong_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_LONGLONG);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG)) {
		    
                        allInIntRange &= (expect[j] >= longlong_min && expect[j] <= longlong_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_longlong(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG) && (expect[j] >= longlong_min && expect[j] <= longlong_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_LONGLONG)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vara_ulonglong(void)
{
    int i, k, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    ulonglong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vara_ulonglong(BAD_ID, 0, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vara_ulonglong(ncid, BAD_VARID, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vara_ulonglong(BAD_ID, i, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j]; /* causes NC_EINVALCOORDS */
            err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1; /* causes NC_EEDGE */
            err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[*]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1; /* should cause NC_EINVALCOORDS */
            err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
        }

        err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ULONGLONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ULONGLONG) &&
                (expect[0] >= ulonglong_min && expect[0] <= ulonglong_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            size_t nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_ULONGLONG);
                if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG)) {
		    
                        allInIntRange &= (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max);
                } else
                    allInExtRange = 0;
            }
            err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                    }
                    
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (j = 0; j < nels; j++) {
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG) && (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max)) {
                        
                        IF (!equal((double)value[j],expect[j],var_type[i],NCT_ULONGLONG)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("element number: %d, ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}




int
test_nc_get_vars_text(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    text value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_text(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_text(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_text(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) ;

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_text(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_TEXT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_TEXT) &&
                1) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_TEXT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_TEXT)) {
		        if (var_type[i] != NC_CHAR)
                            allInIntRange &= 1;
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_text(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (1) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_TEXT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_uchar(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    uchar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_uchar(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_uchar(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_uchar(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_UCHAR);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_UCHAR) &&
                (expect[0] >= uchar_min && expect[0] <= uchar_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
#endif
        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_UCHAR);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR)) {
		        
                            allInIntRange &= (expect[j] >= uchar_min && expect[j] <= uchar_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_uchar(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=8)
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }
#endif

                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR) && (expect[j] >= uchar_min && expect[j] <= uchar_max)) {
                            
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_UCHAR)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_schar(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    schar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_schar(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_schar(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_schar(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_SCHAR);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_SCHAR) &&
                (expect[0] >= schar_min && expect[0] <= schar_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_SCHAR);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR)) {
		        
                            allInIntRange &= (expect[j] >= schar_min && expect[j] <= schar_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_schar(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
#if defined(USE_PNETCDF) && PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR<7
                    else if (cdf_format < NC_FORMAT_CDF5) {
#else
                    else {
#endif
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR) && (expect[j] >= schar_min && expect[j] <= schar_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_SCHAR)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_short(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    short value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_short(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_short(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_short(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_short(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_SHORT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_SHORT) &&
                (expect[0] >= short_min && expect[0] <= short_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_SHORT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT)) {
		        
                            allInIntRange &= (expect[j] >= short_min && expect[j] <= short_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_short(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT) && (expect[j] >= short_min && expect[j] <= short_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_SHORT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_int(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    int value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_int(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_int(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_int(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_int(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_INT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_INT) &&
                (expect[0] >= int_min && expect[0] <= int_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_INT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT)) {
		        
                            allInIntRange &= (expect[j] >= int_min && expect[j] <= int_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_int(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT) && (expect[j] >= int_min && expect[j] <= int_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_INT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_long(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    long value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_long(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_long(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_long(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_long(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_LONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_LONG) &&
                (expect[0] >= long_min && expect[0] <= long_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_LONG);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG)) {
		        
                            allInIntRange &= (expect[j] >= long_min && expect[j] <= long_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_long(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG) && (expect[j] >= long_min && expect[j] <= long_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_LONG)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_float(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    float value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_float(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_float(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_float(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_float(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_FLOAT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_FLOAT) &&
                (expect[0] >= float_min && expect[0] <= float_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_FLOAT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT)) {
		        
                            allInIntRange &= (expect[j] >= float_min && expect[j] <= float_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_float(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT) && (expect[j] >= float_min && expect[j] <= float_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_FLOAT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_double(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    double value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_double(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_double(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_double(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_double(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_DOUBLE);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_DOUBLE) &&
                (expect[0] >= double_min && expect[0] <= double_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_DOUBLE);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE)) {
		        
                            allInIntRange &= (expect[j] >= double_min && expect[j] <= double_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_double(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE) && (expect[j] >= double_min && expect[j] <= double_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_DOUBLE)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_ushort(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    ushort value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_ushort(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_ushort(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_ushort(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_USHORT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_USHORT) &&
                (expect[0] >= ushort_min && expect[0] <= ushort_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_USHORT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT)) {
		        
                            allInIntRange &= (expect[j] >= ushort_min && expect[j] <= ushort_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_ushort(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT) && (expect[j] >= ushort_min && expect[j] <= ushort_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_USHORT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_uint(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    uint value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_uint(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_uint(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_uint(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_UINT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_UINT) &&
                (expect[0] >= uint_min && expect[0] <= uint_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_UINT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT)) {
		        
                            allInIntRange &= (expect[j] >= uint_min && expect[j] <= uint_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_uint(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT) && (expect[j] >= uint_min && expect[j] <= uint_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_UINT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_longlong(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    longlong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_longlong(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_longlong(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_longlong(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_LONGLONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_LONGLONG) &&
                (expect[0] >= longlong_min && expect[0] <= longlong_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_LONGLONG);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG)) {
		        
                            allInIntRange &= (expect[j] >= longlong_min && expect[j] <= longlong_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_longlong(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG) && (expect[j] >= longlong_min && expect[j] <= longlong_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_LONGLONG)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_vars_ulonglong(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK];
    double expect[MAX_NELS];
    ulonglong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_vars_ulonglong(BAD_ID, 0, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_vars_ulonglong(ncid, BAD_VARID, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_ulonglong(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ULONGLONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ULONGLONG) &&
                (expect[0] >= ulonglong_min && expect[0] <= ulonglong_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_ULONGLONG);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG)) {
		        
                            allInIntRange &= (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_vars_ulonglong(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG) && (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_ULONGLONG)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }

    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}




int
test_nc_get_varm_text(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    text value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_text(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_text(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_text(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) ;

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_TEXT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_TEXT) &&
                1) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_TEXT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_TEXT)) {
		        if (var_type[i] != NC_CHAR)
                            allInIntRange &= 1;
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_text(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (1) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_TEXT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_uchar(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    uchar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_uchar(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_uchar(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_uchar(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_UCHAR);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_UCHAR) &&
                (expect[0] >= uchar_min && expect[0] <= uchar_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
#endif
        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_UCHAR);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR)) {
		        
                            allInIntRange &= (expect[j] >= uchar_min && expect[j] <= uchar_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_uchar(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=8)
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }
#endif

                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_UCHAR) && (expect[j] >= uchar_min && expect[j] <= uchar_max)) {
                            
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_UCHAR)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_schar(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    schar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_schar(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_schar(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_schar(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_SCHAR);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_SCHAR) &&
                (expect[0] >= schar_min && expect[0] <= schar_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_SCHAR);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR)) {
		        
                            allInIntRange &= (expect[j] >= schar_min && expect[j] <= schar_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_schar(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
#if defined(USE_PNETCDF) && PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR<7
                    else if (cdf_format < NC_FORMAT_CDF5) {
#else
                    else {
#endif
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_SCHAR) && (expect[j] >= schar_min && expect[j] <= schar_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_SCHAR)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_short(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    short value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_short(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_short(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_short(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_SHORT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_SHORT) &&
                (expect[0] >= short_min && expect[0] <= short_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_SHORT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT)) {
		        
                            allInIntRange &= (expect[j] >= short_min && expect[j] <= short_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_short(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_SHORT) && (expect[j] >= short_min && expect[j] <= short_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_SHORT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_int(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    int value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_int(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_int(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_int(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_INT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_INT) &&
                (expect[0] >= int_min && expect[0] <= int_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_INT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT)) {
		        
                            allInIntRange &= (expect[j] >= int_min && expect[j] <= int_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_int(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_INT) && (expect[j] >= int_min && expect[j] <= int_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_INT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_long(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    long value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_long(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_long(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_long(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_LONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_LONG) &&
                (expect[0] >= long_min && expect[0] <= long_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_LONG);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG)) {
		        
                            allInIntRange &= (expect[j] >= long_min && expect[j] <= long_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_long(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONG) && (expect[j] >= long_min && expect[j] <= long_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_LONG)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_float(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    float value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_float(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_float(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_float(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_FLOAT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_FLOAT) &&
                (expect[0] >= float_min && expect[0] <= float_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_FLOAT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT)) {
		        
                            allInIntRange &= (expect[j] >= float_min && expect[j] <= float_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_float(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_FLOAT) && (expect[j] >= float_min && expect[j] <= float_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_FLOAT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_double(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    double value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_double(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_double(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_double(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_DOUBLE);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_DOUBLE) &&
                (expect[0] >= double_min && expect[0] <= double_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_DOUBLE);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE)) {
		        
                            allInIntRange &= (expect[j] >= double_min && expect[j] <= double_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_double(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_DOUBLE) && (expect[j] >= double_min && expect[j] <= double_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_DOUBLE)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_ushort(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    ushort value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_ushort(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_ushort(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_ushort(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_USHORT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_USHORT) &&
                (expect[0] >= ushort_min && expect[0] <= ushort_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_USHORT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT)) {
		        
                            allInIntRange &= (expect[j] >= ushort_min && expect[j] <= ushort_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_ushort(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_USHORT) && (expect[j] >= ushort_min && expect[j] <= ushort_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_USHORT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_uint(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    uint value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_uint(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_uint(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_uint(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_UINT);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_UINT) &&
                (expect[0] >= uint_min && expect[0] <= uint_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_UINT);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT)) {
		        
                            allInIntRange &= (expect[j] >= uint_min && expect[j] <= uint_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_uint(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_UINT) && (expect[j] >= uint_min && expect[j] <= uint_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_UINT)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_longlong(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    longlong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_longlong(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_longlong(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_longlong(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_LONGLONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_LONGLONG) &&
                (expect[0] >= longlong_min && expect[0] <= longlong_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_LONGLONG);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG)) {
		        
                            allInIntRange &= (expect[j] >= longlong_min && expect[j] <= longlong_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_longlong(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_LONGLONG) && (expect[j] >= longlong_min && expect[j] <= longlong_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_LONGLONG)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_varm_ulonglong(void)
{
    int i, k, d, err, nslabs, ncid, cdf_format;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    ptrdiff_t nstarts;   /* number of different starts */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    size_t j, m, nels;
    size_t start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    size_t index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    size_t sstride[MAX_RANK];
    ptrdiff_t stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    ulonglong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_varm_ulonglong(BAD_ID, 0, NULL, NULL, NULL, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_varm_ulonglong(ncid, BAD_VARID, NULL, NULL, NULL, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = nc_get_vars_ulonglong(BAD_ID, i, NULL, NULL, NULL, value);
        IF (err != NC_EBADID)
            error("expecting NC_EBADID but got %s",nc_err_code_name(err));
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }


        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EEDGE)
                error("expecting NC_EEDGE but got %s",nc_err_code_name(err));
            edge[j] = 1;
            stride[j] = 0;
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
        }

        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                start[j] = 0;
                continue;
            }
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            start[j] = var_shape[i][j]+1;  /* should cause NC_EINVALCOORDS */
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_EINVALCOORDS)
                error("expecting NC_EINVALCOORDS but got %s",nc_err_code_name(err));
            start[j] = 0;
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>=7)
            stride[j] = 0;
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
            IF (err != NC_ESTRIDE)
                error("expecting NC_ESTRIDE but got %s",nc_err_code_name(err));
            stride[j] = 1;
#endif
        }

        err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
        } else if (var_rank[i] == 0) {
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ULONGLONG);
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ULONGLONG) &&
                (expect[0] >= ulonglong_min && expect[0] <= ulonglong_max)) {
                IF (err != NC_NOERR) error("expecting NC_NOERR but got %s",nc_err_code_name(err));
            }

            else IF (err != NC_ERANGE) error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

        } else {
            IF (err != NC_NOERR)
                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                stride[j] = (ptrdiff_t)sstride[j];
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j]-index[j]-1) / (size_t)stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * (size_t)stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    int jj = var_rank[i] - 1;
                    imap[jj] = 1;
                    for (; jj > 0; jj--)
                        imap[jj-1] = imap[jj] * (ptrdiff_t)count[jj];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * (size_t)stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_ULONGLONG);
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG)) {
		        
                            allInIntRange &= (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max);
                    } else
                        allInExtRange = 0;
                }
                err = nc_get_varm_ulonglong(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                error("expecting NC_NOERR but got %s",nc_err_code_name(err));
                        }
                        
                    else {

                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
                        ELSE_NOK
                    }


                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                    }
                    for (j = 0; j < nels; j++) {
                        if (inRange3(cdf_format, expect[j],var_type[i],NCT_ULONGLONG) && (expect[j] >= ulonglong_min && expect[j] <= ulonglong_max)) {
                            
                            IF (!equal((double)value[j],expect[j],var_type[i], NCT_ULONGLONG)){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("var_type: %s, ", s_nc_type(var_type[i]));
                                    error("element number: %d, ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
                }
            }
        }
    }
    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}




int
test_nc_get_att_text(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    text value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_text(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_text(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) ;

            err = nc_get_att_text(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_text(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_text(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_TEXT);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_TEXT)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    if (ATT_TYPE(i,j) != NC_CHAR)
		    
                        allInIntRange &= 1;
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_text(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (1) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_TEXT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_uchar(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    uchar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_uchar(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_uchar(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);

            err = nc_get_att_uchar(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_uchar(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_uchar(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_UCHAR);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_UCHAR)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    if (cdf_format > NC_FORMAT_64BIT_OFFSET || (cdf_format < NC_FORMAT_CDF5 && ATT_TYPE(i,j) != NC_BYTE))
                        allInIntRange &= (expect[k] >= uchar_min && expect[k] <= uchar_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_uchar(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));
#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));
#endif
                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_UCHAR) && (expect[k] >= uchar_min && expect[k] <= uchar_max)) {
                        
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && ATT_TYPE(i,j) == NC_BYTE && expect[k] > schar_max) continue;
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_UCHAR)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_schar(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    schar value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_schar(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_schar(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);

            err = nc_get_att_schar(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_schar(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_schar(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_SCHAR);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_SCHAR)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= schar_min && expect[k] <= schar_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_schar(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_SCHAR) && (expect[k] >= schar_min && expect[k] <= schar_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_SCHAR)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_short(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    short value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_short(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_short(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SHORT == NCT_TEXT);

            err = nc_get_att_short(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_short(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_short(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_SHORT);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_SHORT)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= short_min && expect[k] <= short_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_short(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_SHORT) && (expect[k] >= short_min && expect[k] <= short_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_SHORT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_int(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    int value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_int(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_int(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_INT == NCT_TEXT);

            err = nc_get_att_int(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_int(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_int(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_INT);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_INT)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= int_min && expect[k] <= int_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_int(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_INT) && (expect[k] >= int_min && expect[k] <= int_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_INT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_long(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    long value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_long(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_long(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_LONG == NCT_TEXT);

            err = nc_get_att_long(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_long(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_long(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_LONG);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_LONG)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= long_min && expect[k] <= long_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_long(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_LONG) && (expect[k] >= long_min && expect[k] <= long_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_LONG)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_float(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    float value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_float(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_float(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);

            err = nc_get_att_float(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_float(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_float(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_FLOAT);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_FLOAT)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= float_min && expect[k] <= float_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_float(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_FLOAT) && (expect[k] >= float_min && expect[k] <= float_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_FLOAT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_double(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    double value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_double(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_double(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);

            err = nc_get_att_double(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_double(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_double(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_DOUBLE);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_DOUBLE)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= double_min && expect[k] <= double_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_double(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_DOUBLE) && (expect[k] >= double_min && expect[k] <= double_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_DOUBLE)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_ushort(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    ushort value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_ushort(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_ushort(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_USHORT == NCT_TEXT);

            err = nc_get_att_ushort(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_ushort(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_ushort(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_USHORT);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_USHORT)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= ushort_min && expect[k] <= ushort_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_ushort(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_USHORT) && (expect[k] >= ushort_min && expect[k] <= ushort_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_USHORT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_uint(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    uint value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_uint(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_uint(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_UINT == NCT_TEXT);

            err = nc_get_att_uint(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_uint(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_uint(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_UINT);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_UINT)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= uint_min && expect[k] <= uint_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_uint(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_UINT) && (expect[k] >= uint_min && expect[k] <= uint_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_UINT)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_longlong(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    longlong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_longlong(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_longlong(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);

            err = nc_get_att_longlong(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_longlong(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_longlong(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_LONGLONG);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_LONGLONG)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= longlong_min && expect[k] <= longlong_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_longlong(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_LONGLONG) && (expect[k] >= longlong_min && expect[k] <= longlong_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_LONGLONG)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}

int
test_nc_get_att_ulonglong(void)
{
    int i, j, err, ncid, cdf_format;
    size_t k, ndx[1];
    int allInExtRange;
    int allInIntRange;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;        /* count of valid comparisons */
    double expect[MAX_NELS];
    ulonglong value[MAX_NELS];

    err = file_open(testfile, NC_NOWRITE, &ncid);
    IF (err != NC_NOERR) error("open: %s",  nc_strerror(err));

    err =  nc_inq_format(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s",  nc_strerror(err));

    err = nc_get_att_ulonglong(BAD_ID, 0, NULL, value);
    IF (err != NC_EBADID)
        error("expecting NC_EBADID but got %s",nc_err_code_name(err));
    ELSE_NOK

    err = nc_get_att_ulonglong(ncid, BAD_VARID, NULL, value);
    IF (err != NC_ENOTVAR)
        error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
    ELSE_NOK

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);

            err = nc_get_att_ulonglong(ncid, BAD_VARID, ATT_NAME(i,j), value);
            IF (err != NC_ENOTVAR)
                error("expecting NC_ENOTVAR but got %s",nc_err_code_name(err));
            ELSE_NOK

#if !defined(USE_PNETCDF) || (PNETCDF_VERSION_MAJOR==1 && PNETCDF_VERSION_MINOR>7)
            /* check if can detect a bad name */
            err = nc_get_att_ulonglong(ncid, i, NULL, NULL);
            IF (err != NC_EBADNAME)
                error("expecting NC_EBADNAME but got %s",nc_err_code_name(err));
            ELSE_NOK
#endif

            err = nc_get_att_ulonglong(ncid, i, "noSuch", value);
            IF (err != NC_ENOTATT)
                error("expecting NC_ENOTATT but got %s",nc_err_code_name(err));
            ELSE_NOK

            allInExtRange = allInIntRange = 1;
            for (k = 0; k < ATT_LEN(i,j); k++) {
                ndx[0] = k;
                expect[k] = hash4(cdf_format, ATT_TYPE(i,j), -1, ndx, NCT_ULONGLONG);
                if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_ULONGLONG)) {
		    /* netCDF specification make a special case for type
		     * conversion between uchar and scahr: do not check for
		     * range error. See
		     * http://www.unidata.ucar.edu/software/netcdf/docs/data_type.html#type_conversion
                     */
		    
		    
                        allInIntRange &= (expect[k] >= ulonglong_min && expect[k] <= ulonglong_max);
                } else {
                    allInExtRange = 0;
                }
            }
            err = nc_get_att_ulonglong(ncid, i, ATT_NAME(i,j), value);
            if (canConvert || ATT_LEN(i,j) == 0) {
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            error("expecting NC_NOERR but got %s",nc_err_code_name(err));

                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting NC_ERANGE but got %s",nc_err_code_name(err));

                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        error("expecting NC_NOERR or NC_ERANGE but got %s",nc_err_code_name(err));
                }
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    if (inRange3(cdf_format, expect[k],ATT_TYPE(i,j),NCT_ULONGLONG) && (expect[k] >= ulonglong_min && expect[k] <= ulonglong_max)) {
                        
                        IF (!equal((double)value[k],expect[k],ATT_TYPE(i,j), NCT_ULONGLONG)){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                if (i == -1)
                                    error("var_type: GLOBAL, ");
                                else
                                    error("var_name: %s var_type: %s, ", var_name[i],s_nc_type(var_type[i]));
                                error("att_name: %s, ", ATT_NAME(i,j));
                                error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                                error("element number: %d, ", k);
                                error("expect: %g, ", expect[k]);
                                error("got: %g", (double) value[k]);
                            }
                        } else {
                            nok++;
                        }
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    error("expecting NC_ECHAR but got %s",nc_err_code_name(err));
            }
        }
    }

    err =  nc_close(ncid);
    IF (err != NC_NOERR)
        error("close: %s",  nc_strerror(err));
    return nok;
}


