/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SerialBlobTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerialBlobTest
extends TestCase {
    public void testConstructorLBlob() throws Exception {
        boolean isAbnormal = false;
        MockSerialBlob mockBlob = new MockSerialBlob(isAbnormal);
        SerialBlob serialBlob = new SerialBlob((Blob)mockBlob);
        SerialBlobTest.assertTrue((boolean)mockBlob.isGetBytesInvoked);
        SerialBlobTest.assertEquals((long)1L, (long)serialBlob.length());
        isAbnormal = true;
        mockBlob = new MockSerialBlob(isAbnormal);
        try {
            new SerialBlob((Blob)mockBlob);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SerialBlob(null);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testConstructor$B() throws Exception {
        byte[] buf = new byte[8];
        SerialBlob serialBlob = new SerialBlob(buf);
        SerialBlobTest.assertEquals((long)8L, (long)serialBlob.length());
        try {
            new SerialBlob(null);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetBinaryStream() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(buf);
        InputStream is = serialBlob.getBinaryStream();
        int i = 0;
        while (true) {
            int b;
            if ((b = is.read()) == -1) {
                if (i >= buf.length) break;
                SerialBlobTest.fail((String)"returned input stream contains too few data");
                break;
            }
            if (i > buf.length) {
                SerialBlobTest.fail((String)"returned input stream contains too much data");
            }
            SerialBlobTest.assertEquals((int)buf[i++], (int)b);
        }
    }

    public void testGetBytesJI() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(buf);
        byte[] data = serialBlob.getBytes(1L, 1);
        SerialBlobTest.assertEquals((int)1, (int)data.length);
        SerialBlobTest.assertEquals((int)1, (int)data[0]);
        data = serialBlob.getBytes(2L, 3);
        SerialBlobTest.assertEquals((int)3, (int)data.length);
        SerialBlobTest.assertEquals((int)2, (int)data[0]);
        SerialBlobTest.assertEquals((int)3, (int)data[1]);
        SerialBlobTest.assertEquals((int)4, (int)data[2]);
        data = serialBlob.getBytes(2L, 1);
        SerialBlobTest.assertEquals((int)1, (int)data.length);
        SerialBlobTest.assertEquals((int)2, (int)data[0]);
        data = serialBlob.getBytes(1L, 10);
        SerialBlobTest.assertEquals((int)8, (int)data.length);
        SerialBlobTest.assertTrue((boolean)Arrays.equals(buf, data));
        try {
            data = serialBlob.getBytes(2L, -1);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            data = serialBlob.getBytes(0L, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            data = serialBlob.getBytes(-1L, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            data = serialBlob.getBytes(10L, 11);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetBytesJ$B() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] theBytes = new byte[]{9, 10, 11};
        SerialBlob serialBlob = new SerialBlob(buf);
        int count = serialBlob.setBytes(1L, theBytes);
        byte[] res = serialBlob.getBytes(1L, buf.length);
        byte[] expected = new byte[]{9, 10, 11, 4, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(expected, res));
        SerialBlobTest.assertEquals((int)3, (int)count);
        count = serialBlob.setBytes(2L, theBytes);
        res = serialBlob.getBytes(1L, buf.length);
        expected = new byte[]{9, 9, 10, 11, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(expected, res));
        SerialBlobTest.assertEquals((int)3, (int)count);
        count = serialBlob.setBytes(6L, theBytes);
        res = serialBlob.getBytes(1L, buf.length);
        expected = new byte[]{9, 9, 10, 11, 5, 9, 10, 11};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(expected, res));
        SerialBlobTest.assertEquals((int)3, (int)count);
        try {
            serialBlob.setBytes(-1L, theBytes);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(10L, theBytes);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(7L, theBytes);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetBytesJ$BII() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] theBytes = new byte[]{9, 10, 11};
        SerialBlob serialBlob = new SerialBlob(buf);
        int count = serialBlob.setBytes(1L, theBytes, 0, 3);
        byte[] res = serialBlob.getBytes(1L, buf.length);
        byte[] expected = new byte[]{9, 10, 11, 4, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(expected, res));
        SerialBlobTest.assertEquals((int)3, (int)count);
        count = serialBlob.setBytes(3L, theBytes, 1, 2);
        res = serialBlob.getBytes(1L, buf.length);
        expected = new byte[]{9, 10, 10, 11, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(expected, res));
        SerialBlobTest.assertEquals((int)2, (int)count);
        count = serialBlob.setBytes(6L, theBytes, 0, 2);
        res = serialBlob.getBytes(1L, buf.length);
        expected = new byte[]{9, 10, 10, 11, 5, 9, 10, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(expected, res));
        SerialBlobTest.assertEquals((int)2, (int)count);
        try {
            serialBlob.setBytes(7L, theBytes, 0, 10);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(-1L, theBytes, 0, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(10L, theBytes, 0, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(1L, theBytes, -1, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(1L, theBytes, 0, 10);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(7L, theBytes, 0, 3);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(7L, theBytes, 0, -1);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testPosition$BJ() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(buf);
        this.assertBlobPosition_BytePattern((Blob)serialBlob);
        MockSerialBlob mockBlob = new MockSerialBlob();
        mockBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        serialBlob = new SerialBlob((Blob)mockBlob);
        this.assertBlobPosition_BytePattern((Blob)serialBlob);
    }

    public void testPositionLBlobJ() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(buf);
        this.assertBlobPosition_BlobPattern((Blob)serialBlob);
        MockSerialBlob mockBlob = new MockSerialBlob();
        mockBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        serialBlob = new SerialBlob((Blob)mockBlob);
        this.assertBlobPosition_BlobPattern((Blob)serialBlob);
    }

    public void testTruncateJ() throws Exception {
        SerialBlob[] serialBlobs;
        byte[] buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob1 = new SerialBlob(buf);
        MockSerialBlob mockBlob = new MockSerialBlob();
        mockBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob2 = new SerialBlob((Blob)mockBlob);
        SerialBlob[] serialBlobArray = serialBlobs = new SerialBlob[]{serialBlob1, serialBlob2};
        int n = 0;
        int n2 = serialBlobArray.length;
        while (n < n2) {
            SerialBlob serialBlob = serialBlobArray[n];
            serialBlob.truncate(3L);
            SerialBlobTest.assertEquals((long)3L, (long)serialBlob.length());
            byte[] truncatedBytes = serialBlob.getBytes(1L, 3);
            SerialBlobTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, truncatedBytes));
            try {
                serialBlob.truncate(-1L);
                SerialBlobTest.fail((String)"should throw SerialException");
            }
            catch (SerialException serialException) {
                // empty catch block
            }
            SerialBlobTest.assertEquals((long)3L, (long)serialBlob.length());
            try {
                serialBlob.truncate(10L);
                SerialBlobTest.fail((String)"should throw SerialException");
            }
            catch (SerialException serialException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testSetBinaryStreamJ() throws Exception {
        MockSerialBlob mockBlob = new MockSerialBlob();
        mockBlob.binaryStream = new ByteArrayOutputStream();
        SerialBlob serialBlob = new SerialBlob((Blob)mockBlob);
        OutputStream os = serialBlob.setBinaryStream(1L);
        SerialBlobTest.assertTrue((boolean)mockBlob.isSetBinaryStreamInvoked);
        SerialBlobTest.assertEquals((long)1L, (long)mockBlob.pos);
        SerialBlobTest.assertSame((Object)mockBlob.binaryStream, (Object)os);
        mockBlob.binaryStream = null;
        try {
            serialBlob.setBinaryStream(1L);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        byte[] buf = new byte[1];
        serialBlob = new SerialBlob(buf);
        try {
            serialBlob.setBinaryStream(1L);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    private void assertBlobPosition_BytePattern(Blob blob) throws SerialException, SQLException {
        byte[] pattern = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        long pos = blob.position(pattern, 1L);
        SerialBlobTest.assertEquals((long)1L, (long)pos);
        pattern = new byte[]{2, 3, 4};
        pos = blob.position(pattern, 1L);
        SerialBlobTest.assertEquals((long)2L, (long)pos);
        pos = blob.position(pattern, 2L);
        SerialBlobTest.assertEquals((long)2L, (long)pos);
        pos = blob.position(pattern, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pattern = new byte[]{2, 4};
        pos = blob.position(pattern, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position(pattern, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pattern = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        pos = blob.position(pattern, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position(pattern, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pattern = new byte[]{2, 3, 4};
        pos = blob.position(pattern, 0L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position(pattern, -1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position((byte[])null, -1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        try {
            pos = blob.position((byte[])null, 1L);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void assertBlobPosition_BlobPattern(Blob blob) throws SerialException, SQLException {
        MockSerialBlob pattern = new MockSerialBlob();
        pattern.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        long pos = blob.position((Blob)pattern, 1L);
        SerialBlobTest.assertEquals((long)1L, (long)pos);
        pattern.buf = new byte[]{2, 3, 4};
        pos = blob.position((Blob)pattern, 1L);
        SerialBlobTest.assertEquals((long)2L, (long)pos);
        pos = blob.position((Blob)pattern, 2L);
        SerialBlobTest.assertEquals((long)2L, (long)pos);
        pos = blob.position((Blob)pattern, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pattern.buf = new byte[]{2, 4};
        pos = blob.position((Blob)pattern, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position((Blob)pattern, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pattern.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        pos = blob.position((Blob)pattern, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position((Blob)pattern, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pattern.buf = new byte[]{2, 3, 4};
        pos = blob.position((Blob)pattern, 0L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        pos = blob.position((Blob)pattern, -1L);
        SerialBlobTest.assertEquals((long)-1L, (long)pos);
        try {
            pos = blob.position((Blob)null, -1L);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            pos = blob.position((Blob)null, 1L);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        MockSerialBlob abnormalBlob = new MockSerialBlob(true);
        try {
            blob.position((Blob)abnormalBlob, 1L);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.position((Blob)abnormalBlob, -1L);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

