/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v20.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          292,  361,  295,  191,  191,  238,   97,  682,  276,  276, 
          455,  289,  294,  480,  462,  311,  341,  402,  412,  261, 
          405,  192,  641,  205,  191,  279,  279,   88,   88,  573, 
          499,   83,   83,  642,  228,  228,  228,  111,  702,  262, 
          228,  228,  823,  205,  288,  207,  519,  280,  280,  191, 
          521,  316,  320,  701,  261,  835,  701,  317,    8,  754, 
          232,  235,  339,  870,  654,  207,  655,  347,    8,  291, 
           88,   88,  291,  618,  337,  313,  228,  702,   88,  318, 
          322,  535,  564,  538,  650,  726,  643,  845,  400,  654, 
          643,  416,  654,  590,  826,  234,  740,  418,  872,  238, 
          944,  276,  582,  967,  614,  261,  622,  660,  306,  589, 
          628, 1017,  588,  654,  261,  261,  865,    8,  279,  613, 
          234,  736,  678,  574,  301,  337,  234,  590,  654,   88, 
          417,  941,  284,  228,  434,  434,  582,  400,  654,  691, 
          280, 1069,  590,  589,  233,  600,  588,  226,  226,  226, 
           79,  582,   78,  614,  828,  622,  317,  451,  589,  491, 
          406,  588,  234,  915,  352,  654,  654,  507,  613,  233, 
          574,  359,  694,   91,  359,  233,  287,  654,  629,  600, 
          629,  511, 1026,  513,   91,  629,  866,  291,  282,  574, 
           77,  468,  516,  574,  600,   80,  319,  302,  723, 1069, 
          393,   77,  790,   76,  649,  535,  694,  516,  386,  406, 
           86,  233,  296,  352,  284,  654,  574, 1011, 1017,  574, 
          391,  480,  649,  573,  463,  880,  515,  297,  502,  238, 
          633,  694,  394,  654,  352,  287,   88,  652,  574,  891, 
          421,  518,  283,  654,  389,  898,   80,  852,  559,  878, 
           88,  291,  944,  360,  523,  732,  360,  421,  759,  881, 
          733,   86,  392,  760,  870,  702,  527,  288,   84,  977, 
           53,  730,  644,  387,  390,  311,  564,  276,  388,  276, 
          276,  353,  701,  701,  396, 1053,  356, 1051,  306,  582, 
          417,  486,  654,  510,  279,  407,  279,  559,  374,  375, 
           97,  238,  357,  872,  811,  654,  730,  736,  857,  228, 
          812,  228,  228,  654,  613,  228,  280,  228,  280,   84, 
          643,   88,   88,  582,  812,   83,  457, 1082,   88,  408, 
           88,  442,  505,  390,  391,  439,  799,  643,  582,  798, 
          464,  261,  807,  440,  870, 1005,  414,   88,  910,  917, 
          703,  919,  367,  368,  654,  816,  812,  654,  707,  708, 
          500,  337,  654,  613,  958,  457,  831,   81,  306,  694, 
          409,  658,  630,  643,  630,  659,  716,  446,  648,  630, 
          311,  718,  654,  446,  413,  641,  643,  228,  228,  228, 
          228,   88,  228,  228,  276,  584,  642,  453,  655,  623, 
          290,  655,  870,  623,  115,  486,  654,  588,   77,  459, 
           88,  445,  580,  581,  582,  583,  261,  654,   81,  643, 
          573,    8,  573,  643,  646,  624,  228,  654,  490,  736, 
          492,  736,  632,  839,  632,   88,  337,  400,  228,  632, 
         1097,   88,  590,  276,  588,   83,  523,  843,  623,  842, 
          654,  582, 1030,  115,  486,  228,  905, 1034,  589,  452, 
          276,  829,  228,  853,   80,  623,  654,  683,  613,  836, 
          454,  486,   88,  306,  624,  228,  573,  588,  573,   86, 
           88,  709,   79, 1007,   78,  522,  228,  614,  317,  622, 
          853,  624,  228,  191,  600,  856,  702,  654,  654,  623, 
          226,  226,  226,  226,  290,  585,  586,  608,  700,  406, 
          674,  686,  205,  789,  701,  736, 1013,  465,  681,  276, 
          282,  574,  228,  282,  623,  624,  469,   80,  319,  564, 
          486,  564,  393,  261,  207,   88,  801,   84,  629,  629, 
          386,  608,   86,  559,  629,  629,  284,  719,  574,  284, 
          624,  228,  391,  337, 1091,  971,  608,  629,  107,  107, 
          475,  785,  654,  523,  394,  107,  107,  107,  657,  476, 
          654,  107,  107,  839,  283,  667,  389,  283,  401,  841, 
          559,  654,  765,  736,  582,  736,  529,  530,  529,  530, 
          887,  889,  772,  532,  392,  532,  894,  896,  479,  226, 
           84,  107,  107,  369,  770,  387,  390,  107,  859,  613, 
          388,  654,  776,  559,  493,  654,  654,  503,  779,  504, 
           89,  582,  508,   18,  520,  736,  778,  573,  415,  514, 
          654,  522,  778,  747,  749,  710,   81,  769,  844, 1012, 
          398,   17,  654,  277,  283,  775,  613,  399,  404,  528, 
          261,  775,  772,  322,  582,  806,  647,  276,  367,  368, 
          655,  115,  623,  629,  107,  772,  191,  191,  486,  671, 
          337,   89,   18,  661,  625,  810,  814,  673,  819,  613, 
          833,  643,  494,  495,  805,  819,  205,  322,  624,  228, 
           17,   88,  598,  675,  522,  552,  553,  772,  778,   81, 
         1002,  971,  322,  684, 1004,  971,  497,  900,  207,  523, 
           88,  704,   88,  769,  861,  976, 1076,  775,  705,   97, 
          706,  711,  522,  450,  940,  261,  598,  712,  522,  522, 
          522,  720,  630,  630,  322,  625,  420,  840,  630,  630, 
           88,  598,  654,  522,   83,  337,   82,  715,  830,  694, 
          834,  630,   87,   85,  741,  742,  625,  541,  456,  542, 
          543,  544,  545,  971,  743,  746,  884,  107,  884,  748, 
          102,  529,  530,  772,  868,  522,  871,  276,  532,  112, 
          752,  107,  623,  537,  460,  460,  982,  912,  486,  750, 
          460,  654,  632,  632,  753,  756,  261,   82,  632,  632, 
          552,  761,  608,   87,   85,  763,   88,  766,  624,  228, 
          901,  632,  781,  923,  800,  398,  337,  528,  767,  228, 
           88,  768,  399,  400,  108,  108,  322,  773,   88,  461, 
          509,  108,  108,  108,  654,  654,   88,  108,  108,  608, 
          107,  228,  107,  107,  913,   88,  107,   83,  107,  552, 
          774,  788,  107,  107,   88,  861,  608,  630,  786,  107, 
          791,  107,  812,  295,  821,  802,  926,  108,  108,  858, 
          822,  824,  608,  108,  924,   18,   18,   18,  461,  772, 
          825,   18,   18,  928,   18,  827,  854,  467,  879,   89, 
           88,   88,  932,   17,   17,   17,  886,  892,   83,   17, 
           17,  541,   17,  542,  543,  544,  545,  980,   88,  959, 
           88,  893,  481,  984,  484,  450,  911,  632,  107,  107, 
          107,  107,  107,  107,  107,  916,  261,  921, 1045,  950, 
          108,   55,  226,  948,  861,  927,  819,   88,  634,  952, 
          954,   55,  956,  914,  957,  653,  999,  929,  973,  118, 
           88,  918,   89,  930,  226,   18,  933,  107,  935,  937, 
          398,   88,  938,  107,  625,  107,  107,  399,  449,  107, 
          107,  322,  107,   17,  875,  261,   18,  875,  322,  322, 
          942, 1021,  319,  634,  629,  653,  107,  598, 1003, 1054, 
           55,  945,  946,  107,   17, 1038,  654,  947,  118, 1008, 
           18,  654,  322,  107,  108,  121,  107,  814,  951,  127, 
           88,  107,  522,  949,  131,   82,  953,  107,   17,  522, 
          522,   87,   85,  107,  598,  625,  955,   88,  981,   88, 
          525,  972,  654,  108,   88,  714,  983,  276, 1010, 1018, 
          525,  598,  623,  522,  261, 1024,  625,  108,  486, 1019, 
          772,  447,  819,  107,  528, 1063, 1027,  598,  127, 1067, 
          979,  528,  528,  322, 1072, 1046,  107, 1048,  624,  228, 
          322,  322, 1050, 1029,  525, 1031,  629,  654,   82, 1039, 
         1042,  654,  107, 1033,   87,   85,  461, 1040, 1052,  525, 
          447, 1055, 1057, 1058, 1059,  811,  552, 1049,  552,  552, 
          552,  552,  552,   93,   93,  966,  108,  552,  108,  108, 
          102, 1062,  108, 1056,  108,  263,   83, 1100,  108,  108, 
         1070,  525, 1073, 1085,  398,  108,  654,  108, 1081, 1087, 
          552,  399,  466, 1041, 1089,  101, 1092,  876,  552,  552, 
          552,  552, 1104,  641,  102,  654,   93,   93,  847,  848, 
          338,  849,  398,  654,  642, 1098,  526,  643,  461,  399, 
          501,  102,  643,  541,  211,  542,  543,  544,  545,  647, 
          862,  529,  530,  531,  647,  873,  552,  643,  532,   83, 
          664,  649,  527,  654,  108,  108,  108,  108,  108,  108, 
          108,  528,  643,   55,   55,   55,  358,  734,   55,   55, 
           55,  338,   55,  470,  471,  472,  118,  350,  474,  758, 
          435,  435,   55,  211,  473,  436,   59,   60,  717,  626, 
          107, 1080,  107,  108,   55,   55,   55,   55,   55,  108, 
         1047,  108,  108,  784,  103,  108,  108,  194,  108,  127, 
          447,  107,  780,  107,  121,  885,  985,  869,  966,  874, 
         1064,  966,  108,  875,  962,  966,  529,  530,  534,  108, 
         1065,  899,  792,  532,  610,  265,  127,  525,  969,  108, 
          855,  107,  108,   55,  525,  525, 1044,  108, 1083,  447, 
          626,  529,   65,  108,  654,  654,  654,  403,  447,  108, 
         1079,  654,   65,  121,   55,  447,  447,  815,  888,  890, 
            0,  626,    0,    0,  895,  897,    0,  104,  961,  966, 
          626,  966,   93,  966,    0,    0,  966,    0,   55,  108, 
            0,    0,  447,  107,  107,  528,   93,  447,  966,  107, 
          107,  654,  108,    0,  447,  447,  654,  107,  654,    0, 
          107,   65,  107,  642,    0,    0,    0,  651,  108,    0, 
          107,  107,  888,  890,  530,  895,  897,    0,  525,  107, 
            0,  447,    0,    0,    0,  525,  525,  107,    0,  546, 
          120,  626,  107,    0,  547,    0,  107,  664, 1020,  102, 
         1022,    0, 1023,    0,    0,  107,  261,    0,    0,  525, 
            0,  642,  626,  398,    0,    0,  261,   93,   93,    0, 
          399,  525,  275,    0,   93,    0,   93,  552,  553,  697, 
          699,  969,  275,  319,  969,    0, 1066,  398,  969,  527, 
            0,  107,  107,    0,  399,  663,  527,  527,  528,    0, 
          261,  529,  530,  536,    0,  528,  528,  338,  532,  107, 
            0,  107,  102,  554,  261,  261,  270,    0,  107,  699, 
            0, 1060,  319,  362,  363,  364,  365,  366, 1068,    0, 
          211,  275,  211,  211,  211,  211,  211,   93,  107,  122, 
          398,  211,  969,  129,  969,    0,  969,  399,  783,  969, 
            0,  107,  528, 1084,    0,  120,  108,    0,  108,    0, 
          528,  969,  107,    0,  211,  211,  369,   61,   62,   63, 
           64,  121,  211,  211,  211,  211,  755,  108,  635,  108, 
          635,   93,  338,  398, 1099,  635, 1101,   93,  529, 1102, 
          399, 1043,  129,    0,    0,  529,  529,    0,  384,    0, 
            0, 1108,  386,  387,  120,    0,   96,  108,    0,  128, 
          211,  107,  123,    0,   65,   65,   65,    0,   93,   65, 
           65,   65,    0,   65,  632,    0,   93,    0,  107,    0, 
          107,    0,  528,   65,   65,  107,  527,    0,    0,  528, 
          528,  787,   65,   65,    0,   65,   65,   65,   65,   65, 
            0,    0,  131,  522,  303,  529,  530,  534,  128,  108, 
          108,  530,  532,    0,  303,  108,  108,    0,  530,  530, 
          107,    0,  696,  108,    0,  808,  108,    0,  108,    0, 
            0,   93,    0,    0,  398,    0,  108,  108,    0,    0, 
          628,  399, 1071,    0,   65,  108,    0,   65,  296,  338, 
          837,  131,  838,  108,    0,    0,    0,    0,  108,  699, 
          319,    0,  108,  303,    0,   65,    0,    0,  261,  261, 
          261,  108,    0,  261,  261,  261, 1014,  261,  542,  543, 
          544,  545,    0,  322,  275,  275,  275,  261,  261,   65, 
          275,  275,    0,  275,    0,    0,  261,  261,  122,  261, 
          261,  261,  261,  261,  275,  275,    0,  108,  108,    0, 
          877,  261,  275,  275,    0,  275,  275,  275,  275,  529, 
          530,  729,  529,  530,  757,  108,  532,  108,    0,  532, 
          298,  300,    0,    0,  108,    0,  275,  275,    0,  340, 
          342,    0,  909,    0,    0,  261,    0,  122,  261,    0, 
          129,  261,    0,  261,  108,    0,    0,    0,  436,    0, 
            0,    0,  120,  632,  275,    0,  338,  108,  436,  261, 
          541,    0,  542,  543,  544,  545,    0,    0,  108,  529, 
            0,  261,  931,    0,    0,  275,    0,   93,  970,    0, 
            0,  115,  625,  261,  494,  494,  494,  275,    0,    0, 
            0,  494,    0,    0,  734,    0,   93,    0,   93,  275, 
            0,  632,  735,    0,    0,    0,  128,  436,  632,  632, 
            0,   96,   96,  527,  628,    0,    0,  108,    0,  628, 
          527,  527,  123,  264,    0,    0,   93,    0,    0,    0, 
          522,  338,    0,    0,  108,  632,  108,  522,  522,  851, 
            0,  108,    0,  625,    0,    0,    0,    0,   96,  131, 
            0,    0,  978,    0,   96,   96,  303,  303,  303,    0, 
            0,  303,  303,  303,  625,  303,  125,  628,  103,  103, 
            0,  123,    0,  106,  628,  628,  108,    0,  635,  635, 
          628,  319,   96,    0,  635,  635,    0,  303,  303,  303, 
          303,  303,   93,    0,    0,    0,    0,  635,    0,   96, 
            0,  628,  338,  530,    0,  369,   93,    0,    0,    0, 
          322,  103,  103,    0,   93,  125,    0,  322,  322,    0, 
          532,  970,   93,  629,  970,    0,  970,    0,  970,  522, 
            0,   93,    0,  303,    0,    0,  303,  384,    0,    0, 
           93,  386,  387,  388,  389,  122,  295,  532,  275,  275, 
          275,  342,    0,  275,    0,    0,  295,  303,    0,  204, 
            0,    0,    0,  275,    0,  275,  275,    0,    0,    0, 
            0,    0,    0,    0,  498,    0,   93,   93,    0,    0, 
            0,  303,  970,    0,  970,    0,  970,    0,    0,  970, 
          295,    0,    0,    0,   93,    0,   93,  124,    0,    0, 
            0,  970,    0,  635,    0,  295,  529,    0,  204,    0, 
          436,  436,  436,  529,  529,  436,  436,  436,    0,  436, 
           96,    0,    0,   93,  641,  641,  641,    0,    0,  436, 
          641,  641, 1000,  641,   96,    0,   93,    0,  436,  436, 
          214,  436,  436,  436,  436,  436,  124,   93,  587,  588, 
          589,  590,  591,  291,    0,  592,  593,  594,  595,  596, 
          597,  598,  599,  600,  601,  602,  603,  604,  605,    0, 
          126,  606,  607,  608,  609,    0,  436,  103,  531,  123, 
          275,  435,  625,  436,  436,    0,  631,    0,  638,  214, 
          436,  103,  275,  631,    0,    0,   93,    0,    0,    0, 
            0,    0,    0,    0,  641,   96,   96,    0,  125,    0, 
            0,  436,   96,   93,   96,   93,    0,   96,  625,  126, 
           93,    0,    0,  125,    0,  641,    0,    0,    0,  275, 
            0,  631,  631,  631,    0,  436,  275,    0,    0,    0, 
          530,    0,    0,  260,    0,    0,  275,  530,  530,  641, 
          435,  533,  112,  260,  275,  275,    0,  532,  275,    0, 
            0,    0,  103,  103,  532,  532,  522,    0,    0,  103, 
            0,  103,    0,  522,  522,   96,    0,    0,    0,  625, 
           96,    0,  713,  631,  532,    0,  112,  260,    0,    0, 
            0,  532,  532,    0,  275,    0,    0,  275,    0,    0, 
          625,  260,  260,  112,    0,  275,  260,    0,  295,  295, 
          295,   99,    0,  295,  295,  295,  636,  295,  636,   96, 
            0,    0,    0,  636,    0,   96,    0,  295,  295,    0, 
          117,    0,  103,  322,    0,    0,  295,  295,    0,  295, 
          295,  295,  295,  295,  541,   99,  542,  543,  544,  545, 
            0,  275,    0,    0,  124,  204,   96,  204,  204,  204, 
          204,  204,   99,    0,   96,    0,  204,    0,    0,    0, 
            0,    0,    0,  103,    0,  103,  103,  527,  734,  117, 
          103,    0,  103,    0,    0,  527,  943,    0,  295,  204, 
          204,  295,  525,  295,    0,    0,    0,  204,  204,  204, 
          204,    0,    0,    0,  300,    0,    0,    0,    0,  295, 
            0,  524,    0,  103,  300,  531,  275,    0,    0,   96, 
            0,  103,  531,  531,    0,    0,   99,  126,    0,    0, 
            0,    0,    0,  295,    0,  204,  214,  130,  214,  214, 
          214,  214,  214,  275,    0,    0,    0,  214,  295,  541, 
          275,  542,  543,  544,  545,  546,    0,  105,  529,    0, 
          547,    0,    0,  300,    0,    0,  529,    0,    0,    0, 
          214,  214,    0,  525,    0,  275,  103,  275,  214,  214, 
          214,  214,    0,  548,  275,  275,  130,    0,  533,    0, 
            0,  550,  551,  552,  553,  533,  533,    0,    0,    0, 
            0,    0,    0,    0,  531,  260,  260,  260,    0,    0, 
          260,  260,  260,    0,  260,    0,  214,    0,  629,  107, 
            0,  112,  110,    0,  260,  260,    0,    0,    0,  554, 
            0,    0,    0,  260,  260,  275,  260,  260,  260,  260, 
          260,    0,    0,    0,    0,    0,  631,  631,  260,    0, 
            0,    0,  631,  631,    0,    0,    0,    0,    0,  116, 
            0,  902,    0,  275,  101,  631,  533,  275,  260,  632, 
          322,    0,  260,  260,    0,   96,    0,  322,  322,  297, 
           99,  626,  260,  629,  112,  260,    0,  117,  260,  297, 
          260,    0,    0,    0,   96,    0,   96,    0,  101,    0, 
          631,  631,    0,  631,  631,  199,  260,  275,  116,    0, 
            0,    0,    0,    0,    0,  101,    0,    0,  260,    0, 
            0,    0,    0,  297,   96,    0,    0,    0,    0,  525, 
          260,    0,  103,    0,    0,    0,  525,  525,  297,    0, 
          523,    0,  626,   99,    0,  527,   98,    0,  524,    0, 
            0,  103,    0,  103,  199,  524,  524,    0,    0,    0, 
            0,  118,  626,  626,   97,  974,  300,  300,  300,    0, 
            0,  975,  300,  300,    0,  300,  636,  636,    0,    0, 
            0,  103,  636,  636,    0,  100,    0,  275,    0,    0, 
           96,    0,  124,  524,  130,  636,    0,  300,  300,  300, 
          300,  300,    0,    0,   96,    0,    0,  629,  975,    0, 
          525,  523,   96,    0,    0,    0,  275,  525,  525,    0, 
           96,  522,    0,  626,    0,    0,    0,    0,    0,   96, 
            0,  522,  526,  103,  103,    0,    0,    0,   96,  103, 
          103,  531,    0,    0,  626,    0,  300,  103,  531,  531, 
            0,    0,  103,    0,  126,  629,    0,  129,  632,    0, 
            0,  103,  629,  629,    0,  522,    0,  300,  629,  103, 
            0,    0,    0,    0,   96,   96,    0,  103,    0,  522, 
          522,    0,  115,    0,  522,    0,  103,    0,  369,  629, 
            0,  300,   96,    0,   96,  103,    0,    0,    0,    0, 
            0,  636,    0,  533,  382,  383,  632,    0,    0,    0, 
          533,  533,  522,  632,  632,    0,  116,    0,    0,  628, 
          384,   96,  385,  275,  386,  387,  388,  389,    0,    0, 
         1001,  103,  103,  101,   96,    0,    0,    0,    0,    0, 
          632,  297,  297,  297,    0,   96,  297,  297,  297,  103, 
          297,  103,    0,    0,    0,    0,  525,    0,  103,    0, 
          297,  297,    0,    0,    0,    0,  525,    0,    0,  297, 
          297,    0,  297,  297,  297,  297,  297,  523,  103,    0, 
            0,  117,  527,    0,  523,  523,    0,    0,    0,  527, 
          527,  103,    0,    0,   96,    0,  101,    0,    0,  116, 
          525,  199,  103,  199,  199,  199,  199,  199,    0,    0, 
            0,   96,  199,   96,  525,  525,    0,  118,   96,  525, 
          119,  297,    0,  530,  297,    0,  297,    0,    0,    0, 
          524,  530,    0,    0,    0,  199,  199,  524,  524,    0, 
            0,    0,  297,  199,  199,  199,  199,  525,  523,    0, 
            0,  103,    0,    0,    0,  523,  523,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  297,    0,  103,  526, 
          103,    0,    0,    0,    0,  103,  526,  526,  625,  625, 
          625,  199,  625,  522,  522,  522,  625,  625,  522,  522, 
          522,  625,  522,  625,  625,  625,  625,  625,  625,  625, 
            0,  625,  522,  522,  625,  625,  625,  625,  625,  625, 
          625,  522,  522,  625,  522,  522,  522,  522,  522,    0, 
          625,    0,    0,  625,  625,  625,  522,  625,  625,  625, 
          625,  625,  625,  625,  625,  625,  625,  625,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,    0,    0,  522,  522,  522,  522,  625,  534, 
          522,  625,  625,  522,  625,  625,  522,  625,  522,  625, 
          522,  625,  522,  625,  522,  522,  522,  522,  522,  522, 
          522,  625,  522,  625,  522,    0,  625,  625,  625,  625, 
          625,  625,    0,    0,    0,  625,  522,  625,  625,    0, 
          625,  625,  625,  625,    0,  625,  625,  625,  522,  336, 
            0,    0,    0,  626,  626,  626,    0,  626,  525,  525, 
          525,  626,  626,  525,  525,  525,  626,  525,  626,  626, 
          626,  626,  626,  626,  626,    0,  626,  525,  525,  626, 
          626,  626,  626,  626,  626,  626,  525,  525,  626,  525, 
          525,  525,  525,  525,    0,  626,    0,    0,  626,  626, 
          626,  525,  626,  626,  626,  626,  626,  626,  626,  626, 
          626,  626,  626,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  114,    0,  525, 
          525,  525,  525,  626,  537,  525,  626,  626,  525,  626, 
          626,  525,  626,  525,  626,  525,  626,  525,  626,  525, 
          525,  525,  525,  525,  525,  525,  626,  525,  626,  525, 
            0,  626,  626,  626,  626,  626,  626,    0,    0,  632, 
          626,  525,  626,  626,  313,  626,  626,  626,  626,  632, 
          626,  626,  626,  525,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 1028,    0,    0,    0, 
         1032,    0,    0,  369,    0,  642,  642,  642,  374,  375, 
            0,  642,  642,  632,  642,    0,    0,  369,    0,  382, 
          383,    0,    0,    0,    0,    0,    0,  632,  632,    0, 
          129,    0,  632,  382,  383,  384,    0,  385,    0,  386, 
          387,  388,  389,  390,  391,  392,    0,  393,    0,  384, 
            0,  385,    0,  386,  387,  388,  389,    0,    0,  392, 
          632,  393,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          241,  242,   17,   18,    0,  642,    0,    0,   19,  243, 
          244,  323,  324,  325,  326, 1086,    0,  249, 1088, 1090, 
          628,    0, 1093, 1094,  250,    0,  642,  327,  328,  329, 
          628,  330,   35,  331,  332,  333,  334,    0,   40,    0, 
            0,  259,  541,    0,  542,  543,  544,  545,  546,    0, 
          642,    0,    0,  547, 1103, 1105, 1106, 1107,    0,    0, 
            0,    0,  335, 1109,  628,  225,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,  548,  549,  628,  628, 
          369,  128,  133,  628,  550,  551,  552,  553,    0,    0, 
           52,   53,   54,   55,   56,   57,  382,  383,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  628,  384,    0,    0,    0,  386,  387,  388,  389, 
            0,    0,  554,    0,    0,    0,    0,    0,    0,    0, 
            0,  313,    0,    0,    0,    0,    0,    0,  313,  313, 
          181,    0,    0,    0,    0,    0,  628,  628,  628,    0, 
          628,  632,  632,  632,  628,  628,  632,  632,  632,  628, 
          632,  628,  628,  628,  628,  628,  628,  628,    0,  632, 
          632,  632,  628,  628,  628,  628,  628,  628,  628,  632, 
          632,  628,  632,  632,  632,  632,  632,    0,  628,  181, 
            0,  628,  628,  628,  632,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  632,  632,  632,  632, 
          632,  632,  632,  632,  632,  632,  632,  632,  632,  632, 
          113,    0,  632,  632,  632,  632,  628,    0,  632,  628, 
          628,  632,  628,  628,  632,  628,  632,  628,  632,  628, 
          632,  628,  632,  632,  632,  632,  632,  632,  632,  628, 
          632,  632,  632,    0,  628,  628,  628,  628,  628,  628, 
            0,    0,    0,  628,  632,  628,  628,  323,  628,  628, 
          628,  628,    0,  628,  628,  628,  632,  628,  628,  628, 
            0,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,    0, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,    0,  628, 
            0,    0,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,    0,    0,  628,  628,  628,  628,  628,    0,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,    0,  628,  628,  628,  628,  628, 
          628,    0,    0,  629,  628,  628,  628,  628,    0,  628, 
          628,  628,  628,  629,  628,  628,  628,  628,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  541, 
            0,  542,  543,  544,  545,  546,    0,    0,    0,    0, 
          547,    0,    0,    0,    0,    0,  181,  629,  181,  181, 
          181,  181,  181,    0,    0,    0,    0,  181,    0,    0, 
            0,  629,  629,  548,  130,  132,  629,    0,  532,    0, 
            0,  550,  551,  552,  553,    0,  532,    0,    0,    0, 
          181,  181,    0,    0,    0,    0,    0,    0,  181,  181, 
          181,  181,    0,    0,  629,  541,    0,  542,  543,  544, 
          545,  546,    0,    0,    0,    0,  547,    0,    0,  554, 
            0,    0,    0,    0,  323,    0,    0,    0,    0,    0, 
            0,  323,  323,    0,    0,    0,  181,    0,    0,  548, 
            0,    0,    0,    0,  314,    0,    0,    0,    0,  552, 
          553,    0,    0,    0,  314,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  611,  612,    0,    0, 
          613,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,  166,  167,  168,    0,  554,  169,  170,  314,    0, 
            0,  171,  172,  173,  174,    0,    0,    0,    0,    0, 
            0,  287,  314,  314,    0,    0,    0,  314,  176,  177, 
            0,  178,  179,  180,  181,  182,  183,  184,  185,  186, 
          187,  188,    0,    0,  189,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  314,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  182,    0,    0,    0,    0,    0, 
          629,  629,  629,    0,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,    0,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,    0,  629,  182,    0,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,    0,    0,  629,  629,  629,  629, 
          629,    0,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,    0,  629,  629, 
          629,  629,  629,  629,    0,    0,    0,  629,  629,  629, 
          629,    0,  629,  629,  629,  629,    0,  629,  629,  629, 
          629,  627,  627,  627,    0,  627,  314,  314,  314,  627, 
          627,  314,  314,  314,  627,  314,  627,  627,  627,  627, 
          627,  627,  627,    0,  627,  314,  314,  627,  627,  627, 
          627,  627,  627,  627,  314,  314,  627,  314,  314,  314, 
          314,  314,    0,  627,    0,    0,  627,  627,  627,  314, 
          627,  627,  627,  627,  627,  627,  627,  627,  627,  627, 
          627,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
          314,  314,  314,  314,  314,    0,    0,  314,  314,  314, 
          314,  627,    0,  314,  627,  627,  314,  627,  627,  314, 
          627,  314,  627,  314,  627,  314,  627,  314,  314,  314, 
          314,  314,  314,  314,  627,  314,  627,  314,    0,  627, 
          627,  627,  627,  627,  627,    0,    0,  633,  627,  314, 
          627,  627,    0,  627,  627,  627,  627,  633,  627,  627, 
          627,  314,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          182,  633,  182,  182,  182,  182,  182,    0,    0,    0, 
            0,  182,    0,    0,    0,  633,  633,    0,    0,    0, 
          633,    0,  531,  369,  370,  371,  372,  373,  374,  375, 
          531,    0,  378,  379,  182,  182,    0,    0,    0,  382, 
          383,    0,  182,  182,  182,  182,    0,    0,  633,    0, 
            0,    0,    0,    0,    0,  384,    0,  385,    0,  386, 
          387,  388,  389,  390,  391,  392,    0,  393,    0,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
          182,    0,    9,   10,    0,    0,    0,   11,  634,   12, 
           13,   14,  241,  242,   17,   18,    0,    0,  634,    0, 
           19,  243,  244,  245,  246,  247,  248,    0,    0,  249, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,  251, 
          252,  253,    0,  254,   35,  255,  256,  257,  258,    0, 
           40,    0,  634,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  634,  634,    0,    0, 
            0,  634,    0,    0,  260,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  634, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,    0,    0,  183,    0, 
            0,    0,    0,    0,  630,  630,  630,    0,  630,  633, 
          633,  633,  630,  630,  633,  633,  633,  630,  633,  630, 
          630,  630,  630,  630,  630,  630,    0,  633,  633,  633, 
          630,  630,  630,  630,  630,  630,  630,  633,  633,  630, 
          633,  633,  633,  633,  633,    0,  630,  183,    0,  630, 
          630,  630,  633,  630,  630,  630,  630,  630,  630,  630, 
          630,  630,  630,  630,  633,  633,  633,  633,  633,  633, 
          633,  633,  633,  633,  633,  633,  633,  633,    0,    0, 
          633,  633,  633,  633,  630,    0,  633,  630,  630,  633, 
          630,  630,  633,  630,  633,  630,  633,  630,  633,  630, 
          633,  633,  633,  633,  633,  633,  633,  630,  633,  633, 
          633,    0,  630,  630,  630,  630,  630,  630,    0,    0, 
            0,  630,  633,  630,  630,    0,  630,  630,  630,  630, 
            0,  630,  630,  630,  633,  631,  631,  631,    0,  631, 
          634,  634,  634,  631,  631,  634,  634,  634,  631,  634, 
          631,  631,  631,  631,  631,  631,  631,    0,  634,  634, 
          634,  631,  631,  631,  631,  631,  631,  631,  634,  634, 
          631,  634,  634,  634,  634,  634,  394,  631,    0,    0, 
          631,  631,  631,  634,  631,  631,  631,  631,  631,  631, 
          631,  631,  631,  631,  631,  634,  634,  634,  634,  634, 
          634,  634,  634,  634,  634,  634,  634,  634,  634,    0, 
            0,  634,  634,  634,  634,  631,    0,  634,  631,  631, 
          634,  631,  631,  634,  631,  634,  631,  634,  631,  634, 
          631,  634,  634,  634,  634,  634,  634,  634,  631,  634, 
          634,  634,    0,  631,  631,  631,  631,  631,  631,    0, 
            0,  322,  631,  634,  631,  631,    0,  631,  631,  631, 
          631,  322,  631,  631,  631,  634,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  183,  322,  183,  183,  183,  183, 
          183,    0,    0,    0,    0,  183,    0,    0,    0,  322, 
          322,    0,  131,    0,  322,    0,  533,    0,    0,    0, 
            0,    0,    0,    0,  533,    0,    0,    0,  183,  183, 
            0,    0,    0,    0,    0,    0,  183,  183,  183,  183, 
            0,    0,  322,    0,    0,    0,    0,  369,  370,  371, 
          372,  373,  374,  375,  376,  377,  378,  379,    0,    0, 
            0,    0,    0,  382,  383,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  183,    0,    0,    0,    0,  384, 
            0,  385,  446,  386,  387,  388,  389,  390,  391,  392, 
            0,  393,  446,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          782,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  446,    0,    0,    0, 
          369,  370,  371,  372,  373,  374,  375,  376,  377,  378, 
          379,  446,  380,  381,    0,  446,  382,  383,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  384,    0,  385,    0,  386,  387,  388,  389, 
          390,  391,  392,  446,  393,    0,    0,    0,    0,    0, 
            0,  139,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  629,  629, 
          629,    0,  629,  322,  322,  322,  629,  629,  322,  322, 
          322,  629,  322,  629,  629,  629,  629,  629,  629,  629, 
          139,    0,  322,  322,  629,  629,  629,  629,  629,  629, 
          629,  322,  322,  629,  322,  322,  322,  322,  322,    0, 
          629,    0,    0,  629,  629,  629,  322,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  322,  322, 
          322,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
          322,  322,  109,    0,  322,  322,  322,  322,  629,    0, 
          322,  629,  629,  322,  629,  629,  322,  629,  322,  629, 
          322,  629,  322,  629,  322,  322,  322,  322,  322,  322, 
          322,  629,  322,    0,  322,    0,  629,  629,  629,  629, 
          629,  629,    0,    0,    0,  629,  322,  629,  629,  628, 
          629,  629,  629,  629,    0,  629,  629,  629,  322,  290, 
          290,  290,    0,  290,  446,  446,  446,  290,  290,  446, 
          446,  446,  290,  446,  290,  290,  290,  290,  290,  290, 
          290,  394,  446,  446,  446,  290,  290,  290,  290,  290, 
          290,  290,  446,  446,  290,  446,  446,  446,  446,  446, 
            0,  290,    0,    0,  290,  290,  290,    0,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  446, 
          446,  446,  446,  446,  446,  446,  446,  446,  446,  446, 
          446,  446,  446,  654,    0,  446,  446,  446,  446,  290, 
            0,  446,  290,  654,  446,  290,  290,  446,  290,  446, 
          290,  446,  290,  446,  290,  446,  446,  446,  446,  446, 
          446,  446,  290,  446,  446,  446,    0,  290,  290,  290, 
          290,  290,  290,    0,    0,    0,  290,  654,  290,  290, 
            0,  290,  290,  290,  290,    0,  290,  290,  290,  446, 
            0,    0,  654,    0,    0,    0,  654,  139,    0,  139, 
          139,  139,  139,  139,    0,    0,    0,    0,  139,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  522, 
            0,    0,    0,    0,  654,    0,    0,  522,    0,    0, 
            0,  139,  139,    0,    0,    0,    0,  128,  628,  139, 
          139,  139,  139,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  329,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  329,    0,    0,  139,    0,    0, 
            0,    0,    0,    0,    0,    0,  628,    0,    0,    0, 
            0,    0,    0,  628,  628,    0,    0,    0,    0,  628, 
            0,    0,    0,    0,    0,    0,    0,    0,  329,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          628,    0,    0,  329,    0,    0,    0,  329,    0,    0, 
            0,    0,    0,    0,    0,  369,  370,  371,  372,  373, 
          374,  375,  376,  377,  378,  379,    0,  380,  381,    0, 
            0,  382,  383,    0,    0,  329,    0,    0,    0,    0, 
            0,    0,    0,  140,    0,    0,    0,  384,    0,  385, 
            0,  386,  387,  388,  389,  390,  391,  392,    0,  393, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          290,  290,  290,    0,  290,  654,  654,  654,  290,  290, 
          654,  654,  654,  290,  654,  290,  290,  290,  290,  290, 
          290,  290,  140,  654,  654,  654,  290,  290,  290,  290, 
          290,  290,  290,  654,  654,  290,  654,  654,  654,  654, 
          654,    0,  290,    0,    0,  290,  290,  290,    0,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          654,  654,  654,  654,  654,  654,  654,  654,  654,  654, 
          654,  654,  654,  654,  111,    0,  654,  654,  654,  654, 
          290,    0,  654,  290,    0,  654,  290,  290,  654,  290, 
          654,  290,  654,  290,  654,  290,  654,  654,  654,  654, 
          654,  654,  654,  290,  654,  654,  654,    0,  290,  290, 
          290,  290,  290,  290,    0,    0,    0,  290,    0,  290, 
          290,  629,  290,  290,  290,  290,    0,  290,  290,  290, 
          654,  290,  290,  290,    0,  290,  329,  329,  329,  290, 
          290,  329,  329,  329,  290,  329,  290,  290,  290,  290, 
          290,  290,  290,    0,    0,  329,  329,  290,  290,  290, 
          290,  290,  290,  290,  329,  329,  290,  329,  329,  329, 
          329,  329,    0,  290,    0,    0,  290,  290,  290,    0, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  329,  329,  329,  329,  329,  329,  329,  329,  329, 
          329,  329,  329,  329,  329,  522,    0,  329,  329,  329, 
          329,  290,    0,  329,  290,  522,  329,  290,  290,  329, 
          290,  329,  290,  329,  290,  329,  290,  329,  329,  329, 
          329,  329,  329,  329,  290,  329,    0,  329,    0,  290, 
          290,  290,  290,  290,  290,    0,    0,    0,  290,   96, 
          290,  290,    0,  290,  290,  290,  290,    0,  290,  290, 
          290,  329,    0,    0,  522,    0,  115,    0,  522,  140, 
            0,  140,  140,  140,  140,  140,    0,    0,    0,    0, 
          140,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  525,    0,    0,    0,    0,  522,    0,    0,  525, 
            0,    0,    0,  140,  140,    0,    0,    0,    0,  130, 
          629,  140,  140,  140,  140,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  525,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  525,    0,    0,  140, 
            0,    0,    0,    0,    0,    0,    0,    0,  629,    0, 
            0,    0,    0,    0,    0,  629,  629,    0,    0,    0, 
            0,  629,    0,    0,    0,    0,    0,    0,    0,    0, 
           99,    0,    0,    0,  369,  370,  371,  372,  373,  374, 
          375,  376,  629,  378,  379,  525,    0,  118,    0,  525, 
          382,  383,    0,    0,    0,    0,  103,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  384,    0,  385,    0, 
          386,  387,  388,  389,  390,  391,  392,  525,  393,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          103,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  103,    0,    0, 
            0,    0,  625,  625,  625,    0,  625,  522,  522,  522, 
          625,  625,    0,  522,  522,  625,  522,  625,  625,  625, 
          625,  625,  625,  625,    0,  625,    0,  529,  625,  625, 
          625,  625,  625,  625,  625,  522,  522,  625,  522,  522, 
          522,  522,  522,    0,  625,    0,    0,  625,  625,  625, 
            0,  625,  625,  625,  625,  625,  625,  625,  625,  625, 
          625,  625,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,    0,    0,  522,  522, 
          522,  522,  625,  534,    0,  625,  625,  522,  625,  625, 
            0,  625,    0,  625,  522,  625,  522,  625,  522,  522, 
          522,  522,  522,  522,  522,  625,  522,  625,  522,    0, 
          625,  625,  625,  625,  625,  625,    0,    0,    0,  625, 
            0,  625,  625,    0,  625,  625,  625,  625,    0,  625, 
          625,  625,  522,  626,  626,  626,    0,  626,  525,  525, 
          525,  626,  626,    0,  525,  525,  626,  525,  626,  626, 
          626,  626,  626,  626,  626,    0,  626,    0,    0,  626, 
          626,  626,  626,  626,  626,  626,  525,  525,  626,  525, 
          525,  525,  525,  525,    0,  626,    0,    0,  626,  626, 
          626,    0,  626,  626,  626,  626,  626,  626,  626,  626, 
          626,  626,  626,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,    0,    0,  525, 
          525,  525,  525,  626,  537,  103,  626,  626,  525,  626, 
          626,    0,  626,    0,  626,  525,  626,  525,  626,  525, 
          525,  525,  525,  525,  525,  525,  626,  525,  626,  525, 
            0,  626,  626, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          626,  626,  626,  626,    0,    0,  632,  626,    0,  626, 
          626,    0,  626,  626,  626,  626,  632,  626,  626,  626, 
          525,  529,    0,    0,    0,    0,    0,    0,  529,  529, 
            0,    0,    0,    0,    0,  103,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          110,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  632,    0,  129,    0,  632, 
            0,    0,    0,  619,  620,    0,    0,  621,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,  166,  167, 
          168,    0,    0,  169,  170,    0,    0,  632,  171,  172, 
          173,  174,    0,    0,    0,    0,    0,    0,  287,    0, 
            0,    0,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,  185,  186,  187,  188,    0, 
            0,  189,    0,    0,    0,    0,    0,  628,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  628,    0,    0, 
          104,    0,    0,  190,    0,    0,    0,    0,    0,    0, 
            0,    0,  676,  612,    0,    0,  677,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,  166,  167,  168, 
            0,  109,  169,  170,  104,    0,    0,  171,  172,  173, 
          174,    0,    0,    0,    0,    0,  628,  287,  128,    0, 
          628,  104,    0,    0,  176,  177,    0,  178,  179,  180, 
          181,  182,  183,  184,  185,  186,  187,  188,    0,    0, 
          189,    0,    0,    0,    0,    0,    0,    0,  628,    0, 
            0,  530,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  190,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  628,  628,  628,    0,  628,  632,  632, 
          632,  628,  628,    0,  632,  632,  628,  632,  628,  628, 
          628,  628,  628,  628,  628,    0,  632,    0,    0,  628, 
          628,  628,  628,  628,  628,  628,  632,  632,  628,  632, 
          632,  632,  632,  632,    0,  628,    0,    0,  628,  628, 
          628,    0,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  632,  632,  632,  632,  632,  632,  632, 
          632,  632,  632,  632,  632,  632,  632,    0,    0,  632, 
          632,  632,  632,  628,    0,    0,  628,  628,  632,  628, 
          628,    0,  628,    0,  628,  632,  628,  632,  628,  632, 
          632,  632,  632,  632,  632,  632,  628,  632,  632,  632, 
            0,  628,  628,  628,  628,  628,  628,    0,    0,    0, 
          628,    0,  628,  628,    0,  628,  628,  628,  628,    0, 
          628,  628,  628,  632,  628,  628,  628,    0,  628,  628, 
          628,  628,  628,  628,    0,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,    0,  628,    0,  104, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,    0,  628,    0,    0,  628, 
          628,  628,    0,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  530,    0, 
          628,  628,  628,  628,  628,  530,  530,  628,  628,  628, 
          628,  628,  104,  628,    0,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,    0,  628,  628,  628,  628,  628,  628,    0,    0, 
          629,  628,    0,  628,  628,    0,  628,  628,  628,  628, 
          629,  628,  628,  628,  628,    0,    0,    0,    0,    0, 
            0,    0,  679,  620,    0,    0,  680,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,  166,  167,  168, 
            0,    0,  169,  170,  111,    0,    0,  171,  172,  173, 
          174,    0,    0,    0,    0,    0,    0,  287,    0,  629, 
            0,  130,    0,  629,  176,  177,    0,  178,  179,  180, 
          181,  182,  183,  184,  185,  186,  187,  188,    0,    0, 
          189,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  629,    0,    0,    0,    0,    0,    0,    0,    0, 
          688,  612,  190,    0,  689,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,  166,  167,  168,    0,    0, 
          169,  170,    0,    0,    0,  171,  172,  173,  174,    0, 
            0,  632,    0,    0,    0,  287,    0,    0,    0,    0, 
            0,  632,  176,  177,  106,  178,  179,  180,  181,  182, 
          183,  184,  185,  186,  187,  188,  692,  620,  189,    0, 
          693,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,  166,  167,  168,    0,  632,  169,  170,  106,    0, 
          190,  171,  172,  173,  174,    0,    0,    0,    0,    0, 
          632,  287,  129,    0,  632,  106,    0,    0,  176,  177, 
            0,  178,  179,  180,  181,  182,  183,  184,  185,  186, 
          187,  188,    0,    0,  189,    0,    0,    0,    0,    0, 
            0,    0,  632,    0,    0,  532,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  629,  629,  629, 
            0,  629,  629,  629,  629,  629,  629,    0,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,    0, 
          629,    0,    0,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,    0,  629, 
            0,    0,  629,  629,  629,    0,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,    0,    0,  629,  629,  629,  629,  629,    0,    0, 
          629,  629,  629,  629,  629,    0,  629,    0,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,    0,  629,  629,  629,  629,  629, 
          629,    0,    0,    0,  629,    0,  629,  629,    0,  629, 
          629,  629,  629,    0,  629,  629,  629,  629,  628,  628, 
          628,    0,  628,  632,  632,  632,  628,  628,    0,  632, 
          632,  628,  632,  628,  628,  628,  628,  628,  628,  628, 
            0,  632,    0,  106,  628,  628,  628,  628,  628,  628, 
          628,  632,  632,  628,  632,  632,  632,  632,  632,    0, 
          628,    0,    0,  628,  628,  628,    0,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  632,  632, 
          632,  632,  632,  632,  632,  632,  632,  632,  632,  632, 
          632,  632,  532,    0,  632,  632,  632,  632,  628,  532, 
          532,  628,  628,  632,  628,  628,  106,  628,    0,  628, 
          632,  628,  632,  628,  632,  632,  632,  632,  632,  632, 
          632,  628,  632,  632,  632,    0,  628,  628,  628,  628, 
          628,  628,    0,    0,  628,  628,    0,  628,  628,    0, 
          628,  628,  628,  628,  628,  628,  628,  628,  632,    0, 
            0,    0,    0,    0,    0,    0,  721,  612,    0,    0, 
          722,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,  166,  167,  168,    0,    0,  169,  170,  628,    0, 
            0,  171,  172,  173,  174,    0,    0,    0,    0,    0, 
            0,  287,    0,  628,    0,  128,    0,  628,  176,  177, 
            0,  178,  179,  180,  181,  182,  183,  184,  185,  186, 
          187,  188,    0,    0,  189,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  628,    0,    0,    0,    0, 
            0,    0,    0,    0,  724,  620,  190,    0,  725,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,  166, 
          167,  168,    0,    0,  169,  170,    0,    0,    0,  171, 
          172,  173,  174,    0,    0,  629,    0,    0,    0,  287, 
            0,    0,    0,    0,    0,  629,  176,  177,  105,  178, 
          179,  180,  181,  182,  183,  184,  185,  186,  187,  188, 
          796,  612,  189,    0,  797,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,  166,  167,  168,    0,  629, 
          169,  170,  105,    0,  190,  171,  172,  173,  174,    0, 
            0,    0,    0,    0,  629,  287,  130,    0,  629,  105, 
            0,    0,  176,  177,    0,  178,  179,  180,  181,  182, 
          183,  184,  185,  186,  187,  188,    0,    0,  189,    0, 
            0,    0,    0,    0,    0,    0,  629,    0,    0,  531, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          190,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  628,  628,  628,    0,  628,  628,  628,  628,  628, 
          628,    0,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,    0,  628,    0,    0,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,    0,  628,    0,    0,  628,  628,  628,    0, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,    0,    0,  628,  628,  628, 
          628,  628,    0,    0,  628,  628,  628,  628,  628,    0, 
          628,    0,  628,  628,  628,  628,  628,  628,  628,  628, 
          628,  628,  628,  628,  628,  628,  628,  628,    0,  628, 
          628,  628,  628,  628,  628,    0,    0,    0,  628,    0, 
          628,  628,    0,  628,  628,  628,  628,    0,  628,  628, 
          628,  628,  629,  629,  629,    0,  629,  629,  629,  629, 
          629,  629,    0,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,    0,  629,    0,  105,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,    0,  629,    0,    0,  629,  629,  629, 
            0,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  531,    0,  629,  629, 
          629,  629,  629,  531,  531,  629,  629,  629,  629,  629, 
          105,  629,    0,  629,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  629,  629,  629,    0, 
          629,  629,  629,  629,  629,  629,    0,    0,  322,  629, 
            0,  629,  629,    0,  629,  629,  629,  629,  322,  629, 
          629,  629,  629,    0,    0,    0,    0,    0,    0,    0, 
          626,  620,    0,    0,  627,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,  166,  167,  168,    0,    0, 
          169,  170,  112,    0,    0,  171,  172,  173,  174,    0, 
            0,    0,    0,    0,    0,  287,    0,  322,    0,  131, 
            0,  322,  176,  177,    0,  178,  179,  180,  181,  182, 
          183,  184,  185,  186,  187,  188,    0,    0,  189,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  322, 
            0,    0,    0,    0,    0,    0,    0,    0,  903,  612, 
          190,    0,  904,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,  166,  167,  168,    0,    0,  169,  170, 
            0,    0,    0,  171,  172,  173,  174,    0,    0,  322, 
            0,    0,    0,  287,    0,    0,    0,    0,    0,  322, 
          176,  177,  107,  178,  179,  180,  181,  182,  183,  184, 
          185,  186,  187,  188,  906,  620,  189,    0,  907,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,  166, 
          167,  168,    0,  322,  169,  170,  107,    0,  190,  171, 
          172,  173,  174,    0,    0,    0,    0,    0,  322,  287, 
          131,    0,  322,  107,    0,    0,  176,  177,    0,  178, 
          179,  180,  181,  182,  183,  184,  185,  186,  187,  188, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
          322,    0,    0,  533,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  190,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  629,  629,  629,    0,  629, 
          322,  322,  322,  629,  629,    0,  322,  322,  629,  322, 
          629,  629,  629,  629,  629,  629,  629,    0,    0,    0, 
            0,  629,  629,  629,  629,  629,  629,  629,  322,  322, 
          629,  322,  322,  322,  322,  322,    0,  629,    0,    0, 
          629,  629,  629,    0,  629,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  322,  322,  322,  322,  322, 
          322,  322,  322,  322,  322,  322,  322,  322,  322,    0, 
            0,  322,  322,  322,  322,  629,    0,    0,  629,  629, 
          322,  629,  629,    0,  629,    0,  629,  322,  629,  322, 
          629,  322,  322,  322,  322,  322,  322,  322,  629,  322, 
            0,  322,    0,  629,  629,  629,  629,  629,  629,    0, 
            0,  654,  629,    0,  629,  629,    0,  629,  629,  629, 
          629,  654,  629,  629,  629,  322,  629,  629,  629,    0, 
          629,  322,  322,  322,  629,  629,    0,  322,  322,  629, 
          322,  629,  629,  629,  629,  629,  629,  629,    0,    0, 
            0,  107,  629,  629,  629,  629,  629,  629,  629,  322, 
          322,  629,  322,  322,  322,  322,  322,    0,  629,    0, 
          654,  629,  629,  629,    0,  629,  629,  629,  629,  629, 
          629,  629,  629,  629,  629,  629,  322,  322,  322,  322, 
          322,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
          533,    0,  322,  322,  322,  322,  629,  533,  533,  629, 
          629,  322,  629,  629,  107,  629,    0,  629,  322,  629, 
          322,  629,  322,  322,  322,  322,  322,  322,  322,  629, 
          322,    0,  322,    0,  629,  629,  629,  629,  629,  629, 
            0,    0,  447,  629,    0,  629,  629,    0,  629,  629, 
          629,  629,  447,  629,  629,  629,  322,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  110,    0,  447,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          447,  447,    0,  127,    0,  447,    0,    0,    0,  632, 
            0,    0,    0,    0,    0,    0,    0,    0,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  447,    0,  110,    0,    0,    0,    0, 
            0,    0,    0,  632,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  632,    0, 
            0,    0,    0,    0,    0,  632,    0,    0,  290,  290, 
          290,    0,  290,  654,  654,  654,  290,  290,  654,  654, 
          654,  290,  654,  290,  290,  290,  290,  290,  290,  290, 
          632,  654,  654,    0,  290,  290,  290,  290,  290,  290, 
          290,  654,  654,  290,  654,  654,  654,  654,  654,    0, 
          290,    0,    0,  290,  290,  290,    0,  290,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  654, 
            0,    0,    0,    0,    0,    0,  654,  654,  290,    0, 
            0,  290,    0,  654,  290,  290,    0,  290,  528,  290, 
            0,  290,    0,  290,    0,    0,    0,    0,  528,    0, 
            0,  290,    0,  654,  654,    0,  290,  290,  290,  290, 
          290,  290,    0,    0,    0,  290,    0,  290,  290,    0, 
          290,  290,  290,  290,    0,  290,  290,  290,  654,    0, 
            0,    0,  528,    0,  447,  447,  447,    0,    0,  447, 
          447,  447,    0,  447,    0,    0,  528,  528,    0,  121, 
            0,  528,  447,  447,  447,    0,    0,    0,    0,    0, 
            0,    0,  447,  447,    0,  447,  447,  447,  447,  447, 
            0,    0,    0,    0,    0,    0,    0,  447,    0,  528, 
            0,    0,    0,  110,  632,    0,    0,    0,    0,  447, 
          447,  447,  447,  447,  447,  447,  447,  447,  447,  447, 
          447,  447,  447,    0,    0,  447,  447,  447,  447,  632, 
          527,  447,    0,    0,  447,    0,    0,  447,    0,  447, 
          527,  447,    0,  447,    0,  447,  447,  447,  447,  447, 
          447,  447,  632,  447,  447,  447,    0,    0,    0,  632, 
          632,    0,    0,    0,    0,  628,  110,  447,    0,    0, 
            0,    0,    0,    0,  527,    0,    0,  632,    0,  447, 
            0,    0,    0,    0,  632,  632,  632,    0,  527,  527, 
          628,  120,    0,  527,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  632,    0, 
            0,  632,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  527,    0,    0,    0,  119,    0,    0,    0,    0, 
            0,    0,    0,    0,  109,    0,    0,    0,   37,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   37,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  109,    0, 
          528,  528,  528,    0,  119,  528,  528,  528,    0,  528, 
            0,    0,    0,    0,    0,  109,    0,    0,    0,  528, 
          528,    0,    0,    0,    0,    0,    0,   37,  528,  528, 
            0,  528,  528,  528,  528,  528,  526,    0,    0,    0, 
            0,    0,    0,  528,  529,  628,    0,    0,    0,    0, 
            0,    0,    0,    0,  529,  528,  528,  528,  528,  528, 
          528,  528,  528,  528,  528,  528,  528,  528,  528,    0, 
            0,  528,  528,  528,  528,    0,  540,  528,    0,    0, 
          528,    0,    0,  528,    0,  528,    0,  528,  529,  528, 
            0,  528,  528,  528,  528,  528,  528,  528,    0,  528, 
            0,  528,  529,  529,    0,  122,    0,  529,    0,    0, 
            0,    0,    0,  528,    0,    0,    0,    0,    0,    0, 
            0,    0,  527,  527,  527,  528,    0,  527,  527,  527, 
            0,  527,    0,    0,    0,  529,    0,    0,    0,    0, 
            0,  527,  527,    0,    0,    0,    0,    0,    0,    0, 
          527,  527,    0,  527,  527,  527,  527,  527,    0,    0, 
            0,    0,    0,    0,    0,  527,  530,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  530,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,    0,    0,  527,  527,  527,  527,    0,  539,  527, 
            0,    0,  527,    0,    0,  527,    0,  527,    0,  527, 
          530,  527,  119,  527,  527,  527,  527,  527,  527,  527, 
            0,  527,    0,  527,  530,  530,    0,  123,    0,  530, 
           37,   37,   37,  109,  628,  527,   37,   37,    0,   37, 
            0,    0,    0,    0,    0,    0,    0,  527,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  530,    0,    0, 
            0,   37,   37,   37,   37,   37,    0,    0,    0,    0, 
          111,    0,    0,  526,   26,    0,    0,    0,    0,    0, 
          526,  526,  628,    0,   26,    0,    0,    0,    0,  628, 
          628,    0,    0,    0,    0,  628,  109,    0,    0,    0, 
            0,    0,    0,    0,  111,    0,  529,  529,  529,    0, 
           37,  529,  529,  529,    0,  529,  628,    0,    0,    0, 
            0,  111,    0,    0,    0,  529,  529,    0,    0,    0, 
            0,   37,    0,   26,  529,  529,    0,  529,  529,  529, 
          529,  529,    0,    0,    0,    0,    0,    0,    0,  529, 
          532,  629,    0,    0,    0,   37,    0,    0,    0,    0, 
          532,  529,  529,  529,  529,  529,  529,  529,  529,  529, 
          529,  529,  529,  529,  529,    0,    0,  529,  529,  529, 
          529,    0,  541,  529,    0,    0,  529,    0,    0,  529, 
            0,  529,    0,  529,  532,  529,    0,  529,  529,  529, 
          529,  529,  529,  529,    0,  529,    0,  529,  532,  532, 
            0,  125,    0,  532,    0,    0,    0,    0,    0,  529, 
            0,    0,    0,    0,    0,    0,    0,    0,  530,  530, 
          530,  529,    0,  530,  530,  530,    0,  530,    0,    0, 
            0,  532,    0,    0,    0,    0,    0,  530,  530,    0, 
            0,    0,    0,    0,    0,    0,  530,  530,    0,  530, 
          530,  530,  530,  530,    0,    0,    0,    0,    0,    0, 
            0,  530,  531,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  531,  530,  530,  530,  530,  530,  530,  530, 
          530,  530,  530,  530,  530,  530,  530,    0,    0,  530, 
          530,  530,  530,    0,  542,  530,    0,    0,  530,    0, 
            0,  530,    0,  530,    0,  530,  531,  530,    0,  530, 
          530,  530,  530,  530,  530,  530,    0,  530,    0,  530, 
          531,  531,    0,  124,    0,  531,   26,   26,   26,  111, 
          629,  530,   26,   26,    0,   26,    0,    0,    0,    0, 
            0,    0,    0,  530,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  531,    0,    0,    0,   26,   26,   26, 
           26,   26,    0,    0,    0,    0,  108,    0,    0,    0, 
           46,    0,    0,    0,    0,    0,    0,    0,  629,    0, 
           46,    0,    0,    0,    0,  629,  629,    0,    0,    0, 
            0,  629,  111,    0,    0,    0,    0,    0,    0,    0, 
          108,    0,  532,  532,  532,    0,   26,  532,  532,  532, 
            0,  532,  629,    0,    0,    0,    0,  108,    0,    0, 
            0,  532,  532,    0,    0,    0,    0,   26,    0,   46, 
          532,  532,    0,  532,  532,  532,  532,  532,    0,    0, 
            0,    0,    0,    0,    0,  532,  533,  447,    0,    0, 
            0,   26,    0,    0,    0,    0,  533,  532,  532,  532, 
          532,  532,  532,  532,  532,  532,  532,  532,  532,  532, 
          532,    0,    0,  532,  532,  532,  532,    0,  544,  532, 
            0,    0,  532,    0,    0,  532,    0,  532,    0,  532, 
          533,  532,    0,  532,  532,  532,  532,  532,  532,  532, 
            0,  532,    0,  532,  533,  533,    0,  126,    0,  533, 
            0,    0,    0,    0,    0,  532,    0,    0,    0,    0, 
            0,    0,    0,    0,  531,  531,  531,  532,    0,  531, 
          531,  531,    0,  531,    0,    0,    0,  533,    0,    0, 
            0,    0,    0,  531,  531,    0,    0,    0,    0,    0, 
            0,    0,  531,  531,    0,  531,  531,  531,  531,  531, 
            0,    0,    0,    0,    0,    0,    0,  531,  524,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  524,  531, 
          531,  531,  531,  531,  531,  531,  531,  531,  531,  531, 
          531,  531,  531,    0,    0,  531,  531,  531,  531,    0, 
          543,  531,    0,    0,  531,    0,    0,  531,    0,  531, 
            0,  531,  524,  531,    0,  531,  531,  531,  531,  531, 
          531,  531,    0,  531,    0,  531,  524,  524,    0,  117, 
            0,  524,   46,   46,   46,  108,  447,  531,   46,   46, 
            0,   46,   98,    0,    0,   97,    0,    0,    0,  531, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  524, 
            0,    0,    0,   46,   46,   46,   46,    0,    0,  100, 
            0,    0,    0,  114,    0,    0,   98,    0,    0,   97, 
            0,    0,    0,    0,  447,    0,    0,    0,    0,    0, 
            0,  447,  447,   98,    0,    0,   97,    0,  108,    0, 
            0,    0,    0,  100,    0,    0,    0,  114,  533,  533, 
          533,    0,   46,  533,  533,  533,    0,  533,  447,    0, 
          100,    0,    0,  524,  114,    0,  523,  533,  533,    0, 
            0,    0,    0,   46,    0,    0,  533,  533,    0,  533, 
          533,  533,  533,  533,    0,    0,    0,    0,    0,    0, 
          526,  533,  523,    0,  313,    0,    0,   46,    0,    0, 
            0,    0,  523,  533,  533,  533,  533,  533,  533,  533, 
          533,  533,  533,  533,  533,  533,  533,    0,    0,  533, 
          533,  533,  533,    0,  545,  533,    0,    0,  533,    0, 
            0,  533,    0,  533,  113,  533,  523,  533,    0,  533, 
          533,  533,  533,  533,  533,  533,    0,  533,    0,  533, 
          523,  523,    0,  116,    0,  523,    0,    0,    0,    0, 
            0,  533,    0,    0,    0,    0,    0,    0,  113,    0, 
          524,  524,  524,  533,    0,  524,  524,  524,    0,  524, 
            0,    0,    0,  523,    0,  113,    0,    0,    0,  524, 
          524,    0,    0,    0,    0,    0,    0,    0,  524,  524, 
            0,  524,  524,  524,  524,  524,    0,    0,    0,    0, 
            0,    0,    0,  524,  526,  323,    0,    0,    0,    0, 
            0,    0,    0,    0,  526,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,    0, 
            0,  524,  524,  524,  524,    0,  536,  524,    0,    0, 
          524,   98,    0,  524,   97,  524,    0,  524,  526,  524, 
            0,  524,  524,  524,  524,  524,  524,  524,    0,  524, 
          133,  524,  526,  526,    0,  119,    0,  526,  100,    0, 
            0,    0,  114,  524,    0,    0,    0,    0,  132,    0, 
            0,    0,    0,    0,    0,  524,    0,    0,    0,    0, 
          524,    0,    0,  523,    0,  526,    0,  524,  524,    0, 
          523,  523,    0,    0,   98,    0,    0,   97,    0,  133, 
            0,    0,    0,    0,    0,    0,    0,  526,    0,    0, 
            0,  313,    0,    0,  526,  526,    0,  132,  313,  313, 
            0,  100,    0,    0,    0,  114,    0,    0,    0,    0, 
            0,  313,    0,    0,  523,  523,  523,    0,    0,  523, 
          523,  523,    0,  523,    0,    0,    0,    0,    0,  323, 
            0,    0,    0,  523,  523,    0,    0,    0,    0,    0, 
            0,    0,  523,  523,    0,  523,  523,  523,  523,  523, 
            0,    0,    0,    0,    0,    0,    0,  523,  446,    0, 
            0,    0,    0,  113,    0,    0,    0,    0,  446,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,    0,    0,  523,  523,  523,  523,    0, 
          535,  523,    0,    0,  523,    0,    0,  523,    0,  523, 
            0,  523,  446,  523,    0,  523,  523,  523,  523,  523, 
          523,  523,  323,  523,    0,  523,  446,  446,    0,  323, 
          323,  446,    0,    0,    0,    0,  113,  523,    0,    0, 
            0,    0,    0,    0,    0,    0,  526,  526,  526,  523, 
            0,  526,  526,  526,    0,  526,    0,    0,    0,  446, 
            0,    0,    0,    0,    0,  526,  526,    0,    0,    0, 
            0,    0,    0,    0,  526,  526,    0,  526,  526,  526, 
          526,  526,    0,    0,    0,    0,    0,    0,    0,  526, 
          654,    0,    0,    0,    0,    0,    0,  133,    0,    0, 
          654,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  132,    0,  526,  526,  526, 
          526,    0,  538,  526,    0,    0,  526,    0,    0,  526, 
            0,  526,    0,  526,  654,  526,    0,  526,  526,  526, 
          526,  526,  526,  526,    0,  526,    0,  526,  654,  654, 
            0,    0,    0,  654,    0,    0,    0,    0,  313,  526, 
            0,    0,    0,    0,    0,  313,  313,    0,    0,    0, 
            0,  526,    0,    0,    0,    0,  323,    0,    0,    0, 
            0,  654,    0,  323,  323,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          446,  446,  446,    0,    0,  446,  446,  446,    0,  446, 
            0,    0,    0,    0,    0,    0,    0,    0,  446,  446, 
          446,    0,    0,    0,    0,    0,    0,    0,  446,  446, 
            0,  446,  446,  446,  446,  446,    0,    0,    0,    0, 
            0,    0,    0,  446,  313,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  313,  446,  446,  446,  446,  446, 
          446,  446,  446,  446,  446,  446,  446,  446,  446,    0, 
            0,  446,  446,  446,  446,    0,    0,  446,    0,    0, 
          446,    0,    0,  446,    0,  446,    0,  446,  313,  446, 
            0,  446,  446,  446,  446,  446,  446,  446,    0,  446, 
          446,  446,  313,  313,    0,  133,    0,  313,    0,    0, 
            0,    0,    0,  446,    0,    0,    0,    0,    0,    0, 
            0,    0,  654,  654,  654,  446,    0,  654,  654,  654, 
            0,  654,    0,    0,    0,  313,    0,    0,    0,    0, 
          654,  654,  654,    0,    0,    0,    0,    0,    0,    0, 
          654,  654,    0,  654,  654,  654,  654,  654,    0,    0, 
            0,    0,    0,    0,    0,  654,  323,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  323,  654,  654,  654, 
          654,  654,  654,  654,  654,  654,  654,  654,  654,  654, 
          654,    0,    0,  654,  654,  654,  654,    0,    0,  654, 
            0,    0,  654,    0,    0,  654,    0,  654,    0,  654, 
          323,  654,    0,  654,  654,  654,  654,  654,  654,  654, 
            0,  654,  654,  654,  323,  323,    0,  132,    0,  323, 
            0,    0,    0,    0,    0,  654,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  654,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  323,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  313,  313,  313,    0, 
            0,  313,  313,  313,    0,  313,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  313,  313,    0,    0,    0, 
            0,    0,    0,    0,  313,  313,    0,  313,  313,  313, 
          313,  313,    0,    0,    0,    0,    0,    0,    0,  313, 
          471,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          471,  313,  313,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,  313,    0,    0,  313,  313,  313, 
          313,    0,    0,  313,    0,    0,  313,    0,    0,  313, 
            0,  313,    0,  313,  471,  313,    0,  313,  313,  313, 
          313,  313,  313,  313,    0,  313,    0,  313,  471,  471, 
            0,    0,    0,  471,    0,    0,    0,    0,    0,  313, 
            0,    0,    0,    0,    0,    0,    0,    0,  323,  323, 
          323,  313,    0,  323,  323,  323,    0,  323,    0,    0, 
            0,  471,    0,    0,    0,    0,    0,  323,  323,    0, 
            0,    0,    0,    0,    0,    0,  323,  323,    0,  323, 
          323,  323,  323,  323,    0,    0,    0,    0,    0,    0, 
            0,  323,  334,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  334,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,    0,    0,  323, 
          323,  323,  323,    0,    0,  323,    0,    0,  323,    0, 
            0,  323,    0,  323,    0,  323,  334,  323,    0,  323, 
          323,  323,  323,  323,  323,  323,    0,  323,    0,  323, 
          334,  334,    0,    0,    0,  334,    0,    0,    0,    0, 
            0,  323,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  334,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  471,  471,  471,    0,    0,  471,  471,  471, 
            0,  471,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  471,  471,    0,    0,    0,    0,    0,    0,    0, 
          471,  471,    0,  471,  471,  471,  471,  471,    0,    0, 
            0,    0,    0,    0,    0,  471,  263,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  263,  471,  471,  471, 
          471,  471,  471,  471,  471,  471,  471,  471,  471,  471, 
          471,    0,    0,  471,  471,  471,  471,    0,    0,  471, 
            0,    0,  471,    0,    0,  471,    0,  471,    0,  471, 
          263,  471,    0,  471,  471,  471,  471,  471,  471,  471, 
            0,  471,    0,  471,  263,  263,    0,    0,    0,  263, 
            0,    0,    0,    0,    0,  471,    0,    0,    0,    0, 
            0,    0,    0,    0,  334,  334,  334,  471,    0,  334, 
          334,  334,    0,  334,    0,    0,    0,  366,    0,    0, 
            0,    0,    0,  334,  334,    0,    0,    0,    0,    0, 
            0,    0,  334,  334,    0,  334,  334,  334,  334,  334, 
            0,    0,    0,    0,    0,    0,    0,  334,  329,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  329,  334, 
          334,  334,  334,  334,  334,  334,  334,  334,  334,  334, 
          334,  334,  334,    0,    0,  334,  334,  334,  334,    0, 
            0,  334,    0,    0,  334,    0,    0,  334,    0,  334, 
            0,  334,  329,  334,    0,  334,  334,  334,  334,  334, 
          334,  334,    0,  334,    0,  334,  329,  329,    0,    0, 
            0,  329,    0,    0,    0,    0,    0,  334,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  334, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  329, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  263,  263, 
          263,    0,    0,  263,  263,  263,    0,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  263,  263,    0, 
            0,    0,    0,    0,    0,    0,  263,  263,    0,  263, 
          263,  263,  263,  263,    0,    0,    0,    0,    0,    0, 
            0,  263,  517,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,  263,  263,  263,  263,  263,  263,  263, 
          263,  263,  263,  263,  366,  263,  263,    0,    0,  263, 
          263,  366,  366,    0,    0,  263,    0,    0,  263,    0, 
            0,  263,    0,  263,    0,  263,  517,  263,    0,  263, 
          263,  263,  263,  263,  263,  263,    0,  263,    0,  263, 
          517,  517,    0,    0,    0,  517,    0,    0,    0,    0, 
            0,  263,    0,    0,    0,    0,    0,    0,    0,    0, 
          329,  329,  329,  263,    0,  329,  329,  329,    0,  329, 
            0,    0,    0,  517,    0,    0,    0,    0,    0,  329, 
          329,    0,    0,    0,    0,    0,    0,    0,  329,  329, 
            0,  329,  329,  329,  329,  329,    0,    0,    0,    0, 
            0,    0,    0,  329,  362,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  362,  329,  329,  329,  329,  329, 
          329,  329,  329,  329,  329,  329,  329,  329,  329,    0, 
            0,  329,  329,  329,  329,    0,    0,  329,    0,    0, 
          329,    0,    0,  329,    0,  329,    0,  329,  362,  329, 
            0,  329,  329,  329,  329,  329,  329,  329,    0,  329, 
            0,  329,    0,  362,    0,    0,    0,  362,    0,    0, 
            0,    0,    0,  329,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  329,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  362,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  363,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  363,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,  517,  517,    0,    0,  517, 
          517,  517,  363,  517,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  517,  517,    0,    0,  363,    0,    0, 
            0,  363,  517,  517,    0,  517,  517,  517,  517,  517, 
            0,    0,    0,    0,    0,    0,    0,  517,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  363, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,    0,    0,  517,  517,  517,  517,    0, 
          326,  517,    0,    0,  517,    0,    0,  517,    0,  517, 
          326,  517,    0,  517,    0,  517,  517,  517,  517,  517, 
          517,  517,    0,  517,    0,  517,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  517,    0,    0, 
            0,    0,    0,    0,  326,    0,  362,  362,  362,  517, 
            0,  362,  362,  362,    0,  362,    0,    0,    0,  326, 
            0,    0,    0,  326,    0,  362,  362,    0,    0,    0, 
            0,    0,    0,    0,  362,  362,    0,  362,  362,  362, 
          362,  362,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  326,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  362,  362,  362,  362,  362,  362,  362,  362,  362, 
          362,  362,  362,  362,  362,    0,    0,  362,  362,  362, 
          362,    0,    0,  362,    0,    0,  362,    0,    0,  362, 
            0,  362,    0,  362,    0,  362,  234,  362,  362,  362, 
          362,  362,  362,  362,    0,  362,  234,  362,    0,    0, 
          363,  363,  363,    0,    0,  363,  363,  363,    0,  363, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  363, 
          363,  362,    0,    0,    0,    0,    0,    0,  363,  363, 
          234,  363,  363,  363,  363,  363,    0,    0,    0,    0, 
            0,    0,    0,    0,  234,  234,    0,    0,    0,  234, 
            0,    0,    0,    0,    0,  363,  363,  363,  363,  363, 
          363,  363,  363,  363,  363,  363,  363,  363,  363,    0, 
            0,  363,  363,  363,  363,    0,    0,  363,    0,    0, 
          363,    0,    0,  363,    0,  363,    0,  363,    0,  363, 
            0,  363,  363,  363,  363,  363,  363,  363,    0,  363, 
           54,  363,    0,    0,    0,    0,    0,    0,    0,    0, 
           54,    0,  326,  326,  326,    0,    0,  326,  326,  326, 
            0,  326,    0,    0,    0,  363,    0,    0,    0,    0, 
            0,  326,  326,    0,    0,    0,    0,    0,    0,    0, 
          326,  326,    0,  326,  326,  326,  326,  326,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,    0,    0,   54, 
            0,    0,    0,    0,    0,    0,  235,  326,  326,  326, 
          326,  326,  326,  326,  326,  326,  326,  326,  326,  326, 
          326,    0,    0,  326,  326,  326,  326,    0,    0,  326, 
            0,    0,  326,    0,    0,  326,    0,  326,    0,  326, 
          235,  326,    0,  326,  326,  326,  326,  326,  326,  326, 
            0,  326,    0,  326,  235,  235,    0,    0,    0,  235, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  326,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  234,  234, 
          234,    0,    0,  234,  234,  234,    0,  234,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,    0, 
            0,    0,    0,    0,    0,    0,  234,  234,    0,  234, 
          234,  234,  234,  234,    0,    0,    0,    0,    0,    0, 
            0,  234,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  244,  234,  234,  234,  234,  234,  234,  234, 
          234,  234,  234,  234,    0,  234,  234,    0,    0,  234, 
          234,    0,    0,    0,    0,  234,    0,    0,  234,    0, 
            0,  234,    0,  234,    0,  234,  244,  234,    0,  234, 
          234,  234,  234,  234,  234,  234,    0,  234,    0,  234, 
          244,  244,    0,    0,    0,  244,    0,    0,    0,    0, 
            0,  234,   54,   54,   54,    0,    0,   54,   54,   54, 
            0,   54,    0,  234,    0,    0,    0,    0,    0,    0, 
            0,   54,    0,    0,    0,    0,    0,    0,    0,    0, 
           54,   54,    0,   54,   54,   54,   54,   54,    0,    0, 
            0,  241,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  241,    0,    0,    0,    0,    0,    0,  235,  235, 
          235,    0,    0,  235,  235,  235,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,  235,    0, 
            0,    0,   54,    0,    0,  241,  235,  235,    0,  235, 
          235,  235,  235,  235,    0,    0,    0,    0,    0,  241, 
          241,  235,    0,   54,  241,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,  235,  235,  235,  235,  235,  235, 
          235,  235,  235,  235,    0,  235,  235,   54,    0,  235, 
          235,    0,    0,    0,    0,  235,    0,    0,  235,    0, 
            0,  235,    0,  235,    0,  235,    0,  235,    0,  235, 
          235,  235,  235,  235,  235,  235,    0,  235,  238,  235, 
            0,    0,    0,    0,    0,    0,    0,    0,  238,    0, 
            0,  235,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  244,  244,  244,    0,    0,  244, 
          244,  244,  238,  244,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  244, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          244,    0,  238,  238,    0,    0,    0,  238,  244,  244, 
            0,  244,  244,  244,  244,  244,    0,    0,    0,    0, 
            0,    0,    0,  244,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  244,  244,  244,  244, 
          244,  244,  244,  244,  244,  244,    0,  244,  244,    0, 
            0,  244,  244,    0,    0,    0,    0,  244,    0,    0, 
          244,    0,    0,  244,    0,  244,    0,  244,    0,  244, 
          240,  244,  244,  244,  244,  244,  244,  244,    0,  244, 
          240,  244,    0,    0,    0,    0,    0,    0,    0,  241, 
          241,  241,    0,  244,  241,  241,  241,    0,  241,    0, 
            0,    0,    0,    0,    0,  244,    0,    0,  241,  241, 
            0,    0,    0,    0,  240,    0,    0,  241,  241,    0, 
          241,  241,  241,  241,  241,    0,    0,    0,  240,  240, 
            0,    0,  241,  240,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  241,  241,  241,  241,  241, 
          241,  241,  241,  241,  241,    0,  241,  241,    0,    0, 
          241,  241,    0,    0,    0,    0,  241,    0,    0,  241, 
            0,    0,  241,    0,  241,    0,  241,    0,  241,    0, 
          241,  241,  241,  241,  241,  241,  241,  239,  241,    0, 
          241,    0,    0,    0,    0,    0,    0,  239,    0,    0, 
            0,    0,  241,    0,    0,    0,  238,  238,  238,    0, 
            0,  238,  238,  238,  241,  238,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  238,  238,    0,    0,    0, 
            0,  239,    0,    0,  238,  238,    0,  238,  238,  238, 
          238,  238,    0,    0,    0,  239,  239,    0,    0,  238, 
          239,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  238,  238,  238,  238,  238,  238,  238,  238, 
          238,  238,    0,  238,  238,    0,    0,  238,  238,    0, 
            0,    0,    0,  238,    0,    0,  238,    0,    0,  238, 
            0,  238,    0,  238,    0,  238,  242,  238,  238,  238, 
          238,  238,  238,  238,    0,  238,  242,  238,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  238, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  238,  240,  240,  240,    0,    0,  240,  240,  240, 
          242,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,  240,    0,  242,  242,    0,    0,    0,  242, 
          240,  240,    0,  240,  240,  240,  240,  240,    0,    0, 
            0,    0,    0,    0,    0,  240,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  240,  240, 
          240,  240,  240,  240,  240,  240,  240,  240,    0,  240, 
          240,    0,    0,  240,  240,    0,    0,    0,    0,  240, 
            0,    0,  240,    0,    0,  240,    0,  240,    0,  240, 
            0,  240,    0,  240,  240,  240,  240,  240,  240,  240, 
            0,  240,  447,  240,    0,    0,    0,    0,    0,    0, 
            0,    0,  447,    0,    0,  240,    0,    0,    0,  239, 
          239,  239,    0,    0,  239,  239,  239,  240,  239,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,  239, 
            0,    0,    0,    0,    0,    0,  108,  239,  239,    0, 
          239,  239,  239,  239,  239,    0,    0,    0,    0,    0, 
            0,  447,  239,  127,    0,  447,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  239,  239,  239,  239,  239, 
          239,  239,  239,  239,  239,    0,  239,  239,    0,    0, 
          239,  239,    0,  447,    0,    0,  239,    0,    0,  239, 
            0,    0,  239,    0,  239,    0,  239,  447,  239,    0, 
          239,  239,  239,  239,  239,  239,  239,  447,  239,    0, 
          239,    0,    0,    0,    0,    0,    0,    0,  242,  242, 
          242,    0,  239,  242,  242,  242,    0,  242,    0,    0, 
            0,    0,    0,    0,  239,    0,    0,  242,  242,    0, 
            0,  447,    0,    0,    0,    0,  242,  242,    0,  242, 
          242,  242,  242,  242,    0,    0,  447,    0,  127,    0, 
          447,  242,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  242,  242,  242,  242,  242,  242, 
          242,  242,  242,  242,    0,  242,  242,    0,  447,  242, 
          242,    0,    0,    0,    0,  242,    0,    0,  242,    0, 
            0,  242,    0,  242,    0,  242,  528,  242,    0,  242, 
          242,  242,  242,  242,  242,  242,  528,  242,    0,  242, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  242,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  242,    0,    0,    0,    0,    0,    0, 
          102,    0,    0,    0,  447,  447,  447,    0,    0,    0, 
          447,  447,    0,  447,    0,  528,    0,  121,    0,  528, 
            0,    0,  447,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  447,  447,    0,  447,  447,  447,  447,  447, 
            0,    0,    0,    0,    0,    0,    0,  528,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  447, 
          447,  447,  447,  447,  447,  447,  447,  447,  447,  447, 
          447,  447,  447,    0,    0,  447,  447,  447,  447,    0, 
            0,    0,    0,    0,  447,    0,    0,    0,    0,    0, 
            0,  447,    0,  447,    0,  447,  447,  447,  447,  447, 
          447,  447,    0,  447,  447,  447,    0,    0,    0,  447, 
          447,  447,    0,    0,    0,  447,  447,    0,  447,    0, 
            0,    0,    0,    0,    0,    0,    0,  447,    0,  447, 
            0,    0,    0,    0,    0,    0,    0,  447,  447,    0, 
          447,  447,  447,  447,  447,    0,    0,    0,    0,    0, 
            0,    0,    0,  527,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  527,  447,  447,  447,  447,  447,  447, 
          447,  447,  447,  447,  447,  447,  447,  447,    0,    0, 
          447,  447,  447,  447,    0,    0,    0,    0,    0,  447, 
            0,    0,    0,    0,    0,    0,  447,  101,  447,    0, 
          447,  447,  447,  447,  447,  447,  447,    0,  447,  447, 
          447,    0,  527,    0,  120,    0,  527,    0,  528,  528, 
          528,    0,    0,    0,  528,  528,    0,  528,    0,    0, 
            0,    0,    0,    0,  447,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  527,    0,  528,  528,    0,  528, 
          528,  528,  528,  528,    0,    0,    0,  529,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  529,    0,    0, 
            0,    0,    0,  528,  528,  528,  528,  528,  528,  528, 
          528,  528,  528,  528,  528,  528,  528,    0,    0,  528, 
          528,  528,  528,    0,  540,    0,    0,    0,  528,    0, 
            0,  103,    0,    0,    0,  528,    0,  528,    0,  528, 
          528,  528,  528,  528,  528,  528,  529,  528,  122,  528, 
          529,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  530,    0,    0,    0,    0,    0, 
            0,    0,    0,  528,  530,    0,    0,    0,  529,    0, 
            0,    0,    0,    0,    0,    0, 1074,  612,    0,    0, 
         1075,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,  166,  167,  168,    0,    0,  169,  170,  104,    0, 
            0,  171,  172,  173,  174,    0,    0,    0,    0,    0, 
            0,  287,    0,  530,    0,  123,    0,  530,  176,  177, 
            0,  178,  179,  180,  181,  182,  183,  184,  185,  186, 
          187,  188,    0,    0,  189,  527,  527,  527,    0,    0, 
            0,  527,  527,    0,  527,  530,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,    0,    0,    0, 
            0,    0,    0,  527,  527,    0,  527,  527,  527,  527, 
          527,    0,    0,    0,  532,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  532,    0,    0,    0,    0,    0, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,    0,    0,  527,  527,  527,  527, 
            0,  539,    0,    0,    0,  527,    0,    0,  106,    0, 
            0,    0,  527,    0,  527,    0,  527,  527,  527,  527, 
          527,  527,  527,  532,  527,  125,  527,  532,    0,  529, 
          529,  529,    0,    0,    0,  529,  529,    0,  529,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          527,    0,    0,    0,    0,  532,    0,  529,  529,    0, 
          529,  529,  529,  529,  529,    0,    0,    0,   59,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   59,    0, 
            0,    0,    0,    0,  529,  529,  529,  529,  529,  529, 
          529,  529,  529,  529,  529,  529,  529,  529,    0,    0, 
          529,  529,  529,  529,    0,  541,  530,  530,  530,  529, 
            0,    0,  530,  530,    0,  530,  529,    0,  529,    0, 
          529,  529,  529,  529,  529,  529,  529,   59,  529,    0, 
          529,    0,    0,    0,  530,  530,    0,  530,  530,  530, 
          530,  530,    0,    0,    0,  531,    0,    0,    0,    0, 
            0,    0,    0,    0,  529,  531,    0,    0,    0,    0, 
            0,  530,  530,  530,  530,  530,  530,  530,  530,  530, 
          530,  530,  530,  530,  530,    0,    0,  530,  530,  530, 
          530,    0,  542,    0,    0,    0,  530,    0,    0,  105, 
            0,    0,    0,  530,    0,  530,    0,  530,  530,  530, 
          530,  530,  530,  530,  531,  530,  124,  530,  531,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  532,  532,  532,    0, 
            0,  530,  532,  532,    0,  532,  531,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  532,  532,    0,  532,  532,  532, 
          532,  532,    0,    0,    0,  533,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  533,    0,    0,    0,    0, 
            0,  532,  532,  532,  532,  532,  532,  532,  532,  532, 
          532,  532,  532,  532,  532,    0,    0,  532,  532,  532, 
          532,    0,  544,    0,    0,    0,  532,    0,    0,  107, 
            0,    0,    0,  532,    0,  532,    0,  532,  532,  532, 
          532,  532,  532,  532,  533,  532,  126,  532,  533,    0, 
           59,   59,   59,    0,    0,   59,   59,   59,    0,   59, 
            0,    0,  524,    0,    0,    0,    0,    0,    0,   59, 
            0,  532,  524,    0,    0,    0,  533,    0,   59,   59, 
            0,   59,   59,   59,   59,   59,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   98,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  524,    0,  117,    0,  524,    0,  531,  531,  531, 
           59,    0,    0,  531,  531,    0,  531,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   59,    0,  524,    0,  531,  531,    0,  531,  531, 
          531,  531,  531,    0,    0,    0,  523,    0,    0,    0, 
            0,    0,    0,    0,    0,   59,  523,    0,    0,    0, 
            0,    0,  531,  531,  531,  531,  531,  531,  531,  531, 
          531,  531,  531,  531,  531,  531,    0,    0,  531,  531, 
          531,  531,    0,  543,    0,    0,    0,  531,    0,    0, 
           97,    0,    0,    0,  531,    0,  531,    0,  531,  531, 
          531,  531,  531,  531,  531,  523,  531,  116,  531,  523, 
            0,    0,  291,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  533,  533,  533, 
            0,    0,  531,  533,  533,    0,  533,  523,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  533,  533,    0,  533,  533, 
          533,  533,  533,    0,    0,  394,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  533,  533,  533,  533,  533,  533,  533,  533, 
          533,  533,  533,  533,  533,  533,    0,    0,  533,  533, 
          533,  533,    0,  545,  524,  524,  524,  533,    0,    0, 
          524,  524,    0,  524,  533,    0,  533,    0,  533,  533, 
          533,  533,  533,  533,  533,    0,  533,    0,  533,    0, 
            0,    0,  524,  524,    0,  524,  524,  524,  524,  524, 
            0,    0,    0,  526,    0,    0,    0,    0,    0,    0, 
            0,    0,  533,  526,    0,    0,    0,    0,    0,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,    0,    0,  524,  524,  524,  524,    0, 
          536,    0,    0,    0,  524,    0,    0,  100,    0,    0, 
            0,  524,    0,  524,    0,  524,  524,  524,  524,  524, 
          524,  524,  526,  524,  119,  524,  526,    0,  523,  523, 
          523,    0,    0,    0,  523,  523,    0,  523,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  524, 
            0,    0,    0,    0,  526,    0,  523,  523,    0,  523, 
          523,  523,  523,  523,    0,    0,    0,    0,    0,    0, 
            0,    0,  249,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  249,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,  523,  523,    0,    0,  523, 
          523,  523,  523,    0,  535,    0,    0,    0,  523,    0, 
            0,    0,    0,    0,    0,  523,  249,  523,    0,  523, 
          523,  523,  523,  523,  523,  523,    0,  523,    0,  523, 
          249,  249,    0,    0,    0,  249,    0,    0,    0,  369, 
          370,  371,  372,  373,  374,  375,  376,  377,  378,  379, 
            0,  380,  381,  523,    0,  382,  383,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  384,    0,  385,  313,  386,  387,  388,  389,  390, 
          391,  392,    0,  393,  313,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  114,    0, 
            0,    0,    0,    0,    0,  526,  526,  526,    0,    0, 
            0,  526,  526,  313,  526,  133,    0,  313,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  526,  526,    0,  526,  526,  526,  526, 
          526,    0,    0,    0,    0,  313,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,    0,    0,  526,  526,  526,  526, 
            0,  538,    0,    0,    0,  526,    0,    0,    0,    0, 
            0,    0,  526,  323,  526,    0,  526,  526,  526,  526, 
          526,  526,  526,  323,  526,    0,  526,    0,    0,    0, 
            0,    0,    0,    0,  249,  249,  249,    0,    0,  249, 
          249,  249,    0,  249,    0,    0,    0,    0,    0,    0, 
          526,    0,    0,  249,  249,    0,    0,  113,    0,    0, 
            0,    0,  249,  249,    0,  249,  249,  249,  249,  249, 
            0,    0,  323,    0,  132,    0,  323,  249,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  249, 
          249,  249,  249,  249,    0,    0,  249,  249,  249,  249, 
            0,  249,  249,    0,  323,  249,  249,    0,    0,    0, 
            0,  249,    0,    0,  249,    0,    0,  249,    0,  249, 
            0,  249,  236,  249,    0,  249,  249,  249,  249,    0, 
            0,  249,  236,  249,    0,  249,  313,  313,  313,    0, 
            0,    0,  313,  313,    0,  313,    0,  249,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  249, 
            0,    0,    0,    0,  313,  313,  236,  313,  313,  313, 
          313,  313,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,  236,    0,    0,    0,  236,    0,    0,    0,    0, 
            0,  313,  313,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,  313,    0,    0,  313,  313,  313, 
          313,    0,    0,    0,    0,    0,  313,    0,    0,    0, 
            0,    0,    0,  313,    0,  313,    0,  313,  313,  313, 
          313,  313,  313,  313,    0,  313,  237,  313,    0,    0, 
            0,    0,    0,    0,    0,    0,  237,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  313,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  323,  323,  323,    0,    0, 
          237,  323,  323,    0,  323,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  237,  237,    0,    0,    0,  237, 
            0,    0,    0,  323,  323,    0,  323,  323,  323,  323, 
          323,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,    0,    0,  323,  323,  323,  323, 
            0,    0,    0,    0,    0,  323,    0,    0,    0,    0, 
            0,    0,  323,  313,  323,    0,  323,  323,  323,  323, 
          323,  323,  323,  313,  323,    0,  323,    0,    0,    0, 
            0,    0,    0,    0,  236,  236,  236,    0,    0,  236, 
          236,  236,    0,  236,    0,    0,    0,    0,    0,    0, 
          323,    0,    0,  236,  236,    0,    0,  313,    0,    0, 
            0,    0,  236,  236,    0,  236,  236,  236,  236,  236, 
            0,    0,  313,    0,  133,    0,  313,  236,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,  236,  236,  236,  236,  236,  236,  236,  236,  236, 
            0,  236,  236,    0,  313,  236,  236,    0,    0,    0, 
            0,  236,    0,    0,  236,    0,    0,  236,    0,  236, 
            0,    0,    0,  236,    0,    0,  257,  236,  236,  236, 
          236,  236,    0,  236,    0,  236,  257,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  236,  237,  237, 
          237,    0,    0,  237,  237,  237,    0,  237,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,  237,  237,    0, 
          257,    0,    0,    0,    0,    0,  237,  237,    0,  237, 
          237,  237,  237,  237,  257,  257,    0,    0,    0,  257, 
            0,  237,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  237,  237,  237,  237,  237,  237, 
          237,  237,  237,  237,    0,  237,  237,    0,    0,  237, 
          237,    0,    0,    0,    0,  237,    0,    0,  237,    0, 
            0,  237,    0,  237,    0,    0,  258,  237,    0,    0, 
            0,  237,  237,  237,  237,  237,  258,  237,    0,  237, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  237,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  237,    0,  313,  313,  313,    0,    0, 
          258,  313,  313,    0,  313,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  258,  258,    0,    0,    0,  258, 
            0,    0,    0,  313,  313,    0,  313,  313,  313,  313, 
          313,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          313,  313,  313,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,    0,    0,  313,  313,  313,  313, 
            0,    0,    0,    0,    0,  313,    0,    0,    0,    0, 
            0,    0,  313,    0,  313,    0,  313,  313,  313,  313, 
          313,  313,  313,    0,  313,    0,  313,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  257,  257, 
          257,    0,    0,  257,  257,  257,    0,  257,    0,  247, 
          313,    0,    0,    0,    0,    0,    0,  257,  257,  247, 
            0,    0,    0,    0,    0,    0,  257,  257,    0,  257, 
          257,  257,  257,  257,    0,    0,    0,    0,    0,    0, 
            0,  257,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  247,  257,  257,  257,  257,  257,  257, 
          257,  257,  257,  257,    0,  257,  257,  247,  247,  257, 
          257,    0,  247,    0,    0,  257,    0,    0,  257,    0, 
            0,  257,    0,  257,    0,    0,    0,  257,    0,    0, 
            0,    0,    0,  257,  257,  257,    0,  257,    0,  257, 
            0,    0,    0,    0,    0,    0,    0,    0,  258,  258, 
          258,  257,    0,  258,  258,  258,    0,  258,    0,  245, 
            0,    0,    0,  257,    0,    0,    0,  258,  258,  245, 
            0,    0,    0,    0,    0,    0,  258,  258,    0,  258, 
          258,  258,  258,  258,    0,    0,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  245,  258,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,    0,  258,  258,  245,  245,  258, 
          258,    0,  245,    0,    0,  258,    0,    0,  258,    0, 
            0,  258,    0,  258,    0,    0,    0,  258,    0,    0, 
            0,    0,    0,  258,  258,  258,    0,  258,    0,  258, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  246, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  246, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,  247,  247,    0,    0,  247,  247,  247,    0, 
          247,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,  247,    0,  246,    0,    0,    0,    0,    0,  247, 
          247,    0,  247,  247,  247,  247,  247,  246,  246,    0, 
            0,    0,  246,    0,  247,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,  247,  247, 
          247,  247,  247,  247,  247,  247,  247,    0,  247,  247, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,  247,    0,    0,  247,    0,  247,    0,    0,  268, 
          247,    0,    0,    0,    0,    0,  247,  247,  247,  268, 
          247,    0,  247,    0,    0,    0,    0,    0,    0,    0, 
            0,  245,  245,  245,  247,    0,  245,  245,  245,    0, 
          245,    0,    0,    0,    0,    0,  247,    0,    0,    0, 
          245,  245,    0,  268,    0,    0,    0,    0,    0,  245, 
          245,    0,  245,  245,  245,  245,  245,  268,  268,    0, 
            0,    0,  268,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  245,  245,  245, 
          245,  245,  245,  245,  245,  245,  245,    0,  245,  245, 
            0,    0,    0,    0,    0,    0,    0,    0,  245,    0, 
            0,  245,    0,    0,  245,    0,  245,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  245,  245,  245,    0, 
          245,    0,  245,    0,    0,    0,    0,    0,    0,  269, 
            0,    0,    0,    0,  245,    0,    0,    0,    0,  269, 
            0,    0,    0,    0,    0,    0,  245,    0,    0,    0, 
            0,  246,  246,  246,    0,    0,  246,  246,  246,    0, 
          246,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,  246,    0,  269,    0,    0,    0,    0,    0,  246, 
          246,    0,  246,  246,  246,  246,  246,  269,  269,    0, 
            0,    0,  269,    0,  246,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  246,  246,  246, 
          246,  246,  246,  246,  246,  246,  246,    0,  246,  246, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,    0, 
            0,  246,    0,    0,  246,    0,  246,    0,    0,  248, 
            0,    0,    0,    0,    0,    0,  246,  246,  246,  248, 
          246,    0,  246,    0,    0,    0,    0,    0,    0,    0, 
            0,  268,  268,  268,  246,    0,  268,  268,  268,    0, 
          268,    0,    0,    0,    0,    0,  246,    0,    0,    0, 
          268,  268,    0,  248,    0,    0,    0,    0,    0,  268, 
          268,    0,  268,  268,  268,  268,  268,  248,  248,    0, 
            0,    0,  248,    0,  268,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  268,  268,  268, 
          268,  268,  268,  268,  268,  268,  268,    0,  268,  268, 
            0,    0,    0,    0,    0,    0,    0,    0,  268,    0, 
            0,  268,    0,    0,  268,    0,  268,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  268,  268,    0,    0, 
            0,    0,  268,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,  268,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,    0,    0,  268,    0,    0,    0, 
            0,  269,  269,  269,    0,    0,  269,  269,  269,    0, 
          269,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          269,  269,    0,  250,    0,    0,    0,    0,    0,  269, 
          269,    0,  269,  269,  269,  269,  269,  250,  250,    0, 
            0,    0,  250,    0,  269,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  269,  269,  269, 
          269,  269,  269,  269,  269,  269,  269,    0,  269,  269, 
            0,    0,    0,    0,    0,    0,    0,    0,  269,    0, 
            0,  269,    0,    0,  269,    0,  269,    0,    0,  251, 
            0,    0,    0,    0,    0,    0,  269,  269,    0,  251, 
            0,    0,  269,    0,    0,    0,    0,    0,    0,    0, 
            0,  248,  248,  248,  269,    0,  248,  248,  248,    0, 
          248,    0,    0,    0,    0,    0,  269,    0,    0,    0, 
          248,  248,    0,  251,    0,    0,    0,    0,    0,  248, 
          248,    0,  248,  248,  248,  248,  248,  251,  251,    0, 
            0,    0,  251,    0,  248,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,  248,  252,    0,    0,  248,  248, 
            0,    0,    0,    0,    0,  252,    0,    0,  248,    0, 
            0,  248,    0,    0,  248,    0,  248,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  248,    0,    0,    0,    0,    0,    0,  252, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,    0, 
            0,    0,    0,  252,  252,    0,  248,    0,  252,    0, 
            0,  250,  250,  250,    0,    0,  250,  250,  250,    0, 
          250,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          250,  250,    0,    0,    0,    0,    0,    0,    0,  250, 
          250,    0,  250,  250,  250,  250,  250,    0,  259,    0, 
            0,    0,    0,    0,  250,    0,    0,    0,  259,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,  250,    0,    0,    0,  250,  250, 
            0,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  250,  259,    0,  250,    0,  250,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  259,  259,    0,    0, 
            0,  259,  250,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,  251,  251,  250,    0,  251,  251,  251,    0, 
          251,    0,    0,    0,  253,    0,  250,    0,    0,    0, 
          251,  251,    0,    0,  253,    0,    0,    0,    0,  251, 
          251,    0,  251,  251,  251,  251,  251,    0,    0,    0, 
            0,    0,    0,    0,  251,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  253,    0, 
            0,    0,    0,  251,  251,    0,    0,    0,  251,  251, 
            0,    0,  253,  253,    0,    0,    0,  253,  251,    0, 
            0,  251,    0,    0,  251,    0,  251,  252,  252,  252, 
            0,    0,  252,  252,  252,    0,  252,    0,    0,    0, 
          254,    0,  251,    0,    0,    0,  252,  252,    0,    0, 
          254,    0,    0,    0,  251,  252,  252,    0,  252,  252, 
          252,  252,  252,    0,    0,    0,  251,    0,    0,    0, 
          252,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,    0,    0,  252, 
          252,    0,    0,    0,  252,  252,    0,    0,  254,  254, 
            0,    0,    0,  254,  252,    0,    0,  252,    0,    0, 
          252,    0,  252,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  252,    0, 
          259,  259,  259,    0,    0,  259,  259,  259,    0,  259, 
          252,    0,    0,  232,    0,    0,    0,    0,    0,  259, 
          259,    0,  252,  232,    0,    0,    0,    0,  259,  259, 
            0,  259,  259,  259,  259,  259,    0,    0,    0,    0, 
            0,    0,    0,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  232,    0,    0, 
            0,    0,  259,  259,    0,    0,    0,  259,  259,    0, 
            0,  232,  232,    0,    0,    0,  232,  259,    0,    0, 
          259,    0,    0,  259,    0,  259,  253,  253,  253,    0, 
            0,  253,  253,  253,    0,  253,    0,    0,    0,  233, 
            0,  259,    0,    0,    0,  253,  253,    0,    0,  233, 
            0,    0,    0,  259,  253,  253,    0,  253,  253,  253, 
          253,  253,    0,    0,    0,  259,    0,    0,    0,  253, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  233,    0,    0,    0,    0,  253,  253, 
            0,    0,    0,  253,  253,    0,    0,  233,  233,    0, 
            0,    0,  233,  253,    0,    0,  253,    0,    0,  253, 
            0,  253,  254,  254,  254,    0,    0,  254,  254,  254, 
            0,  254,    0,    0,    0,  276,    0,  253,    0,    0, 
            0,  254,  254,    0,    0,  276,    0,    0,    0,  253, 
          254,  254,    0,  254,  254,  254,  254,  254,    0,    0, 
            0,  253,    0,    0,    0,  254,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  276, 
            0,    0,    0,    0,  254,  254,    0,    0,    0,  254, 
          254,    0,    0,  276,  276,    0,    0,    0,    0,  254, 
            0,    0,  254,    0,    0,  254,    0,  254,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,  232,  232,  232,    0,    0, 
          232,  232,  232,  262,  232,  254,    0,    0,    0,    0, 
            0,    0,    0,  262,  232,  232,    0,  254,    0,    0, 
            0,    0,    0,  232,  232,    0,  232,  232,  232,  232, 
          232,    0,    0,    0,    0,    0,    0,    0,  232,    0, 
            0,    0,    0,    0,    0,    0,    0,  262,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  262,  262,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  232,    0,    0,  232,    0,    0,  232,    0, 
          232,  233,  233,  233,    0,    0,  233,  233,  233,  225, 
          233,    0,    0,    0,    0,    0,  232,    0,    0,  225, 
          233,  233,    0,    0,    0,    0,    0,    0,  232,  233, 
          233,    0,  233,  233,  233,  233,  233,    0,    0,    0, 
          232,    0,    0,    0,  233,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,  225,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  233,    0, 
            0,  233,    0,    0,  233,    0,  233,  276,  276,  276, 
            0,    0,  276,  276,  276,  270,  276,    0,    0,    0, 
            0,    0,  233,    0,    0,  270,  276,  276,    0,    0, 
            0,    0,    0,    0,  233,  276,  276,    0,  276,  276, 
          276,  276,  276,    0,    0,    0,  233,    0,    0,    0, 
          276,    0,    0,    0,    0,    0,    0,    0,    0,  270, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  270,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  276,    0,    0,  276,    0,    0, 
          276,    0,  276,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  275,    0,  262,  262,  262,  276,    0, 
          262,  262,  262,  275,  262,    0,    0,    0,    0,    0, 
          276,    0,    0,    0,  262,  262,    0,    0,    0,    0, 
            0,    0,  276,  262,  262,    0,  262,  262,  262,  262, 
          262,    0,  655,    0,    0,    0,    0,  275,  262,    0, 
            0,    0,  655,    0,    0,    0,    0,    0,    0,    0, 
            0,  275,  275,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  262,    0,    0,  262,    0,    0,  262,    0, 
          262,  225,  225,  225,    0,    0,  225,  225,  225,    0, 
          225,  655,    0,    0,    0,    0,  262,    0,    0,    0, 
          225,  225,    0,    0,    0,    0,    0,    0,  262,  225, 
          225,    0,  225,  225,  225,  225,  225,    0,    0,   69, 
          262,    0,    0,    0,  225,    0,    0,    0,    0,   69, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  225,    0, 
           67,  225,    0,    0,  225,    0,  225,  270,  270,  270, 
           67,    0,  270,  270,  270,    0,  270,    0,   69,    0, 
            0,    0,  225,    0,    0,    0,  270,  270,    0,    0, 
            0,    0,    0,    0,  225,  270,  270,    0,  270,  270, 
          270,  270,  270,    0,   61,    0,  225,    0,    0,    0, 
          270,    0,    0,    0,   61,    0,    0,    0,    0,   67, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  270,    0,    0,  270,   62,    0, 
          270,    0,  270,    0,    0,  275,  275,  275,   62,    0, 
          275,  275,  275,   61,  275,    0,    0,    0,  270,    0, 
            0,    0,    0,    0,  275,  275,    0,    0,    0,    0, 
          270,    0,    0,  275,  275,    0,  275,  275,  275,  275, 
            0,    0,  270,    0,  655,  655,  655,    0,  275,  655, 
          655,  655,  301,  655,    0,    0,    0,   62,    0,    0, 
            0,    0,  301,  655,  655,    0,    0,    0,    0,    0, 
            0,    0,  655,  655,    0,  655,  655,  655,  655,  655, 
            0,    0,  275,    0,    0,  275,    0,    0,  275,    0, 
          275,    0,    0,    0,    0,    0,  297,    0,    0,    0, 
            0,    0,  302,    0,    0,    0,  275,    0,    0,    0, 
            0,  301,  302,    0,    0,    0,    0,    0,  275,    0, 
            0,    0,    0,    0,  655,    0,    0,  655,    0,  655, 
          275,   69,   69,   69,    0,    0,   69,   69,   69,    0, 
           69,    0,    0,    0,    0,  655,  298,    0,    0,    0, 
           69,   69,    0,    0,  291,    0,    0,    0,    0,   69, 
           69,  302,   69,   69,   69,   69,   69,    0,    0,  655, 
            0,    0,   67,   67,   67,    0,    0,   67,   67,   67, 
            0,   67,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   67,   67,    0,    0,    0,    0,    0,    0,    0, 
           67,   67,    0,   67,   67,   67,   67,   67,    0,    0, 
            0,   69,    0,    0,   69,    0,   61,   61,   61,    0, 
            0,   61,   61,   61,    0,   61,    0,    0,    0,    0, 
            0,    0,   69,    0,    0,   61,    0,    0,    0,    0, 
            0,    0,    0,    0,   61,   61,    0,   61,   61,   61, 
           61,   61,   67,    0,    0,   67,   69,    0,    0,    0, 
           62,   62,   62,    0,    0,   62,   62,   62,    0,   62, 
            0,    0,    0,   67,    0,    0,    0,    0,    0,   62, 
            0,    0,    0,    0,    0,    0,  134,    0,   62,   62, 
            0,   62,   62,   62,   62,   62,   61,   67,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  301,  301,  301,   61,    0,  301, 
          301,  301,    0,  301,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  134,    0,    0,    0,    0, 
           62,   61,    0,    0,    0,  301,  301,  301,  301,  301, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   62,    0,    0,  302,  302,  302,  522,    0,  302, 
          302,  302,    0,  302,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   62,    0,    0,    0,    0, 
            0,  301,    0,    0,  301,  302,  302,  302,  302,  302, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,  301,   12,   13,   14,   15, 
           16,   17,   18,    0,  135,    0,    0,   19,   20,   21, 
          212,  213,  214,  215,    0,    0,  249,    0,    0,  301, 
            0,  302,    0,   28,  302,    0,  216,  217,  218,    0, 
          219,   35,  220,  221,  222,  223,  269,   40,   41,   42, 
           43,    0,    0,    0,    0,  302,    0,    0,    0,    0, 
            0,    0,    0,  135,    0,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,    0,    0,   46,   47,  302, 
           48,    0,  270,    0,  271,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  272,  525,    0,    0,    0,   52, 
          273,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          274,    0,  134,  134,  134,  134,  134,  134,  134,  134, 
          134,  134,  134,    0,    0,  134,  134,    0,  134,  134, 
          134,  134,  134,  134,  134,    0,  625,    0,  134,  134, 
          134,  134,  134,  134,  134,  134,    0,    0,  134,    0, 
            0,    0,    0,    0,  134,  134,    0,  134,  134,  134, 
          134,    0,  134,  134,  134,  134,  134,  134,    0,  134, 
          134,  134,  134,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  522,    0,    0,  134,    0,    0, 
            0,  522,  522,  134,    0,    0,  134,  625,    0,  134, 
          134,    0,  134,    0,  134,    0,    0,    0,  134,    0, 
            0,    0,    0,  134,    0,    0,  134,    0,  625,  632, 
            0,  134,  134,  134,  134,  134,  134,    0,    0,    0, 
          134,    0,  134,  134,    0,  134,  134,  134,  134,    0, 
          134,  134,    0,    0,    0,    0,    0,    0,    0,    0, 
          135,  135,  135,  135,  135,  135,  135,  135,  135,  135, 
          135,    0,    0,  135,  135,    0,  135,  135,  135,  135, 
          135,  135,  135,    0,  626,    0,  135,  135,  135,  135, 
          135,  135,  135,  135,    0,    0,  135,    0,    0,    0, 
            0,    0,  135,  135,    0,  135,  135,  135,  135,    0, 
          135,  135,  135,  135,  135,  135,    0,  135,  135,  135, 
          135,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  525,    0,    0,  135,    0,    0,    0,  525, 
          525,  135,    0,    0,  135,  626,    0,  135,  135,    0, 
          135,    0,  135,    0,    0,    0,  135,    0,    0,    0, 
            0,  135,    0,    0,  135,    0,  626,  322,    0,  135, 
          135,  135,  135,  135,  135,    0,    0,    0,  135,    0, 
          135,  135,    0,  135,  135,  135,  135,    0,  135,  135, 
            0,    0,    0,    0,  134,  134,  134,  134,  134,  134, 
          134,  134,  134,  134,  134,    0,    0,  134,  134,    0, 
          134,  134,  134,  134,  134,  134,  134,    0,  632,    0, 
          135,  134,  134,  134,  134,  134,  134,  134,    0,    0, 
          134,    0,    0,    0,    0,    0,  134,  134,    0,  134, 
          134,  134,  134,    0,  134,  134,  134,  134,  134,  134, 
            0,  134,  134,  134,  134,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  632,    0,    0,  135, 
            0,    0,    0,  632,  632,  134,    0,    0,  134,  628, 
            0,  134,  134,    0,  134,    0,  134,    0,    0,    0, 
          134,    0,    0,    0,    0,  134,    0,    0,  134,    0, 
          632,  323,    0,  134,  134,  134,  134,  134,  134,    0, 
            0,    0,  134,    0,  134,  134,    0,  134,  134,  134, 
          134,    0,  134,  134,    0,    0,    0,    0,    0,    0, 
            0,    0,  135,  135,  135,  135,  135,  135,  135,  135, 
          135,  135,  135,    0,    0,  135,  135,    0,  135,  135, 
          135,  135,  135,  135,  135,    0,  371,    0,    0,  135, 
          135,  135,  135,  135,  135,  135,    0,    0,  135,    0, 
            0,    0,    0,    0,  135,  135,    0,  135,  135,  135, 
          135,    0,  135,  135,  135,  135,  135,  135,    0,  135, 
          135,  135,  135,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  322,  371,    0,    0,    0,    0, 
            0,  322,  322,  135,    0,    0,  135,  629,    0,  135, 
          135,    0,  135,    0,  135,    0,    0,    0,  135,    0, 
            0,    0,    0,  135,    0,    0,  135,    0,    0,    0, 
            0,  135,  135,  135,  135,  135,  135,    0,    0,    0, 
          135,    0,  135,  135, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,  135,  135,  135,  135,    0,  135,  135,    0,    0, 
            0,    0,  135,  135,  135,  135,  135,  135,  135,  135, 
          135,  135,  135,    0,    0,  135,  135,    0,  135,  135, 
          135,  135,  135,  135,  135,    0,  315,    0,    0,  135, 
          135,  135,  135,  135,  135,  135,    0,    0,  135,    0, 
            0,    0,    0,    0,  135,  135,    0,  135,  135,  135, 
          135,    0,  135,  135,  135,  135,  135,  135,    0,  135, 
          135,  135,  135,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  323,  315,    0,    0,    0,    0, 
            0,  323,  323,  135,    0,    0,  135,    0,    0,  135, 
          135,    0,  135,    0,  135,    0,    0,    0,  135,    0, 
            0,    0,    0,  135,    0,    0,  135,    0,    0,    0, 
            0,  135,  135,  135,  135,  135,  135,    0,    0,    0, 
          135,    0,  135,  135,    0,  135,  135,  135,  135,    0, 
          135,  135,    0,    0,    0,    0,    0,    0,  371,  371, 
          371,  371,  371,  371,  371,  371,  371,  371,  371,    0, 
          371,  371,  371,  371,  371,  371,  371,  371,  371,  371, 
          371,  550,    0,    0,    0,  371,  371,  371,  371,  371, 
          371,  371,    0,    0,  371,    0,    0,    0,    0,    0, 
          371,  371,    0,  371,  371,  371,  371,    0,  371,  371, 
          371,  371,  371,  371,    0,  371,  371,  371,  371,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          550,    0,    0,    0,    0,    0,    0,    0,    0,  371, 
            0,    0,  371,    0,    0,  371,  371,    0,  371,    0, 
          371,    0,    0,    0,  371,    0,    0,    0,    0,    0, 
            0,    0,  371,    0,    0,    0,    0,  371,  371,  371, 
          371,  371,  371,    0,    0,    0,  371,    0,  371,  371, 
            0,  371,  371,  371,  371,    0,  371,  371,    0,    0, 
            0,    0,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,    0,    0,  315,  315,    0,  315,  315, 
          315,  315,  315,  315,  315,  654,    0,    0,    0,  315, 
          315,  315,  315,  315,  315,  315,    0,    0,  315,    0, 
            0,    0,    0,    0,  315,  315,    0,  315,  315,  315, 
          315,    0,  315,  315,  315,  315,  315,  315,    0,  315, 
          315,  315,  315,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  654,    0,    0,    0,    0,    0, 
            0,    0,    0,  315,    0,    0,  315,    0,    0,  315, 
          315,    0,  315,    0,  315,    0,    0,    0,  315,    0, 
            0,    0,    0,    0,    0,    0,  315,    0,   19,    0, 
            0,  315,  315,  315,  315,  315,  315,    0,    0,    0, 
          315,    0,  315,  315,    0,  315,  315,  315,  315,    0, 
          315,  315,    0,    0,    0,    0,    0,  550,  550,  550, 
          550,  550,  550,  550,  550,  550,  550,  550,    0,    0, 
          550,  550,    0,  550,  550,  550,  550,  550,  550,  550, 
          654,    0,    0,    0,  550,  550,  550,  550,  550,  550, 
          550,    0,    0,  550,    0,    0,    0,    0,    0,  550, 
          550,    0,  550,  550,  550,  550,    0,  550,  550,  550, 
          550,  550,  550,    0,  550,  550,  550,  550,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  654, 
            0,    0,    0,    0,    0,    0,    0,    0,  550,    0, 
            0,  550,    0,    0,  550,  550,    0,  550,    0,  550, 
            0,    0,    0,  550,    0,    0,    0,    0,    0,    0, 
            0,  550,    0,    0,    0,    0,  550,  550,  550,  550, 
          550,  550,    0,    0,    0,  550,    0,  550,  550,    0, 
          550,  550,  550,  550,    0,  550,  550,    0,    0,    0, 
            0,  654,  654,  654,  654,  654,  654,  654,  654,  654, 
          654,  654,    0,    0,  654,  654,    0,  654,  654,  654, 
          654,  654,  654,  654,  234,    0,    0,    0,  654,  654, 
          654,  654,  654,  654,  654,    0,    0,  654,    0,    0, 
            0,    0,    0,  654,  654,    0,  654,  654,  654,  654, 
            0,  654,  654,  654,  654,  654,  654,    0,  654,  654, 
          654,  654,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  233,    0,    0,    0,    0,    0,    0, 
            0,    0,  654,    0,    0,  654,    0,    0,  654,  654, 
            0,  654,    0,  654,    0,    0,    0,  654,    0,    0, 
            0,    0,    0,    0,    0,  654,    0,    0,    0,    0, 
          654,  654,  654,  654,  654,  654,    0,    0,    0,  654, 
            0,  654,  654,    0,  654,  654,  654,  654,    0,  654, 
          654,    0,    0,    0,    0,    0,  654,  654,  654,  654, 
          654,  654,    0,    0,    0,  654,  654,    0,    0,    0, 
          654,    0,  654,  654,  654,  654,  654,  654,  654,  291, 
            0,    0,    0,  654,  654,  654,  654,  654,  654,  654, 
            0,    0,  654,    0,    0,    0,    0,    0,  654,  654, 
            0,  654,  654,  654,  654,    0,  654,  654,  654,  654, 
          654,  654,    0,  654,  654,  654,  654,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  654,    0,    0, 
          654,    0,    0,  654,  654,    0,  654,    0,  654,    0, 
            0,    0,  654,    0,    0,    0,    0,    0,    0,    0, 
          654,    0,    0,  654,    0,  654,  654,  654,  654,  654, 
          654,    0,    0,    0,  654,    0,  654,  654,    0,  654, 
          654,  654,  654,    0,  654,  654,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          212,  213,  214,  215,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  216,  217,  218,    0, 
          219,   35,  220,  221,  222,  223,  645,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,  212,  213,  214,  215,    0, 
            0,   26,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  216,  217,  218,    0,  219,   35,  220,  221,  222, 
          223,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
          459,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  224,    0,    0,  225, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  241,  242,   17, 
           18,    0,    0,    0,    0,   19,  243,  244,  323,  324, 
          325,  326,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,  327,  328,  329,    0,  330,   35, 
          331,  332,  333,  334,    0,   40,    0,    0,  259,  459, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  335, 
            0,    0,  225,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            7,  304,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
            0,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  139,  140,  141,  142,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  151,  152,  153,    0,  154,  155,  156,  157,  158, 
          159,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
          175,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,  343,  344,  204, 
          345,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,  293,    0,  204, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,    0,    0,  204, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,  112,  113,  114,  115, 
          116,  117,  118,  119,  120,  121,  122,  123,  124,  125, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  196,  197,  198,  199,  143, 
          144,  145,    0,    0,    0,    0,  146,  147,  148,  149, 
          150,  200,  201,  202,    0,  203,  155,    0,    0,  204, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          166,  167,  168,    0,    0,  169,  170,    0,    0,    0, 
          171,  172,  173,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  185,  186,  187, 
          188,    0,    0,  189,    0,    0,    0,    0,    0,    0, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,  190,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          303,    4,    5,    6,    7,  304,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,    0,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,  305,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          303,    4,    5,    6,    7,  304,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,    0,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  270,    0,  271,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  698,    0,  271,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
          290,  290,  290,    0,  290,    0,    0,    0,  290,  290, 
            0,    0,    0,  290,    0,  290,  290,  290,  290,  290, 
          290,  290,    0,    0,    0,    0,  290,  290,  290,  290, 
          290,  290,  290,    0,    0,  290,    0,    0,    0,    0, 
            0,    0,  290,    0,    0,  290,  290,  290,    0,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          290,    0,    0,  290,    0,    0,  290,  290,    0,  290, 
            0,  290,    0,  290,    0,  290,    0,    0,    0,    0, 
            0,    0,    0,  290,    0,    0,    0,    0,  290,  290, 
          290,  290,  290,  290,    0,    0,    0,  290,    0,  290, 
          290,    0,  290,  290,  290,  290,    0,  290,  290,  290, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  270,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,  271,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,  698,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,  269,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,  273, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  274, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  241,  242,   17,   18, 
            0,    0,    0,    0,   19,  243,  244,  212,  213,  214, 
          215,    0,    0,  249,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  216,  217,  218,    0,  219,   35,  220, 
          221,  222,  223,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
            0,  225,  497,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  272,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  212,  213,  214,  215, 
            0,    0,  249,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  216,  217,  218,    0,  219,   35,  220,  221, 
          222,  223,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
          225,    0,    0,   46,   47,    0,   48,    0,  637,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          272,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  241,  242,   17,   18,    0,    0, 
            0,    0,   19,  243,  244,  212,  213,  214,  215,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  216,  217,  218,    0,  219,   35,  220,  221,  222, 
          223,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  224,    0,    0,  225, 
            0,    0,   46,   47,    0,   48,    0,  270,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  272, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  241,  242,   17,   18,    0,    0,    0, 
            0,   19,  243,  244,  212,  213,  214,  215,    0,    0, 
          249,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          216,  217,  218,    0,  219,   35,  220,  221,  222,  223, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  224,    0,    0,  225,    0, 
            0,   46,   47,    0,   48,    0,  637,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  272,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  241,  242,   17,   18,    0,    0,    0,    0, 
           19,  243,  244,  212,  213,  214,  215,    0,    0,  249, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  216, 
          217,  218,    0,  219,   35,  220,  221,  222,  223,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,  225,    0,    0, 
           46,   47,    0,   48,    0,  908,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  272,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  241,  242,   17,   18,    0,    0,    0,    0,   19, 
          243,  244,  212,  213,  214,  215,    0,    0,  249,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  216,  217, 
          218,    0,  219,   35,  220,  221,  222,  223,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,    0,    0,   46, 
           47,    0,   48,    0,  698,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  272,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,  643,  643,  643,    0,  643,    0,    0,    0, 
          643,  643,    0,    0,    0,  643,    0,  643,  643,  643, 
          643,  643,  643,  643,    0,    0,    0,    0,  643,  643, 
          643,  643,  643,  643,  643,    0,    0,  643,    0,    0, 
            0,    0,    0,    0,  643,    0,    0,  643,  643,  643, 
            0,  643,  643,  643,  643,  643,  643,    0,  643,  643, 
          643,  643,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  643,    0,    0,  643,  643,    0,  643,  643, 
            0,  643,    0,    0,    0,    0,    0,  643,    0,    0, 
            0,    0,    0,    0,    0,  643,    0,    0,    0,    0, 
          643,  643,  643,  643,  643,  643,    0,    0,    0,  643, 
            0,  643,  643,    0,  643,  643,  643,  643,    0,  643, 
          643,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          212,  213,  214,  215,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  216,  217,  218,    0, 
          219,   35,  220,  221,  222,  223,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  241,  242, 
           17,   18,    0,    0,    0,    0,   19,  243,  244,  212, 
          213,  214,  215,    0,    0,  249,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  216,  217,  218,    0,  219, 
           35,  220,  221,  222,  223,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  225,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  272,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,  212,  213, 
          214,  215,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  216,  217,  218,    0,  219,   35, 
          220,  221,  222,  223,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,  225,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  272,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,  643,  643, 
          643,    0,  643,    0,    0,    0,  643,  643,    0,    0, 
            0,  643,    0,  643,  643,  643,  643,  643,  643,  643, 
            0,    0,    0,    0,  643,  643,  643,  643,  643,  643, 
          643,    0,    0,  643,    0,    0,    0,    0,    0,    0, 
          643,    0,    0,  643,  643,  643,    0,  643,  643,  643, 
          643,  643,  643,    0,  643,  643,  643,  643,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  643,    0, 
            0,  643,    0,    0,  643,  643,    0,  643,    0,    0, 
            0,    0,    0,  643,    0,    0,    0,    0,    0,    0, 
            0,  643,    0,    0,    0,    0,  643,  643,  643,  643, 
          643,  643,    0,    0,    0,  643,    0,  643,  643,    0, 
          643,  643,  643,  643,    0,  643,  643,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  241,  242,   17,   18,    0, 
            0,    0,    0,   19,  243,  244,  323,  324,  325,  326, 
            0,    0,  249,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,  327,  328,  329,    0,  330,   35,  331,  332, 
          333,  334,    0,   40,    0,    0,  259,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  335,    0,    0, 
          410,    0,    0,   46,   47,    0,   48,    0,  411,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  241,  242,   17,   18,    0,    0, 
            0,    0,   19,  243,  244,  421,  422,  423,  424,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  425,  426,  427,    0,  428,   35,  156,  157,  429, 
          159,    0,   40,    0,    0,  259,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  430,    0,    0,    0,  431,    0,    0,  225, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  241,  242,   17,   18,    0,    0,    0, 
            0,   19,  243,  244,  421,  422,  423,  424,    0,    0, 
          249,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
          425,  426,  427,    0,  428,   35,  156,  157,  429,  159, 
            0,   40,    0,    0,  259,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  431,    0,    0,  225,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  241,  242,   17,   18,    0,    0,    0,    0, 
           19,  243,  244,  323,  324,  325,  326,    0,    0,  249, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,  327, 
          328,  329,    0,  330,   35,  331,  332,  333,  334,    0, 
           40,    0,    0,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  335,    0,    0,  410,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  241,  242,   17,   18,    0,    0,    0,    0,   19, 
          243,  244,  986,  987,  988,  989,    0,    0,  249,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,  990,  991, 
          992,    0,  993,   35,  994,  995,  996,  997,    0,   40, 
            0,    0,  259,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  998,    0,    0,  225,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          241,  242,   17,   18,    0,    0,    0,    0,   19,  243, 
          244,  421,  422,  423,  424,    0,    0,  249,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  425,  426,  427, 
            0, 1035,   35,  156,  157, 1036,  159,    0,   40,    0, 
            0,  259,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0, 1037,    0,    0,  225,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66, 1077,  620,    0,    0, 1078,    0,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,  166,  167,  168,    0, 
            0,  169,  170,    0,    0,    0,  171,  172,  173,  174, 
            0,    0,    0,    0,    0,    0,  287,    0,    0,    0, 
            0,    0,    0,  176,  177,    0,  178,  179,  180,  181, 
          182,  183,  184,  185,  186,  187,  188, 1095,  612,  189, 
            0, 1096,    0,    0,    0,  160,  161,    0,  162,  163, 
          164,  165,  166,  167,  168,    0,    0,  169,  170,    0, 
            0,  190,  171,  172,  173,  174,    0,    0,    0,    0, 
            0,    0,  287,    0,    0,    0,    0,    0,    0,  176, 
          177,    0,  178,  179,  180,  181,  182,  183,  184,  185, 
          186,  187,  188,  626,  620,  189,    0,  627,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,  166,  167, 
          168,    0,    0,  169,  170,    0,    0,  190,  171,  172, 
          173,  174,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,  185,  186,  187,  188,    0, 
            0,  189,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  190, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,   74,   28,    6,    7,   11,    2,  456,   15,   16, 
          232,   21,   27,  280,  240,   45,   51,   88,  100,   14, 
           91,    6,    0,    7,   27,   15,   16,    2,    3,  355, 
          296,    2,    3,    0,    9,   10,   11,    3,  479,   14, 
           15,   16,  678,   27,   21,    7,  318,   15,   16,   52, 
          322,   47,   48,  476,   49,  691,  479,   47,    0,  571, 
           10,   11,   49,  746,   10,   27,   10,   52,   10,   10, 
           45,   46,   10,  401,   49,   46,   51,  518,   10,   47, 
           48,  349,  355,  351,  413,  528,   59,  723,   10,   10, 
           59,  105,   10,   10,  681,   10,  549,  107,  748,  105, 
          858,  108,   10,  881,  400,  100,  402,  431,   45,   10, 
          406,  946,   10,   59,  109,  110,  305,   59,  108,   10, 
           10,  548,  450,  305,   43,  100,   10,   44,   10,   61, 
          107,  856,  341,  108,  109,  110,   44,   59,   59,  467, 
          108, 1031,   59,   44,   59,   10,   44,    9,   10,   11, 
           10,   59,   10,  449,   44,  451,   10,  228,   59,  290, 
           10,   59,   10,  799,   10,   10,   10,  305,   59,   59, 
           10,  280,  468,   44,  280,   59,  341,   59,  407,   44, 
          409,  312,  960,  314,   44,  414,  375,   10,   10,   10, 
           61,  262,   10,  375,   59,   10,   10,  310,  526, 1089, 
           10,   61,  645,   61,  345,  473,  502,   10,   10,   59, 
           10,   59,  362,   59,   10,   59,   10,  942, 1053,   59, 
           10,  488,  363,  549,  250,  325,   44,  362,  299,  235, 
          407,  527,   10,    0,   32,  341,  211,  414,   59,  770, 
          342,   44,   10,   10,   10,  776,   61,   32,   10,   32, 
          225,   10, 1010,  362,  336,  373,  362,  359,  373,  359, 
          378,   61,   10,  378,  947,  706,  337,  244,   10,  905, 
          366,  539,  410,   10,   10,  305,  549,  284,   10,  286, 
          287,   32,  705,  706,  282,   44,   32, 1012,  225,   10, 
          267,  287,   59,  307,  284,  338,  286,   59,  322,  323, 
          296,  307,   32,  953,  263,   10,  574,  734,  735,  284, 
          269,  286,  287,   10,   10,  290,  284,  292,  286,   61, 
          342,  296,  297,   44,  269,  296,  271, 1052,  303,   44, 
          305,   44,  303,  357,  358,  328,  664,  359,   59,  663, 
          259,  336,  671,  336, 1027,  932,  338,  279,  791,  802, 
          481,  804,  290,  291,   59,  268,  269,   10,  489,  490, 
          297,  336,   59,   59,  876,  271,  281,   10,  305,  665, 
           61,  306,  407,  342,  409,  310,  507,  267,  413,  414, 
          410,  512,  264,  267,   61,  363,  359,  362,  363,  364, 
          365,  366,  367,  368,  401,  366,  363,   61,  342,  402, 
          341,  345, 1085,  406,   10,  401,   59,  305,  279,   59, 
          342,  310,  362,  363,  364,  365,  411,  363,   61,  409, 
          746,  363,  748,  413,  411,  402,  401,  345,  290,  856, 
          292,  858,  407,  700,  409,  410,  411,  359,  413,  414, 
         1076,  416,  359,  450,  342,  416,  528,  719,  451,  715, 
          416,  359,  964,   59,  450,  430,  784,  969,  359,  338, 
          467,  683,  437,  731,  279,  468,  387,  457,  359,  695, 
          338,  467,  447,  410,  451,  450,  802,  375,  804,  279, 
          455,  496,  342,  932,  342,   91,  461,  783,  342,  785, 
          758,  468,  467,  496,  359,   44,  937,  342,  342,  502, 
          362,  363,  364,  365,  341,  367,  368,   10,  476,  359, 
          447,  461,  496,  644,  937,  942,  943,  310,  455,  526, 
          342,  342,  497,  345,  527,  502,  279,  342,  342,  802, 
          526,  804,  342,  528,  496,  510,  667,  279,  767,  768, 
          342,   44,  342,  305,  773,  774,  342,  515,  342,  345, 
          527,  526,  342,  528, 1066,  881,   59,  786,    2,    3, 
          339,  632,  267,  645,  342,    9,   10,   11,  430,   44, 
          267,   15,   16,  840,  342,  437,  342,  345,   91,  710, 
          342,   10,  608, 1010,  305, 1012,  371,  372,  371,  372, 
          767,  768,  618,  378,  342,  378,  773,  774,   44,  461, 
          342,   45,   46,  317,  614,  342,  342,   51,  739,  305, 
          342,  264,  622,  375,  308,  268,  269,  317,  628,  338, 
           10,  342,  342,   10,  363, 1052,  622,  953,  105,  345, 
           59,  310,  628,  562,  563,  497,  279,  614,  720,   44, 
          328,   10,  339,   15,   16,  622,  342,  335,  336,   44, 
          645,  628,  678,   10,  375,  670,   44,  664,  290,  291, 
          347,  267,  665,  892,  108,  691,  669,  670,  664,  262, 
          645,   61,   59,  357,  280,  671,  672,  264,  674,  375, 
          686,  671,  376,  377,  669,  681,  670,   44,  665,  664, 
           59,  666,   10,  267,   10,  350,  351,  723,  694,  342, 
          922, 1027,   59,  264,  926, 1031,  341,  780,  670,  791, 
          685,  342,  687,  690,  740,  892, 1044,  694,   44,  715, 
           44,  363,  328,   91,  855,  720,   44,  363,   44,  335, 
          336,   44,  767,  768,   91,  341,  108,  705,  773,  774, 
          715,   59,   10,   59,  715,  720,   10,  362,  685, 1045, 
          687,  786,   10,   10,  306,  306,  362,  306,  235,  308, 
          309,  310,  311, 1089,   44,   44,  762,  211,  764,   44, 
           44,  371,  372,  799,  746,   91,  748,  784,  378,   44, 
          306,  225,  785,  383,  263,  264,  917,  793,  784,   44, 
          269,   59,  767,  768,   44,   61,  791,   61,  773,  774, 
           10,  264,  305,   61,   61,  363,  781,  264,  785,  784, 
          781,  786,  297,  809,  666,  328,  791,   91,  338,  794, 
          795,  338,  335,  336,    2,    3,   91,  338,  803,   10, 
          307,    9,   10,   11,  263,  264,  811,   15,   16,  342, 
          284,  816,  286,  287,  794,  820,  290,   10,  292,   59, 
          338,   44,  296,  297,  829,  881,  359,  892,   61,  303, 
           44,  305,  269,   44,  338,  341,  816,   45,   46,   44, 
          338,  338,  375,   51,  811,  262,  263,  264,   59,  905, 
          338,  268,  269,  820,  271,  264,   32,   91,   32,  279, 
          865,  866,  829,  262,  263,  264,   58,  338,   61,  268, 
          269,  306,  271,  308,  309,  310,  311,  913,  883,  881, 
          885,  345,  284,  919,  286,   91,  363,  892,  362,  363, 
          364,  365,  366,  367,  368,  264,  921,  339,  999,  866, 
          108,    0,  794,  862,  960,  264,  932,  912,  407,  868, 
          869,   10,  871,  795,  873,  414,  921,  338,  885,   10, 
          925,  803,  342,  264,  816,  342,  264,  401,  264,   44, 
          328,  936,  363,  407,  280,  409,  410,  335,  336,  413, 
          414,  328,  416,  342,  750,  970,  363,  753,  335,  336, 
           44,  953,   48,  452,  341,  454,  430,  305,  925, 1015, 
           59,  342,   59,  437,  363,  970,  264,   44,   59,  936, 
          387,  269,  359,  447,   44,  279,  450, 1003,   44,   10, 
          985,  455,  328,  865,  279,  279,   44,  461,  387,  335, 
          336,  279,  279,  467,  342,  341,   44, 1002,  264, 1004, 
           91,  883,   10,  211, 1009,  504,  264, 1044,   44,  264, 
           10,  359, 1045,  359, 1039,   44,  362,  225, 1044,  363, 
         1076,   91, 1048,  497,  328, 1027,   44,  375,   59, 1031, 
          912,  335,  336,  328, 1039, 1002,  510, 1004, 1045, 1044, 
          335,  336, 1009,   44,   44,   44,  341,   10,  342,   61, 
          310,   59,  526,  359,  342,  342,  267,  264,   44,   59, 
           91, 1020, 1021, 1022, 1023,  263,  306,  264,  308,  309, 
          310,  311,  312,    2,    3,  881,  284,  317,  286,  287, 
           10,  359,  290,   44,  292,   14,  279, 1089,  296,  297, 
          310,   91,  264,   44,  328,  303,   59,  305,  387,   44, 
          340,  335,  336,  985,   44,   44,   44,  750,  348,  349, 
          350,  351,   44,  271,   44,  363,   45,   46,  308,  309, 
           49,  311,  328,  345,  271, 1084,   91,  342,  339,  335, 
          336,   61,  341,  306,   10,  308,  309,  310,  311,  363, 
          743,  371,  372,  373,  345,  748,  386,   58,  378,  342, 
           91,  345,   91,  264,  362,  363,  364,  365,  366,  367, 
          368,   91,  345,  262,  263,  264,   70,  340,  267,  268, 
          269,  100,  271,  269,  270,  271,  267,   54,  274,  574, 
          109,  110,  281,   59,  273,  110,  376,  377,  510,  280, 
          664, 1048,  666,  401,  293,  294,  295,  296,  297,  407, 
         1003,  409,  410,   91,   44,  413,  414,    6,  416,  279, 
          280,  685,  628,  687,   10,  764,  920,  746, 1024,  750, 
         1027, 1027,  430, 1029,  881, 1031,  371,  372,  373,  437, 
         1029,  779,  655,  378,  396,   14,  267,  328,  881,  447, 
          734,  715,  450,  342,  335,  336,   91,  455, 1053,  280, 
          341,   91,    0,  461,  262,  263,  264,   89,  328,  467, 
         1046,  269,   10,   59,  363,  335,  336,  672,  767,  768, 
           -1,  362,   -1,   -1,  773,  774,   -1,   44,  881, 1085, 
          280, 1087,  211, 1089,   -1,   -1, 1092,   -1,  387,  497, 
           -1,   -1,  362,  767,  768,   91,  225,  328, 1104,  773, 
          774,  264,  510,   -1,  335,  336,  269,  781,  271,   -1, 
          784,   59,  786,  409,   -1,   -1,   -1,  413,  526,   -1, 
          794,  795,  821,  822,   91,  824,  825,   -1,  328,  803, 
           -1,  362,   -1,   -1,   -1,  335,  336,  811,   -1,  312, 
          279,  341,  816,   -1,  317,   -1,  820,   91,  951,  279, 
          953,   -1,  955,   -1,   -1,  829,    0,   -1,   -1,  359, 
           -1,  457,  362,  328,   -1,   -1,   10,  296,  297,   -1, 
          335,  336,    0,   -1,  303,   -1,  305,  350,  351,  475, 
          476, 1024,   10,  479, 1027,   -1, 1029,  328, 1031,  328, 
           -1,  865,  866,   -1,  335,  336,  335,  336,  328,   -1, 
           44,  371,  372,  373,   -1,  335,  336,  336,  378,  883, 
           -1,  885,  342,  386,   58,   59,   44,   -1,  892,  515, 
           -1, 1024,  518,  293,  294,  295,  296,  297, 1031,   -1, 
          306,   59,  308,  309,  310,  311,  312,  366,  912,  279, 
          328,  317, 1085,   10, 1087,   -1, 1089,  335,  336, 1092, 
           -1,  925,  328, 1056,   -1,   10,  664,   -1,  666,   -1, 
          336, 1104,  936,   -1,  340,  341,  317,  379,  380,  381, 
          382,  267,  348,  349,  350,  351,  572,  685,  407,  687, 
          409,  410,  411,  328, 1087,  414, 1089,  416,  328, 1092, 
          335,  336,   59,   -1,   -1,  335,  336,   -1,  349,   -1, 
           -1, 1104,  353,  354,   59,   -1,   44,  715,   -1,   10, 
          386,  985,  279,   -1,  262,  263,  264,   -1,  447,  267, 
          268,  269,   -1,  271,   91,   -1,  455,   -1, 1002,   -1, 
         1004,   -1,  328,  281,  282, 1009,   91,   -1,   -1,  335, 
          336,  637,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   10,   91,    0,  371,  372,  373,   59,  767, 
          768,  328,  378,   -1,   10,  773,  774,   -1,  335,  336, 
         1044,   -1,  388,  781,   -1,  671,  784,   -1,  786,   -1, 
           -1,  510,   -1,   -1,  328,   -1,  794,  795,   -1,   -1, 
           91,  335,  336,   -1,  342,  803,   -1,  345,   44,  528, 
          696,   59,  698,  811,   -1,   -1,   -1,   -1,  816,  705, 
          706,   -1,  820,   59,   -1,  363,   -1,   -1,  262,  263, 
          264,  829,   -1,  267,  268,  269,  306,  271,  308,  309, 
          310,  311,   -1,   91,  262,  263,  264,  281,  282,  387, 
          268,  269,   -1,  271,   -1,   -1,  290,  291,   10,  293, 
          294,  295,  296,  297,   15,   16,   -1,  865,  866,   -1, 
          756,  305,  290,  291,   -1,  293,  294,  295,  296,  371, 
          372,  373,  371,  372,  373,  883,  378,  885,   -1,  378, 
           41,   42,   -1,   -1,  892,   -1,   47,   48,   -1,   50, 
           51,   -1,  788,   -1,   -1,  339,   -1,   59,  342,   -1, 
          267,  345,   -1,  347,  912,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  267,  280,  342,   -1,  645,  925,   10,  363, 
          306,   -1,  308,  309,  310,  311,   -1,   -1,  936,   91, 
           -1,  375,  828,   -1,   -1,  363,   -1,  666,  881,   -1, 
           -1,  279,  280,  387,  371,  372,  373,  108,   -1,   -1, 
           -1,  378,   -1,   -1,  340,   -1,  685,   -1,  687,  387, 
           -1,  328,  348,   -1,   -1,   -1,  267,   59,  335,  336, 
           -1,    2,    3,  328,  341,   -1,   -1,  985,   -1,  280, 
          335,  336,   10,   14,   -1,   -1,  715,   -1,   -1,   -1, 
          328,  720,   -1,   -1, 1002,  362, 1004,  335,  336,  728, 
           -1, 1009,   -1,  341,   -1,   -1,   -1,   -1,   10,  267, 
           -1,   -1,  908,   -1,   45,   46,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  362,  271,   10,  328,    2,    3, 
           -1,   59,   -1,   44,  335,  336, 1044,   -1,  767,  768, 
          341,  937,   44,   -1,  773,  774,   -1,  293,  294,  295, 
          296,  297,  781,   -1,   -1,   -1,   -1,  786,   -1,   61, 
           -1,  362,  791,   91,   -1,  317,  795,   -1,   -1,   -1, 
          328,   45,   46,   -1,  803,   59,   -1,  335,  336,   -1, 
           91, 1024,  811,  341, 1027,   -1, 1029,   -1, 1031,   91, 
           -1,  820,   -1,  339,   -1,   -1,  342,  349,   -1,   -1, 
          829,  353,  354,  355,  356,  267,    0,   91,  269,  270, 
          271,  272,   -1,  274,   -1,   -1,   10,  363,   -1,   10, 
           -1,   -1,   -1,  284,   -1,  286,  287,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  295,   -1,  865,  866,   -1,   -1, 
           -1,  387, 1085,   -1, 1087,   -1, 1089,   -1,   -1, 1092, 
           44,   -1,   -1,   -1,  883,   -1,  885,   10,   -1,   -1, 
           -1, 1104,   -1,  892,   -1,   59,  328,   -1,   59,   -1, 
          262,  263,  264,  335,  336,  267,  268,  269,   -1,  271, 
          211,   -1,   -1,  912,  262,  263,  264,   -1,   -1,  281, 
          268,  269,  921,  271,  225,   -1,  925,   -1,  290,  291, 
           10,  293,  294,  295,  296,  297,   59,  936,  369,  370, 
          371,  372,  373,   10,   -1,  376,  377,  378,  379,  380, 
          381,  382,  383,  384,  385,  386,  387,  388,  389,   -1, 
           10,  392,  393,  394,  395,   -1,  328,  211,   91,  267, 
          401,  970,  403,  335,  336,   -1,  407,   -1,  409,   59, 
          342,  225,  413,  414,   -1,   -1,  985,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  342,  296,  297,   -1,  279,   -1, 
           -1,  363,  303, 1002,  305, 1004,   -1,  279,  280,   59, 
         1009,   -1,   -1,  267,   -1,  363,   -1,   -1,   -1,  450, 
           -1,  452,  453,  454,   -1,  387,  457,   -1,   -1,   -1, 
          328,   -1,   -1,    0,   -1,   -1,  467,  335,  336,  387, 
         1039,   91,   10,   10,  475,  476,   -1,  328,  479,   -1, 
           -1,   -1,  296,  297,  335,  336,  328,   -1,   -1,  303, 
           -1,  305,   -1,  335,  336,  366,   -1,   -1,   -1,  341, 
          342,   -1,  503,  504,  328,   -1,   44,   44,   -1,   -1, 
           -1,  335,  336,   -1,  515,   -1,   -1,  518,   -1,   -1, 
          362,   58,   59,   61,   -1,  526,   63,   -1,  262,  263, 
          264,   10,   -1,  267,  268,  269,  407,  271,  409,  410, 
           -1,   -1,   -1,  414,   -1,  416,   -1,  281,  282,   -1, 
           10,   -1,  366,   91,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  306,   44,  308,  309,  310,  311, 
           -1,  572,   -1,   -1,  267,  306,  447,  308,  309,  310, 
          311,  312,   61,   -1,  455,   -1,  317,   -1,   -1,   -1, 
           -1,   -1,   -1,  407,   -1,  409,  410,  328,  340,   59, 
          414,   -1,  416,   -1,   -1,  336,  348,   -1,  342,  340, 
          341,  345,   91,  347,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  363, 
           -1,   91,   -1,  447,   10,  328,  637,   -1,   -1,  510, 
           -1,  455,  335,  336,   -1,   -1,   44,  267,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,  386,  306,   10,  308,  309, 
          310,  311,  312,  664,   -1,   -1,   -1,  317,   44,  306, 
          671,  308,  309,  310,  311,  312,   -1,   44,  328,   -1, 
          317,   -1,   -1,   59,   -1,   -1,  336,   -1,   -1,   -1, 
          340,  341,   -1,   91,   -1,  696,  510,  698,  348,  349, 
          350,  351,   -1,  340,  705,  706,   59,   -1,  328,   -1, 
           -1,  348,  349,  350,  351,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  386,   -1,   91,   44, 
           -1,  279,   44,   -1,  281,  282,   -1,   -1,   -1,  386, 
           -1,   -1,   -1,  290,  291,  756,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,  767,  768,  305,   -1, 
           -1,   -1,  773,  774,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  782,   -1,  784,   10,  786,   91,  788,  325,   91, 
          328,   -1,  329,  330,   -1,  666,   -1,  335,  336,    0, 
          279,  280,  339,  341,  342,  342,   -1,  267,  345,   10, 
          347,   -1,   -1,   -1,  685,   -1,  687,   -1,   44,   -1, 
          821,  822,   -1,  824,  825,   10,  363,  828,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   44,  715,   -1,   -1,   -1,   -1,  328, 
          387,   -1,  666,   -1,   -1,   -1,  335,  336,   59,   -1, 
           91,   -1,  341,  342,   -1,   91,   44,   -1,  328,   -1, 
           -1,  685,   -1,  687,   59,  335,  336,   -1,   -1,   -1, 
           -1,  279,  280,  362,   44,  886,  262,  263,  264,   -1, 
           -1,  892,  268,  269,   -1,  271,  767,  768,   -1,   -1, 
           -1,  715,  773,  774,   -1,   44,   -1,  908,   -1,   -1, 
          781,   -1,  279,   91,  267,  786,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  795,   -1,   -1,  280,  929,   -1, 
          328,   91,  803,   -1,   -1,   -1,  937,  335,  336,   -1, 
          811,    0,   -1,  341,   -1,   -1,   -1,   -1,   -1,  820, 
           -1,   10,   91,  767,  768,   -1,   -1,   -1,  829,  773, 
          774,  328,   -1,   -1,  362,   -1,  342,  781,  335,  336, 
           -1,   -1,  786,   -1,  279,  328,   -1,  279,  280,   -1, 
           -1,  795,  335,  336,   -1,   44,   -1,  363,  341,  803, 
           -1,   -1,   -1,   -1,  865,  866,   -1,  811,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  820,   -1,  317,  362, 
           -1,  387,  883,   -1,  885,  829,   -1,   -1,   -1,   -1, 
           -1,  892,   -1,  328,  333,  334,  328,   -1,   -1,   -1, 
          335,  336,   91,  335,  336,   -1,  267,   -1,   -1,  341, 
          349,  912,  351, 1044,  353,  354,  355,  356,   -1,   -1, 
          921,  865,  866,  279,  925,   -1,   -1,   -1,   -1,   -1, 
          362,  262,  263,  264,   -1,  936,  267,  268,  269,  883, 
          271,  885,   -1,   -1,   -1,   -1,    0,   -1,  892,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   10,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,  328,  912,   -1, 
           -1,  279,  328,   -1,  335,  336,   -1,   -1,   -1,  335, 
          336,  925,   -1,   -1,  985,   -1,  342,   -1,   -1,  279, 
           44,  306,  936,  308,  309,  310,  311,  312,   -1,   -1, 
           -1, 1002,  317, 1004,   58,   59,   -1,   61, 1009,   63, 
          279,  342,   -1,  328,  345,   -1,  347,   -1,   -1,   -1, 
          328,  336,   -1,   -1,   -1,  340,  341,  335,  336,   -1, 
           -1,   -1,  363,  348,  349,  350,  351,   91,  328,   -1, 
           -1,  985,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   -1, 1002,  328, 
         1004,   -1,   -1,   -1,   -1, 1009,  335,  336,  257,  258, 
          259,  386,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,  375,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  386,  387,   44, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   44,   -1,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,    0, 
          374,  375,  376,  377,   91,  379,  380,  381,  382,   10, 
          384,  385,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  961,   -1,   -1,   -1, 
          965,   -1,   -1,  317,   -1,  262,  263,  264,  322,  323, 
           -1,  268,  269,   44,  271,   -1,   -1,  317,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,  333,  334,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,   -1,   -1,  359, 
           91,  361,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  342,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289, 1060,   -1,  292, 1063, 1064, 
            0,   -1, 1067, 1068,  299,   -1,  363,  302,  303,  304, 
           10,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,  306,   -1,  308,  309,  310,  311,  312,   -1, 
          387,   -1,   -1,  317, 1099, 1100, 1101, 1102,   -1,   -1, 
           -1,   -1,  337, 1108,   44,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,  340,  341,   58,   59, 
          317,   61,  279,   63,  348,  349,  350,  351,   -1,   -1, 
          365,  366,  367,  368,  369,  370,  333,  334,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,   91,  349,   -1,   -1,   -1,  353,  354,  355,  356, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           44,   -1,  333,  334,  335,  336,  337,   -1,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,  375,  376,  377,   91,  379,  380, 
          381,  382,   -1,  384,  385,  386,  387,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,   -1,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,    0,  374,  375,  376,  377,   -1,  379, 
          380,  381,  382,   10,  384,  385,  386,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,   -1,   -1,   -1,   -1,  306,   44,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   58,   59,  340,   61,  279,   63,   -1,  328,   -1, 
           -1,  348,  349,  350,  351,   -1,  336,   -1,   -1,   -1, 
          340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,   -1,   91,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,   -1,  386,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  350, 
          351,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,  386,  326,  327,   44,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   58,   59,   -1,   -1,   -1,   63,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          337,   -1,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,  375,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          387,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,    0,  374,  375, 
          376,  377,   -1,  379,  380,  381,  382,   10,  384,  385, 
          386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   44,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,  328,  317,  318,  319,  320,  321,  322,  323, 
          336,   -1,  326,  327,  340,  341,   -1,   -1,   -1,  333, 
          334,   -1,  348,  349,  350,  351,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          386,   -1,  265,  266,   -1,   -1,   -1,  270,    0,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   10,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   44,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   59,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,   -1,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,  375,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  386,  387,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   63,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,  375,  376,  377,   -1,  379,  380,  381, 
          382,   10,  384,  385,  386,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   44,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,   -1,  340,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,   -1, 
           -1,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,  349, 
           -1,  351,    0,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   59,  329,  330,   -1,   63,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   91,  361,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           59,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   -1, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   -1,  384,  385,  386,  387,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   63,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,    0,   -1,  333,  334,  335,  336,  337, 
           -1,  339,  340,   10,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   44,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  386,  387, 
           -1,   -1,   59,   -1,   -1,   -1,   63,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,  336,   -1,   -1, 
           -1,  340,  341,   -1,   -1,   -1,   -1,  279,  280,  348, 
          349,  350,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  386,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   59,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   44,   -1,  333,  334,  335,  336, 
          337,   -1,  339,  340,   -1,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   91,  379,  380,  381,  382,   -1,  384,  385,  386, 
          387,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,    0,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,   10,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   44, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,   -1,   -1,   59,   -1,   61,   -1,   63,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   91,   -1,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1,  279, 
          280,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  362,  326,  327,   59,   -1,   61,   -1,   63, 
          333,  334,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   91,  361,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   61,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   91,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,  338,   -1,  340,  341,  342,  343,  344, 
           -1,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  386,  387,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,  279,  340,  341,  342,  343, 
          344,   -1,  346,   -1,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          367,  368,  369,  370,   -1,   -1,    0,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   10,  384,  385,  386, 
          387,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   91,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           10,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   44,  326,  327,   44,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   59,  341,   61,   -1, 
           63,   61,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,   -1,   -1,  340,  341,  342,  343, 
          344,   -1,  346,   -1,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  386,  387,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,  279, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  328,   -1, 
          333,  334,  335,  336,  337,  335,  336,  340,  341,  342, 
          343,  344,  342,  346,   -1,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
            0,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           10,  384,  385,  386,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   44,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   59, 
           -1,   61,   -1,   63,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,  307,  386,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,    0,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   10,  348,  349,   10,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  306,  307,  364,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   44,  326,  327,   44,   -1, 
          386,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           59,  341,   61,   -1,   63,   61,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,   -1,   -1, 
          340,  341,  342,  343,  344,   -1,  346,   -1,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,  279,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  328,   -1,  333,  334,  335,  336,  337,  335, 
          336,  340,  341,  342,  343,  344,  342,  346,   -1,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   10,  384,  385,  386,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   44,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   59,   -1,   61,   -1,   63,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,  307,  386,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,    0,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   10,  348,  349,   10,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          306,  307,  364,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   44, 
          326,  327,   44,   -1,  386,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   59,  341,   61,   -1,   63,   61, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,   -1,  340,  341,  342,  343,  344,   -1, 
          346,   -1,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,  279,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  328,   -1,  333,  334, 
          335,  336,  337,  335,  336,  340,  341,  342,  343,  344, 
          342,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   10,  384, 
          385,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   44,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   59,   -1,   61, 
           -1,   63,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307, 
          386,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,    0, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   10, 
          348,  349,   10,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  306,  307,  364,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   44,  326,  327,   44,   -1,  386,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   59,  341, 
           61,   -1,   63,   61,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,   -1,  340,  341, 
          342,  343,  344,   -1,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   10,  384,  385,  386,  387,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,  279,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           59,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          328,   -1,  333,  334,  335,  336,  337,  335,  336,  340, 
          341,  342,  343,  344,  342,  346,   -1,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   10,  384,  385,  386,  387,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   61,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           91,  280,  281,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,  337,   -1, 
           -1,  340,   -1,  342,  343,  344,   -1,  346,    0,  348, 
           -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  360,   -1,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  386,  387,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,  280,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   91, 
           -1,   -1,   -1,  279,  280,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  280, 
            0,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           10,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,  328,  361,  362,  363,   -1,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,  341,  342,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,  328,   -1,  387, 
           -1,   -1,   -1,   -1,  335,  336,  362,   -1,   58,   59, 
          341,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          262,  263,  264,   -1,   59,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   59,  290,  291, 
           -1,  293,  294,  295,  296,  297,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  387,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,  267,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   -1,   63, 
          262,  263,  264,  279,  280,  375,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,  328,    0,   -1,   -1,   -1,   -1,   -1, 
          335,  336,  328,   -1,   10,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
          342,  267,  268,  269,   -1,  271,  362,   -1,   -1,   -1, 
           -1,   61,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,  363,   -1,   59,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   91,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   61,   -1,   63,  262,  263,  264,  279, 
          280,  375,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           10,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,  342,  267,  268,  269, 
           -1,  271,  362,   -1,   -1,   -1,   -1,   61,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,  363,   -1,   59, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   91,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   61, 
           -1,   63,  262,  263,  264,  279,  280,  375,  268,  269, 
           -1,  271,   10,   -1,   -1,   10,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,  293,  294,  295,  296,   -1,   -1,   10, 
           -1,   -1,   -1,   10,   -1,   -1,   44,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   61,   -1,   -1,   61,   -1,  342,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,  342,  267,  268,  269,   -1,  271,  362,   -1, 
           61,   -1,   -1,   91,   61,   -1,   91,  281,  282,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,  305,    0,   -1,   91,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   10,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   91,   -1,   61,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,  279,   -1,  345,  279,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           10,  363,   58,   59,   -1,   61,   -1,   63,  279,   -1, 
           -1,   -1,  279,  375,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,  328,   -1,   91,   -1,  335,  336,   -1, 
          335,  336,   -1,   -1,  342,   -1,   -1,  342,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,  328,   -1,   -1,  335,  336,   -1,   59,  335,  336, 
           -1,  342,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,  328,  361,   -1,  363,   58,   59,   -1,  335, 
          336,   63,   -1,   -1,   -1,   -1,  342,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,  267,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  267,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,  328,  375, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   91,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
          362,  363,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  387,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,  362,  363,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   59,   -1,   -1, 
           -1,   63,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
            0,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           10,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264,  387, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,  387,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
            0,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  342,   -1,   -1,   44,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  305,   -1,  363,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,  387,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,    0,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
            0,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           10,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,  375,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   58,   59, 
           -1,   -1,  305,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,    0,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  387,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   58,   59,   -1,   -1,  305, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1,   63, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,    0,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  375,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  387,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  305,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   91,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,    0,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   10,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  375,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,  281,  282,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   59,   -1,   61,   -1, 
           63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   91,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,  280,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,  362,  363,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,  362, 
          363,   -1,   59,   -1,   61,   -1,   63,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   59,  361,   61,  363, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   44,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   59,   -1,   61,   -1,   63,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   59,  361,   61,  363,   63,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   91,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  262,  263,  264,  342, 
           -1,   -1,  268,  269,   -1,  271,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   59,  361,   -1, 
          363,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   59,  361,   61,  363,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  387,  268,  269,   -1,  271,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   59,  361,   61,  363,   63,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,  387,   10,   -1,   -1,   -1,   91,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,  262,  263,  264, 
          342,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  363,   -1,   91,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  387,  268,  269,   -1,  271,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  262,  263,  264,  342,   -1,   -1, 
          268,  269,   -1,  271,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   10,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   59,  361,   61,  363,   63,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   91,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,  387,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,    0,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   59,  271,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,    0,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   10,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   59,   -1,   61,   -1,   63,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,   -1,   -1,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   91,  333,  334,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,    0,  351,   -1,  353,  354,  355,  356,   -1, 
           -1,  359,   10,  361,   -1,  363,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,    0,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           44,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,    0,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   10,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   59,   -1,   61,   -1,   63,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   91,  333,  334,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,    0,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,    0,  351,   -1,   -1, 
           -1,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,  262,  263,  264,   -1,   -1, 
           44,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,    0, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   58,   59,  333, 
          334,   -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  375,   -1,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   58,   59,  333, 
          334,   -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,    0, 
          351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,   10, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  375,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,   10, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  375,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  357,  358,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,  357,  358,   -1,   10, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  375,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,    0,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  387,   -1,   63,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   44,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  375,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,    0,   -1,  387,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   10,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
            0,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           10,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          375,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,  387,   10,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,    0, 
           -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1,   10, 
           -1,   -1,   -1,  375,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  387,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,    0,   -1,  363,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   10,   -1,   -1,   -1,  375, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,    0,  271,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  281,  282,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,    0, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   10, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,    0,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   10,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,  262,  263,  264,  363,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,    0,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   59,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,    0, 
          387,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
            0,  342,   -1,   -1,  345,   -1,  347,  262,  263,  264, 
           10,   -1,  267,  268,  269,   -1,  271,   -1,   59,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,    0,   -1,  387,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,    0,   -1, 
          345,   -1,  347,   -1,   -1,  262,  263,  264,   10,   -1, 
          267,  268,  269,   59,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
           -1,   -1,  387,   -1,  262,  263,  264,   -1,  305,  267, 
          268,  269,    0,  271,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   10,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   59,   10,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
          387,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,  363,   44,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   10,   -1,   -1,   -1,   -1,  290, 
          291,   59,  293,  294,  295,  296,  297,   -1,   -1,  387, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  342,   -1,   -1,  345,  387,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  342,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  363,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
          342,  387,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  363,   -1,   -1,  262,  263,  264,   91,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,  293,  294,  295,  296,  297, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,  363,  272,  273,  274,  275, 
          276,  277,  278,   -1,   10,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,  387, 
           -1,  339,   -1,  299,  342,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,  387, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   91,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   10,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   59,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   91, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   -1,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   10,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   59,   -1,   -1,   -1,  335, 
          336,  337,   -1,   -1,  340,  341,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,  357,   -1,   -1,  360,   -1,  362,   91,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   -1,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           10,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   59, 
           -1,   -1,   -1,  335,  336,  337,   -1,   -1,  340,  341, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1, 
          362,   91,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   10,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   59,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   10,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   59,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   10,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           10,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   10, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   44,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,  386,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,  341,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  333,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  386,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,  386,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  386, 
      };
   }

}
