/*
 * Copyright (C) 2009-2010 Geometer Plus <contact@geometerplus.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */


#ifndef __DBCONNECTION_H__
#define __DBCONNECTION_H__

class DBConnection {
public:
	DBConnection();
	virtual ~DBConnection();

public: // to implement:
	virtual bool open() = 0;
	virtual bool close() = 0;
	virtual bool isOpened() const = 0;

private: // against copying:
	DBConnection(const DBConnection &);
	const DBConnection &operator = (const DBConnection &);
};

#endif /* __DBCONNECTION_H__ */

