/*============================================================================
 * Code_Saturne documentation page
 *============================================================================*/

/*
  This file is part of Code_Saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2019 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*-----------------------------------------------------------------------------*/

/*!
  \page cs_user_performance_tuning Performance tuning

  \section cs_user_performance_tuning_h_intro Introduction

  C user functions for performance tuning.

  Several functions are present in the file, each specific to different
  performance tuning parameters.

  \section cs_user_performance_tuning_h_cs_user_performance_tuning_numbering  Advanced mesh numbering

  \snippet cs_user_performance_tuning-numbering.c performance_tuning_numbering

  \section cs_user_performance_tuning_h_cs_user_performance_tuning_partition  Advanced partitioning

  \subsection cs_user_performance_tuning_h_cs_user_performance_tuning_partition_1 Example 1

  \snippet cs_user_performance_tuning-partition.c performance_tuning_partition_1

  \subsection cs_user_performance_tuning_h_cs_user_performance_tuning_partition_2 Example 2

  \snippet cs_user_performance_tuning-partition.c performance_tuning_partition_2

  \subsection cs_user_performance_tuning_h_cs_user_performance_tuning_partition_3 Example 3

  \snippet cs_user_performance_tuning-partition.c performance_tuning_partition_3

  \subsection cs_user_performance_tuning_h_cs_user_performance_tuning_partition_4 Example 4

  \snippet cs_user_performance_tuning-partition.c performance_tuning_partition_4

  \section cs_user_performance_tuning_h_cs_user_performance_tuning_parallel_io  Parallel IO

  \snippet cs_user_performance_tuning-parallel-io.c perfomance_tuning_parallel_io

  \section cs_user_performance_tuning_h_cs_user_performance_tuning_matrix  Matrix tuning

  \snippet cs_user_performance_tuning-matrix.c performance_tuning_matrix

*/
