#!/bin/bash

PACKAGE=autofs
OUTPUTFILE=/mnt/testarea/cthon_automount-results

# source the test script helpers
. /usr/bin/rhts_environment.sh

ARENA=`pwd`

RHTS_SERVER1="rhel4-nfs.rhts.boston.redhat.com"
RHTS_SERVER2="sol10-nfs.rhts.boston.redhat.com"
RHTS_SERVER_DIR="/export/cthon_automount"
RHTS_BIN_PATH="${ARENA}/cthon_automount/bin"

function cthon_setup()
{
    cd cthon_automount/src

    sed -e "s%RHTS_SERVER1%${RHTS_SERVER1}%g" \
	-e "s%RHTS_SERVER2%${RHTS_SERVER2}%g" \
	-e "s%RHTS_CLIENT_MNTPNT%${ARENA}/mnt%g" \
	-e "s%RHTS_SERVER_DIR%${RHTS_SERVER_DIR}%g" \
	-e "s%RHTS_TMP_DIR%${ARENA}/maps%g" \
	-e "s%RHTS_BIN_PATH%${RHTS_BIN_PATH}%g" \
	   tests.init.rhts > tests.init

    make
    make install
    make domount doautomount
    cp domount doautomount ../bin
    cd ../bin

    ./setup -a

    # because the linux automounter does not support included maps,
    # we have to copy the auto.master file to /etc/
    cp -f /etc/auto.master /etc/auto.master.cthon_sav
    cp -f ${ARENA}/maps/auto.master /etc/
}

function export_localhost()
{
    cp -f /etc/exports /etc/exports.orig
    mkdir -p /export/
    echo "/export/		*(rw,no_root_squash)" >> /etc/exports
    service nfs restart
}

function fixup_exports()
{
    mv /etc/exports.orig /etc/exports
    service nfs restart
}

function cthon_runtest()
{
    cd ${ARENA}/cthon_automount/bin

    export PATH="${PATH}:${RHTS_BIN_PATH}"
    ./autotest -a -c 2>&1 | tee ${OUTPUTFILE}
}

cthon_setup
export_localhost
cthon_runtest

fixup_exports

# Now calculate the results based on our baseline
cd ${ARENA}

RESULT="PASS"

grep Total ${OUTPUTFILE} > /tmp/thisrun_totals
tail -n 15 ${OUTPUTFILE} > /tmp/thisrun_passfail

diff /tmp/thisrun_totals ${ARENA}/baseline_totals >& /dev/null
if [ $? -ne 0 ]; then
    echo "totals differ"
    RESULT="FAIL"
fi

diff /tmp/thisrun_passfail ${ARENA}/baseline_passfail >& /dev/null
if [ $? -ne 0 ]; then
    echo "passfail differs"
    RESULT="FAIL"
fi

report_result ${TEST} ${RESULT}
