/*
 * sysfs.h
 */

#include <limits.h>
#include <sys/user.h>

/*
 * sysfs_info - structure for sysfs metatdata (mount point, etc)
 */

struct sysfs_info {
	int	si_cwd_fd;
	int	si_mount_fd;
	char	* si_mount_dir;
};


extern int sysfs_init(struct sysfs_info * si);
extern void sysfs_exit(struct sysfs_info * si);



struct sysfs_object {
	char	* so_name;
	char	* so_object_name;

	int	so_orig_fd;
	int	so_depth;
};

extern int sysfs_object_init(struct sysfs_object * so, char * name);
extern void sysfs_object_exit(struct sysfs_object * so);



struct sysfs_object_list {
	int		sol_num;
	char		** sol_list;
	struct dirent	** sol_dirent;
};

extern int sysfs_list_children(struct sysfs_object_list * sol);
extern void sysfs_unlist_children(struct sysfs_object_list * sol);


struct sysfs_attr {
	char	* a_name;
	int	a_name_len;
	char	* a_data;
	int	a_len;
	int	a_flag;
};


struct sysfs_attr_list {
	int			sal_num;
	char			** sal_list;
	struct dirent		** sal_dirent;
	struct sysfs_attr	* sal_attr;
};

extern int sysfs_list_attr(struct sysfs_attr_list * sal);
extern void sysfs_unlist_attr(struct sysfs_attr_list * sal);

extern int sysfs_read_attr(struct sysfs_attr_list * sal);
extern struct sysfs_attr * sysfs_find_attr(struct sysfs_attr_list * sal, char * name);
extern void sysfs_chop_attr(struct sysfs_attr * a);

struct sysfs_link_list {
	int		sll_num;
	char		** sll_name;
	char		** sll_target;
	struct dirent	** sll_dirent;
};

extern int sysfs_list_link(struct sysfs_link_list * sll);
extern void sysfs_unlist_link(struct sysfs_link_list * sll);

extern int sysfs_read_file(char * file, char * buffer);
extern int sysfs_write_file(char * file, char * buffer, int len);

