#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <getopt.h>
#include <string.h>
#include "sysfs.h"
#include "si.h"

struct si_block_data {
	struct sysfs_object_list	d_block_sol;
};

static int get_block_devices(struct si_action * a)
{
	struct si_block_data * data = a->a_data;
	struct sysfs_object so;
	int error;

	error = sysfs_object_init(&so, "block");
	if (error)
		return error;

	error = sysfs_list_children(&data->d_block_sol);

	sysfs_object_exit(&so);
	return error;
}

/**
 *	block_init - Check arguments and allocate private data structures.
 *	@a:	Session data.
 */

static int block_init(struct si_action * a)
{
	struct si_block_data * data;
	int error;

	if (a->a_argc > 4)
		return -EINVAL;

	data = calloc(1, sizeof(struct si_block_data));
	if (!data)
		return -ENOMEM;

	error = get_block_devices(a);
	if (!error)
		a->a_data = data;
	else
		free(data);
	return error;
}


static int block_exec(struct si_action * a)
{
	struct si_block_data * data = a->a_data;
	int error = 0;

	return error;
}

static void block_exit(struct si_action * a)
{
	struct si_block_data * data = a->a_data;

	a->a_data = NULL;
	free(data);
}

static const char * block_help = "Show block device information";
static const char * block_usage = "<object>";

decl_cmd(block);

