/*
 * tools/lib/pv_check_new.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 * January,September 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    12/05/1998 - avoided checking vg_name against LVM_PV_NEW
 *    13/01/1999 - enhanced checks
 *    07/09/1999 - enhanced checks
 *
 */

#include <liblvm.h>

int pv_check_new ( pv_t *pv) {
   int i = 0;
   int ret = FALSE;
   char *ptr = ( char*) pv;

#ifdef DEBUG
   debug ( "pv_check_new -- CALLED\n");
#endif

   if ( pv == NULL) ret = -LVM_EPARAM;
   else {
      for ( i = 0; i < sizeof ( pv->vg_name); i++) {
         if ( pv->vg_name[i] != 0) break;
      }
      if ( i == sizeof ( pv->vg_name) &&
           pv->pe_total == 0) ret = TRUE;

      for ( i = 0; i < sizeof ( pv_t); i++) {
         if ( ptr[i] != 0) break;
      }
      if ( i == sizeof ( pv_t)) ret = FALSE;
   }


#ifdef DEBUG
   debug ( "pv_check_new -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
