/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines interface to Layer Management Entity 
 */


#ifndef LLC_LM_H
#define LLC_LM_H


/* Component types */
#define LM_COMPONENT_TYPE_STATION      1
#define LM_COMPONENT_TYPE_SAP          2
#define LM_COMPONENT_TYPE_CONNECTION   3


/* Status values reported */
#define LM_REPORT_STS_UP               1       /* status status values */
#define LM_REPORT_STS_DOWN             2
#define LM_DUP_ADDRESS_FOUND           3
#define LM_SAP_ACTIVE                  4       /* SAP status values */
#define LM_SAP_INACTIVE                5
#define LM_REMOTE_BUSY                 6       /* connection status values */
#define LM_FRMR_RECEIVED               7
#define LM_FRMR_SENT                   8
#define LM_REMOTE_NOT_BUSY             9



#ifdef LLC_LM_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_LM_C */


EXTRN us16         llc_lm_init (void);
EXTRN us16         llc_lm_exit (void);
EXTRN us16         lm_report_status (us8 component_type,
                                 us32 component_handle, us16 status_value);


#undef EXTRN
#endif /* LLC_LM_H */


