//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// Copyright (C) 2011 Vicente J. Botet Escriba
//
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// <boost/thread/future.hpp>

// class promise<R>

// void promise<R&>::set_value(R& r);

#define BOOST_THREAD_VERSION 3

#include <boost/thread/future.hpp>
#include <boost/detail/lightweight_test.hpp>
#include <boost/static_assert.hpp>

int main()
{

  {
    typedef int& T;
    int i = 3;
    boost::promise<T> p;
    boost::future<T> f = p.get_future();
    p.set_value(i);
    int& j = f.get();
    BOOST_TEST(j == 3);
    ++i;
    BOOST_TEST(j == 4);
    try
    {
      p.set_value(i);
      BOOST_TEST(false);
    }
    catch (const boost::future_error& e)
    {
      BOOST_TEST(e.code() == boost::system::make_error_code(boost::future_errc::promise_already_satisfied));
    }
    catch (...)
    {
      BOOST_TEST(false);
    }
  }
  {
    typedef int& T;
    int i = 3;
    boost::promise<T> p;
    boost::future<T> f = p.get_future();
    p.set_value(i);
    int& j = f.get();
    BOOST_TEST(j == 3);
    ++i;
    BOOST_TEST(j == 4);
    try
    {
      p.set_value_deferred(i);
      BOOST_TEST(false);
    }
    catch (const boost::future_error& e)
    {
      BOOST_TEST(e.code() == boost::system::make_error_code(boost::future_errc::promise_already_satisfied));
    }
    catch (...)
    {
      BOOST_TEST(false);
    }
  }
  {
    typedef int& T;
    int i = 3;
    boost::promise<T> p;
    boost::future<T> f = p.get_future();
    p.set_value_deferred(i);
    BOOST_TEST(!f.is_ready());
    p.notify_deferred();
    int& j = f.get();
    BOOST_TEST(j == 3);
    ++i;
    BOOST_TEST(j == 4);
    try
    {
      p.set_value_deferred(i);
      BOOST_TEST(false);
    }
    catch (const boost::future_error& e)
    {
      BOOST_TEST(e.code() == boost::system::make_error_code(boost::future_errc::promise_already_satisfied));
    }
    catch (...)
    {
      BOOST_TEST(false);
    }
  }
  {
    typedef int& T;
    int i = 3;
    boost::promise<T> p;
    boost::future<T> f = p.get_future();
    p.set_value_deferred(i);
    BOOST_TEST(!f.is_ready());
    p.notify_deferred();
    int& j = f.get();
    BOOST_TEST(j == 3);
    ++i;
    BOOST_TEST(j == 4);
    try
    {
      p.set_value(i);
      BOOST_TEST(false);
    }
    catch (const boost::future_error& e)
    {
      BOOST_TEST(e.code() == boost::system::make_error_code(boost::future_errc::promise_already_satisfied));
    }
    catch (...)
    {
      BOOST_TEST(false);
    }
  }
  return boost::report_errors();
}

